/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.LevelLoadStatusManager;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.LeaderboardsScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.inventory.LegacyMerchantMenu;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin
extends ClientCommonPacketListenerImpl {
    @Shadow
    private LevelLoadStatusManager levelLoadStatusManager;

    protected ClientPacketListenerMixin(Minecraft minecraft, Connection connection, CommonListenerCookie commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(method={"handleRespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setId(I)V")})
    public void handleRespawn(ClientboundRespawnPacket clientboundRespawnPacket, CallbackInfo ci) {
        if (!clientboundRespawnPacket.shouldKeep((byte)3)) {
            this.minecraft.setScreen((Screen)LegacyLoadingScreen.getRespawningScreen(() -> ((LevelLoadStatusManager)this.levelLoadStatusManager).levelReady()));
        }
    }

    @Redirect(method={"handleRespawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/MusicManager;stopPlaying()V"))
    public void handleRespawn(MusicManager instance) {
        this.minecraft.getSoundManager().stop();
    }

    @Inject(method={"handlePlayerInfoUpdate"}, at={@At(value="RETURN")})
    public void handlePlayerInfoUpdate(ClientboundPlayerInfoUpdatePacket clientboundPlayerInfoUpdatePacket, CallbackInfo ci) {
        Legacy4JClient.onClientPlayerInfoChange();
    }

    @Inject(method={"handlePlayerInfoRemove"}, at={@At(value="RETURN")})
    public void handlePlayerInfoUpdate(ClientboundPlayerInfoRemovePacket clientboundPlayerInfoRemovePacket, CallbackInfo ci) {
        Legacy4JClient.onClientPlayerInfoChange();
    }

    @Redirect(method={"handleSetCursorItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;setCarried(Lnet/minecraft/world/item/ItemStack;)V"))
    public void handleContainerSetSlot(AbstractContainerMenu instance, ItemStack itemStack) {
        if (this.minecraft.screen instanceof CreativeModeScreen) {
            return;
        }
        instance.setCarried(itemStack);
    }

    @Inject(method={"handleContainerSetSlot"}, at={@At(value="RETURN")})
    public void handleContainerSetSlot(ClientboundContainerSetSlotPacket clientboundContainerSetSlotPacket, CallbackInfo ci) {
        if (this.minecraft.screen instanceof CreativeModeScreen) {
            this.minecraft.player.inventoryMenu.setRemoteSlot(clientboundContainerSetSlotPacket.getSlot(), clientboundContainerSetSlotPacket.getItem());
            this.minecraft.player.inventoryMenu.broadcastChanges();
        }
    }

    @Redirect(method={"handleContainerSetSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;setItem(IILnet/minecraft/world/item/ItemStack;)V", ordinal=0))
    public void handleContainerSetSlot(AbstractContainerMenu instance, int i, int j, ItemStack itemStack) {
        if (this.minecraft.screen instanceof CreativeModeScreen) {
            return;
        }
        instance.setItem(i, j, itemStack);
    }

    @Redirect(method={"handleSetEntityPassengersPacket"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;setOverlayMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    public void handleSetEntityPassengersPacket(Gui instance, Component component, boolean bl) {
    }

    @Inject(method={"handleMerchantOffers"}, at={@At(value="RETURN")})
    public void handleMerchantOffers(ClientboundMerchantOffersPacket clientboundMerchantOffersPacket, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu;
        if (clientboundMerchantOffersPacket.getContainerId() == this.minecraft.player.containerMenu.containerId && (abstractContainerMenu = this.minecraft.player.containerMenu) instanceof LegacyMerchantMenu) {
            LegacyMerchantMenu m = (LegacyMerchantMenu)abstractContainerMenu;
            m.merchant.overrideOffers(clientboundMerchantOffersPacket.getOffers());
            m.merchant.overrideXp(clientboundMerchantOffersPacket.getVillagerXp());
            m.merchantLevel = clientboundMerchantOffersPacket.getVillagerLevel();
            m.showProgressBar = clientboundMerchantOffersPacket.showProgress();
        }
    }

    @Inject(method={"handleAwardStats"}, at={@At(value="RETURN")})
    public void handleAwardStats(ClientboundAwardStatsPacket clientboundAwardStatsPacket, CallbackInfo ci) {
        Screen screen = this.minecraft.screen;
        if (screen instanceof LeaderboardsScreen) {
            LeaderboardsScreen s = (LeaderboardsScreen)screen;
            s.onStatsUpdated();
        }
    }

    @Inject(method={"handleSystemChat"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void handleSystemChat(ClientboundSystemChatPacket clientboundSystemChatPacket, CallbackInfo ci) {
        if (!((Boolean)LegacyOptions.systemMessagesAsOverlay.get()).booleanValue()) {
            this.minecraft.getChatListener().handleSystemMessage(clientboundSystemChatPacket.content(), false);
            ci.cancel();
        }
    }
}

