/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FlowerBlock.class})
public abstract class FlowerBlockMixin
extends BushBlock
implements BonemealableBlock {
    protected FlowerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (blockState.is(Blocks.WITHER_ROSE)) {
            return false;
        }
        for (int xd = -1; xd <= 1; ++xd) {
            for (int zd = -1; zd <= 1; ++zd) {
                BlockState side;
                if (zd == 0 && xd == 0 || (side = levelReader.getBlockState(blockPos.offset(xd, 0, zd))).isCollisionShapeFullBlock((BlockGetter)levelReader, blockPos) && !side.is(Blocks.GRASS_BLOCK)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        for (int xd = -3; xd <= 3; ++xd) {
            block1: for (int zd = -3; zd <= 3; ++zd) {
                if (zd == 0 && xd == 0) continue;
                for (int yd = -1; yd <= 1; ++yd) {
                    BlockState blockState2;
                    BlockPos blockPos2 = blockPos.offset(xd, yd, zd);
                    if (!serverLevel.getBlockState(blockPos2).isAir() || randomSource.nextInt((int)Math.pow(2.0, Math.abs(xd) + Math.abs(zd) + Math.abs(yd))) != 0 || !(blockState2 = serverLevel.getBlockState(blockPos2.below())).is(Blocks.GRASS_BLOCK)) continue;
                    serverLevel.setBlock(blockPos2, (this == Blocks.POPPY || this == Blocks.DANDELION) && randomSource.nextInt(5) == 0 ? (this == Blocks.POPPY ? Blocks.DANDELION : Blocks.POPPY).defaultBlockState() : this.defaultBlockState(), 3);
                    continue block1;
                }
            }
        }
    }
}

