/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyOptions;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @ModifyExpressionValue(method={"computeFogColor"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getWaterFogColor()I")})
    private static int getWaterFogColor(int original, Camera camera, float f, ClientLevel clientLevel) {
        LegacyBiomeOverride o = LegacyBiomeOverride.getOrDefault(clientLevel.getBiome(BlockPos.containing((Position)camera.getPosition())).unwrapKey());
        if (o.waterFogColor() != null || o.waterColor() != null) {
            return o.waterFogColor() == null ? o.waterColor() : o.waterFogColor();
        }
        return original;
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;start:F", opcode=181, ordinal=8, shift=At.Shift.AFTER)})
    private static void setupFogStart(CallbackInfoReturnable<FogParameters> cir, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.start = LegacyOptions.getTerrainFogStart() * 16;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;end:F", opcode=181, ordinal=11, shift=At.Shift.AFTER)})
    private static void setupFogEnd(CallbackInfoReturnable<FogParameters> cir, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.end = ((Integer)LegacyOptions.terrainFogEnd.get()).floatValue() * 16.0f;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;start:F", opcode=181, ordinal=7, shift=At.Shift.AFTER)})
    private static void setupSkyFogStart(CallbackInfoReturnable<FogParameters> cir, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.start = LegacyOptions.getTerrainFogStart() * 16;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;end:F", opcode=181, ordinal=10, shift=At.Shift.AFTER)})
    private static void setupSkyFogEnd(CallbackInfoReturnable<FogParameters> cir, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.end = ((Integer)LegacyOptions.terrainFogEnd.get()).floatValue() * 16.0f;
        }
    }
}

