/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import wily.factoryapi.util.ColorUtil;

@Mixin(value={ScreenEffectRenderer.class})
public abstract class ScreenEffectRendererMixin {
    @Shadow
    @Nullable
    private static BlockState getViewBlockingState(Player player) {
        return null;
    }

    @Shadow
    private static void renderTex(TextureAtlasSprite textureAtlasSprite, PoseStack poseStack, MultiBufferSource multiBufferSource) {
    }

    @Redirect(method={"renderScreenEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ScreenEffectRenderer;renderTex(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private static void renderScreenEffect(TextureAtlasSprite f, PoseStack f1, MultiBufferSource multiBufferSource, Minecraft minecraft) {
        BlockState state = ScreenEffectRendererMixin.getViewBlockingState((Player)minecraft.player);
        List quads = minecraft.getBlockRenderer().getBlockModelShaper().getBlockModel(state).getQuads(state, Direction.UP, minecraft.player.getRandom());
        if (!quads.isEmpty()) {
            BakedQuad quad = (BakedQuad)quads.get(0);
            f = quad.getSprite();
            int color = minecraft.getBlockColors().getColor(state, (BlockAndTintGetter)minecraft.level, minecraft.player.blockPosition(), quad.getTintIndex());
            RenderSystem.setShaderColor((float)ColorUtil.getRed((int)color), (float)ColorUtil.getGreen((int)color), (float)ColorUtil.getBlue((int)color), (float)1.0f);
        }
        ScreenEffectRendererMixin.renderTex(f, f1, multiBufferSource);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

