/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Reader;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.util.ScreenUtil;

@Mixin(value={WinScreen.class})
public abstract class WinScreenMixin
extends Screen
implements ControlTooltip.Event {
    @Unique
    ResourceLocation POEM_BACKGROUND = Legacy4J.createModLocation("textures/gui/end_poem_background.png");
    @Unique
    ResourceLocation CREDITS_BACKGROUND = Legacy4J.createModLocation("textures/gui/credits_background.png");
    @Unique
    ResourceLocation CREDITS_BACKGROUND_FADE = Legacy4J.createModLocation("textures/gui/credits_background_fade.png");
    @Shadow
    @Final
    private boolean poem;
    @Unique
    private IntSet titleLines;
    @Shadow
    private IntSet centeredLines;
    @Shadow
    private float scroll;
    @Shadow
    private float scrollSpeed;
    @Shadow
    private List<FormattedCharSequence> lines;
    @Shadow
    private boolean speedupActive;

    protected WinScreenMixin(Component component) {
        super(component);
    }

    public void added() {
        super.added();
        ControlTooltip.Renderer.of(this).clear().add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.RIGHT_BUTTON.getIcon(), () -> this.poem ? CommonComponents.GUI_CONTINUE : CommonComponents.GUI_BACK);
    }

    @Shadow
    protected abstract void renderVignette(GuiGraphics var1);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        this.scroll = Math.max(0.0f, this.scroll + f * this.scrollSpeed);
        float g = -this.scroll;
        int m = this.height;
        if (this.poem) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(this.POEM_BACKGROUND, 0, 0, 0.0f, (float)Util.getMillis() / 280.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), 80, 80);
            this.renderVignette(guiGraphics);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, g, 0.0f);
            Legacy4JClient.defaultFontOverride = LegacyIconHolder.MOJANGLES_11_FONT;
            int k = this.width / 2 - 161;
            for (int n = 0; n < this.lines.size(); ++n) {
                float h;
                if (n == this.lines.size() - 1 && (h = (float)m + g - (float)(this.height / 2 - 6)) < 0.0f) {
                    guiGraphics.pose().translate(0.0f, -h, 0.0f);
                }
                if ((float)m + g + 12.0f + 8.0f > 0.0f && (float)m + g < (float)this.height) {
                    FormattedCharSequence formattedCharSequence = this.lines.get(n);
                    boolean centered = this.centeredLines.contains(n);
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)k, centered ? (float)(this.width / 2) : (float)m, 0.0f);
                    guiGraphics.pose().scale(2.0f, 2.0f, 0.0f);
                    if (centered) {
                        guiGraphics.drawCenteredString(this.font, formattedCharSequence, 0, 0, 0xFFFFFF);
                    } else {
                        guiGraphics.drawString(this.font, formattedCharSequence, 0, 0, 0xFFFFFF);
                    }
                    guiGraphics.pose().popPose();
                }
                m += 72;
            }
            guiGraphics.pose().popPose();
            Legacy4JClient.defaultFontOverride = null;
        } else {
            int fixedWidth = Math.max(guiGraphics.guiHeight() * 16 / 9, guiGraphics.guiWidth());
            int fixedHeight = Math.max(guiGraphics.guiWidth() * 9 / 16, guiGraphics.guiHeight());
            float x = (float)(fixedWidth - guiGraphics.guiWidth()) / 2.0f;
            float y = (float)(fixedHeight - guiGraphics.guiHeight()) / 2.0f;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(this.CREDITS_BACKGROUND, 0, 0, x, y, guiGraphics.guiWidth(), guiGraphics.guiHeight(), fixedWidth, fixedHeight);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, g, 0.0f);
            int k = this.width / 2;
            for (int n = 0; n < this.lines.size(); ++n) {
                float h;
                if (n == this.lines.size() - 1 && (h = (float)m + g - (float)(this.height / 2 - 6)) < 0.0f) {
                    guiGraphics.pose().translate(0.0f, -h, 0.0f);
                }
                if ((float)m + g + 12.0f + 8.0f > 0.0f && (float)m + g < (float)this.height) {
                    FormattedCharSequence formattedCharSequence = this.lines.get(n);
                    boolean title = this.titleLines.contains(n);
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)k - (float)this.font.width(formattedCharSequence) * (title ? 1.5f : 1.0f) / 2.0f, (float)m, 0.0f);
                    if (title) {
                        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
                    }
                    this.font.drawInBatch8xOutline(formattedCharSequence, 0.0f, 0.0f, 0xFFFFFF, 0, guiGraphics.pose().last().pose(), (MultiBufferSource)FactoryGuiGraphics.of((GuiGraphics)guiGraphics).getBufferSource(), 0xF000F0);
                    guiGraphics.pose().popPose();
                    guiGraphics.flush();
                }
                m += 18;
            }
            guiGraphics.pose().popPose();
            RenderSystem.enableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).disableDepthTest();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(this.CREDITS_BACKGROUND_FADE, 0, 0, x, y, guiGraphics.guiWidth(), guiGraphics.guiHeight(), fixedWidth, fixedHeight);
            guiGraphics.flush();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).enableDepthTest();
            RenderSystem.disableBlend();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            ScreenUtil.renderLogo(guiGraphics);
            guiGraphics.pose().popPose();
        }
        ci.cancel();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    public void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (i == 265 || i == 264) {
            this.speedupActive = true;
        }
    }

    @Inject(method={"keyReleased"}, at={@At(value="HEAD")})
    public void keyReleased(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (i == 265 || i == 264) {
            this.speedupActive = false;
        }
    }

    @Inject(method={"init"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/WinScreen;lines:Ljava/util/List;", opcode=181)})
    private void init(CallbackInfo ci) {
        this.titleLines = new IntOpenHashSet();
    }

    @Redirect(method={"addPoemFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/WinScreen;addEmptyLine()V", ordinal=0))
    private void addPoemFile(WinScreen instance) {
    }

    @ModifyArg(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/WinScreen;wrapCreditsIO(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/gui/screens/WinScreen$CreditsReader;)V", ordinal=0))
    private ResourceLocation addPoemFile(ResourceLocation arg) {
        ResourceLocation langLocation = Legacy4J.createModLocation("end_poem/" + this.minecraft.getLanguageManager().getSelected() + ".txt");
        return this.minecraft.getResourceManager().getResource(langLocation).isPresent() ? langLocation : arg;
    }

    @Redirect(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/WinScreen;addCreditsLine(Lnet/minecraft/network/chat/Component;Z)V", ordinal=0))
    private void addCreditsFileHeading(WinScreen instance, Component arg, boolean bl) {
    }

    @Redirect(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/WinScreen;addCreditsLine(Lnet/minecraft/network/chat/Component;Z)V", ordinal=2))
    private void addCreditsFileSecondHeading(WinScreen instance, Component arg, boolean bl) {
    }

    @ModifyArg(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/Component;literal(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=0))
    private String addCreditsFileSectionToUppercase(String string) {
        return string.toUpperCase();
    }

    @Redirect(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=0))
    private MutableComponent addCreditsFileSectionStyle(MutableComponent instance, ChatFormatting arg) {
        return instance;
    }

    @Redirect(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=1))
    private MutableComponent addCreditsFileDisciplineStyle(MutableComponent instance, ChatFormatting arg) {
        return instance;
    }

    @Redirect(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=2))
    private MutableComponent addCreditsFileTitleStyle(MutableComponent instance, ChatFormatting arg) {
        return instance;
    }

    @Inject(method={"addCreditsFile"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/WinScreen;addCreditsLine(Lnet/minecraft/network/chat/Component;Z)V", ordinal=1)})
    private void addCreditsFileSectionTitle(Reader reader, CallbackInfo ci) {
        this.titleLines.add(this.lines.size());
    }

    @Inject(method={"addCreditsFile"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/WinScreen;addCreditsLine(Lnet/minecraft/network/chat/Component;Z)V", ordinal=3)})
    private void addCreditsFileDisciplineTitle(Reader reader, CallbackInfo ci) {
        this.titleLines.add(this.lines.size());
    }

    @Redirect(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/Component;literal(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=3))
    private MutableComponent addCreditsFileRemoveNameSpacing(String string) {
        return Component.empty();
    }

    @ModifyArg(method={"addCreditsFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=3))
    private ChatFormatting addCreditsFile(ChatFormatting arg) {
        return ChatFormatting.YELLOW;
    }
}

