/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wily.legacy.init.LegacyRegistries;

public class WaterCauldronBlockEntity
extends BlockEntity {
    public Holder<Potion> potion = Potions.WATER;
    public Holder<Item> lastPotionItemUsed = Items.POTION.builtInRegistryHolder();
    public Integer waterColor;

    public WaterCauldronBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        } else {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                l.getChunkSource().blockChanged(this.getBlockPos());
            }
        }
    }

    public boolean hasWater() {
        return ((Potion)this.potion.value()).equals(Potions.WATER.value());
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (compoundTag.contains("dyeColor")) {
            this.waterColor = compoundTag.getInt("dyeColor");
        }
        BuiltInRegistries.POTION.getHolder(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)ResourceLocation.tryParse((String)compoundTag.getString("potion")))).ifPresent(p -> {
            this.potion = p;
        });
        BuiltInRegistries.ITEM.getHolder(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)compoundTag.getString("lastPotionItemUsed")))).ifPresent(p -> {
            this.lastPotionItemUsed = p;
        });
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.waterColor != null) {
            compoundTag.putInt("dyeColor", this.waterColor.intValue());
        }
        this.potion.unwrapKey().ifPresent(r -> compoundTag.putString("potion", r.location().toString()));
        this.lastPotionItemUsed.unwrapKey().ifPresent(r -> compoundTag.putString("lastPotionItemUsed", r.location().toString()));
    }
}

