/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.client.CommonColor;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public record GlobalPacks(List<String> list, boolean applyOnTop) {
    public static final GlobalPacks EMPTY = new GlobalPacks(Collections.emptyList(), true);
    public static final Codec<GlobalPacks> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("packs").forGetter(GlobalPacks::list), (App)Codec.BOOL.fieldOf("applyOnTop").forGetter(GlobalPacks::applyOnTop)).apply((Applicative)i, GlobalPacks::new));
    public static final FactoryConfig.StorageHandler STORAGE = new FactoryConfig.StorageHandler().withFile("legacy/global_packs.json");
    public static final FactoryConfig<GlobalPacks> globalResources = STORAGE.register(FactoryConfig.create((String)"globalResources", null, () -> CODEC, (Object)EMPTY, v -> {}, (FactoryConfig.StorageAccess)STORAGE));

    public void applyPacks(PackRepository repository, List<String> additional) {
        ArrayList<String> packs = new ArrayList<String>(this.list());
        packs.removeIf(additional::contains);
        packs.addAll(this.applyOnTop ? 0 : packs.size(), additional);
        repository.setSelected(packs);
    }

    public GlobalPacks withPacks(List<String> packs) {
        return new GlobalPacks(packs, this.applyOnTop);
    }

    public GlobalPacks withApplyOnTop(boolean applyOnTop) {
        return new GlobalPacks(this.list, applyOnTop);
    }

    public static class Selector
    extends AbstractWidget
    implements ControlTooltip.ActionHolder {
        private final Component screenComponent;
        public final FactoryConfig<GlobalPacks> globalPacks;
        public PackSelectionModel model;
        public final Stocker.Sizeable scrolledList;
        private final Path packPath;
        private final boolean hasTooltip;
        public int selectedIndex = -1;
        public Pack selectedPack;
        private final PackRepository packRepository;
        private final Minecraft minecraft;
        protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
        public final ScrollableRenderer scrollableRenderer = new ScrollableRenderer(this.scrollRenderer);
        public final BiFunction<Component, Integer, MultiLineLabel> labelsCache = Util.memoize((c, i) -> MultiLineLabel.create((Font)Minecraft.getInstance().font, (Component)c, (int)i));

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip) {
            return new Selector(i, j, k, l, LegacyComponents.GLOBAL_RESOURCE_PACKS, LegacyComponents.SHOW_RESOURCE_PACKS, Minecraft.getInstance().getResourcePackRepository(), Minecraft.getInstance().getResourcePackDirectory(), globalResources, hasTooltip);
        }

        public Selector(int i2, int j, int k, int l, Component component, Component screenComponent, PackRepository packRepository, Path packPath, FactoryConfig<GlobalPacks> globalPacks, boolean hasTooltip) {
            super(i2, j, k, l, component);
            this.screenComponent = screenComponent;
            this.globalPacks = globalPacks;
            this.packPath = packPath;
            this.hasTooltip = hasTooltip;
            this.minecraft = Minecraft.getInstance();
            this.packRepository = packRepository;
            Collection packs = packRepository.getSelectedIds();
            packRepository.setSelected(((GlobalPacks)globalPacks.get()).list());
            this.updateModel();
            packRepository.setSelected(packs);
            this.scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
            List<Pack> displayPacks = this.getDisplayPacks();
            int s = displayPacks.size();
            if (s > this.getMaxPacks()) {
                this.scrolledList.max = displayPacks.size() - this.getMaxPacks();
            }
            this.setSelectedPack(0);
            this.updateTooltip();
        }

        public List<Pack> getDisplayPacks() {
            return Stream.concat(this.model.selected.stream(), this.model.unselected.stream()).toList();
        }

        public void updateTooltip() {
            if (this.hasTooltip) {
                this.setTooltip(Tooltip.create((Component)this.selectedPack.getDescription(), (Component)this.selectedPack.getTitle()));
            }
        }

        public void renderTooltipBox(GuiGraphics guiGraphics, LayoutElement panel) {
            this.renderTooltipBox(guiGraphics, panel, 0);
        }

        public void renderTooltipBox(GuiGraphics guiGraphics, LayoutElement panel, int xOffset) {
            this.renderTooltipBox(guiGraphics, panel.getX() + panel.getWidth() - 2 + xOffset, panel.getY() + 5, 161, panel.getHeight() - 10);
        }

        public void renderTooltipBox(GuiGraphics graphics, int x, int y, int width, int height) {
            if (this.hasTooltip) {
                return;
            }
            ScreenUtil.renderPointerPanel(graphics, x, y, width, height);
            if (this.selectedPack != null) {
                FactoryGuiGraphics.of((GuiGraphics)graphics).blit(PackAlbum.Selector.getPackIcon(this.selectedPack), x + 7, y + 5, 0.0f, 0.0f, 32, 32, 32, 32);
                graphics.enableScissor(x + 40, y + 4, x + 148, y + 44);
                this.labelsCache.apply(this.selectedPack.getTitle(), 108).renderLeftAligned(graphics, x + 43, y + 8, 12, 0xFFFFFF);
                graphics.disableScissor();
                ResourceLocation background = PackAlbum.Selector.getPackBackground(this.selectedPack);
                MultiLineLabel label = this.labelsCache.apply(this.selectedPack.getDescription(), 145);
                this.scrollableRenderer.render(graphics, x + 8, y + 40, 146, 12 * (background == null ? 14 : 7), () -> label.renderLeftAligned(graphics, x + 8, y + 40, 12, 0xFFFFFF));
                if (background != null) {
                    FactoryGuiGraphics.of((GuiGraphics)graphics).blit(background, x + 8, y + height - 78, 0.0f, 0.0f, 145, 72, 145, 72);
                }
            }
        }

        public boolean keyPressed(int i, int j, int k) {
            if (this.isHoveredOrFocused() && this.active) {
                if (i == 88) {
                    this.openPackSelectionScreen();
                    return true;
                }
                if (CommonInputs.selected((int)i)) {
                    this.tryChangePackState(this.selectedIndex);
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    return true;
                }
                if (i == 263) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get()) {
                        this.updateScroll(-1, true);
                    }
                    this.setSelectedPack(this.selectedIndex - 1);
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
                } else if (i == 262) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get() + this.getMaxPacks() - 1) {
                        this.updateScroll(1, true);
                    }
                    this.setSelectedPack(this.selectedIndex + 1);
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
                }
            }
            return super.keyPressed(i, j, k);
        }

        public void setSelectedPack(int index) {
            if (this.selectedIndex == index) {
                return;
            }
            List<Pack> displayPacks = this.getDisplayPacks();
            this.selectedIndex = Stocker.cyclic((int)0, (int)index, (int)displayPacks.size());
            this.selectedPack = displayPacks.get(this.selectedIndex);
            this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
            ResourceLocation background = PackAlbum.Selector.getPackBackground(this.selectedPack);
            this.scrollableRenderer.scrolled.max = Math.max(0, this.labelsCache.apply(this.selectedPack.getDescription(), 145).getLineCount() - (background == null ? 20 : 7));
            this.updateTooltip();
        }

        public void tryChangePackState(int index) {
            Pack p = this.getDisplayPacks().get(index);
            if (p.isRequired()) {
                return;
            }
            if (this.model.selected.contains(p)) {
                this.model.selected.remove(p);
                this.model.unselected.add(p);
            } else {
                this.model.unselected.remove(p);
                this.model.selected.add(0, p);
            }
        }

        public List<String> getSelectedIds() {
            return this.model.selected.stream().filter(p -> !FactoryAPIPlatform.isPackHidden((Pack)p) && !p.isRequired()).map(Pack::getId).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
                Collections.reverse(l);
                return l;
            }));
        }

        public boolean hasChanged() {
            return !this.getSelectedIds().equals(this.globalPacks.get());
        }

        public void applyChanges() {
            if (!this.hasChanged()) {
                return;
            }
            this.globalPacks.set((Object)((GlobalPacks)this.globalPacks.get()).withPacks(this.getSelectedIds()));
            this.globalPacks.save();
        }

        public void updateModel() {
            this.model = new PackSelectionModel(() -> {}, PackAlbum.Selector::getPackIcon, this.packRepository, r -> {});
        }

        public void openPackSelectionScreen() {
            if (this.minecraft.screen != null) {
                Screen screen = this.minecraft.screen;
                Collection packs = this.packRepository.getSelectedIds();
                this.packRepository.setSelected(this.getSelectedIds());
                this.minecraft.setScreen((Screen)new PackSelectionScreen(this.packRepository, p -> {
                    this.updateModel();
                    this.packRepository.setSelected(packs);
                    this.minecraft.setScreen(screen);
                }, this.packPath, this.getMessage()));
            }
        }

        public void onClick(double d, double e) {
            if (Screen.hasShiftDown()) {
                this.openPackSelectionScreen();
                return;
            }
            int visibleCount = 0;
            for (int index = 0; index < this.getDisplayPacks().size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                if (!(d >= (double)(this.getX() + 20 + 30 * index))) continue;
                int n = this.getY();
                Objects.requireNonNull(this.minecraft.font);
                if (!(e >= (double)(n + 9 + 3))) continue;
                int n2 = this.getX();
                Objects.requireNonNull(this.minecraft.font);
                if (!(d < (double)(n2 + 9 + 49 + 30 * index))) continue;
                int n3 = this.getY();
                Objects.requireNonNull(this.minecraft.font);
                if (!(e < (double)(n3 + 9 + 32))) continue;
                if (this.selectedIndex == index + (Integer)this.scrolledList.get()) {
                    this.tryChangePackState(index + (Integer)this.scrolledList.get());
                }
                this.setSelectedPack(index + (Integer)this.scrolledList.get());
            }
            super.onClick(d, e);
        }

        public boolean mouseScrolled(double d, double e, double f, double g) {
            if (this.updateScroll((int)Math.signum(g), false)) {
                return true;
            }
            return super.mouseScrolled(d, e, f, g);
        }

        public boolean updateScroll(int i, boolean cyclic) {
            if (this.scrolledList.max > 0 && ((Integer)this.scrolledList.get() <= this.scrolledList.max && i > 0 || (Integer)this.scrolledList.get() >= 0 && i < 0)) {
                return this.scrolledList.add(i, cyclic) != 0;
            }
            return false;
        }

        protected int getMaxPacks() {
            return (this.width - 40) / 30;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            Font font = this.minecraft.font;
            FactoryGuiGraphics factoryGuiGraphics = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
            int n = this.getX() - 1;
            int n2 = this.getY();
            Objects.requireNonNull(font);
            int n3 = n2 + 9 - 1;
            Objects.requireNonNull(this.minecraft.font);
            factoryGuiGraphics.blitSprite(LegacySprites.PANEL_RECESS, n, n3, this.width + 2, this.height + 2 - 9);
            List<Pack> displayPacks = this.getDisplayPacks();
            int visibleCount = 0;
            RenderSystem.enableBlend();
            for (int index = 0; index < displayPacks.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                FactoryGuiGraphics factoryGuiGraphics2 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                ResourceLocation resourceLocation = PackAlbum.Selector.getPackIcon(displayPacks.get((Integer)this.scrolledList.get() + index));
                int n4 = this.getX() + 21 + 30 * index;
                int n5 = this.getY();
                Objects.requireNonNull(font);
                factoryGuiGraphics2.blit(resourceLocation, n4, n5 + 9 + 4, 0.0f, 0.0f, 28, 28, 28, 28);
                if (this.model.selected.contains(displayPacks.get((Integer)this.scrolledList.get() + index))) {
                    FactoryGuiGraphics factoryGuiGraphics3 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                    int n6 = this.getX() + 20 + 30 * index;
                    int n7 = this.getY();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics3.blitSprite(LegacySprites.PACK_SELECTED, n6, n7 + 9 + 3, 30, 30);
                }
                if ((Integer)this.scrolledList.get() + index != this.selectedIndex) continue;
                FactoryGuiGraphics factoryGuiGraphics4 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                int n8 = this.getX() + 20 + 30 * index;
                int n9 = this.getY();
                Objects.requireNonNull(font);
                factoryGuiGraphics4.blitSprite(LegacySprites.PACK_HIGHLIGHTED, n8, n9 + 9 + 3, 30, 30);
            }
            RenderSystem.disableBlend();
            guiGraphics.drawString(font, this.getMessage(), this.getX() + 1, this.getY(), this.isHoveredOrFocused() ? ScreenUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.isHoveredOrFocused());
            if (this.scrolledList.max > 0) {
                if ((Integer)this.scrolledList.get() < this.scrolledList.max) {
                    int n10 = this.getX() + this.width - 12;
                    int n11 = this.getY();
                    Objects.requireNonNull(font);
                    int n12 = n11 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, n10, n12 + (this.height - 9 - 11) / 2);
                }
                if ((Integer)this.scrolledList.get() > 0) {
                    int n13 = this.getX() + 8;
                    int n14 = this.getY();
                    Objects.requireNonNull(font);
                    int n15 = n14 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, n13, n15 + (this.height - 9 - 11) / 2);
                }
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> k.key() == 88 && this.isFocused() || k.key() == 0 && this.isHovered() ? this.screenComponent : ControlTooltip.getSelectAction((GuiEventListener)this, context));
        }
    }
}

