/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTabInfo;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.util.JsonUtil;

public class LegacyCreativeTabListing
implements LegacyTabInfo {
    public static final Codec<LegacyCreativeTabListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(LegacyCreativeTabListing::id), (App)DynamicUtil.getComponentCodec().fieldOf("name").forGetter(LegacyCreativeTabListing::name), (App)LegacyTabButton.ICON_HOLDER_CODEC.fieldOf("icon").forGetter(LegacyCreativeTabListing::iconHolder), (App)DynamicUtil.ITEM_SUPPLIER_CODEC.listOf().fieldOf("listing").forGetter(LegacyCreativeTabListing::displayItems)).apply((Applicative)i, LegacyCreativeTabListing::new));
    public static final ListMap<ResourceLocation, LegacyCreativeTabListing> map = new ListMap();
    private static final String LISTING = "creative_tab_listing.json";
    private final ResourceLocation id;
    private Component name;
    private LegacyTabButton.IconHolder<?> iconHolder;
    private final List<ArbitrarySupplier<ItemStack>> displayItems;

    public static void rebuildVanillaCreativeTabsItems(Minecraft minecraft) {
        if (minecraft.getConnection() != null && CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)minecraft.getConnection().enabledFeatures(), (boolean)((Boolean)minecraft.options.operatorItemsTab().get()), (HolderLookup.Provider)minecraft.getConnection().registryAccess())) {
            List list = List.copyOf(CreativeModeTabs.searchTab().getDisplayItems());
            minecraft.getConnection().searchTrees().updateCreativeTooltips((HolderLookup.Provider)minecraft.getConnection().registryAccess(), list);
            minecraft.getConnection().searchTrees().updateCreativeTags(list);
        }
    }

    public LegacyCreativeTabListing(ResourceLocation id, Component name, LegacyTabButton.IconHolder<?> iconHolder, List<ArbitrarySupplier<ItemStack>> displayItems) {
        this.id = id;
        this.name = name;
        this.iconHolder = iconHolder;
        this.displayItems = displayItems;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public LegacyTabButton.IconHolder<?> iconHolder() {
        return this.iconHolder;
    }

    public List<ArbitrarySupplier<ItemStack>> displayItems() {
        return this.displayItems;
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public Manager() {
            DynamicUtil.COMMON_ITEMS.put((Object)FactoryAPI.createVanillaLocation((String)"ominous_banner"), () -> {
                if (Minecraft.getInstance().getConnection() == null) {
                    return ItemStack.EMPTY;
                }
                return Raid.getLeaderBannerInstance((HolderGetter)Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BANNER_PATTERN));
            });
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            map.clear();
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)LegacyCreativeTabListing.LISTING)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.openAsReader();){
                    JsonElement json = JsonParser.parseReader((Reader)bufferedReader);
                    if (json instanceof JsonArray) {
                        JsonArray a = (JsonArray)json;
                        a.forEach(e -> CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(listing -> {
                            if (map.containsKey((Object)listing.id)) {
                                LegacyCreativeTabListing l = (LegacyCreativeTabListing)map.get((Object)listing.id);
                                if (listing.name != null) {
                                    l.name = listing.name;
                                }
                                if (listing.iconHolder != null) {
                                    l.iconHolder = listing.iconHolder;
                                }
                                l.displayItems.addAll(listing.displayItems);
                            } else if (listing.isValid()) {
                                map.put((Object)listing.id, listing);
                            }
                        }));
                    }
                }
                catch (IOException var8) {
                    Legacy4J.LOGGER.warn((Object)var8);
                }
            }));
        }

        public String getName() {
            return "legacy:creative_tab_listing";
        }
    }
}

