/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.JsonUtil;

public class LegacyResourceManager
implements ResourceManagerReloadListener {
    public static final ResourceLocation GAMEPAD_MAPPINGS = Legacy4J.createModLocation("gamepad_mappings.txt");
    public static final ResourceLocation INTRO_LOCATION = Legacy4J.createModLocation("intro.json");
    public static final ResourceLocation GAMMA_LOCATION = Legacy4J.createModLocation("post_effect/gamma.json");
    public static final ResourceLocation DEFAULT_KEYBOARD_LAYOUT_LOCATION = Legacy4J.createModLocation("keyboard_layout/en_us.json");
    public static final ResourceLocation PLAYER_IDENTIFIERS_LOCATION = Legacy4J.createModLocation("player_identifiers.json");
    public static final String CONTROL_TYPES = "control_types.json";
    public static final String COMMON_COLORS = "common_colors.json";
    public static final String COMMON_VALUES = "common_values.json";
    public static final String DEFAULT_KBM_ICONS = "control_tooltips/icons/kbm.json";
    public static final String DEFAULT_CONTROLLER_ICONS = "control_tooltips/icons/controller.json";
    public static final List<ResourceLocation> INTROS = new ArrayList<ResourceLocation>();
    public static final List<KeyboardScreen.CharButtonBuilder> keyboardButtonBuilders = new ArrayList<KeyboardScreen.CharButtonBuilder>();
    public static ControllerBinding<?> shiftBinding;

    public void onResourceManagerReload(ResourceManager resourceManager) {
        Minecraft minecraft = Minecraft.getInstance();
        resourceManager.getResource(GAMEPAD_MAPPINGS).ifPresent(r -> {
            try {
                ControllerManager.getHandler().applyGamePadMappingsFromBuffer(r.openAsReader());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (Legacy4JClient.gammaEffect != null) {
            Legacy4JClient.gammaEffect.close();
        }
        try {
            Legacy4JClient.gammaEffect = new PostChain(minecraft.getTextureManager(), (ResourceProvider)resourceManager, minecraft.getMainRenderTarget(), GAMMA_LOCATION);
            Legacy4JClient.gammaEffect.resize(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight());
        }
        catch (IOException iOException) {
            Legacy4J.LOGGER.warn("Failed to load gamma: {}", (Object)GAMMA_LOCATION, (Object)iOException);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            Legacy4J.LOGGER.warn("Failed to parse shader: {}", (Object)GAMMA_LOCATION, (Object)jsonSyntaxException);
        }
        LegacyResourceManager.registerIntroLocations(resourceManager);
        PlayerIdentifier.list.clear();
        resourceManager.getResourceStack(PLAYER_IDENTIFIERS_LOCATION).forEach(r -> {
            try {
                GsonHelper.parseArray((Reader)r.openAsReader()).forEach(e -> PlayerIdentifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(p -> PlayerIdentifier.list.put(p.index(), p)));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        });
        ControlType.types.clear();
        CommonValue.COMMON_VALUES.forEach((s, c) -> c.reset());
        CommonColor.COMMON_COLORS.forEach((s, c) -> c.reset());
        resourceManager.getResource(DEFAULT_KEYBOARD_LAYOUT_LOCATION).ifPresent(LegacyResourceManager::setKeyboardLayout);
        JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> {
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)CONTROL_TYPES)).ifPresent(r -> {
                try {
                    GsonHelper.parseArray((Reader)r.openAsReader()).forEach(e -> {
                        ControlType type;
                        ResourceLocation id;
                        if (e instanceof JsonPrimitive) {
                            JsonPrimitive p = (JsonPrimitive)e;
                            id = FactoryAPI.createLocation((String)p.getAsString());
                            if (ControlType.types.containsKey((Object)id.toString()) && ControlType.defaultTypes.contains(ControlType.types.get((Object)id.toString()))) {
                                return;
                            }
                            for (ControlType defaultType : ControlType.defaultTypes) {
                                if (!defaultType.getId().equals((Object)id)) continue;
                                ControlType.types.put((Object)id.toString(), (Object)defaultType);
                                return;
                            }
                            type = ControlType.create(id, null, false);
                        } else {
                            JsonObject o = e.getAsJsonObject();
                            id = FactoryAPI.createLocation((String)GsonHelper.getAsString((JsonObject)o, (String)"id"));
                            type = ControlType.create(id, (Component)JsonUtil.getJsonStringOrNull(o, "displayName", Component::translatable), GsonHelper.getAsBoolean((JsonObject)o, (String)"isKbm", (boolean)false));
                        }
                        ControlType.types.put((Object)id.toString(), (Object)type);
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)COMMON_COLORS)).ifPresent(r -> {
                try {
                    JsonObject obj = GsonHelper.parse((Reader)r.openAsReader());
                    obj.asMap().forEach((s, e) -> {
                        ResourceLocation id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_COLORS.containsKey((Object)id)) {
                            ((CommonColor)((Object)((Object)((Object)((Object)CommonColor.COMMON_COLORS.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)COMMON_VALUES)).ifPresent(r -> {
                try {
                    JsonObject obj = GsonHelper.parse((Reader)r.openAsReader());
                    obj.asMap().forEach((s, e) -> {
                        ResourceLocation id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_VALUES.containsKey((Object)id)) {
                            ((CommonValue)((Object)((Object)((Object)((Object)CommonColor.COMMON_VALUES.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            LegacyResourceManager.addKbmIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_KBM_ICONS), (s, b) -> {
                for (ControlType value : ControlType.types.values()) {
                    if (!value.isKbm()) continue;
                    value.getIcons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            LegacyResourceManager.addControllerIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_CONTROLLER_ICONS), (s, b) -> {
                for (ControlType value : ControlType.types.values()) {
                    if (value.isKbm()) continue;
                    value.getIcons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            for (ControlType value : ControlType.types.values()) {
                ResourceLocation location = FactoryAPI.createLocation((String)value.getId().getNamespace(), (String)"control_tooltips/icons/%s.json".formatted(value.getId().getPath()));
                if (value.isKbm()) {
                    LegacyResourceManager.addKbmIcons(resourceManager, location, value.getIcons()::put);
                    continue;
                }
                LegacyResourceManager.addControllerIcons(resourceManager, location, value.getIcons()::put);
            }
            resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)("keyboard_layout/" + minecraft.getLanguageManager().getSelected() + ".json"))).ifPresent(LegacyResourceManager::setKeyboardLayout);
        });
    }

    public static void setKeyboardLayout(Resource resource) {
        try {
            JsonObject obj = GsonHelper.parse((Reader)resource.openAsReader());
            keyboardButtonBuilders.clear();
            shiftBinding = obj.has("shiftBinding") ? ControllerBinding.map.get(obj.get("shiftBinding").getAsString()) : ControllerBinding.LEFT_STICK_BUTTON;
            obj.getAsJsonArray("layout").forEach(e -> {
                if (e instanceof JsonObject) {
                    JsonObject o = (JsonObject)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(GsonHelper.getAsInt((JsonObject)o, (String)"width", (int)25), GsonHelper.getAsString((JsonObject)o, (String)"chars"), GsonHelper.getAsString((JsonObject)o, (String)"shiftChars", null), JsonUtil.getJsonStringOrNull(o, "binding", ControllerBinding.map::get), JsonUtil.getJsonStringOrNull(o, "icon", FactoryAPI::createLocation), JsonUtil.getJsonStringOrNull(o, "soundEvent", s -> (SoundEvent)FactoryAPIPlatform.getRegistryValue((ResourceLocation)FactoryAPI.createLocation((String)s), (Registry)BuiltInRegistries.SOUND_EVENT))));
                } else if (e instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(25, p.getAsString(), null, null, null, null));
                }
            });
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.warn(e2.getMessage());
        }
    }

    public static void addIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, JsonObject> addIcon) {
        resourceManager.getResource(location).ifPresent(r -> {
            try {
                GsonHelper.parse((Reader)r.openAsReader()).asMap().forEach((s, o) -> addIcon.accept((String)s, o.getAsJsonObject()));
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn(e.getMessage());
            }
        });
    }

    public static void addControllerIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            ControllerBinding<?> binding = ControllerBinding.map.get(s);
            if (binding != null) {
                addIcon.accept((String)s, ControlTooltip.LegacyIcon.create(() -> ((BindingState)binding.getMapped().state()).pressed, JsonUtil.getJsonStringOrNull(o, "icon", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))), () -> !((BindingState)binding.getMapped().state()).isBlocked(), ControlType::getActiveControllerType));
            }
        });
    }

    public static void addKbmIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            InputConstants.Key key = InputConstants.getKey((String)s);
            ControlTooltip.LegacyIcon icon = ControlTooltip.LegacyIcon.create(key, JsonUtil.getJsonStringOrNull(o, "icon", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))));
            addIcon.accept(key.getName(), icon);
        });
    }

    public static void registerIntroLocations(ResourceManager resourceManager) {
        try {
            INTROS.clear();
            JsonArray array = GsonHelper.parseArray((Reader)resourceManager.getResourceOrThrow(INTRO_LOCATION).openAsReader());
            array.forEach(e -> INTROS.add(FactoryAPI.createLocation((String)e.getAsString())));
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.error(e2.getMessage());
        }
    }

    public String getName() {
        return "legacy:resource_manager";
    }
}

