/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.GlobalPacks;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public record PackAlbum(String id, int version, Component displayName, Component description, Optional<ResourceLocation> iconSprite, Optional<ResourceLocation> backgroundSprite, List<String> packs, Optional<String> displayPack) {
    public static final Codec<PackAlbum> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("id").forGetter(PackAlbum::id), (App)Codec.INT.optionalFieldOf("version", (Object)0).forGetter(PackAlbum::version), (App)DynamicUtil.getComponentCodec().fieldOf("name").forGetter(PackAlbum::displayName), (App)DynamicUtil.getComponentCodec().fieldOf("description").forGetter(PackAlbum::description), (App)ResourceLocation.CODEC.optionalFieldOf("icon").forGetter(PackAlbum::iconSprite), (App)ResourceLocation.CODEC.optionalFieldOf("background").forGetter(PackAlbum::backgroundSprite), (App)Codec.STRING.listOf().fieldOf("packs").forGetter(PackAlbum::packs), (App)Codec.STRING.optionalFieldOf("displayPack").forGetter(PackAlbum::displayPack)).apply((Applicative)i, PackAlbum::new));
    public static final Codec<List<PackAlbum>> LIST_CODEC = CODEC.listOf();
    public static final ListMap<String, PackAlbum> resourceAlbums = new ListMap();
    public static final List<PackAlbum> DEFAULT_RESOURCE_ALBUMS = new ArrayList<PackAlbum>();
    public static final String RESOURCE_ALBUMS = "resource_albums";
    public static final Path RESOURCE_ALBUMS_PATH = Minecraft.getInstance().gameDirectory.toPath().resolve("resource_albums");
    @Deprecated
    public static final Path RESOURCE_ASSORTS_PATH = Minecraft.getInstance().gameDirectory.toPath().resolve("resource_assorts");
    public static final Component ALBUM_OPTIONS = Component.translatable((String)"legacy.menu.album_options");
    public static final Component ALBUM_OPTIONS_MESSAGE = Component.translatable((String)"legacy.menu.album_options_message");
    public static final Component ADD_ALBUM = Component.translatable((String)"legacy.menu.add_album");
    public static final Component EDIT_ALBUM = Component.translatable((String)"legacy.menu.edit_album");
    public static final Component REMOVE_ALBUM = Component.translatable((String)"legacy.menu.remove_album");
    public static final Gson GSON = new GsonBuilder().create();
    public static final PackAlbum MINECRAFT = PackAlbum.registerDefaultResource("minecraft", 2, (Component)Component.translatable((String)"legacy.menu.albums.resource.minecraft"), (Component)Component.translatable((String)"legacy.menu.albums.resource.minecraft.description"), null, Legacy4J.createModLocation("icon/background"), PackAlbum.getMinecraftResourcePacks(), "vanilla");
    public static final PackAlbum MINECRAFT_CLASSIC_TEXTURES = PackAlbum.registerDefaultResource("minecraft_classic", 1, (Component)Component.translatable((String)"legacy.menu.albums.resource.minecraft_classic"), (Component)Component.translatable((String)"legacy.menu.albums.resource.minecraft_classic.description"), Legacy4J.createModLocation("icon/minecraft_classic"), Legacy4J.createModLocation("icon/minecraft_classic_background"), PackAlbum.getMinecraftClassicResourcePacks(), null);
    public static final Stocker<String> defaultResourceAlbum = Stocker.of((Object)PackAlbum.MINECRAFT.id);

    public static List<String> getMinecraftResourcePacks() {
        return new ArrayList<String>(List.of("vanilla", FactoryAPI.getLoader().isForgeLike() ? "mod_resources" : "fabric", "legacy:legacy_waters"));
    }

    public static List<String> getMinecraftClassicResourcePacks() {
        List<String> album = PackAlbum.getMinecraftResourcePacks();
        album.add(album.size() - 1, "programmer_art");
        if (FactoryAPI.getLoader().isForgeLike()) {
            album.add(album.size() - 1, "legacy:programmer_art");
        }
        return album;
    }

    public static PackAlbum getDefaultResourceAlbum() {
        return PackAlbum.resourceById((String)defaultResourceAlbum.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PackAlbum)) return false;
        PackAlbum a = (PackAlbum)obj;
        if (!a.id.equals(this.id)) return false;
        return true;
    }

    public PackAlbum withPacks(List<String> packs) {
        return new PackAlbum(this.id, this.version, this.displayName, this.description, this.iconSprite, this.backgroundSprite, packs, this.displayPack);
    }

    public static void init() {
        List<PackAlbum> albums = Files.exists(RESOURCE_ASSORTS_PATH, new LinkOption[0]) ? PackAlbum.load(RESOURCE_ASSORTS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum, true) : Collections.emptyList();
        albums.forEach(PackAlbum::registerResource);
        if (!Files.exists(RESOURCE_ALBUMS_PATH, new LinkOption[0]) || !albums.isEmpty()) {
            PackAlbum.save(RESOURCE_ALBUMS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum);
        }
        if (albums.isEmpty()) {
            PackAlbum.load();
        }
    }

    public static PackAlbum resourceById(String s) {
        return (PackAlbum)resourceAlbums.getOrDefault((Object)s, (Object)MINECRAFT);
    }

    public static void load() {
        resourceAlbums.clear();
        PackAlbum.load(RESOURCE_ALBUMS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum).forEach(PackAlbum::registerResource);
    }

    public static List<PackAlbum> load(Path path, List<PackAlbum> defaultAlbums, Stocker<String> selected) {
        return PackAlbum.load(path, defaultAlbums, selected, false);
    }

    public static List<PackAlbum> load(Path path, List<PackAlbum> defaultAlbums, Stocker<String> selected, boolean deprecated) {
        ArrayList<String> order = new ArrayList<String>();
        Path orderJson = path.resolveSibling(String.valueOf(path.getFileName()) + ".json");
        String defaultAlbum = PackAlbum.MINECRAFT.id;
        try (BufferedReader r2 = Files.newBufferedReader(orderJson, Charsets.UTF_8);){
            JsonObject obj = (JsonObject)GSON.getAdapter(JsonObject.class).read(new JsonReader((Reader)r2));
            defaultAlbum = obj.getAsJsonPrimitive("default").getAsString();
            for (JsonElement e : obj.getAsJsonArray("order")) {
                if (!(e instanceof JsonPrimitive)) continue;
                order.add(e.getAsString());
            }
        }
        catch (IOException r2) {
            // empty catch block
        }
        for (int i = defaultAlbums.size() - 1; i >= 0; --i) {
            PackAlbum a = defaultAlbums.get(i);
            if (order.contains(a.id)) continue;
            order.add(0, a.id);
        }
        ArrayList<PackAlbum> list = new ArrayList<PackAlbum>();
        try (Stream<Path> s = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.comparingInt(p -> {
            int i = order.indexOf(FilenameUtils.getBaseName((String)p.getFileName().toString()));
            return i < 0 ? order.size() : i;
        }));){
            for (Path p2 : s::iterator) {
                if (!p2.toString().endsWith(".json")) continue;
                try {
                    BufferedReader r = Files.newBufferedReader(p2, Charsets.UTF_8);
                    try {
                        CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.parse((Reader)r)).result().ifPresent(list::add);
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                    }
                }
                catch (IOException e) {
                    Legacy4J.LOGGER.warn("Failed to load {}, this album won't be loaded", (Object)p2, (Object)e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (deprecated) {
            FileUtils.deleteQuietly((File)path.toFile());
            FileUtils.deleteQuietly((File)orderJson.toFile());
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
        }
        for (int i = defaultAlbums.size() - 1; i >= 0; --i) {
            PackAlbum a = defaultAlbums.get(i);
            int index = list.indexOf(a);
            if (index < 0) {
                list.add(0, a);
                continue;
            }
            if (a.version <= ((PackAlbum)list.get((int)index)).version) continue;
            list.set(index, a);
        }
        selected.set((Object)defaultAlbum);
        return list;
    }

    public static void save() {
        PackAlbum.save(RESOURCE_ALBUMS_PATH, resourceAlbums.values(), defaultResourceAlbum);
    }

    public static void save(Path path, Collection<PackAlbum> albums, Stocker<String> selected) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Failed to make albums directory {}", (Object)path, (Object)e);
            }
        } else {
            FileUtils.listFiles((File)path.toFile(), (String[])new String[]{"json"}, (boolean)true).forEach(File::delete);
        }
        ArrayList<String> order = new ArrayList<String>();
        for (PackAlbum album : albums) {
            order.add(album.id);
            Path p = path.resolve(album.id + ".json");
            try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(p, Charsets.UTF_8, new OpenOption[0]));){
                w.setSerializeNulls(false);
                w.setIndent("  ");
                GsonHelper.writeValue((JsonWriter)w, (JsonElement)((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)album).result().orElseThrow()), null);
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Failed to write {}, this album won't be saved", (Object)p, (Object)e);
            }
        }
        Path orderJson = path.resolveSibling(String.valueOf(path.getFileName()) + ".json");
        try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(orderJson, Charsets.UTF_8, new OpenOption[0]));){
            w.setSerializeNulls(false);
            w.setIndent("  ");
            JsonArray a = new JsonArray();
            order.forEach(arg_0 -> ((JsonArray)a).add(arg_0));
            JsonObject obj = new JsonObject();
            obj.add("default", (JsonElement)new JsonPrimitive((String)selected.get()));
            obj.add("order", (JsonElement)a);
            GsonHelper.writeValue((JsonWriter)w, (JsonElement)obj, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PackAlbum registerResource(PackAlbum a) {
        resourceAlbums.put((Object)a.id(), (Object)a);
        return a;
    }

    public static PackAlbum registerDefaultResource(String id, int version, Component displayName, Component description, ResourceLocation iconSprite, ResourceLocation backgroundSprite, List<String> packs, String displayPack) {
        return PackAlbum.registerDefaultResource(new PackAlbum(id, version, displayName, description, Optional.ofNullable(iconSprite), Optional.ofNullable(backgroundSprite), packs, Optional.ofNullable(displayPack)));
    }

    public static PackAlbum registerDefaultResource(PackAlbum a) {
        DEFAULT_RESOURCE_ALBUMS.add(a);
        return a;
    }

    public static void applyDefaultResourceAlbum() {
        List<String> oldSelection = PackAlbum.getSelectableIds(Minecraft.getInstance().getResourcePackRepository());
        ((GlobalPacks)GlobalPacks.globalResources.get()).applyPacks(Minecraft.getInstance().getResourcePackRepository(), PackAlbum.getDefaultResourceAlbum().packs());
        if (!oldSelection.equals(PackAlbum.getSelectableIds(Minecraft.getInstance().getResourcePackRepository()))) {
            Minecraft.getInstance().reloadResourcePacks();
            PackAlbum.updateSavedResourcePacks();
        }
    }

    public static void updateSavedResourcePacks() {
        Minecraft.getInstance().options.resourcePacks.clear();
        Minecraft.getInstance().options.incompatibleResourcePacks.clear();
        Minecraft.getInstance().getResourcePackRepository().getSelectedPacks().forEach(p -> {
            if (p.getCompatibility().isCompatible()) {
                Minecraft.getInstance().options.resourcePacks.add(p.getId());
            } else {
                Minecraft.getInstance().options.incompatibleResourcePacks.add(p.getId());
            }
        });
    }

    public static List<String> getSelectedIds(PackRepository packRepository) {
        return packRepository.getSelectedPacks().stream().map(Pack::getId).toList();
    }

    public static List<String> getSelectableIds(PackRepository packRepository) {
        return packRepository.getSelectedPacks().stream().filter(pack -> !FactoryAPIPlatform.isPackHidden((Pack)pack)).map(Pack::getId).toList();
    }

    public boolean isValidPackDisplay(PackRepository packRepository) {
        String id = this.getDisplayPackId();
        if (id == null) {
            return false;
        }
        return packRepository.getPack(id) != null;
    }

    public String getDisplayPackId() {
        return this.displayPack.orElse(this.packs.isEmpty() ? null : this.packs.get(this.packs.size() - 1));
    }

    public static ConfirmationScreen createAlbumEditScreen(Screen parent, Component title, Component defaultName, Component defaultDescription, BiConsumer<Component, Component> editAlbum) {
        final EditBox nameBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, (Component)Component.translatable((String)"legacy.menu.album_info"));
        final MultiLineEditBox descriptionBox = new MultiLineEditBox(Minecraft.getInstance().font, 0, 0, 200, 60, defaultDescription, nameBox.getMessage());
        nameBox.setHint(defaultName);
        return new ConfirmationScreen(parent, 230, 184, title, nameBox.getMessage(), p -> editAlbum.accept((Component)(nameBox.getValue().isBlank() ? defaultName : Component.literal((String)nameBox.getValue())), (Component)(descriptionBox.getValue().isBlank() ? defaultDescription : Component.literal((String)descriptionBox.getValue())))){

            @Override
            protected void init() {
                super.init();
                nameBox.setPosition(this.panel.x + 15, this.panel.y + 45);
                this.addRenderableWidget((GuiEventListener)nameBox);
                descriptionBox.setPosition(this.panel.x + 15, this.panel.y + 69);
                this.addRenderableWidget((GuiEventListener)descriptionBox);
            }
        };
    }

    public static class Selector
    extends AbstractWidget
    implements ControlTooltip.ActionHolder {
        public static final String TEMPLATE_ALBUM = "template_album";
        public static final ResourceLocation DEFAULT_ICON = FactoryAPI.createVanillaLocation((String)"textures/misc/unknown_pack.png");
        private static final Map<String, ResourceLocation> packIcons = Maps.newHashMap();
        private static final Map<String, ResourceLocation> packBackgrounds = Maps.newHashMap();
        private final ListMap<String, PackAlbum> albums;
        public final Stocker.Sizeable scrolledList;
        private final Component screenComponent;
        public PackAlbum savedAlbum;
        protected final PackAlbum initialAlbum;
        private final Path packPath;
        private final Consumer<Selector> reloadChanges;
        private final FactoryConfig<GlobalPacks> globalPacks;
        private final boolean hasTooltip;
        public int selectedIndex;
        private final PackRepository packRepository;
        private final Minecraft minecraft;
        protected final List<String> oldSelection;
        protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
        public final ScrollableRenderer scrollableRenderer = new ScrollableRenderer(this.scrollRenderer);
        public final BiFunction<Component, Integer, MultiLineLabel> labelsCache = Util.memoize((c, i) -> MultiLineLabel.create((Font)Minecraft.getInstance().font, (Component)c, (int)i));

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip) {
            return new Selector(i, j, k, l, LegacyComponents.RESOURCE_ALBUMS, LegacyComponents.SHOW_RESOURCE_PACKS, (ListMap)resourceAlbums, Minecraft.getInstance().hasSingleplayerServer() ? LegacyClientWorldSettings.of(Minecraft.getInstance().getSingleplayerServer().getWorldData()).getSelectedResourceAlbum() : PackAlbum.resourceById((String)defaultResourceAlbum.get()), Minecraft.getInstance().getResourcePackRepository(), Minecraft.getInstance().getResourcePackDirectory(), Selector::reloadResourcesChanges, (FactoryConfig)GlobalPacks.globalResources, hasTooltip){

                @Override
                public void applyChanges(boolean reloadAndSave) {
                    super.applyChanges(reloadAndSave);
                    if (!Minecraft.getInstance().hasSingleplayerServer()) {
                        defaultResourceAlbum.set((Object)this.savedAlbum.id());
                        PackAlbum.save();
                    }
                }
            };
        }

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip, PackAlbum selectedAlbum) {
            return new Selector(i, j, k, l, LegacyComponents.RESOURCE_ALBUMS, LegacyComponents.SHOW_RESOURCE_PACKS, resourceAlbums, selectedAlbum, Minecraft.getInstance().getResourcePackRepository(), Minecraft.getInstance().getResourcePackDirectory(), Selector::reloadResourcesChanges, GlobalPacks.globalResources, hasTooltip);
        }

        public Selector(int i2, int j, int k, int l, Component component, Component screenComponent, ListMap<String, PackAlbum> albums, PackAlbum savedAlbum, PackRepository packRepository, Path packPath, Consumer<Selector> reloadChanges, FactoryConfig<GlobalPacks> globalPacks, boolean hasTooltip) {
            super(i2, j, k, l, component);
            this.screenComponent = screenComponent;
            this.savedAlbum = this.initialAlbum = savedAlbum;
            this.packPath = packPath;
            this.reloadChanges = reloadChanges;
            this.globalPacks = globalPacks;
            this.hasTooltip = hasTooltip;
            this.albums = albums;
            this.minecraft = Minecraft.getInstance();
            this.packRepository = packRepository;
            this.oldSelection = PackAlbum.getSelectedIds(packRepository);
            this.scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
            if (albums.size() > this.getMaxPacks()) {
                this.scrolledList.max = albums.size() - this.getMaxPacks();
            }
            this.setSelectedIndex(savedAlbum == null ? 0 : ((List)albums.values()).indexOf(savedAlbum));
            while (this.selectedIndex >= (Integer)this.scrolledList.get() + this.getMaxPacks() && this.scrolledList.add(1) != 0) {
            }
            this.updateTooltip();
        }

        public void updateTooltip() {
            if (this.hasTooltip) {
                this.setTooltip(Tooltip.create((Component)this.getSelectedAlbum().description(), (Component)this.getSelectedAlbum().displayName()));
            }
        }

        public void renderTooltipBox(GuiGraphics guiGraphics, LayoutElement panel) {
            this.renderTooltipBox(guiGraphics, panel, 0);
        }

        public void renderTooltipBox(GuiGraphics guiGraphics, LayoutElement panel, int xOffset) {
            this.renderTooltipBox(guiGraphics, panel.getX() + panel.getWidth() - 2 + xOffset, panel.getY() + 5, 161, panel.getHeight() - 10);
        }

        public void renderTooltipBox(GuiGraphics graphics, int x, int y, int width, int height) {
            if (this.hasTooltip) {
                return;
            }
            ScreenUtil.renderPointerPanel(graphics, x, y, width, height);
            if (this.getSelectedAlbum() != null) {
                boolean p = this.getSelectedAlbum().isValidPackDisplay(this.packRepository);
                if (this.getSelectedAlbum().iconSprite().isPresent()) {
                    FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(this.getSelectedAlbum().iconSprite().get(), x + 7, y + 5, 32, 32);
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)graphics).blit(p ? Selector.getPackIcon(this.packRepository.getPack(this.getSelectedAlbum().getDisplayPackId())) : DEFAULT_ICON, x + 7, y + 5, 0.0f, 0.0f, 32, 32, 32, 32);
                }
                graphics.enableScissor(x + 40, y + 4, x + 148, y + 44);
                this.labelsCache.apply(this.getSelectedAlbum().displayName(), 108).renderLeftAligned(graphics, x + 43, y + 8, 12, 0xFFFFFF);
                graphics.disableScissor();
                ResourceLocation background = this.getSelectedAlbum().backgroundSprite.orElse(p ? Selector.getPackBackground(this.packRepository.getPack(this.getSelectedAlbum().getDisplayPackId())) : null);
                MultiLineLabel label = this.labelsCache.apply(this.getSelectedAlbum().description(), 145);
                this.scrollableRenderer.render(graphics, x + 8, y + 40, 146, 12 * (background == null ? 14 : 7), () -> label.renderLeftAligned(graphics, x + 8, y + 40, 12, 0xFFFFFF));
                if (background != null) {
                    if (this.getSelectedAlbum().backgroundSprite().isPresent()) {
                        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(background, x + 8, y + height - 78, 145, 72);
                    } else {
                        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(background, x + 8, y + height - 78, 0.0f, 0.0f, 145, 72, 145, 72);
                    }
                }
            }
        }

        public boolean keyPressed(int i, int j, int k) {
            if (this.isHoveredOrFocused() && this.active) {
                if (i == 88) {
                    this.openPackSelectionScreen();
                    return true;
                }
                if (CommonInputs.selected((int)i)) {
                    this.savedAlbum = this.getSelectedAlbum();
                    this.playDownSound(Minecraft.getInstance().getSoundManager());
                    return true;
                }
                if (i == 263 || i == 262) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get() + (i == 263 ? 0 : this.getMaxPacks() - 1)) {
                        this.updateScroll(i == 263 ? -1 : 1, true);
                    }
                    this.setSelectedIndex(this.selectedIndex + (i == 263 ? -1 : 1));
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
                    return true;
                }
                if (i == 79) {
                    final Screen screen = Minecraft.getInstance().screen;
                    this.minecraft.setScreen((Screen)new ConfirmationScreen(this.minecraft.screen, 230, 133, ALBUM_OPTIONS, ALBUM_OPTIONS_MESSAGE, b -> {}){

                        @Override
                        protected void addButtons() {
                            this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).build());
                            this.renderableVList.addRenderable((Renderable)Button.builder((Component)ADD_ALBUM, b -> {
                                int repeat = 0;
                                while (!PackAlbum.resourceById(Selector.TEMPLATE_ALBUM + (String)(repeat > 0 ? "_" + repeat : "")).equals(MINECRAFT)) {
                                    ++repeat;
                                }
                                String id = Selector.TEMPLATE_ALBUM + (String)(repeat > 0 ? "_" + repeat : "");
                                this.minecraft.setScreen((Screen)PackAlbum.createAlbumEditScreen(this.parent, b.getMessage(), (Component)Component.translatable((String)"legacy.menu.albums.resource.template", (Object[])new Object[]{repeat}), (Component)Component.translatable((String)"legacy.menu.albums.resource.template.description"), (name, description) -> this.minecraft.setScreen((Screen)new PackSelectionScreen(packRepository, r -> {
                                    resourceAlbums.put((Object)id, (Object)new PackAlbum(id, 0, (Component)name, (Component)description, Optional.empty(), Optional.empty(), PackAlbum.getSelectableIds(packRepository), Optional.empty()));
                                    PackAlbum.save();
                                    Minecraft.getInstance().setScreen(this.parent);
                                    packRepository.setSelected(oldSelection);
                                    this.updateSavedAlbum();
                                    this.setSelectedIndex(albums.size());
                                }, packPath, this.title))));
                            }).build());
                            this.renderableVList.addRenderable((Renderable)Button.builder((Component)EDIT_ALBUM, b -> {
                                PackAlbum editAlbum = this.getSelectedAlbum();
                                this.minecraft.setScreen((Screen)PackAlbum.createAlbumEditScreen(this.parent, b.getMessage(), editAlbum.displayName, editAlbum.description, (name, description) -> {
                                    resourceAlbums.put((Object)editAlbum.id(), (Object)new PackAlbum(editAlbum.id(), editAlbum.version(), (Component)name, (Component)description, editAlbum.iconSprite(), editAlbum.backgroundSprite(), editAlbum.packs(), editAlbum.displayPack()));
                                    PackAlbum.save();
                                    Minecraft.getInstance().setScreen(this.parent);
                                    packRepository.setSelected(oldSelection);
                                    this.updateSavedAlbum();
                                }));
                            }).build());
                            Button removeButton = Button.builder((Component)REMOVE_ALBUM, b -> {
                                albums.remove((Object)this.getSelectedAlbum().id());
                                PackAlbum.save();
                                this.updateSavedAlbum();
                                this.setSelectedIndex(0);
                                this.minecraft.setScreen(screen);
                            }).build();
                            this.renderableVList.addRenderable((Renderable)removeButton);
                            if (DEFAULT_RESOURCE_ALBUMS.stream().anyMatch(a -> a.equals(this.getSelectedAlbum()))) {
                                removeButton.active = false;
                            }
                        }
                    });
                    return true;
                }
            }
            return super.keyPressed(i, j, k);
        }

        public void setSelectedIndex(int index) {
            if (this.selectedIndex == index) {
                return;
            }
            this.selectedIndex = Stocker.cyclic((int)0, (int)index, (int)this.albums.size());
            this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
            this.scrollableRenderer.scrolled.max = Math.max((int)0, (int)(this.labelsCache.apply(this.getSelectedAlbum().description(), 145).getLineCount() - (this.getSelectedAlbum().backgroundSprite.orElse(this.getSelectedAlbum().isValidPackDisplay(this.packRepository) ? Selector.getPackBackground(this.packRepository.getPack(this.getSelectedAlbum().getDisplayPackId())) : null) == null ? 20 : 7)));
            this.updateTooltip();
        }

        public void applyChanges(boolean reloadAndSave) {
            ((GlobalPacks)this.globalPacks.get()).applyPacks(this.packRepository, this.savedAlbum.packs());
            if (Minecraft.getInstance().hasSingleplayerServer()) {
                LegacyClientWorldSettings.of(Minecraft.getInstance().getSingleplayerServer().getWorldData()).setSelectedResourceAlbum(this.savedAlbum);
            }
            if (reloadAndSave) {
                this.reloadChanges.accept(this);
            }
        }

        public static void applyResourceChanges(Minecraft minecraft, List<String> oldSelection, List<String> newSelection, Runnable runnable) {
            ((GlobalPacks)GlobalPacks.globalResources.get()).applyPacks(minecraft.getResourcePackRepository(), newSelection);
            minecraft.setScreen((Screen)new LegacyLoadingScreen());
            if (!oldSelection.equals(PackAlbum.getSelectedIds(minecraft.getResourcePackRepository()))) {
                PackAlbum.updateSavedResourcePacks();
                Minecraft.getInstance().reloadResourcePacks().thenRun(runnable);
            } else {
                runnable.run();
            }
        }

        public static void reloadResourcesChanges(Selector selector) {
            if (!selector.oldSelection.equals(PackAlbum.getSelectedIds(selector.packRepository))) {
                PackAlbum.updateSavedResourcePacks();
                Minecraft.getInstance().reloadResourcePacks();
            }
        }

        public void openPackSelectionScreen() {
            if (this.minecraft.screen != null) {
                Screen screen = this.minecraft.screen;
                this.packRepository.setSelected(this.getSelectedAlbum().packs());
                List<String> oldSelection = PackAlbum.getSelectedIds(this.packRepository);
                this.minecraft.setScreen((Screen)new PackSelectionScreen(this.packRepository, p -> {
                    if (!oldSelection.equals(PackAlbum.getSelectedIds(p))) {
                        this.albums.put((Object)this.getSelectedAlbum().id(), (Object)this.getSelectedAlbum().withPacks(List.copyOf(PackAlbum.getSelectableIds(p))));
                        this.updateSavedAlbum();
                        PackAlbum.save();
                    }
                    this.minecraft.setScreen(screen);
                    this.packRepository.setSelected(this.oldSelection);
                }, this.packPath, this.getMessage()));
            }
        }

        public void updateSavedAlbum() {
            this.savedAlbum = (PackAlbum)this.albums.getOrDefault((Object)this.savedAlbum.id(), (Object)this.initialAlbum);
        }

        public void setFocused(boolean bl) {
            if (!bl && this.savedAlbum != null) {
                this.setSelectedIndex(((List)this.albums.values()).indexOf(this.savedAlbum));
            }
            super.setFocused(bl);
        }

        public void onClick(double d, double e) {
            if (Screen.hasShiftDown()) {
                this.openPackSelectionScreen();
                return;
            }
            int visibleCount = 0;
            for (int index = 0; index < this.albums.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                double d2 = this.getX() + 20 + 30 * index;
                int n = this.getY();
                Objects.requireNonNull(this.minecraft.font);
                if (!ScreenUtil.isMouseOver(d, e, d2, n + 9 + 3, 30, 30)) continue;
                this.setSelectedIndex(index + (Integer)this.scrolledList.get());
                this.savedAlbum = this.getSelectedAlbum();
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                return;
            }
            super.onClick(d, e);
        }

        public boolean mouseScrolled(double d, double e, double f, double g) {
            if (this.updateScroll((int)Math.signum((double)g), false)) {
                return true;
            }
            return super.mouseScrolled(d, e, f, g);
        }

        public boolean updateScroll(int i, boolean cyclic) {
            if (this.scrolledList.max > 0 && ((Integer)this.scrolledList.get() <= this.scrolledList.max && i > 0 || (Integer)this.scrolledList.get() >= 0 && i < 0)) {
                return this.scrolledList.add(i, cyclic) != 0;
            }
            return false;
        }

        protected int getMaxPacks() {
            return (this.width - 40) / 30;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            Font font = this.minecraft.font;
            FactoryGuiGraphics factoryGuiGraphics = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
            int n = this.getX() - 1;
            int n2 = this.getY();
            Objects.requireNonNull(font);
            int n3 = n2 + 9 - 1;
            Objects.requireNonNull(this.minecraft.font);
            factoryGuiGraphics.blitSprite(LegacySprites.PANEL_RECESS, n, n3, this.width + 2, this.height + 2 - 9);
            int visibleCount = 0;
            RenderSystem.enableBlend();
            for (int index = 0; index < this.albums.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                PackAlbum album = (PackAlbum)this.albums.getByIndex(Math.min((int)(this.albums.size() - 1), (int)((Integer)this.scrolledList.get() + index)));
                if (album.iconSprite().isPresent()) {
                    FactoryGuiGraphics factoryGuiGraphics2 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                    int n4 = this.getX() + 21 + 30 * index;
                    int n5 = this.getY();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics2.blitSprite(album.iconSprite().get(), n4, n5 + 9 + 4, 28, 28);
                } else {
                    FactoryGuiGraphics factoryGuiGraphics3 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                    ResourceLocation resourceLocation = album.isValidPackDisplay(this.packRepository) ? Selector.getPackIcon(this.packRepository.getPack(album.getDisplayPackId())) : DEFAULT_ICON;
                    int n6 = this.getX() + 21 + 30 * index;
                    int n7 = this.getY();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics3.blit(resourceLocation, n6, n7 + 9 + 4, 0.0f, 0.0f, 28, 28, 28, 28);
                }
                if ((Integer)this.scrolledList.get() + index != this.selectedIndex) continue;
                FactoryGuiGraphics factoryGuiGraphics4 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                int n8 = this.getX() + 20 + 30 * index;
                int n9 = this.getY();
                Objects.requireNonNull(font);
                factoryGuiGraphics4.blitSprite(LegacySprites.PACK_HIGHLIGHTED, n8, n9 + 9 + 3, 30, 30);
            }
            RenderSystem.disableBlend();
            guiGraphics.pose().pushPose();
            if (!this.isHoveredOrFocused()) {
                guiGraphics.pose().translate(0.5f, 0.5f, 0.0f);
            }
            guiGraphics.drawString(font, this.getMessage(), this.getX() + 2, this.getY(), this.isHoveredOrFocused() ? ScreenUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.isHoveredOrFocused());
            guiGraphics.pose().popPose();
            if (this.scrolledList.max > 0) {
                if ((Integer)this.scrolledList.get() < this.scrolledList.max) {
                    int n10 = this.getX() + this.width - 12;
                    int n11 = this.getY();
                    Objects.requireNonNull(font);
                    int n12 = n11 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, n10, n12 + (this.height - 9 - 11) / 2);
                }
                if ((Integer)this.scrolledList.get() > 0) {
                    int n13 = this.getX() + 8;
                    int n14 = this.getY();
                    Objects.requireNonNull(font);
                    int n15 = n14 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, n13, n15 + (this.height - 9 - 11) / 2);
                }
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ResourceLocation loadPackIcon(TextureManager textureManager, Pack pack, String icon, ResourceLocation fallback) {
            try (PackResources packResources = pack.open();){
                void resourceLocation2;
                IoSupplier ioSupplier = packResources.getRootResource(new String[]{icon});
                if (ioSupplier == null) {
                    ResourceLocation resourceLocation3 = fallback;
                    return resourceLocation3;
                }
                String string = pack.getId();
                ResourceLocation resourceLocation3 = FactoryAPI.createLocation((String)"minecraft", (String)(icon + "/" + Util.sanitizeName((String)string, ResourceLocation::validPathChar) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)string)) + "/icon"));
                try (InputStream inputStream = (InputStream)ioSupplier.get();){
                    NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                    textureManager.register(resourceLocation3, (AbstractTexture)new DynamicTexture(nativeImage));
                    ResourceLocation resourceLocation22 = resourceLocation3;
                }
                void resourceLocation = resourceLocation2;
                return resourceLocation;
            }
            catch (Exception exception) {
                Legacy4J.LOGGER.warn("Failed to load icon from pack {}", (Object)pack.getId(), (Object)exception);
                return fallback;
            }
        }

        public static ResourceLocation getPackIcon(Pack pack) {
            return packIcons.computeIfAbsent(pack.getId(), string -> Selector.loadPackIcon(Minecraft.getInstance().getTextureManager(), pack, "pack.png", DEFAULT_ICON));
        }

        public static ResourceLocation getPackBackground(Pack pack) {
            return packBackgrounds.computeIfAbsent(pack.getId(), string -> Selector.loadPackIcon(Minecraft.getInstance().getTextureManager(), pack, "background.png", null));
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        public PackAlbum getSelectedAlbum() {
            return this.albums.isEmpty() || this.selectedIndex > this.albums.size() ? null : (PackAlbum)this.albums.getByIndex(this.selectedIndex);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> k.key() == 79 && this.isFocused() ? LegacyComponents.ALBUM_OPTIONS : (k.key() == 88 && this.isFocused() || k.key() == 0 && this.isHovered() ? this.screenComponent : ControlTooltip.getSelectAction((GuiEventListener)this, context)));
        }
    }
}

