/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;

public interface RecipeInfo<T>
extends RegisterListing.Holder<T> {
    default public boolean isInvalid() {
        Recipe r;
        Object object = this.get();
        return object instanceof Recipe && (r = (Recipe)object).isSpecial() || this.getOptionalIngredients().isEmpty() || this.getResultItem().isEmpty();
    }

    default public boolean isOverride() {
        return this.get() == null;
    }

    public List<Optional<Ingredient>> getOptionalIngredients();

    public ItemStack getResultItem();

    public Component getName();

    public Component getDescription();

    public static <T> RecipeInfo<T> create(ResourceKey<Recipe<?>> id, T value, List<Optional<Ingredient>> ings, ItemStack result) {
        return RecipeInfo.create(id.location(), value, ings, result, () -> null);
    }

    public static <T> RecipeInfo<T> create(ResourceLocation id, T value, List<Optional<Ingredient>> ings, ItemStack result) {
        return RecipeInfo.create(id, value, ings, result, () -> null);
    }

    public static <T> RecipeInfo<T> create(ResourceLocation id, T value, List<Optional<Ingredient>> ings, ItemStack result, Supplier<Component> description) {
        return RecipeInfo.create(id, value, ings, result, result.getHoverName(), description);
    }

    public static <T> RecipeInfo<T> create(final ResourceLocation id, final T value, final List<Optional<Ingredient>> ings, final ItemStack result, final Component name, final Supplier<Component> description) {
        return new RecipeInfo<T>(){

            public T get() {
                return value;
            }

            public ResourceLocation getId() {
                return id;
            }

            @Override
            public List<Optional<Ingredient>> getOptionalIngredients() {
                return ings;
            }

            @Override
            public ItemStack getResultItem() {
                return result;
            }

            @Override
            public Component getName() {
                return name;
            }

            @Override
            public Component getDescription() {
                return (Component)description.get();
            }

            public boolean equals(Object obj) {
                RecipeInfo h1;
                RecipeHolder h;
                return super.equals(obj) || obj instanceof RecipeHolder && (h = (RecipeHolder)obj).id().equals((Object)this.getId()) || obj instanceof RecipeInfo && (h1 = (RecipeInfo)obj).getId().equals((Object)this.getId());
            }
        };
    }

    public static interface Filter
    extends Predicate<RecipeInfo<?>> {
        public static final ListMap<ResourceLocation, Codec<? extends Filter>> map = ListMap.builder().put((Object)"id", Id.CODEC).put((Object)"item_tag", Id.CODEC).put((Object)"block_tag", BlockTag.CODEC).put((Object)"item_id", ItemId.CODEC).mapKeys(FactoryAPI::createVanillaLocation).build();
        public static final Codec<Filter> BY_TYPE_CODEC = new Codec<Filter>(){

            public <T> DataResult<T> encode(Filter input, DynamicOps<T> ops, T prefix) {
                ResourceLocation.CODEC.fieldOf("type").codec().encode((Object)((ResourceLocation)map.getKey(input.codec())), ops, prefix);
                return input.codec().fieldOf("value").codec().encode((Object)input, ops, prefix);
            }

            public <T> DataResult<Pair<Filter, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic = new Dynamic(ops, input);
                return dynamic.get("type").flatMap(arg_0 -> ((Codec)ResourceLocation.CODEC).parse(arg_0)).flatMap(r -> dynamic.get("value").flatMap(d -> ((Codec)map.get(r)).parse(d)).map(f -> Pair.of((Object)f, (Object)input)));
            }
        };
        public static final Codec<Filter> CODEC = Codec.either(BY_TYPE_CODEC, (Codec)Codec.STRING.xmap(Filter::parse, (Function<Filter, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lwily/legacy/client/RecipeInfo$Filter;)Ljava/lang/String;)())).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);
        public static final Codec<List<Filter>> LIST_CODEC = CODEC.listOf().xmap(ArrayList::new, Function.identity());
        public static final Codec<Map<String, List<Filter>>> LISTING_CODEC = Filter.createListingCodec(Codec.either(CODEC, LIST_CODEC).xmap(e -> e.right().orElseGet(() -> new ArrayList<Filter>(Collections.singleton((Filter)e.left().get()))), Either::right), "group", "recipes", l -> ((Filter)l.get(0)).toString());
        public static final ResourceLocation TIPPED_ARROW = FactoryAPI.createVanillaLocation((String)"tipped_arrow");
        public static final ResourceLocation SUSPICIOUS_STEW = FactoryAPI.createVanillaLocation((String)"suspicious_stew");
        public static final Map<ResourceLocation, IdOverride> ID_RECIPE_INFO_OVERRIDES = new HashMap(Map.of(TIPPED_ARROW, (validRecipes, recipeAdder) -> BuiltInRegistries.POTION.asHolderIdMap().forEach(p -> {
            if (((Potion)p.value()).getEffects().isEmpty() && !p.equals((Object)Potions.WATER)) {
                return;
            }
            ItemStack potion = Legacy4J.setItemStackPotion(Items.LINGERING_POTION.getDefaultInstance(), (Holder<Potion>)p);
            ItemStack result = Legacy4J.setItemStackPotion(new ItemStack((ItemLike)Items.TIPPED_ARROW, 8), (Holder<Potion>)p);
            ArrayList<Optional<Ingredient>> ings = new ArrayList<Optional<Ingredient>>();
            Optional<Ingredient> arrowOptional = Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.ARROW}));
            for (int i = 0; i < 8; ++i) {
                ings.add(arrowOptional);
            }
            ings.add(4, Optional.of(StackIngredient.of((boolean)true, (ItemStack)potion)));
            ArrayList description = new ArrayList();
            recipeAdder.accept(RecipeInfo.create(TIPPED_ARROW, null, ings, result, () -> {
                description.clear();
                Legacy4J.addPotionTooltip((Holder<Potion>)p, description, 0.125f, Minecraft.getInstance().level.tickRateManager().tickrate());
                return (Component)description.get(0);
            }));
        }), SUSPICIOUS_STEW, (validRecipes, recipeAdder) -> BuiltInRegistries.ITEM.getTag(ItemTags.SMALL_FLOWERS).ifPresent(s -> s.forEach(h -> {
            ItemStack result = Items.SUSPICIOUS_STEW.getDefaultInstance();
            SuspiciousEffectHolder suspiciousEffectHolder = SuspiciousEffectHolder.tryGet((ItemLike)((ItemLike)h.value()));
            if (suspiciousEffectHolder != null) {
                result.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)suspiciousEffectHolder.getSuspiciousEffects());
            }
            recipeAdder.accept(RecipeInfo.create(SUSPICIOUS_STEW, null, List.of(Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM})), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_MUSHROOM})), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)h.value()})), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}))), result));
        }))));

        public static <E> Codec<Map<String, E>> createListingCodec(final Codec<E> codec, final String keyField, final String valueField, final Function<E, String> fallBackKey) {
            return new Codec<Map<String, E>>(){

                public <T> DataResult<Pair<Map<String, E>, T>> decode(DynamicOps<T> ops, T input) {
                    Dynamic dynamic = new Dynamic(ops, input);
                    DataResult defaultMap = dynamic.asMapOpt().map(s -> s.collect(Collectors.toMap(p -> (String)((Dynamic)p.getFirst()).asString().result().orElseThrow(), p -> codec.parse((Dynamic)p.getSecond()).result().orElseThrow(), (a, b) -> b, LinkedHashMap::new)));
                    return (defaultMap.result().isPresent() ? defaultMap : dynamic.asListOpt(d -> {
                        Object element = codec.parse(d).result().orElseGet(() -> d.get(valueField).flatMap(arg_0 -> ((Codec)codec).parse(arg_0)).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).error(arg_0)).get());
                        return Pair.of((Object)d.get(keyField).asString().result().orElse((String)fallBackKey.apply(element)), (Object)element);
                    }).map(l -> l.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> b, LinkedHashMap::new)))).map(m -> Pair.of((Object)m, (Object)input));
                }

                public <T> DataResult<T> encode(Map<String, E> input, DynamicOps<T> ops, T prefix) {
                    Dynamic dynamic = new Dynamic(ops, prefix);
                    input.forEach((s, e) -> codec.encodeStart(ops, e).result().ifPresent(r -> dynamic.set(s, new Dynamic(ops, r))));
                    return DataResult.success(prefix);
                }
            };
        }

        default public <T> void addRecipes(Iterable<RecipeInfo<T>> validRecipes, Consumer<RecipeInfo<T>> recipeAdder) {
            for (RecipeInfo<T> validRecipe : validRecipes) {
                if (!this.test(validRecipe)) continue;
                recipeAdder.accept(validRecipe);
                if (!this.onlyFirstMatch()) continue;
                return;
            }
        }

        default public boolean onlyFirstMatch() {
            return false;
        }

        public Codec<? extends Filter> codec();

        public static Filter parse(String s) {
            if (s.startsWith("#")) {
                return new ItemTag((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
            }
            return new Id(FactoryAPI.createLocation((String)s));
        }

        public record ItemTag(TagKey<Item> tag) implements Filter
        {
            public static final Codec<ItemTag> CODEC = TagKey.codec((ResourceKey)Registries.ITEM).xmap(ItemTag::new, ItemTag::tag);

            @Override
            public boolean test(RecipeInfo<?> h) {
                return h.getResultItem().is(this.tag);
            }

            @Override
            public Codec<? extends Filter> codec() {
                return CODEC;
            }

            @Override
            public String toString() {
                return "#" + String.valueOf(this.tag.location());
            }
        }

        public record Id(ResourceLocation id) implements Filter
        {
            public static final Codec<Id> CODEC = ResourceLocation.CODEC.xmap(Id::new, Id::id);

            @Override
            public <T> void addRecipes(Iterable<RecipeInfo<T>> validRecipes, Consumer<RecipeInfo<T>> recipeAdder) {
                Filter.super.addRecipes(validRecipes, recipeAdder);
                IdOverride value = (IdOverride)ID_RECIPE_INFO_OVERRIDES.get(this.id);
                if (value != null) {
                    value.addRecipes(validRecipes, recipeAdder);
                }
            }

            @Override
            public boolean onlyFirstMatch() {
                return true;
            }

            @Override
            public Codec<? extends Filter> codec() {
                return CODEC;
            }

            @Override
            public boolean test(RecipeInfo<?> h) {
                return h.getId().equals((Object)this.id);
            }

            @Override
            public String toString() {
                return this.id.toString();
            }
        }

        public record BlockTag(TagKey<Block> tag) implements Filter
        {
            public static final Codec<BlockTag> CODEC = TagKey.codec((ResourceKey)Registries.BLOCK).xmap(BlockTag::new, BlockTag::tag);

            @Override
            public boolean test(RecipeInfo<?> h) {
                BlockItem i;
                Item item = h.getResultItem().getItem();
                return item instanceof BlockItem && (i = (BlockItem)item).getBlock().builtInRegistryHolder().is(this.tag);
            }

            public Codec<Filter> codec() {
                return null;
            }

            @Override
            public String toString() {
                return "#block_tag/" + String.valueOf(this.tag.location());
            }
        }

        public record ItemId(ResourceLocation id, boolean onlyFirstMatch) implements Filter
        {
            public static final Codec<ItemId> EXTENDED_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ItemId::id), (App)Codec.BOOL.fieldOf("onlyFirstMatch").forGetter(ItemId::onlyFirstMatch)).apply((Applicative)i, ItemId::new));
            public static final Codec<ItemId> CODEC = Codec.either((Codec)ResourceLocation.CODEC.xmap(ItemId::new, ItemId::id), EXTENDED_CODEC).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);

            public ItemId(ResourceLocation id) {
                this(id, true);
            }

            @Override
            public boolean test(RecipeInfo<?> h) {
                return BuiltInRegistries.ITEM.getKey((Object)h.getResultItem().getItem()).equals((Object)this.id);
            }

            @Override
            public Codec<? extends Filter> codec() {
                return EXTENDED_CODEC;
            }

            @Override
            public String toString() {
                return "result_item/" + String.valueOf(this.id);
            }
        }

        public static interface IdOverride<T> {
            public void addRecipes(Iterable<RecipeInfo<T>> var1, Consumer<RecipeInfo<T>> var2);
        }
    }
}

