/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.Bearer;
import wily.legacy.client.CommonColor;
import wily.legacy.client.KnownListing;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class ConfirmationScreen
extends OverlayPanelScreen
implements RenderableVList.Access {
    protected final MultiLineLabel messageLabel;
    protected Consumer<ConfirmationScreen> okAction;
    public Button okButton;
    protected Bearer<Integer> messageYOffset = Bearer.of((Object)0);
    protected final RenderableVList renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> 2);
    private final List<RenderableVList> renderableVLists = Collections.singletonList(this.renderableVList);
    protected boolean initialized = false;

    public ConfirmationScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component title, MultiLineLabel messageLabel, Consumer<ConfirmationScreen> okAction) {
        super(parent, panelConstructor, title);
        this.messageLabel = messageLabel;
        this.okAction = okAction;
        this.parent = parent;
    }

    public ConfirmationScreen(Screen parent, int imageWidth, int baseHeight, int xOffset, int yOffset, Component title, MultiLineLabel messageLines, Consumer<ConfirmationScreen> okAction) {
        this(parent, s -> Panel.centered(s, imageWidth, baseHeight + messageLines.getLineCount() * 12, xOffset, yOffset), title, messageLines, okAction);
    }

    public ConfirmationScreen(Screen parent, int imageWidth, int baseHeight, int xOffset, int yOffset, Component title, Component message, Consumer<ConfirmationScreen> okAction) {
        this(parent, imageWidth, baseHeight, xOffset, yOffset, title, MultiLineLabel.create((Font)Minecraft.getInstance().font, (Component)message, (int)(imageWidth - 30)), okAction);
    }

    public ConfirmationScreen(Screen parent, int imageWidth, int baseHeight, Component title, Component message, Consumer<ConfirmationScreen> okAction) {
        this(parent, imageWidth, baseHeight, 0, 0, title, message, okAction);
    }

    public ConfirmationScreen(Screen parent, Component title, Component message, Consumer<ConfirmationScreen> okAction) {
        this(parent, 230, 97, title, message, okAction);
    }

    public ConfirmationScreen(Screen parent, int imageWidth, int baseHeight, Component title, Component message) {
        this(parent, imageWidth, baseHeight, title, message, LegacyScreen::onClose);
    }

    public ConfirmationScreen(Screen parent, Component title, Component message) {
        this(parent, 230, 97, title, message);
    }

    public static ConfirmationScreen createInfoScreen(Screen parent, Component title, Component message) {
        return new ConfirmationScreen(parent, title, message){

            @Override
            protected void addButtons() {
                this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).build();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }
        };
    }

    public static ConfirmationScreen createLinkScreen(Screen parent, String link) {
        return ConfirmationScreen.createLinkScreen(parent, LegacyComponents.OPEN_LINK_TITLE, LegacyComponents.OPEN_LINK_MESSAGE, link);
    }

    public static ConfirmationScreen createLinkScreen(Screen parent, Component title, Component message, String link) {
        return new ConfirmationScreen(parent, 230, 97, title, message, s -> {
            Util.getPlatform().openUri(link);
            s.onClose();
        });
    }

    public static ConfirmationScreen createResetKnownListingScreen(Screen parent, Component title, Component message, KnownListing<?> knownListing) {
        return new ConfirmationScreen(parent, 230, 97, title, message, s -> {
            knownListing.list.clear();
            knownListing.save();
            s.onClose();
        });
    }

    public static ConfirmationScreen createSaveInfoScreen(Screen parent) {
        return new ConfirmationScreen(parent, 275, 130, 0, 25, (Component)Component.empty(), LegacyComponents.AUTOSAVE_MESSAGE, LegacyScreen::onClose){

            @Override
            protected void addButtons() {
                this.transparentBackground = false;
                this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).build();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }

            @Override
            public void renderableVListInit() {
                this.messageYOffset.set((Object)68);
                this.renderableVList.init(this.panel.x + (this.panel.width - 220) / 2, this.panel.y + this.panel.height - 40, 220, 0);
            }

            public boolean shouldCloseOnEsc() {
                return false;
            }

            @Override
            public void render(GuiGraphics guiGraphics, int i, int j, float f) {
                super.render(guiGraphics, i, j, f);
                ScreenUtil.drawAutoSavingIcon(guiGraphics, this.panel.x + 127, this.panel.y + 36);
            }
        };
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            this.addButtons();
            this.initialized = true;
        }
        super.init();
        this.renderableVListInit();
        this.accessor.putIntegerBearer("messageYOffset", this.messageYOffset);
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }

    @Override
    public void renderableVListInit() {
        this.messageYOffset.set((Object)(this.title.getString().isEmpty() ? 15 : 35));
        this.renderableVList.init(this.panel.x + (this.panel.width - 200) / 2, this.panel.y + this.panel.height - this.renderableVList.renderables.size() * 22 - 8, 200, 0);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.renderableVList.keyPressed(i)) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    protected void addButtons() {
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).build());
        this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).build();
        this.renderableVList.addRenderable((Renderable)this.okButton);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        ScreenUtil.renderScrollingString(guiGraphics, this.font, this.title, this.panel.x + 15, this.panel.y + 15, this.panel.x + this.panel.width - 15, this.panel.y + 26, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
        this.messageLabel.renderLeftAlignedNoShadow(guiGraphics, this.panel.x + 15, this.panel.y + (Integer)this.messageYOffset.get(), 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue());
    }
}

