/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.AdvancementToastAccessor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={AdvancementToast.class})
public abstract class AdvancementToastMixin
implements Toast,
AdvancementToastAccessor {
    @Unique
    int width = 82;
    @Shadow
    private boolean playedSound;
    @Shadow
    @Final
    private AdvancementHolder advancement;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, ToastComponent toastComponent, long l, CallbackInfoReturnable<Toast.Visibility> cir) {
        Font font = Minecraft.getInstance().font;
        MutableComponent holdToView = Component.translatable((String)"legacy.menu.advancements.toast", (Object[])new Object[]{(ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(73) : ControllerBinding.UP_BUTTON.getIcon()).getComponent()});
        DisplayInfo displayInfo = this.advancement.value().display().orElse(null);
        this.width = 82 + (displayInfo == null ? 0 : Math.max(font.width((FormattedText)holdToView), Math.max(font.width((FormattedText)displayInfo.getTitle()) * 3 / 2, font.width((FormattedText)displayInfo.getType().getDisplayName()))));
        ScreenUtil.renderPointerPanel(guiGraphics, 0, 0, this.width(), this.height());
        if (displayInfo != null) {
            int i;
            int n = i = displayInfo.getType() == AdvancementType.CHALLENGE ? 0xFF88FF : 0xFFFF00;
            if (l < 1500L) {
                guiGraphics.drawString(font, displayInfo.getType().getDisplayName(), (this.width() - font.width((FormattedText)displayInfo.getType().getDisplayName())) / 2, this.height() - 18, i | Mth.floor((float)(Mth.clamp((float)((float)(1500L - l) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000);
            } else {
                guiGraphics.drawString(font, (Component)holdToView, (this.width() - font.width((FormattedText)holdToView)) / 2, this.height() - 18, 0xFFFFFF | Mth.floor((float)(Mth.clamp((float)((float)(l - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000);
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(((float)this.width() - (float)font.width((FormattedText)displayInfo.getTitle()) * 1.5f) / 2.0f, 10.0f, 0.0f);
            guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
            guiGraphics.drawString(font, displayInfo.getTitle(), 0, 0, -1);
            guiGraphics.pose().popPose();
            if (!this.playedSound && l > 0L) {
                this.playedSound = true;
                if (displayInfo.getType() == AdvancementType.CHALLENGE) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, (float)1.0f, (float)1.0f));
                }
            }
            ScreenUtil.renderLocalPlayerHead(guiGraphics, 7, (this.height() - 32) / 2, 32);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_PANEL, this.width() - 38, (this.height() - 28) / 2, 28, 28);
            guiGraphics.renderItem(displayInfo.getIcon(), this.width() - 32, (this.height() - 16) / 2);
            cir.setReturnValue((Object)((double)l >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW));
            return;
        }
        cir.setReturnValue((Object)Toast.Visibility.HIDE);
    }

    @Override
    public ResourceLocation getAdvancementId() {
        return this.advancement.id();
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return 46;
    }

    public int slotCount() {
        return 5;
    }
}

