/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin {
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart leftArm;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    private void setupAnim(LivingEntity livingEntity, float f, float g, float h, float i, float j, CallbackInfo info) {
        HumanoidArm mainArm = livingEntity.getMainArm();
        float ageInTicks = h;
        if (!livingEntity.hasItemInSlot(EquipmentSlot.MAINHAND) && livingEntity.isShiftKeyDown() && livingEntity.isFallFlying()) {
            (mainArm == HumanoidArm.RIGHT ? this.rightArm : this.leftArm).xRot = (float)Math.PI + (mainArm == HumanoidArm.RIGHT ? 1.0f : -1.0f) * Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        }
        HumanoidArm useArm = livingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND ? mainArm : mainArm.getOpposite();
        ItemStack useItem = livingEntity.getUseItem();
        UseAnim useAnim = useItem.getUseAnimation();
        if (livingEntity.getUseItemRemainingTicks() > 0 && (useAnim == UseAnim.EAT || useAnim == UseAnim.DRINK)) {
            boolean isRightHand = useArm == HumanoidArm.RIGHT;
            ModelPart armModel = isRightHand ? this.rightArm : this.leftArm;
            float r = Math.min(((float)livingEntity.getTicksUsingItem() + FactoryAPIClient.getGamePartialTick((boolean)Minecraft.getInstance().level.tickRateManager().isEntityFrozen((Entity)livingEntity))) / (float)useItem.getUseDuration(livingEntity) * 6.0f, 1.0f);
            armModel.xRot = r * -1.4f + (r > 0.8f ? Mth.cos((float)(ageInTicks * 1.7f)) * 0.08f : 0.0f);
            armModel.yRot = (isRightHand ? -0.45f : 0.45f) * r;
        }
    }

    @Redirect(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/model/geom/ModelPart;xRot:F", opcode=181, ordinal=0))
    public void setupAnim(ModelPart instance, float value, LivingEntity livingEntity, float f, float g, float h, float i, float j) {
        instance.xRot = livingEntity.getPose() == Pose.FALL_FLYING ? value : j * ((float)Math.PI / 180);
    }
}

