/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.config.LegacyCommonOptions;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected ItemStack useItem;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z", ordinal=2))
    public boolean travelFlight(LivingEntity instance) {
        return !this.isLegacyFlying() && this.onGround();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLegacyFlying() {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!(livingEntity instanceof Player)) return false;
        Player p = (Player)livingEntity;
        if (!p.getAbilities().flying) return false;
        if (!this.level().isClientSide) return true;
        if (!FactoryAPIClient.hasModOnServer) return false;
        return true;
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(DDD)V", ordinal=3))
    public void travelFlight(LivingEntity instance, double x, double y, double z) {
        this.setDeltaMovement((this.isLegacyFlying() ? 0.6 : 1.0) * x, (this.isLegacyFlying() ? 0.546 : 1.0) * y, (this.isLegacyFlying() ? 0.6 : 1.0) * z);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        block2: {
            block4: {
                IronGolem i;
                LivingEntityMixin livingEntityMixin;
                block3: {
                    if (this.level().isClientSide || this.level().getServer().isPvpAllowed() || !(damageSource.getDirectEntity() instanceof Player)) break block2;
                    livingEntityMixin = this;
                    if (!(livingEntityMixin instanceof OwnableEntity)) break block3;
                    OwnableEntity o = (OwnableEntity)livingEntityMixin;
                    if (damageSource.getDirectEntity().equals((Object)o.getOwner())) break block4;
                }
                if ((!((livingEntityMixin = this) instanceof IronGolem) || !(i = (IronGolem)livingEntityMixin).isPlayerCreated()) && !(this instanceof SnowGolem)) break block2;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isBlocking"}, at={@At(value="HEAD")}, cancellable=true)
    public void isBlocking(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)LegacyCommonOptions.legacySwordBlocking.get()).booleanValue() && this.useItem.getItem() instanceof SwordItem) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getDamageAfterArmorAbsorb(DamageSource damageSource, float f, CallbackInfoReturnable<Float> cir) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking) && this.useItem.getItem() instanceof SwordItem) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() / 2.0f));
        }
    }
}

