/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.LegacyOptions;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin
extends EntityRenderer<LivingEntity> {
    @Unique
    ItemRenderer itemRenderer;

    @Shadow
    public abstract EntityModel<LivingEntity> getModel();

    protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    protected void init(EntityRendererProvider.Context context, EntityModel<LivingEntity> entityModel, float f, CallbackInfo ci) {
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    @Redirect(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isAlive()Z"))
    public boolean render(LivingEntity instance) {
        return true;
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    public void render(LivingEntity livingEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        Merchant m;
        if (livingEntity instanceof Merchant && (m = (Merchant)livingEntity).getTradingPlayer() != null && ((Boolean)LegacyOptions.merchantTradingIndicator.get()).booleanValue()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, livingEntity.getBbHeight() + 0.5f, 0.0f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(1.0f, 1.0f, 1.0E-4f);
            this.itemRenderer.renderStatic(Items.EMERALD.getDefaultInstance(), ItemDisplayContext.GROUND, i, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, (Level)Minecraft.getInstance().level, 0);
            poseStack.popPose();
        }
    }

    @Redirect(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V"))
    public void renderToBufferFireColor(EntityModel instance, PoseStack poseStack, VertexConsumer consumer, int light, int overlay, int color, LivingEntity livingEntity, float f, float g) {
        instance.renderToBuffer(poseStack, consumer, light, overlay, (Boolean)LegacyOptions.legacyEntityFireTint.get() != false && livingEntity.isOnFire() && livingEntity.displayFireAnimation() && !livingEntity.fireImmune() ? ColorUtil.colorFromFloat((float)ColorUtil.getRed((int)color), (float)(ColorUtil.getGreen((int)color) * this.getGreenFireOverlayDiff((float)livingEntity.tickCount + g)), (float)(ColorUtil.getBlue((int)color) / 6.0f), (float)ColorUtil.getAlpha((int)color)) : color);
    }

    @Inject(method={"getOverlayCoords"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getOverlayCoords(LivingEntity livingEntity, float f, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)LegacyOptions.legacyEntityFireTint.get()).booleanValue() && livingEntity.isOnFire() && livingEntity.displayFireAnimation() && !livingEntity.fireImmune()) {
            cir.setReturnValue((Object)OverlayTexture.pack((int)0, (int)OverlayTexture.v((boolean)true)));
        }
    }

    @Unique
    private float getGreenFireOverlayDiff(float age) {
        float range = age / 10.0f % 1.0f;
        return 0.6f + (range > 0.5f ? 1.0f - range : range) / 1.5f;
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;rotLerp(FFF)F", ordinal=1)})
    private float modifyHeadRotation(float original, LivingEntity entity, float f, float g) {
        return (Boolean)LegacyOptions.headFollowsTheCamera.get() != false ? entity.getViewYRot(g) : original;
    }
}

