/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.util.ScreenUtil;

@Mixin(value={LoadingOverlay.class})
public abstract class LoadingOverlayMixin
extends Overlay {
    @Unique
    private static boolean finishedIntro = false;
    @Unique
    private static boolean loadIntroLocation = false;
    @Shadow
    @Final
    private ReloadInstance reload;
    @Shadow
    @Final
    private Consumer<Optional<Throwable>> onFinish;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private long fadeOutStart;
    @Shadow
    @Final
    private boolean fadeIn;
    @Shadow
    private long fadeInStart;
    @Unique
    private long initTime;
    private static ResourceLocation BACKGROUND = Legacy4J.createModLocation("textures/gui/intro/background.png");

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        if (!loadIntroLocation) {
            this.initTime = Util.getMillis();
            loadIntroLocation = true;
            LegacyResourceManager.registerIntroLocations(this.minecraft.getResourceManager());
        }
        float timer = (float)(Util.getMillis() - this.initTime) / 3200.0f;
        if (!finishedIntro && Legacy4JClient.canSkipIntro(timer) && this.reload.isDone()) {
            finishedIntro = true;
        }
        if (!finishedIntro) {
            guiGraphics.fill(RenderType.guiOverlay(), 0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), -1);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(BACKGROUND, 0, 0, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
            float last = (float)Math.ceil(timer) - timer;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, last <= 0.4f ? last * 2.5f : (last > 0.6f ? (1.0f - last) * 2.5f : 1.0f), true);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(LegacyResourceManager.INTROS.get((int)(timer % (float)LegacyResourceManager.INTROS.size())), (guiGraphics.guiWidth() - guiGraphics.guiHeight() * 320 / 180) / 2, 0, 0.0f, 0.0f, guiGraphics.guiHeight() * 320 / 180, guiGraphics.guiHeight(), guiGraphics.guiHeight() * 320 / 180, guiGraphics.guiHeight());
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor(true);
        }
        if (finishedIntro) {
            float h;
            long m = Util.getMillis();
            if (this.fadeIn && this.fadeInStart == -1L) {
                this.fadeInStart = m;
            }
            float g = this.fadeOutStart > -1L ? (float)(m - this.fadeOutStart) / 1000.0f : -1.0f;
            float f2 = h = this.fadeInStart > -1L ? (float)(m - this.fadeInStart) / 500.0f : -1.0f;
            if (MinecraftAccessor.getInstance().hasGameLoaded() && this.reload.isDone() && this.minecraft.screen != null) {
                this.minecraft.screen.renderWithTooltip(guiGraphics, 0, 0, f);
            } else {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(ScreenUtil.LOADING_BACKGROUND, 0, 0, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
            }
            if (g < 1.0f && !this.reload.isDone() && MinecraftAccessor.getInstance().hasGameLoaded()) {
                ScreenUtil.drawGenericLoading(guiGraphics, (guiGraphics.guiWidth() - 75) / 2, (guiGraphics.guiHeight() - 75) / 2);
            }
            if (g >= 2.0f) {
                this.minecraft.setOverlay(null);
            }
            if (this.fadeOutStart == -1L && this.reload.isDone() && (!this.fadeIn || h >= 2.0f)) {
                try {
                    this.reload.checkExceptions();
                    this.onFinish.accept(Optional.empty());
                }
                catch (Throwable throwable) {
                    this.onFinish.accept(Optional.of(throwable));
                }
                this.fadeOutStart = Util.getMillis();
                if (this.minecraft.screen != null) {
                    this.minecraft.screen.init(this.minecraft, guiGraphics.guiWidth(), guiGraphics.guiHeight());
                }
            }
        }
    }
}

