/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.crafting;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={CraftingScreen.class})
public abstract class CraftingScreenMixin
extends AbstractContainerScreen<CraftingMenu> {
    @Shadow
    private boolean widthTooNarrow;
    @Shadow
    @Final
    private RecipeBookComponent recipeBookComponent;
    @Unique
    private ImageButton recipeButton;

    public CraftingScreenMixin(CraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 215;
        this.imageHeight = 202;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 90;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 11;
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        if (((Boolean)LegacyOptions.showVanillaRecipeBook.get()).booleanValue()) {
            this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
            this.recipeButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 9, this.topPos + 44, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
                this.recipeBookComponent.toggleVisibility();
                this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
                button.setPosition(this.leftPos + 9, this.topPos + 44);
            }));
            this.addWidget((GuiEventListener)this.recipeBookComponent);
            this.setInitialFocus((GuiEventListener)this.recipeBookComponent);
            if (this.recipeBookComponent.isVisible()) {
                this.recipeButton.setFocused(true);
            }
        } else if (this.recipeBookComponent.isVisible()) {
            this.recipeBookComponent.toggleVisibility();
        }
        int slotsAmount = ((CraftingMenu)this.menu).getGridHeight() * ((CraftingMenu)this.menu).getGridWidth();
        for (int i = 0; i < ((CraftingMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((CraftingMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 150, 39, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 32;
                    }
                });
                continue;
            }
            if (i < slotsAmount + 1) {
                LegacySlotDisplay.override(s, 34 + s.getContainerSlot() % 3 * 21, 23 + s.getContainerSlot() / 3 * 21);
                continue;
            }
            if (i < ((CraftingMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 102 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 171);
        }
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 105), (float)(this.topPos + 43), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        guiGraphics.pose().popPose();
        if (!this.recipeBookComponent.isVisible() && this.recipeButton != null && !this.recipeButton.isHovered()) {
            this.recipeButton.setFocused(false);
        }
    }
}

