/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.create_world;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.ScreenUtil;

@Mixin(value={CreateWorldScreen.class})
public abstract class CreateWorldScreenMixin
extends Screen
implements ControlTooltip.Event {
    @Shadow
    @Final
    private WorldCreationUiState uiState;
    @Shadow
    @Final
    private static Component GAME_MODEL_LABEL;
    @Shadow
    @Final
    private static Component NAME_LABEL;
    protected Bearer<Boolean> trustPlayers = Bearer.of((Object)true);
    protected Panel panel;
    protected PublishScreen publishScreen;
    protected PackAlbum.Selector resourceAssortSelector;

    @Shadow
    public abstract void popScreen();

    @Shadow
    protected abstract void onCreate();

    protected CreateWorldScreenMixin(Component component) {
        super(component);
    }

    private CreateWorldScreen self() {
        return (CreateWorldScreen)this;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturn(Minecraft minecraft, Screen screen, WorldCreationContext worldCreationContext, Optional optional, OptionalLong optionalLong, CallbackInfo ci) {
        this.uiState.setDifficulty((Difficulty)LegacyOptions.createWorldDifficulty.get());
        this.panel = Panel.createPanel((Screen)this, p -> (this.width - (p.width + (ScreenUtil.hasTooltipBoxes(UIAccessor.of((Screen)this)) ? 160 : 0))) / 2, p -> (this.height - p.height) / 2, 245, 228);
        this.resourceAssortSelector = PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 106, 220, 45, !ScreenUtil.hasTooltipBoxes());
        this.publishScreen = new PublishScreen((Screen)this, this.uiState.getGameMode().gameType);
    }

    public void added() {
        super.added();
        OptionsScreen.setupSelectorControlTooltips(ControlTooltip.Renderer.of(this), this);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.panel.init();
        this.addRenderableOnly((Renderable)this.panel);
        EditBox nameEdit = new EditBox(this.font, this.panel.x + 13, this.panel.y + 25, 220, 20, (Component)Component.translatable((String)"selectWorld.enterName"));
        nameEdit.setValue(this.uiState.getName());
        nameEdit.setResponder(arg_0 -> ((WorldCreationUiState)this.uiState).setName(arg_0));
        this.uiState.addListener(worldCreationUiState -> nameEdit.setTooltip(Tooltip.create((Component)Component.translatable((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.literal((String)worldCreationUiState.getTargetFolder()).withStyle(ChatFormatting.ITALIC)}))));
        this.setInitialFocus((GuiEventListener)nameEdit);
        this.addRenderableWidget((GuiEventListener)nameEdit);
        LegacySliderButton gameModeButton = (LegacySliderButton)this.addRenderableWidget((GuiEventListener)new LegacySliderButton<WorldCreationUiState.SelectedGameMode>(this.panel.x + 13, this.panel.y + 51, 220, 16, b -> b.getDefaultMessage(GAME_MODEL_LABEL, ((WorldCreationUiState.SelectedGameMode)b.getObjectValue()).displayName), b -> Tooltip.create((Component)this.uiState.getGameMode().getInfo()), this.uiState.getGameMode(), () -> List.of(WorldCreationUiState.SelectedGameMode.SURVIVAL, WorldCreationUiState.SelectedGameMode.HARDCORE, WorldCreationUiState.SelectedGameMode.CREATIVE), b -> this.uiState.setGameMode((WorldCreationUiState.SelectedGameMode)b.getObjectValue())));
        this.uiState.addListener(worldCreationUiState -> {
            gameModeButton.active = !worldCreationUiState.isDebug();
        });
        LegacySliderButton difficultyButton = (LegacySliderButton)this.addRenderableWidget((GuiEventListener)new LegacySliderButton<Difficulty>(this.panel.x + 13, this.panel.y + 77, 220, 16, b -> b.getDefaultMessage((Component)Component.translatable((String)"options.difficulty"), ((Difficulty)b.getObjectValue()).getDisplayName()), b -> Tooltip.create((Component)this.uiState.getDifficulty().getInfo()), this.uiState.getDifficulty(), () -> Arrays.asList(Difficulty.values()), b -> this.uiState.setDifficulty((Difficulty)b.getObjectValue())));
        this.uiState.addListener(worldCreationUiState -> {
            difficultyButton.setObjectValue(this.uiState.getDifficulty());
            difficultyButton.active = !this.uiState.isHardcore();
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"createWorld.tab.more.title"), button -> this.minecraft.setScreen((Screen)new WorldMoreOptionsScreen(this.self(), this.trustPlayers))).bounds(this.panel.x + 13, this.panel.y + 172, 220, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"selectWorld.create"), button -> this.onCreate()).bounds(this.panel.x + 13, this.panel.y + 197, 220, 20).build());
        this.addRenderableWidget((GuiEventListener)new TickBox(this.panel.x + 14, this.panel.y + 155, 220, this.publishScreen.publish, b -> PublishScreen.PUBLISH, b -> null, button -> {
            if (button.selected) {
                this.minecraft.setScreen((Screen)this.publishScreen);
            }
            this.publishScreen.publish = false;
            button.selected = false;
        }));
        this.resourceAssortSelector.setX(this.panel.x + 13);
        this.resourceAssortSelector.setY(this.panel.y + 106);
        this.addRenderableWidget((GuiEventListener)this.resourceAssortSelector);
        this.uiState.onChanged();
    }

    @Inject(method={"repositionElements"}, at={@At(value="HEAD")}, cancellable=true)
    public void repositionElements(CallbackInfo ci) {
        this.rebuildWidgets();
        ci.cancel();
    }

    @Inject(method={"createNewWorld"}, at={@At(value="RETURN")})
    private void onCreate(CallbackInfo ci) {
        this.resourceAssortSelector.applyChanges(true);
        Legacy4JClient.serverPlayerJoinConsumer = s -> {
            LegacyClientWorldSettings.of(s.server.getWorldData()).setTrustPlayers((Boolean)this.trustPlayers.get());
            s.server.getPlayerList().sendPlayerPermissionLevel(s);
            this.publishScreen.publish((IntegratedServer)s.server);
            LegacyClientWorldSettings.of(this.minecraft.getSingleplayerServer().getWorldData()).setSelectedResourceAlbum(this.resourceAssortSelector.getSelectedAlbum());
        };
    }

    @ModifyExpressionValue(method={"createNewWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;createWorldOpenFlows()Lnet/minecraft/client/gui/screens/worldselection/WorldOpenFlows;")})
    private WorldOpenFlows createNewWorld(WorldOpenFlows original) {
        return (Boolean)LegacyOptions.saveCache.get() != false ? new WorldOpenFlows(this.minecraft, Legacy4JClient.currentWorldSource) : original;
    }

    @Inject(method={"createNewWorldDirectory"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource;createAccess(Ljava/lang/String;)Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;")})
    private void createNewWorldDirectory(CallbackInfoReturnable<Optional<LevelStorageSource.LevelStorageAccess>> cir) {
        if (!((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
            return;
        }
        try {
            LevelStorageSource.LevelStorageAccess access = Legacy4JClient.currentWorldSource.createAccess(this.uiState.getTargetFolder());
            access.close();
            if (Files.exists(access.getDimensionPath(Level.OVERWORLD), new LinkOption[0])) {
                FileUtils.deleteDirectory((File)access.getDimensionPath(Level.OVERWORLD).toFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ModifyExpressionValue(method={"createNewWorldDirectory"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getLevelSource()Lnet/minecraft/world/level/storage/LevelStorageSource;")})
    private LevelStorageSource createNewWorldDirectory(LevelStorageSource original) {
        return (Boolean)LegacyOptions.saveCache.get() != false ? Legacy4JClient.currentWorldSource : original;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.resourceAssortSelector.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        ScreenUtil.renderDefaultBackground(UIAccessor.of((Screen)this), guiGraphics, false);
        this.resourceAssortSelector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel);
        super.render(guiGraphics, i, j, f);
        guiGraphics.drawString(this.font, NAME_LABEL, this.panel.x + 14, this.panel.y + 15, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    public boolean keyPressed(int i, int j, int k) {
        return super.keyPressed(i, j, k);
    }

    public void onClose() {
        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.BACK.get(), 1.0f);
        this.popScreen();
    }
}

