/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.furnace;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.recipebook.AbstractFurnaceRecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;

@Mixin(value={AbstractFurnaceScreen.class})
public abstract class AbstractFurnaceScreenMixin<T extends AbstractFurnaceMenu>
extends AbstractContainerScreen<T> {
    @Shadow
    private boolean widthTooNarrow;
    @Shadow
    @Final
    public AbstractFurnaceRecipeBookComponent recipeBookComponent;
    @Unique
    private ImageButton recipeButton;

    public AbstractFurnaceScreenMixin(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    public void added() {
        super.added();
        ControlTooltip.Renderer.of((Object)this).replace(3, i -> i, c -> this.hoveredSlot == null || this.hoveredSlot.getItem().isEmpty() || this.hoveredSlot.container != this.minecraft.player.getInventory() ? c : (((AbstractFurnaceMenu)this.menu).canSmelt(this.hoveredSlot.getItem()) ? LegacyComponents.MOVE_INGREDIENT : (AbstractFurnaceBlockEntity.isFuel((ItemStack)this.hoveredSlot.getItem()) ? LegacyComponents.MOVE_FUEL : c)));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 214;
        this.imageHeight = 215;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 98;
        this.titleLabelX = 14;
        this.titleLabelY = 11;
        super.init();
        for (int i = 0; i < ((AbstractFurnaceMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((AbstractFurnaceMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 77, 25);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 77, 72);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 155, 44, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 32;
                    }
                });
                continue;
            }
            if (i < ((AbstractFurnaceMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 111 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 180);
        }
        this.widthTooNarrow = this.width < 379;
        this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        if (((Boolean)LegacyOptions.showVanillaRecipeBook.get()).booleanValue()) {
            this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
            this.recipeButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 49, this.topPos + 49, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
                this.recipeBookComponent.toggleVisibility();
                this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
                button.setPosition(this.leftPos + 49, this.topPos + 49);
            }));
            if (this.recipeBookComponent.isVisible()) {
                this.recipeButton.setFocused(true);
            }
        } else if (this.recipeBookComponent.isVisible()) {
            this.recipeBookComponent.toggleVisibility();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        super.renderLabels(guiGraphics, i, j);
        MutableComponent ingredient = Component.translatable((String)"legacy.container.ingredient");
        guiGraphics.drawString(this.font, (Component)ingredient, 70 - this.font.width((FormattedText)ingredient), 32, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        MutableComponent fuel = Component.translatable((String)"legacy.container.fuel");
        guiGraphics.drawString(this.font, (Component)fuel, 70 - this.font.width((FormattedText)fuel), 79, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 77), (float)(this.topPos + 48), 0.0f);
        guiGraphics.pose().scale(1.4615384f, 1.4615384f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LIT, 0, 0, 13, 13);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.leftPos + 75.5, (double)this.topPos + 46.5, 0.0);
        guiGraphics.pose().scale(0.4871795f, 0.4871795f, 1.0f);
        if (((AbstractFurnaceMenu)this.menu).isLit()) {
            int n = Mth.ceil((float)(((AbstractFurnaceMenu)this.menu).getLitProgress() * 39.0f)) + 1;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LIT_PROGRESS, 42, 42, 0, 42 - n, 0, 42 - n, 42, n);
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 114), (float)(this.topPos + 48), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)(this.leftPos + 114), (double)this.topPos + 46.5, 0.0);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.FULL_ARROW, 66, 48, 0, 0, 0, 2, (int)Math.ceil(((AbstractFurnaceMenu)this.menu).getBurnProgress() * 66.0f), 48);
        guiGraphics.pose().popPose();
        if (!this.recipeBookComponent.isVisible() && this.recipeButton != null && !this.recipeButton.isHovered()) {
            this.recipeButton.setFocused(false);
        }
    }
}

