/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.FactoryGuiElement;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={Gui.class})
public abstract class GuiMixin
implements ControlTooltip.Event {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Final
    @Shadow
    private static Comparator<? super PlayerScoreEntry> SCORE_DISPLAY_ORDER;
    @Shadow
    private long healthBlinkTime;

    @Shadow
    public abstract Font getFont();

    @Redirect(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getPopTime()I"))
    public int renderSlot(ItemStack instance) {
        return 0;
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;", ordinal=1))
    public Object renderCrosshair(OptionInstance<AttackIndicatorStatus> instance) {
        return FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? AttackIndicatorStatus.OFF : instance.get();
    }

    @Redirect(method={"renderItemHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;"))
    public Object renderItemHotbar(OptionInstance<AttackIndicatorStatus> instance) {
        return FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? AttackIndicatorStatus.OFF : instance.get();
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;blendFuncSeparate(Lcom/mojang/blaze3d/platform/GlStateManager$SourceFactor;Lcom/mojang/blaze3d/platform/GlStateManager$DestFactor;Lcom/mojang/blaze3d/platform/GlStateManager$SourceFactor;Lcom/mojang/blaze3d/platform/GlStateManager$DestFactor;)V", remap=false))
    public void renderCrosshairBlendFunc(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor sourceFactor2, GlStateManager.DestFactor destFactor2, GuiGraphics guiGraphics) {
        if (((Boolean)LegacyOptions.invertedCrosshair.get()).booleanValue()) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)sourceFactor, (GlStateManager.DestFactor)destFactor, (GlStateManager.SourceFactor)sourceFactor2, (GlStateManager.DestFactor)destFactor2);
        }
    }

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEffects(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        ci.cancel();
        ScreenUtil.renderGuiEffects(guiGraphics);
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1)})
    private void renderHotbarSelection(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.HOTBAR_SELECTION, 24, 24, 0, 23, guiGraphics.guiWidth() / 2 - 91 - 1 + this.minecraft.player.getInventory().selected * 20, guiGraphics.guiHeight(), 0, 24, 1);
    }

    @Inject(method={"displayScoreboardSidebar"}, at={@At(value="HEAD")}, cancellable=true)
    private void displayScoreboardSidebar(GuiGraphics guiGraphics, Objective objective, CallbackInfo ci) {
        ci.cancel();
        if (this.minecraft.screen != null) {
            return;
        }
        Scoreboard scoreboard = objective.getScoreboard();
        NumberFormat numberFormat = objective.numberFormatOrDefault((NumberFormat)StyledFormat.SIDEBAR_DEFAULT);
        List<? super PlayerScoreEntry> scores = scoreboard.listPlayerScores(objective).stream().filter(playerScoreEntry -> !playerScoreEntry.isHidden()).sorted(SCORE_DISPLAY_ORDER).limit(15L).toList();
        Component component = objective.getDisplayName();
        int i = this.getFont().width((FormattedText)component);
        int k = this.getFont().width(": ");
        int j = Math.max(i, scores.stream().mapToInt(lv -> {
            int w = this.getFont().width((FormattedText)lv.formatValue(numberFormat));
            return this.getFont().width((FormattedText)PlayerTeam.formatNameForTeam((Team)scoreboard.getPlayersTeam(lv.owner()), (Component)lv.ownerName())) + (w > 0 ? k + w : 0);
        }).max().orElse(0));
        Objects.requireNonNull(this.getFont());
        int l = scores.size() * 9;
        int m = guiGraphics.guiHeight() / 2 + l / 3;
        int x = guiGraphics.guiWidth() - 8;
        int o = x - j;
        int p = x + 2;
        Objects.requireNonNull(this.getFont());
        int s = m - scores.size() * 9;
        Objects.requireNonNull(this.getFont());
        ScreenUtil.renderPointerPanel(guiGraphics, o - 6, s - 16, j + 12, scores.size() * 9 + 22);
        Font var18 = this.getFont();
        int var10003 = o + j / 2 - i / 2;
        Objects.requireNonNull(this.getFont());
        guiGraphics.drawString(var18, component, var10003, s - 9, -1, false);
        for (int t = 0; t < scores.size(); ++t) {
            PlayerScoreEntry lv2 = scores.get(t);
            x = scores.size() - t;
            Objects.requireNonNull(this.getFont());
            int u = m - x * 9;
            guiGraphics.drawString(this.getFont(), (Component)PlayerTeam.formatNameForTeam((Team)scoreboard.getPlayersTeam(lv2.owner()), (Component)lv2.ownerName()), o, u, -1, false);
            MutableComponent score = lv2.formatValue(numberFormat);
            guiGraphics.drawString(this.getFont(), (Component)score, p - this.getFont().width((FormattedText)score), u, -1, false);
        }
    }

    @Shadow
    protected abstract boolean isExperienceBarVisible();

    @Inject(method={"renderExperienceLevel"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderExperienceLevel(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        ci.cancel();
        if (!FactoryGuiElement.EXPERIENCE_BAR.isVisible((UIAccessor)this)) {
            return;
        }
        int i = this.minecraft.player.experienceLevel;
        if (this.isExperienceBarVisible() && i > 0) {
            ScreenUtil.prepareHUDRender(guiGraphics);
            guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f, (float)guiGraphics.guiHeight(), 0.0f);
            ScreenUtil.applyHUDScale(guiGraphics);
            FactoryAPIClient.getProfiler().push("expLevel");
            String exp = "" + i;
            int hudScale = (Integer)LegacyOptions.hudScale.get();
            boolean is720p = this.minecraft.getWindow().getHeight() % 720 == 0;
            guiGraphics.pose().translate(0.0f, -36.0f, 0.0f);
            if (!is720p && hudScale != 1) {
                guiGraphics.pose().scale(0.875f, 0.875f, 0.875f);
            }
            ScreenUtil.drawOutlinedString(guiGraphics, this.getFont(), (Component)Component.literal((String)exp), -this.getFont().width(exp) / 2, -2, 8453920, 0, is720p && hudScale == 3 || !is720p && hudScale == 2 || hudScale == 1 ? 0.5f : 0.6666667f);
            FactoryAPIClient.getProfiler().pop();
            ScreenUtil.finalizeHUDRender(guiGraphics);
        }
    }

    @Inject(method={"renderSavingIndicator"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderAutoSaveIndicator(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        ci.cancel();
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z"))
    private boolean tick(ItemStack instance) {
        return !ScreenUtil.getTooltip(instance).equals(ScreenUtil.getTooltip(this.minecraft.player.getInventory().getSelected()));
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;"))
    private Object tick(OptionInstance<Double> instance) {
        return (double)Math.min(ScreenUtil.getSelectedItemTooltipLines(), ScreenUtil.getTooltip(this.minecraft.player.getInventory().getSelected()).size()) * (Double)instance.get();
    }

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void renderSelectedItemName(GuiGraphics guiGraphics, int shift, CallbackInfo ci) {
        ci.cancel();
        ScreenUtil.renderHUDTooltip(guiGraphics, shift);
    }

    @Redirect(method={"renderPlayerHealth"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/Gui;healthBlinkTime:J", opcode=181, ordinal=1))
    private void renderPlayerHealth(Gui instance, long value) {
        this.healthBlinkTime = value - 6L;
    }
}

