/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.entity.LegacyPlayer;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;

public record PlayerInfoSync(Sync sync, UUID player) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<PlayerInfoSync> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("player_info_sync_c2s"), PlayerInfoSync::new);

    public PlayerInfoSync(CommonNetwork.PlayBuf buf) {
        this((Sync)((RegistryFriendlyByteBuf)buf.get()).readEnum(Sync.class), ((RegistryFriendlyByteBuf)buf.get()).readUUID());
    }

    public PlayerInfoSync(Sync sync, Player player) {
        this(sync, player.getUUID());
    }

    public PlayerInfoSync(Sync sync, GameProfile profile) {
        this(sync, profile.getId());
    }

    public static PlayerInfoSync askAll(Player player) {
        return new PlayerInfoSync(Sync.ASK_ALL, player);
    }

    public static PlayerInfoSync classicCrafting(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_CRAFTING : Sync.LEGACY_CRAFTING, player);
    }

    public static PlayerInfoSync classicTrading(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_TRADING : Sync.LEGACY_TRADING, player);
    }

    public static PlayerInfoSync classicStonecutting(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_STONECUTTING : Sync.LEGACY_STONECUTTING, player);
    }

    public static PlayerInfoSync classicLoom(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_LOOM : Sync.LEGACY_LOOM, player);
    }

    public static PlayerInfoSync disableExhaustion(boolean disableExhaustion, GameProfile profile) {
        return new PlayerInfoSync(disableExhaustion ? Sync.DISABLE_EXHAUSTION : Sync.ENABLE_EXHAUSTION, profile);
    }

    public static PlayerInfoSync mayFlySurvival(boolean mayFlySurvival, GameProfile profile) {
        return new PlayerInfoSync(mayFlySurvival ? Sync.ENABLE_MAY_FLY_SURVIVAL : Sync.DISABLE_MAY_FLY_SURVIVAL, profile);
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((RegistryFriendlyByteBuf)buf.get()).writeEnum((Enum)this.sync);
        ((RegistryFriendlyByteBuf)buf.get()).writeUUID(this.player);
    }

    public static Map<String, Object> getWritableGameRules(final GameRules gameRules) {
        final HashMap<String, Object> rules = new HashMap<String, Object>();
        GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public void visitBoolean(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                rules.put(key.getId(), ((GameRules.BooleanValue)gameRules.getRule(key)).get());
            }

            public void visitInteger(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                rules.put(key.getId(), ((GameRules.IntegerValue)gameRules.getRule(key)).get());
            }
        });
        return rules;
    }

    public void apply(CommonNetwork.SecureExecutor executor, Supplier<Player> p) {
        Player player = p.get();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp = sp.server.getPlayerList().getPlayer(this.player);
            if (sp == null) {
                return;
            }
            switch (this.sync.ordinal()) {
                case 0: {
                    CommonNetwork.sendToPlayer((ServerPlayer)sp, (CommonNetwork.Payload)All.fromPlayerList(sp.server));
                    break;
                }
                case 1: 
                case 2: {
                    ((LegacyPlayer)sp).setCrafting(this.sync == Sync.CLASSIC_CRAFTING);
                    break;
                }
                case 7: 
                case 8: {
                    ((LegacyPlayer)sp).setTrading(this.sync == Sync.CLASSIC_TRADING);
                    break;
                }
                case 9: 
                case 10: {
                    ((LegacyPlayer)sp).setStonecutting(this.sync == Sync.CLASSIC_STONECUTTING);
                    break;
                }
                case 11: 
                case 12: {
                    ((LegacyPlayer)sp).setLoom(this.sync == Sync.CLASSIC_LOOM);
                }
            }
            if (sp.hasPermissions(2)) {
                switch (this.sync.ordinal()) {
                    case 3: 
                    case 4: {
                        ((LegacyPlayerInfo)sp).setDisableExhaustion(this.sync == Sync.DISABLE_EXHAUSTION);
                        break;
                    }
                    case 5: 
                    case 6: {
                        LegacyPlayerInfo.updateMayFlySurvival(sp, this.sync == Sync.ENABLE_MAY_FLY_SURVIVAL, true);
                    }
                }
            }
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    public static enum Sync {
        ASK_ALL,
        CLASSIC_CRAFTING,
        LEGACY_CRAFTING,
        DISABLE_EXHAUSTION,
        ENABLE_EXHAUSTION,
        ENABLE_MAY_FLY_SURVIVAL,
        DISABLE_MAY_FLY_SURVIVAL,
        CLASSIC_TRADING,
        LEGACY_TRADING,
        CLASSIC_STONECUTTING,
        LEGACY_STONECUTTING,
        CLASSIC_LOOM,
        LEGACY_LOOM;

    }

    public record All(Map<UUID, LegacyPlayerInfo> players, Map<String, Object> gameRules, GameType defaultGameType, CommonNetwork.Identifier<All> identifier) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<All> ID_C2S = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("player_info_sync_all_c2s"), b -> new All((CommonNetwork.PlayBuf)b, ID_C2S));
        public static final CommonNetwork.Identifier<All> ID_S2C = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("player_info_sync_all_s2c"), b -> new All((CommonNetwork.PlayBuf)b, ID_S2C));
        public static final List<GameRules.Key<GameRules.BooleanValue>> NON_OP_GAMERULES = new ArrayList<GameRules.Key>(List.of(GameRules.RULE_DOFIRETICK, LegacyGameRules.TNT_EXPLODES, GameRules.RULE_DOMOBLOOT, GameRules.RULE_DOBLOCKDROPS, GameRules.RULE_NATURAL_REGENERATION, LegacyGameRules.GLOBAL_MAP_PLAYER_ICON, GameRules.RULE_DO_IMMEDIATE_RESPAWN));

        public All(Map<String, Object> gameRules, CommonNetwork.Identifier<All> identifier) {
            this(Collections.emptyMap(), gameRules, GameType.SURVIVAL, identifier);
        }

        public All(CommonNetwork.PlayBuf buf, CommonNetwork.Identifier<All> identifier) {
            this(((RegistryFriendlyByteBuf)buf.get()).readMap(HashMap::new, b -> b.readUUID(), b -> LegacyPlayerInfo.decode(buf)), ((RegistryFriendlyByteBuf)buf.get()).readMap(HashMap::new, FriendlyByteBuf::readUtf, b -> {
                int type = b.readVarInt();
                if (type == 0) {
                    return b.readBoolean();
                }
                return b.readVarInt();
            }), (GameType)((RegistryFriendlyByteBuf)buf.get()).readEnum(GameType.class), identifier);
        }

        public static All fromPlayerList(MinecraftServer server) {
            return new All(server.getPlayerList().getPlayers().stream().collect(Collectors.toMap(e -> e.getGameProfile().getId(), e -> (LegacyPlayerInfo)e)), PlayerInfoSync.getWritableGameRules(server.getGameRules()), server.getDefaultGameType(), ID_S2C);
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            ((RegistryFriendlyByteBuf)buf.get()).writeMap(this.players, (b, u) -> b.writeUUID(u), (b, info) -> LegacyPlayerInfo.encode(buf, info));
            ((RegistryFriendlyByteBuf)buf.get()).writeMap(this.gameRules, FriendlyByteBuf::writeUtf, (b, obj) -> {
                b.writeVarInt(obj instanceof Boolean ? 0 : 1);
                if (obj instanceof Boolean) {
                    Boolean bol = (Boolean)obj;
                    b.writeBoolean(bol.booleanValue());
                } else if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    b.writeVarInt(i.intValue());
                }
            });
            ((RegistryFriendlyByteBuf)buf.get()).writeEnum((Enum)this.defaultGameType);
        }

        public void apply(CommonNetwork.SecureExecutor executor, final Supplier<Player> p) {
            executor.executeWhen(() -> {
                if (p.get() != null && ((Player)p.get()).level().isClientSide && FactoryAPIClient.hasModOnServer) {
                    Legacy4JClient.defaultServerGameType = this.defaultGameType;
                    Legacy4JClient.updateLegacyPlayerInfos(this.players);
                    return true;
                }
                return false;
            });
            executor.execute(() -> {
                GameRules gameRules;
                Object t = p.get();
                if (t instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)t;
                    gameRules = sp.getServer().getGameRules();
                } else {
                    gameRules = Legacy4JClient.gameRules;
                }
                final GameRules displayRules = gameRules;
                GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                    public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                        if (gameRules.containsKey(key.getId()) && (((Player)p.get()).level().isClientSide || NON_OP_GAMERULES.contains(key) || ((Player)p.get()).hasPermissions(2))) {
                            GameRules.BooleanValue v;
                            Object object = gameRules.get(key.getId());
                            if (object instanceof Boolean) {
                                Boolean b = (Boolean)object;
                                object = displayRules.getRule(key);
                                if (object instanceof GameRules.BooleanValue) {
                                    v = (GameRules.BooleanValue)object;
                                    v.set(b.booleanValue(), null);
                                }
                            }
                            if ((object = gameRules.get(key.getId())) instanceof Integer) {
                                Integer i = (Integer)object;
                                object = displayRules.getRule(key);
                                if (object instanceof GameRules.IntegerValue) {
                                    v = (GameRules.IntegerValue)object;
                                    v.set(i.intValue(), null);
                                }
                            }
                        }
                    }
                });
            });
        }
    }
}

