/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.FloatByReference;
import dev.isxander.sdl3java.api.SdlInit;
import dev.isxander.sdl3java.api.gamepad.SDL_Gamepad;
import dev.isxander.sdl3java.api.gamepad.SdlGamepad;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.joystick.SdlJoystick;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.apache.commons.io.FileUtils;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.controller.GLFWControllerHandler;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.OverlayPanelScreen;

public class SDLControllerHandler
implements Controller.Handler {
    public static final String SDL_VERSION = "3.2.18.release-3.2.18";
    public static final String nativesMainURLFormat = "https://maven.isxander.dev/releases/dev/isxander/libsdl4j-natives/%s/%s";
    public static final class_2561 TITLE = class_2561.method_43470((String)"SDL3 (isXander's libsdl4j)");
    private static final SDLControllerHandler INSTANCE = new SDLControllerHandler();
    public NativesStatus natives;
    private SDL_JoystickID[] actualIds = new SDL_JoystickID[0];
    private boolean init = false;

    public static SDLControllerHandler getInstance() {
        return INSTANCE;
    }

    public static URI getNativesURI() throws URISyntaxException {
        return new URI(nativesMainURLFormat.formatted(SDL_VERSION, SDLControllerHandler.getNativesFileName()));
    }

    public static NativesStatus getNativesStatus(class_310 minecraft) {
        String fileName = SDLControllerHandler.getNativesFileName();
        boolean pojav = false;
        if (System.getenv("POJAV_NATIVEDIR") != null) {
            Legacy4J.LOGGER.warn("Pojav-based Launcher Detected.");
            pojav = true;
        }
        return new NativesStatus(fileName == null ? null : new File(minecraft.field_1697, "natives/" + fileName), pojav);
    }

    public static String getNativesFileName() {
        try {
            Class.forName("com.sun.jna.Native");
        }
        catch (ClassNotFoundException e) {
            Legacy4J.LOGGER.warn("JNA wasn't found.");
            return null;
        }
        String arch = System.getProperty("os.arch");
        String base = switch (class_156.method_668()) {
            case class_156.class_158.field_1133 -> {
                if (arch.contains("64")) {
                    yield "libsdl4j-natives-%s-windows-x86_64.dll";
                }
                yield "libsdl4j-natives-%s-windows-x86.dll";
            }
            case class_156.class_158.field_1137 -> "libsdl4j-natives-%s-macos-universal.dylib";
            case class_156.class_158.field_1135 -> {
                if (arch.contains("aarch") || arch.contains("arm")) {
                    yield "libsdl4j-natives-%s-linux-aarch64.so";
                }
                yield "libsdl4j-natives-%s-linux-x86_64.so";
            }
            default -> null;
        };
        return base != null ? base.formatted(SDL_VERSION) : null;
    }

    @Override
    public class_2561 getName() {
        return TITLE;
    }

    public void fallback() {
        Legacy4J.LOGGER.warn("{} isn't supported in this system. {} will be used instead.", (Object)this.getName(), (Object)GLFWControllerHandler.getInstance().getName());
        LegacyOptions.selectedControllerHandler.set((Object)GLFWControllerHandler.getInstance());
        LegacyOptions.selectedControllerHandler.save();
        this.init = true;
    }

    @Override
    public void init() {
        if (!this.init) {
            class_310 minecraft = class_310.method_1551();
            if (this.natives == null) {
                this.natives = SDLControllerHandler.getNativesStatus(minecraft);
                if (this.natives.file() == null) {
                    this.fallback();
                }
            }
            if (!this.natives.isPojav()) {
                if (!this.natives.file().exists()) {
                    LegacyOptions.selectedControllerHandler.set((Object)GLFWControllerHandler.getInstance());
                    LegacyOptions.selectedControllerHandler.save();
                    FactoryAPIClient.SECURE_EXECUTOR.executeNowIfPossible(() -> this.openNativesScreen(minecraft), () -> !(minecraft.field_1755 instanceof OverlayPanelScreen) && MinecraftAccessor.getInstance().hasGameLoaded());
                    this.init = true;
                    return;
                }
                try {
                    SdlNativeLibraryLoader.loadLibSDL3FromFilePathNow((String)this.natives.file().getPath());
                }
                catch (Exception | UnsatisfiedLinkError e) {
                    Legacy4J.LOGGER.warn("Failed to load {} natives: {}", (Object)this.getName(), (Object)e.getMessage());
                    this.init = true;
                    return;
                }
            }
            if (!SdlInit.SDL_Init((int)8704)) {
                Legacy4J.LOGGER.warn("SDL Game Controller failed to start!");
                this.fallback();
                return;
            }
            this.tryDownloadAndApplyNewMappings();
            this.init = true;
        }
    }

    public void openNativesScreen(class_310 minecraft) {
        final class_437 s = minecraft.field_1755;
        minecraft.method_1507((class_437)new ConfirmationScreen(s, (class_2561)class_2561.method_43469((String)"legacy.menu.download_natives", (Object[])new Object[]{this.getName()}), Controller.Handler.DOWNLOAD_MESSAGE, b -> {
            final Stocker fileSize = new Stocker((Object)1L);
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            LegacyLoadingScreen screen = new LegacyLoadingScreen(Controller.Handler.DOWNLOADING_NATIVES, class_5244.field_39003){

                public void method_25393() {
                    if (this.getProgress() == 100.0f) {
                        LegacyOptions.selectedControllerHandler.set((Object)SDLControllerHandler.getInstance());
                        LegacyOptions.CLIENT_STORAGE.save();
                        this.method_25419();
                        return;
                    }
                    this.setProgress(SDLControllerHandler.this.natives.file().exists() ? Math.min(1.0f, (float)FileUtils.sizeOf((File)SDLControllerHandler.this.natives.file()) / (float)((Long)fileSize.get()).longValue()) : 0.0f);
                    super.method_25393();
                }

                public void method_25419() {
                    this.field_22787.method_1507(s);
                    LegacyLoadingScreen.closeExecutor(executor);
                }

                @Override
                public boolean method_25422() {
                    return true;
                }
            };
            minecraft.method_1507((class_437)screen);
            CompletableFuture.runAsync(() -> {
                try {
                    fileSize.set((Object)SDLControllerHandler.getNativesURI().toURL().openConnection().getContentLengthLong());
                    FileUtils.copyURLToFile((URL)SDLControllerHandler.getNativesURI().toURL(), (File)this.natives.file());
                    screen.setLoadingHeader(Controller.Handler.LOADING_NATIVES);
                    screen.setProgress(1.0f);
                    this.init = false;
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }, executor);
        }){

            @Override
            public void method_25419() {
                super.method_25419();
                SDLControllerHandler.this.init = false;
            }
        });
    }

    @Override
    public boolean update() {
        if (!this.init) {
            return false;
        }
        SdlGamepad.SDL_UpdateGamepads();
        SdlJoystick.SDL_UpdateJoysticks();
        this.actualIds = SdlGamepad.SDL_GetGamepads();
        return true;
    }

    @Override
    public Controller getController(int jid) {
        if (this.actualIds.length <= jid) {
            return Controller.EMPTY;
        }
        final SDL_Gamepad controller = SdlGamepad.SDL_OpenGamepad((SDL_JoystickID)this.actualIds[jid]);
        return new Controller(){
            String name;

            @Override
            public String getName() {
                if (this.name == null) {
                    this.name = SdlGamepad.SDL_GetGamepadName((SDL_Gamepad)controller);
                }
                return this.name == null ? "Unknown" : this.name;
            }

            @Override
            public ControlType getType() {
                int type = SdlGamepad.SDL_GetGamepadType((SDL_Gamepad)controller);
                return switch (type) {
                    case 4 -> ControlType.get(ControlType.PS3);
                    case 5 -> ControlType.get(ControlType.PS4);
                    case 6 -> ControlType.get(ControlType.PS5);
                    case 2 -> ControlType.get(ControlType.x360);
                    case 3 -> ControlType.get(ControlType.xONE);
                    case 7, 10 -> ControlType.get(ControlType.SWITCH);
                    default -> ControlType.get(ControlType.STEAM);
                };
            }

            @Override
            public boolean buttonPressed(int i) {
                return SdlGamepad.SDL_GetGamepadButton((SDL_Gamepad)controller, (int)i);
            }

            @Override
            public float axisValue(int i) {
                return (float)SdlGamepad.SDL_GetGamepadAxis((SDL_Gamepad)controller, (int)i) / 32767.0f;
            }

            @Override
            public boolean hasLED() {
                return true;
            }

            @Override
            public void setLED(byte r, byte g, byte b) {
                SdlGamepad.SDL_SetGamepadLED((SDL_Gamepad)controller, (byte)r, (byte)g, (byte)b);
            }

            @Override
            public void rumble(char low_frequency_rumble, char high_frequency_rumble, int duration_ms) {
                SdlGamepad.SDL_RumbleGamepad((SDL_Gamepad)controller, (char)low_frequency_rumble, (char)high_frequency_rumble, (long)duration_ms);
            }

            @Override
            public void rumbleTriggers(char left_rumble, char right_rumble, int duration_ms) {
                SdlGamepad.SDL_RumbleGamepadTriggers((SDL_Gamepad)controller, (char)left_rumble, (char)right_rumble, (long)duration_ms);
            }

            @Override
            public int getTouchpadsCount() {
                return SdlGamepad.SDL_GetNumGamepadTouchpads((SDL_Gamepad)controller);
            }

            @Override
            public int getTouchpadFingersCount(int touchpad) {
                return SdlGamepad.SDL_GetNumGamepadTouchpadFingers((SDL_Gamepad)controller, (int)touchpad);
            }

            @Override
            public boolean hasFingerInTouchpad(int touchpad, int finger, Byte state, Float x, Float y, Float pressure) {
                return SdlGamepad.SDL_GetGamepadTouchpadFinger((SDL_Gamepad)controller, (int)touchpad, (int)finger, (ByteByReference)(state == null ? null : new ByteByReference(state.byteValue())), (FloatByReference)(x == null ? null : new FloatByReference(x.floatValue())), (FloatByReference)(y == null ? null : new FloatByReference(y.floatValue())), (FloatByReference)(pressure == null ? null : new FloatByReference(pressure.floatValue())));
            }

            @Override
            public boolean hasButton(ControllerBinding.Button button) {
                int index = SDLControllerHandler.this.getButtonIndex(button);
                return index != -1 && SdlGamepad.SDL_GamepadHasButton((SDL_Gamepad)controller, (int)index);
            }

            @Override
            public boolean hasAxis(ControllerBinding.Axis axis) {
                int index = SDLControllerHandler.this.getAxisIndex(axis);
                return index != -1 && SdlGamepad.SDL_GamepadHasAxis((SDL_Gamepad)controller, (int)index);
            }

            @Override
            public void disconnect(ControllerManager manager) {
                Controller.super.disconnect(manager);
                SdlGamepad.SDL_CloseGamepad((SDL_Gamepad)controller);
            }

            @Override
            public Controller.Handler getHandler() {
                return SDLControllerHandler.this;
            }
        };
    }

    @Override
    public boolean isValidController(int jid) {
        if (this.actualIds.length <= jid) {
            return false;
        }
        return SdlGamepad.SDL_IsGamepad((SDL_JoystickID)this.actualIds[jid]);
    }

    @Override
    public int getButtonIndex(ControllerBinding.Button button) {
        return switch (button) {
            default -> throw new MatchException(null, null);
            case ControllerBinding.Button.DOWN -> 0;
            case ControllerBinding.Button.RIGHT -> 1;
            case ControllerBinding.Button.LEFT -> 2;
            case ControllerBinding.Button.UP -> 3;
            case ControllerBinding.Button.BACK -> 4;
            case ControllerBinding.Button.GUIDE -> 5;
            case ControllerBinding.Button.START -> 6;
            case ControllerBinding.Button.LEFT_STICK -> 7;
            case ControllerBinding.Button.RIGHT_STICK -> 8;
            case ControllerBinding.Button.LEFT_BUMPER -> 9;
            case ControllerBinding.Button.RIGHT_BUMPER -> 10;
            case ControllerBinding.Button.DPAD_UP -> 11;
            case ControllerBinding.Button.DPAD_DOWN -> 12;
            case ControllerBinding.Button.DPAD_LEFT -> 13;
            case ControllerBinding.Button.DPAD_RIGHT -> 14;
            case ControllerBinding.Button.TOUCHPAD -> 20;
            case ControllerBinding.Button.CAPTURE -> 15;
            case ControllerBinding.Button.LSL -> 17;
            case ControllerBinding.Button.LSR -> 19;
            case ControllerBinding.Button.RSL -> 18;
            case ControllerBinding.Button.RSR -> 16;
        };
    }

    @Override
    public int getAxisIndex(ControllerBinding.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case ControllerBinding.Axis.LEFT_STICK_X -> 0;
            case ControllerBinding.Axis.LEFT_STICK_Y -> 1;
            case ControllerBinding.Axis.RIGHT_STICK_X -> 2;
            case ControllerBinding.Axis.RIGHT_STICK_Y -> 3;
            case ControllerBinding.Axis.LEFT_TRIGGER -> 4;
            case ControllerBinding.Axis.RIGHT_TRIGGER -> 5;
        };
    }

    @Override
    public void applyGamePadMappingsFromBuffer(BufferedReader reader) {
        String s = reader.lines().collect(Collectors.joining());
        int i = SdlGamepad.SDL_AddGamepadMapping((String)s);
        Legacy4J.LOGGER.warn("Added SDL Controller Mappings: {} Code", (Object)i);
    }

    public record NativesStatus(File file, boolean isPojav) {
    }
}

