/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import net.minecraft.class_8566;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.client.LegacyGuiItemRenderer;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public abstract class CustomRecipeIconHolder
extends LegacyIconHolder
implements ControlTooltip.ActionHolder {
    final class_1799 defaultItem;
    private final class_310 minecraft;
    class_1799 nextItem = class_1799.field_8037;
    class_1799 previousItem = class_1799.field_8037;
    List<class_1799> addedIngredientsItems = null;
    Predicate<CustomRecipeIconHolder> canAddIngredient = h -> true;

    public CustomRecipeIconHolder(class_1799 defaultItem) {
        super(27, 27);
        this.minecraft = class_310.method_1551();
        this.allowItemDecorations = false;
        this.defaultItem = this.itemIcon = defaultItem;
    }

    public CustomRecipeIconHolder() {
        this(class_1799.field_8037);
    }

    public void init() {
        this.itemIcon = this.defaultItem;
    }

    public void applyAddedIngredients() {
        if (this.addedIngredientsItems == null || this.addedIngredientsItems.isEmpty()) {
            return;
        }
        int index = 0;
        for (int i1 = 0; i1 < this.getIngredientsGrid().size() && index < this.addedIngredientsItems.size(); ++i1) {
            Optional<class_1856> ing = this.getIngredientsGrid().get(i1);
            if (ing.isPresent()) continue;
            this.getIngredientsGrid().set(i1, Optional.of(StackIngredient.of((boolean)false, (class_1799)this.addedIngredientsItems.get(index))));
            ++index;
        }
    }

    public boolean applyNextItemIfAbsent() {
        return false;
    }

    public CustomRecipeIconHolder enableAddIngredients() {
        this.addedIngredientsItems = new ArrayList<class_1799>();
        return this;
    }

    public CustomRecipeIconHolder enableAddIngredients(Predicate<CustomRecipeIconHolder> canAddIngredient) {
        this.canAddIngredient = canAddIngredient;
        return this.enableAddIngredients();
    }

    public class_1799 nextItem(class_1661 inventory, Predicate<class_1799> isValid) {
        int i;
        class_2371 items = inventory.method_67533();
        for (i = Math.max(0, items.indexOf(this.itemIcon)); i < items.size(); ++i) {
            if (this.itemIcon == items.get(i) || !isValid.test((class_1799)items.get(i))) continue;
            return (class_1799)items.get(i);
        }
        for (i = 0; i < Math.max(0, items.indexOf(this.itemIcon)); ++i) {
            if (this.itemIcon == items.get(i) || !isValid.test((class_1799)items.get(i))) continue;
            return (class_1799)items.get(i);
        }
        return class_1799.field_8037;
    }

    public class_1799 previousItem(class_1661 inventory, Predicate<class_1799> isValid) {
        int i;
        class_2371 items = inventory.method_67533();
        for (i = Math.max(0, items.indexOf(this.itemIcon)); i >= 0; --i) {
            if (this.itemIcon == items.get(i) || !isValid.test((class_1799)items.get(i))) continue;
            return (class_1799)items.get(i);
        }
        for (i = items.size() - 1; i >= Math.max(0, items.indexOf(this.itemIcon)); --i) {
            if (this.itemIcon == items.get(i) || !isValid.test((class_1799)items.get(i))) continue;
            return (class_1799)items.get(i);
        }
        return class_1799.field_8037;
    }

    public class_1799 nextItem(List<class_1799> itemStacks) {
        return itemStacks.get(Stocker.cyclic((int)0, (int)(itemStacks.indexOf(this.itemIcon) + 1), (int)itemStacks.size()));
    }

    public class_1799 previousItem(List<class_1799> itemStacks) {
        return itemStacks.get(Stocker.cyclic((int)0, (int)(itemStacks.indexOf(this.itemIcon) - 1), (int)itemStacks.size()));
    }

    @Override
    public void method_25365(boolean bl) {
        if (bl) {
            this.updateRecipe();
        }
        super.method_25365(bl);
    }

    public abstract class_2561 getDisplayName();

    abstract class_1799 nextItem();

    abstract class_1799 previousItem();

    abstract int findInventoryMatchSlot();

    abstract void updateRecipe();

    abstract LegacyScrollRenderer getScrollRenderer();

    public abstract boolean canCraft();

    public abstract List<Optional<class_1856>> getIngredientsGrid();

    public class_1799 assembleCraftingResult(class_1937 level, class_8566 container) {
        container.method_5448();
        for (int i = 0; i < this.getIngredientsGrid().size(); ++i) {
            if (!this.getIngredientsGrid().get(i).isPresent()) continue;
            container.method_5447(i, FactoryIngredient.of((class_1856)this.getIngredientsGrid().get(i).get()).getStacks()[0]);
        }
        class_9694 input = container.method_59961();
        return CommonRecipeManager.getResultFor((class_3956)class_3956.field_17545, (class_9695)input, (class_1937)level).orElse(class_1799.field_8037);
    }

    @Override
    public void onPress(class_11907 input) {
        if (this.method_25370()) {
            if (this.canCraft()) {
                this.craft(input);
                this.updateRecipe();
            } else {
                LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
            }
        }
    }

    public void craft(class_11907 input) {
        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(this.getRecipeId(), List.copyOf(this.getIngredientsGrid()), -1, input.method_74239() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
    }

    public Optional<class_2960> getRecipeId() {
        return Optional.empty();
    }

    public boolean method_25401(double d, double e, double f, double g) {
        int i = (int)Math.signum(g);
        if (this.method_25370() && !this.nextItem.method_7960() && i > 0 || !this.previousItem.method_7960() && i < 0) {
            LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
            this.itemIcon = i > 0 ? this.nextItem : this.previousItem;
            this.updateRecipe();
            return true;
        }
        return false;
    }

    @Override
    public void method_25394(class_332 graphics, int i, int j, float f) {
        if (this.itemIcon.method_7960() || this.applyNextItemIfAbsent() && !this.hasItem(this.itemIcon) || this.method_25370()) {
            this.nextItem = this.nextItem();
            this.previousItem = this.previousItem();
        }
        if ((this.itemIcon.method_7960() || this.applyNextItemIfAbsent() && !this.hasItem(this.itemIcon)) && !this.nextItem.method_7960()) {
            this.itemIcon = this.nextItem;
            if (this.method_25370()) {
                this.updateRecipe();
            }
        }
        super.method_25394(graphics, i, j, f);
    }

    protected boolean hasItem() {
        return this.hasItem(this.itemIcon);
    }

    protected boolean hasItem(class_1799 stack) {
        return !stack.method_7960() && this.minecraft.field_1724.method_31548().method_67533().stream().filter(s -> FactoryItemUtil.equalItems((class_1799)s, (class_1799)stack)).mapToInt(class_1799::method_7947).sum() >= stack.method_7947();
    }

    @Override
    public void renderItem(class_332 graphics, int i, int j, float f) {
        LegacyGuiItemRenderer.secureTranslucentRender(!this.itemIcon.method_7960() && !this.hasItem(this.itemIcon), 0.5f, u -> this.renderItem(graphics, this.itemIcon, this.method_46426(), this.method_46427(), false));
    }

    public boolean canAddIngredient() {
        return this.hasItem(this.itemIcon) && this.addedIngredientsItems != null && this.canAddIngredient.test(this) && this.getIngredientsGrid().stream().anyMatch(Optional::isEmpty);
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 79 && this.canAddIngredient()) {
            this.addedIngredientsItems.add(this.itemIcon.method_46651(1));
            this.updateRecipe();
            return true;
        }
        if (keyEvent.comp_4795() == 88 && this.addedIngredientsItems != null && !this.addedIngredientsItems.isEmpty()) {
            this.addedIngredientsItems.remove(this.addedIngredientsItems.size() - 1);
            this.updateRecipe();
            return true;
        }
        if (!this.nextItem.method_7960() && keyEvent.method_74234() || !this.previousItem.method_7960() && keyEvent.method_74235()) {
            LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
            this.itemIcon = keyEvent.method_74234() ? this.nextItem : this.previousItem;
            this.updateRecipe();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public void renderSelection(class_332 graphics, int i, int j, float f) {
        class_437 class_4372;
        super.renderSelection(graphics, i, j, f);
        if (!this.itemIcon.method_7960() && this.hasItem(this.itemIcon) && (class_4372 = this.minecraft.field_1755) instanceof LegacyMenuAccess) {
            LegacyMenuAccess a = (LegacyMenuAccess)class_4372;
            int matchSlot = this.findInventoryMatchSlot();
            if (matchSlot > 0) {
                class_1735 s = a.method_17577().method_7611(matchSlot);
                LegacyIconHolder h = LegacyRenderUtil.iconHolderRenderer.slotBounds(a.getMenuRectangle().method_49620(), a.getMenuRectangle().method_49618(), s);
                h.method_25394(graphics, i, j, f);
                h.itemIcon = s.method_7677();
                h.renderHighlight(graphics);
                h.renderItem(graphics, i, j, f);
            }
        }
        if (!this.previousItem.method_7960() && this.previousItem != this.itemIcon || !this.nextItem.method_7960() && this.nextItem != this.itemIcon) {
            this.renderScroll(graphics, this.getScrollRenderer());
        }
    }

    @Override
    @Nullable
    public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
        return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.method_25370() && this.canCraft() ? LegacyComponents.CREATE : (c.key() == 79 && this.method_25370() && this.canAddIngredient() ? LegacyComponents.ADD : null));
    }
}

