/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_11905;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_1267;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_640;
import net.minecraft.class_7919;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.compat.WorldHostFriendsScreen;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class HostOptionsScreen
extends PanelVListScreen {
    public static final class_2561 HOST_OPTIONS = class_2561.method_43471((String)"legacy.menu.host_options");
    public static final class_2561 PLAYERS_INVITE = class_2561.method_43471((String)"legacy.menu.players_invite");
    public static final List<class_1928.class_4313<class_1928.class_4310>> WORLD_RULES = new ArrayList<class_1928.class_4313<class_1928.class_4310>>(List.of(class_1928.field_19387, LegacyGameRules.getTntExplodes(), class_1928.field_19396, class_1928.field_19389, class_1928.field_19390, class_1928.field_19388, LegacyGameRules.GLOBAL_MAP_PLAYER_ICON, LegacyGameRules.LEGACY_SWIMMING, LegacyGameRules.LEGACY_FLIGHT));
    public static final List<class_1928.class_4313<class_1928.class_4310>> OTHER_RULES = new ArrayList<class_1928.class_4313>(List.of(class_1928.field_19406, class_1928.field_19391, class_1928.field_19392, class_1928.field_19395, class_1928.field_20638));
    protected final class_2561 title;
    protected float oldAlpha = HostOptionsScreen.getDefaultOpacity();
    protected float alpha = HostOptionsScreen.getDefaultOpacity();
    protected boolean shouldFade = false;

    public HostOptionsScreen(class_2561 title) {
        super((class_437 s) -> Panel.centered(s, LegacySprites.PANEL, 250, 190, 0, 20), HOST_OPTIONS);
        this.title = title;
        this.addPlayerButtons();
        this.renderableVList.layoutSpacing(l -> 0);
    }

    public HostOptionsScreen() {
        this(PLAYERS_INVITE);
    }

    public static void drawPlayerIcon(LegacyPlayerInfo info, class_332 guiGraphics, int x, int y) {
        float[] color = Legacy4JClient.getVisualPlayerColor(info);
        FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(color[0], color[1], color[2], 1.0f);
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(PlayerIdentifier.of(info.getIdentifierIndex()).optionsMapSprite(), x, y, 20, 20);
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((class_332)guiGraphics).clearBlitColor();
    }

    public static List<class_640> getActualPlayerInfos() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null && !minecraft.field_1724.field_3944.method_2880().isEmpty()) {
            return minecraft.field_1724.field_3944.method_2880().stream().sorted(Comparator.comparingInt(p -> minecraft.method_1496() && minecraft.field_1724.method_7334().equals((Object)p.method_2966()) ? 0 : ((LegacyPlayerInfo)p).getIdentifierIndex())).toList();
        }
        return Collections.emptyList();
    }

    protected static float getDefaultOpacity() {
        return 0.5f;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> this.field_22787.method_1496() ? (!this.field_22787.method_1576().method_3860() ? PublishScreen.PUBLISH : (PublishScreen.hasWorldHost() ? WorldHostFriendsScreen.FRIENDS : null)) : null);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> this.field_22787.method_33884().method_33886(this.field_22787.method_1542()) ? LegacyKeyMapping.of(class_310.method_1551().field_1690.field_1890).getDisplayName() : null);
    }

    public void reloadPlayerButtons() {
        int i = this.renderableVList.renderables.indexOf(this.method_25399());
        this.renderableVList.renderables.clear();
        this.addPlayerButtons();
        this.method_41843();
        if (i >= 0 && i < this.renderableVList.renderables.size()) {
            this.method_25395((class_364)this.renderableVList.renderables.get(i));
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(LegacyKeyMapping.of(Legacy4JClient.keyHostOptions).getBinding()) && state.onceClick(true)) {
            this.method_25419();
        }
    }

    @Override
    public boolean method_25404(final class_11908 keyEvent) {
        if (Legacy4JClient.keyHostOptions.method_1417(keyEvent)) {
            this.method_25419();
            return true;
        }
        if (keyEvent.comp_4795() == 79) {
            this.field_22787.method_1507((class_437)new class_408(this, "", false){
                boolean released;
                {
                    super(string, bl);
                    this.released = false;
                }

                public boolean method_25400(class_11905 characterEvent) {
                    if (!this.released) {
                        return false;
                    }
                    return super.method_25400(characterEvent);
                }

                public boolean method_16803(class_11908 keyEvent1) {
                    if (keyEvent.comp_4795() == keyEvent1.comp_4795()) {
                        this.released = true;
                    }
                    return super.method_16803(keyEvent1);
                }
            });
            return true;
        }
        if (keyEvent.comp_4795() == 88 && this.field_22787.method_1496()) {
            if (!this.field_22787.method_1576().method_3860()) {
                this.field_22787.method_1507((class_437)new PublishScreen(this, this, this.field_22787.method_1576().method_3790(), s -> s.publish(this.field_22787.method_1576())){
                    boolean released;
                    {
                        super(parent, gameType, okAction);
                        this.released = false;
                    }

                    public boolean method_25400(class_11905 characterEvent) {
                        if (!this.released) {
                            return false;
                        }
                        return super.method_25400(characterEvent);
                    }

                    public boolean method_16803(class_11908 keyEvent1) {
                        if (keyEvent.comp_4795() == keyEvent1.comp_4795()) {
                            this.released = true;
                        }
                        return super.method_16803(keyEvent1);
                    }
                });
            } else if (PublishScreen.hasWorldHost()) {
                this.field_22787.method_1507((class_437)new WorldHostFriendsScreen(this));
            }
            return true;
        }
        return super.method_25404(keyEvent);
    }

    protected void addPlayerButtons() {
        this.addPlayerButtons(true, (playerInfo, b) -> {
            if (!this.field_22787.field_1724.method_64475(2)) {
                return;
            }
            final HashMap COMMAND_MAP = new HashMap();
            boolean initialVisibility = !((LegacyPlayerInfo)playerInfo).isVisible();
            PanelVListScreen screen = new PanelVListScreen(this, this, s -> Panel.centered(s, LegacySprites.PANEL, 280, playerInfo.method_2958().method_8388() ? 120 : 88), HOST_OPTIONS, (class_640)playerInfo){
                final /* synthetic */ class_640 val$playerInfo;
                {
                    this.val$playerInfo = class_6402;
                    super(parent, panelConstructor, component);
                }

                @Override
                public void renderableVListInit() {
                    this.getRenderableVList().init(this.panel.x + 8, this.panel.y + 27, this.panel.width - 16, this.panel.height - 16);
                }

                @Override
                protected void panelInit() {
                    this.panel.init();
                }

                @Override
                public void method_25419() {
                    COMMAND_MAP.values().forEach(Runnable::run);
                    super.method_25419();
                }

                public boolean method_25421() {
                    return false;
                }

                @Override
                public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
                    this.panel.method_25394(guiGraphics, i, j, f);
                    HostOptionsScreen.drawPlayerIcon((LegacyPlayerInfo)this.val$playerInfo, guiGraphics, this.panel.x + 7, this.panel.y + 5);
                    guiGraphics.method_51433(this.field_22793, this.val$playerInfo.method_2966().name(), this.panel.x + 31, this.panel.y + 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                }
            };
            List<class_1934> gameTypes = Arrays.stream(class_1934.values()).toList();
            screen.renderableVList.addRenderable((class_4068)new TickBox(0, 0, initialVisibility, b1 -> class_2561.method_43471((String)"legacy.menu.host_options.player.invisible"), b1 -> null, b1 -> {
                if (initialVisibility != b1.selected) {
                    COMMAND_MAP.put(b1, () -> {
                        if (b1.selected) {
                            this.field_22787.field_1724.field_3944.method_45730("effect give %s minecraft:invisibility infinite 255 true".formatted(playerInfo.method_2966().name()));
                            this.field_22787.field_1724.field_3944.method_45730("effect give %s minecraft:resistance infinite 255 true".formatted(playerInfo.method_2966().name()));
                        } else {
                            this.field_22787.field_1724.field_3944.method_45730("effect clear %s minecraft:invisibility".formatted(playerInfo.method_2966().name()));
                            this.field_22787.field_1724.field_3944.method_45730("effect clear %s minecraft:resistance".formatted(playerInfo.method_2966().name()));
                        }
                    });
                }
            }));
            if (playerInfo.method_2958().method_8388()) {
                screen.renderableVList.addRenderable((class_4068)new TickBox(0, 0, ((LegacyPlayerInfo)playerInfo).mayFlySurvival(), b1 -> class_2561.method_43471((String)"legacy.menu.host_options.player.mayFly"), b1 -> null, b1 -> CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.mayFlySurvival(b1.selected, playerInfo.method_2966()))));
                screen.renderableVList.addRenderable((class_4068)new TickBox(0, 0, ((LegacyPlayerInfo)playerInfo).isExhaustionDisabled(), b1 -> class_2561.method_43471((String)"legacy.menu.host_options.player.disableExhaustion"), b1 -> null, b1 -> CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.disableExhaustion(b1.selected, playerInfo.method_2966()))));
            }
            screen.renderableVList.addRenderable((class_4068)new LegacySliderButton<class_1934>(0, 0, 230, 16, b1 -> b1.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((class_1934)b1.getObjectValue()).method_32763()), b1 -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("selectWorld.gameMode." + playerInfo.method_2958().method_8381() + ".info"))), playerInfo.method_2958(), () -> gameTypes, b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.method_1562().method_45730("gamemode %s %s".formatted(((class_1934)b1.getObjectValue()).method_8381(), playerInfo.method_2966().name())))));
            screen.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.host_options.set_player_spawn"), b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.field_1724.field_3944.method_45730("spawnpoint %s ~ ~ ~".formatted(playerInfo.method_2966().name())))).method_46434(0, 0, 215, 20).method_46431());
            this.field_22787.method_1507((class_437)screen);
        });
    }

    protected void addPlayerButtons(boolean includeLocal, final BiConsumer<class_640, class_4264> onPress) {
        for (class_640 playerInfo : HostOptionsScreen.getActualPlayerInfos()) {
            if (!includeLocal && Objects.equals(playerInfo.method_2966().name(), class_310.method_1551().field_1724.method_7334().name())) continue;
            this.renderableVList.addRenderable((class_4068)new PlayerButton(this, 0, 0, 230, 30, playerInfo){

                public void method_25306(class_11907 input) {
                    onPress.accept(this.playerInfo, this);
                }
            });
        }
    }

    @Override
    protected void method_25426() {
        CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.askAll((class_1657)this.field_22787.field_1724));
        super.method_25426();
        this.addHostOptionsButton();
    }

    @Override
    protected void panelInit() {
        this.panel.init();
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 10, this.panel.y + 22, this.panel.width - 20, this.panel.height - 26);
    }

    protected void addHostOptionsButton() {
        if (!this.field_22787.field_1724.method_64475(2) && !this.field_22787.method_1496()) {
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)HOST_OPTIONS, this::pressHostOptionsButton).method_46434(this.panel.x, this.panel.y - 36, 250, 20).method_46431());
    }

    protected void pressHostOptionsButton(class_4185 b) {
        final HashMap nonOpGamerules = new HashMap();
        final HashMap COMMAND_MAP = new HashMap();
        PanelVListScreen screen = new PanelVListScreen(this, this, s -> Panel.centered(s, LegacySprites.PANEL, 265, this.field_22787.field_1724.method_64475(2) ? 200 : 130), HOST_OPTIONS){

            @Override
            public void renderableVListInit() {
                this.getRenderableVList().init(this.panel.x + 8, this.panel.y + 8, this.panel.width - 16, this.panel.height - 16);
            }

            @Override
            protected void panelInit() {
                this.panel.init();
            }

            @Override
            public void method_25419() {
                super.method_25419();
                COMMAND_MAP.values().forEach(Runnable::run);
                if (!nonOpGamerules.isEmpty()) {
                    CommonNetwork.sendToServer((CommonNetwork.Payload)new PlayerInfoSync.All(nonOpGamerules, PlayerInfoSync.All.ID_C2S));
                }
            }

            public boolean method_25421() {
                return false;
            }

            @Override
            public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
                this.panel.method_25394(guiGraphics, i, j, f);
            }
        };
        if (!this.field_22787.field_1724.method_64475(2)) {
            for (class_1928.class_4313<class_1928.class_4310> key : PlayerInfoSync.All.NON_OP_GAMERULES) {
                screen.renderableVList.addRenderable((class_4068)new TickBox(0, 0, ((class_1928.class_4310)Legacy4JClient.gameRules.method_20746(key)).method_20753(), b1 -> class_2561.method_43471((String)key.method_27334()), b1 -> null, b1 -> nonOpGamerules.put(key.method_20771(), b1.selected)));
            }
            LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((class_4068)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
            Legacy4J.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((class_4068)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
            this.field_22787.method_1507((class_437)screen);
            return;
        }
        List<String> weathers = List.of("clear", "rain", "thunder");
        int initialWeather = this.field_22787.field_1687.method_8546() ? 2 : (this.field_22787.field_1687.method_8419() ? 1 : 0);
        screen.renderableVList.layoutSpacing(l -> 2);
        for (class_1928.class_4313<class_1928.class_4310> key : WORLD_RULES) {
            screen.renderableVList.addRenderable((class_4068)new TickBox(0, 0, ((class_1928.class_4310)Legacy4JClient.gameRules.method_20746(key)).method_20753(), b1 -> class_2561.method_43471((String)key.method_27334()), b1 -> null, b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.field_1724.field_3944.method_45730("gamerule %s %s".formatted(key.method_20771(), b1.selected)))));
        }
        screen.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.host_options.set_day"), b1 -> this.field_22787.field_1724.field_3944.method_45730("time set day")).method_46434(0, 0, 215, 20).method_46431());
        screen.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.host_options.set_night"), b1 -> this.field_22787.field_1724.field_3944.method_45730("time set 14000")).method_46434(0, 0, 215, 20).method_46431());
        screen.renderableVList.addRenderable((class_4068)new LegacySliderButton<class_1267>(0, 0, 230, 16, b1 -> b1.getDefaultMessage((class_2561)class_2561.method_43471((String)"options.difficulty"), ((class_1267)b1.getObjectValue()).method_5463()), b1 -> class_7919.method_47407((class_2561)this.field_22787.field_1687.method_8407().method_48556()), this.field_22787.field_1687.method_8407(), () -> Arrays.asList(class_1267.values()), b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.method_1562().method_45730("difficulty " + ((class_1267)b1.getObjectValue()).method_5460()))));
        Supplier<class_1934> gameType = () -> Legacy4JClient.defaultServerGameType == null ? this.field_22787.field_1761.method_2920() : Legacy4JClient.defaultServerGameType;
        List<class_1934> gameTypes = Arrays.stream(class_1934.values()).toList();
        screen.renderableVList.addRenderable((class_4068)new LegacySliderButton<class_1934>(0, 0, 230, 16, b1 -> b1.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((class_1934)b1.getObjectValue()).method_32763()), b1 -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("selectWorld.gameMode." + ((class_1934)gameType.get()).method_8381() + ".info"))), gameType.get(), () -> gameTypes, b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.method_1562().method_45730("defaultgamemode " + ((class_1934)b1.getObjectValue()).method_8381()))));
        screen.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.host_options.set_world_spawn"), b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.field_1724.field_3944.method_45730("setworldspawn"))).method_46434(0, 0, 215, 20).method_46431());
        screen.renderableVList.addRenderables(new class_4068[]{SimpleLayoutRenderable.create((int)240, (int)12, l -> (graphics, i, j, f) -> {}), SimpleLayoutRenderable.create((int)240, (int)12, l -> (graphics, i, j, f) -> graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"soundCategory.weather"), l.x + 1, l.y + 4, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false))});
        screen.renderableVList.addRenderable((class_4068)new LegacySliderButton<String>(0, 0, 230, 16, b1 -> class_2561.method_43471((String)("legacy.weather_state." + (String)b1.getObjectValue())), b1 -> null, weathers.get(initialWeather), () -> weathers, b1 -> {
            if (!Objects.equals(b1.getObjectValue(), weathers.get(initialWeather))) {
                COMMAND_MAP.put(b1, () -> this.field_22787.method_1562().method_45730("weather " + (String)b1.getObjectValue()));
            }
        }));
        for (class_1928.class_4313<class_1928.class_4310> key : OTHER_RULES) {
            screen.renderableVList.addRenderable((class_4068)new TickBox(0, 0, ((class_1928.class_4310)Legacy4JClient.gameRules.method_20746(key)).method_20753(), b1 -> class_2561.method_43471((String)key.method_27334()), b1 -> null, b1 -> COMMAND_MAP.put(b1, () -> this.field_22787.field_1724.field_3944.method_45730("gamerule %s %s".formatted(key.method_20771(), b1.selected)))));
        }
        LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((class_4068)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
        Legacy4J.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((class_4068)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
        this.field_22787.method_1507((class_437)screen);
        if (this.field_22787.method_1496() && !this.field_22787.method_1576().method_3860()) {
            return;
        }
        BiFunction<Boolean, class_2561, class_4264> teleportButton = (bol, title) -> class_4185.method_46430((class_2561)title, b1 -> this.field_22787.method_1507((class_437)new HostOptionsScreen(this, (class_2561)title, (Boolean)bol){
            final /* synthetic */ Boolean val$bol;
            {
                this.val$bol = bl;
                super(title);
            }

            @Override
            protected void addHostOptionsButton() {
            }

            @Override
            protected void addPlayerButtons() {
                this.addPlayerButtons(false, (profile, b1) -> {
                    if (this.val$bol.booleanValue()) {
                        this.field_22787.field_1724.field_3944.method_45730("tp %s".formatted(profile.method_2966().name()));
                    } else {
                        this.field_22787.field_1724.field_3944.method_45730("tp %s ~ ~ ~".formatted(profile.method_2966().name()));
                    }
                });
            }

            @Override
            public boolean method_25421() {
                return false;
            }
        })).method_46434(0, 0, 215, 20).method_46431();
        screen.renderableVList.addRenderable((class_4068)teleportButton.apply(true, (class_2561)class_2561.method_43471((String)"legacy.menu.host_options.teleport_player")));
        screen.renderableVList.addRenderable((class_4068)teleportButton.apply(false, (class_2561)class_2561.method_43471((String)"legacy.menu.host_options.teleport_me")));
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        this.oldAlpha = this.alpha;
        this.alpha = class_3532.method_16439((float)(f * 0.1f), (float)this.oldAlpha, (float)(this.shouldFade ? 1.0f : HostOptionsScreen.getDefaultOpacity()));
        this.shouldFade = false;
        FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, this.alpha);
        FactoryScreenUtil.enableBlend();
        this.panel.method_25394(guiGraphics, i, j, f);
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.method_51439(this.field_22793, this.title, this.panel.x + 11, this.panel.y + 8, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    protected abstract class PlayerButton
    extends class_4264 {
        public final class_640 playerInfo;

        public PlayerButton(int x, int y, int width, int height, class_640 playerInfo) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)playerInfo.method_2966().name()));
            this.playerInfo = playerInfo;
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            if (this.method_25367()) {
                HostOptionsScreen.this.shouldFade = true;
            }
            super.method_48579(guiGraphics, i, j, f);
            HostOptionsScreen.drawPlayerIcon((LegacyPlayerInfo)this.playerInfo, guiGraphics, this.method_46426() + 6, this.method_46427() + 5);
        }

        protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
            LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.method_25369(), this.method_46426() + 68, this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), j, true);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }
    }
}

