/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_11908;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_447;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7923;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.util.IOUtil;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LeaderboardsScreen
extends PanelVListScreen {
    public static final List<StatsBoard> statsBoards = new ArrayList<StatsBoard>();
    public static final class_2561 RANK = class_2561.method_43471((String)"legacy.menu.leaderboard.rank");
    public static final class_2561 USERNAME = class_2561.method_43471((String)"legacy.menu.leaderboard.username");
    public static final class_2561 OVERALL = class_2561.method_43471((String)"legacy.menu.leaderboard.filter.overall");
    public static final class_2561 MY_SCORE = class_2561.method_43471((String)"legacy.menu.leaderboard.filter.my_score");
    public static final class_2561 NO_RESULTS = class_2561.method_43471((String)"legacy.menu.leaderboard.no_results");
    protected final Stocker.Sizeable filter = new Stocker.Sizeable(Integer.valueOf(0), 1);
    public int selectedStatBoard = 0;
    protected int statsInScreen = 0;
    protected int lastStatsInScreen = 0;
    protected int page = 0;
    protected int updateTimer = 0;
    protected List<LegacyPlayerInfo> actualRankBoard = Collections.emptyList();

    public LeaderboardsScreen(class_437 parent) {
        super(parent, s -> Panel.createPanel(s, p -> p.appearance(568, 275)), class_5244.field_39003);
        this.rebuildRenderableVList(class_310.method_1551());
        this.renderableVList.layoutSpacing(l -> 1);
    }

    public static class_437 getActualLeaderboardsScreenInstance(class_437 parent) {
        return (Boolean)LegacyOptions.legacyLeaderboards.get() != false ? new LeaderboardsScreen(parent) : new class_447(parent, class_310.method_1551().field_1724.method_3143());
    }

    public static void refreshStatsBoards(class_310 minecraft) {
        if (minecraft.method_1562() == null) {
            return;
        }
        statsBoards.forEach(StatsBoard::clear);
        if (Legacy4JClient.hasModOnServer()) {
            minecraft.method_1562().method_2880().stream().map(p -> ((LegacyPlayerInfo)p).getStatsMap()).forEach(o -> o.forEach((s, i) -> {
                if (i <= 0) {
                    return;
                }
                for (StatsBoard statsBoard : statsBoards) {
                    if (statsBoard.add((class_3445<?>)s)) break;
                }
            }));
        } else {
            minecraft.method_1562().method_52787((class_2596)new class_2799(class_2799.class_2800.field_12775));
            minecraft.field_1724.method_3143().field_15431.forEach((s, i) -> {
                for (StatsBoard statsBoard : statsBoards) {
                    if (statsBoard.add((class_3445<?>)s)) break;
                }
            });
        }
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> LegacyComponents.CHANGE_FILTER);
    }

    public int changedPage(int count) {
        return Math.max(0, this.page + count >= LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).renderables.size() ? this.page : this.page + count);
    }

    public void changeStatBoard(boolean left) {
        int initialSelectedStatBoard = this.selectedStatBoard;
        while ((this.selectedStatBoard = Stocker.cyclic((int)0, (int)(this.selectedStatBoard + (left ? -1 : 1)), (int)statsBoards.size())) != this.selectedStatBoard && this.selectedStatBoard != initialSelectedStatBoard) {
            if (LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.isEmpty()) continue;
            this.page = 0;
            this.rebuildRenderableVList(this.field_22787);
            this.method_48640();
            return;
        }
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        int newPage;
        if (keyEvent.comp_4795() == 88) {
            this.filter.add(1, true);
            this.rebuildRenderableVList(this.field_22787);
            this.method_48640();
        }
        if (keyEvent.method_74232() || keyEvent.method_74233()) {
            this.changeStatBoard(keyEvent.method_74232());
            return true;
        }
        if (!(keyEvent.comp_4795() != 91 && keyEvent.comp_4795() != 93 || this.selectedStatBoard >= statsBoards.size() || LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).renderables.isEmpty() || (newPage = this.changedPage(keyEvent.comp_4795() == 91 ? -this.lastStatsInScreen : this.statsInScreen)) == this.page)) {
            this.lastStatsInScreen = this.statsInScreen;
            this.page = newPage;
            return true;
        }
        if (this.renderableVList.keyPressed(keyEvent.comp_4795())) {
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public boolean method_25401(double d, double e, double f, double g) {
        this.renderableVList.mouseScrolled(g);
        return super.method_25401(d, e, f, g);
    }

    public void rebuildRenderableVList(final class_310 minecraft) {
        this.renderableVList.renderables.clear();
        if (minecraft.method_1562() == null || LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.isEmpty()) {
            return;
        }
        this.actualRankBoard = Legacy4JClient.hasModOnServer() && (Integer)this.filter.get() != 1 ? minecraft.method_1562().method_2880().stream().map(p -> (LegacyPlayerInfo)p).filter(info -> info.getStatsMap().object2IntEntrySet().stream().filter(s -> LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.contains(s.getKey())).mapToInt(Object2IntMap.Entry::getIntValue).sum() > 0).sorted((Integer)this.filter.get() == 0 ? Comparator.comparingInt(info -> ((LegacyPlayerInfo)info).getStatsMap().object2IntEntrySet().stream().filter(s -> LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.contains(s.getKey())).mapToInt(Object2IntMap.Entry::getIntValue).sum()).reversed() : Comparator.comparing(l -> l.legacyMinecraft$getProfile().name())).toList() : List.of((LegacyPlayerInfo)minecraft.method_1562().method_2871(minecraft.field_1724.method_5667()));
        for (int i = 0; i < this.actualRankBoard.size(); ++i) {
            final LegacyPlayerInfo info2 = this.actualRankBoard.get(i);
            final String rank = "" + (i + 1);
            this.renderableVList.renderables.add((class_4068)new class_339(0, 0, 551, 20, (class_2561)class_2561.method_43470((String)info2.legacyMinecraft$getProfile().name())){

                protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
                    int n = this.method_46427();
                    int n2 = this.method_25364();
                    Objects.requireNonNull(LeaderboardsScreen.this.field_22793);
                    int y = n + (n2 - 9) / 2 + 1;
                    FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(this.method_25367() ? LegacySprites.LEADERBOARD_BUTTON_HIGHLIGHTED : LegacySprites.LEADERBOARD_BUTTON, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
                    guiGraphics.method_25303(LeaderboardsScreen.this.field_22793, rank, this.method_46426() + 40 - LeaderboardsScreen.this.field_22793.method_1727(rank) / 2, y, LegacyRenderUtil.getDefaultTextColor(!this.method_25367()));
                    guiGraphics.method_27535(LeaderboardsScreen.this.field_22793, this.method_25369(), this.method_46426() + 120 - LeaderboardsScreen.this.field_22793.method_27525((class_5348)this.method_25369()) / 2, y, LegacyRenderUtil.getDefaultTextColor(!this.method_25367()));
                    guiGraphics.method_27535(LeaderboardsScreen.this.field_22793, this.method_25369(), this.method_46426() + 120 - LeaderboardsScreen.this.field_22793.method_27525((class_5348)this.method_25369()) / 2, y, LegacyRenderUtil.getDefaultTextColor(!this.method_25367()));
                    int added = 0;
                    class_2561 hoveredValue = null;
                    for (int index = LeaderboardsScreen.this.page; index < LeaderboardsScreen.statsBoards.get((int)LeaderboardsScreen.this.selectedStatBoard).statsList.size() && added < LeaderboardsScreen.this.statsInScreen; ++added, ++index) {
                        class_3445<?> stat = LeaderboardsScreen.statsBoards.get((int)LeaderboardsScreen.this.selectedStatBoard).statsList.get(index);
                        class_2561 value = ControlTooltip.CONTROL_ICON_FUNCTION.apply(stat.method_14953((Legacy4JClient.hasModOnServer() ? info2.getStatsMap() : minecraft.field_1724.method_3143().field_15431).getInt(stat)), class_2583.field_24360).getComponent();
                        SimpleLayoutRenderable renderable = LeaderboardsScreen.statsBoards.get((int)LeaderboardsScreen.this.selectedStatBoard).renderables.get(index);
                        int w = LeaderboardsScreen.this.field_22793.method_27525((class_5348)value);
                        LegacyRenderUtil.renderScrollingString(guiGraphics, LeaderboardsScreen.this.field_22793, value, renderable.method_46426() + Math.max(0, renderable.method_25368() - w) / 2, this.method_46427(), renderable.method_46426() + Math.min(renderable.method_25368(), (renderable.method_25368() - w) / 2 + this.method_25368()), this.method_46427() + this.method_25364(), LegacyRenderUtil.getDefaultTextColor(!this.method_25367()), true);
                        if (!LegacyRenderUtil.isMouseOver(i, j, renderable.method_46426() + Math.max(0, renderable.method_25368() - w) / 2, this.method_46427(), Math.min(renderable.method_25368(), w), this.method_25364())) continue;
                        hoveredValue = value;
                    }
                    if (hoveredValue != null) {
                        guiGraphics.method_51438(LeaderboardsScreen.this.field_22793, hoveredValue, i, j);
                    }
                }

                protected void method_47399(class_6382 narrationElementOutput) {
                    this.method_37021(narrationElementOutput);
                }
            });
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.updateTimer <= 0) {
            this.updateTimer = 20;
            if (Legacy4JClient.hasModOnServer()) {
                CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.askAll((class_1657)this.field_22787.field_1724));
            } else {
                this.field_22787.method_1562().method_52787((class_2596)new class_2799(class_2799.class_2800.field_12775));
            }
        } else {
            --this.updateTimer;
        }
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.method_37060((guiGraphics, i, j, f) -> {
            LegacyRenderUtil.renderPointerPanel(guiGraphics, this.panel.x + 8, this.panel.y - 18, 166, 18);
            LegacyRenderUtil.renderPointerPanel(guiGraphics, this.panel.x + (this.panel.width - 211) / 2, this.panel.y - 18, 211, 18);
            LegacyRenderUtil.renderPointerPanel(guiGraphics, this.panel.x + this.panel.width - 174, this.panel.y - 18, 166, 18);
            if (!statsBoards.isEmpty() && this.selectedStatBoard < statsBoards.size()) {
                int newWidth;
                StatsBoard board = statsBoards.get(this.selectedStatBoard);
                LegacyFontUtil.applySmallerFont(LegacyFontUtil.MOJANGLES_11_FONT, b -> {
                    guiGraphics.method_51448().pushMatrix();
                    class_5250 filter = class_2561.method_43469((String)"legacy.menu.leaderboard.filter", (Object[])new Object[]{(Integer)this.filter.get() == 0 ? OVERALL : MY_SCORE});
                    guiGraphics.method_51448().translate((float)(this.panel.x + 91) - (float)this.field_22793.method_27525((class_5348)filter) / 3.0f, (float)(this.panel.y - 12));
                    if (!b.booleanValue()) {
                        guiGraphics.method_51448().scale(0.6666667f, 0.6666667f);
                    }
                    guiGraphics.method_27535(this.field_22793, (class_2561)filter, 0, 0, -1);
                    guiGraphics.method_51448().popMatrix();
                    guiGraphics.method_51448().pushMatrix();
                    guiGraphics.method_51448().translate((float)this.panel.x + ((float)this.panel.width - (float)(this.field_22793.method_27525((class_5348)board.displayName) * 2) / 3.0f) / 2.0f, (float)(this.panel.y - 12));
                    if (!b.booleanValue()) {
                        guiGraphics.method_51448().scale(0.6666667f, 0.6666667f);
                    }
                    guiGraphics.method_27535(this.field_22793, board.displayName, 0, 0, -1);
                    guiGraphics.method_51448().popMatrix();
                    guiGraphics.method_51448().pushMatrix();
                    class_5250 entries = class_2561.method_43469((String)"legacy.menu.leaderboard.entries", (Object[])new Object[]{this.actualRankBoard.size()});
                    guiGraphics.method_51448().translate((float)(this.panel.x + 477) - (float)this.field_22793.method_27525((class_5348)entries) / 3.0f, (float)(this.panel.y - 12));
                    if (!b.booleanValue()) {
                        guiGraphics.method_51448().scale(0.6666667f, 0.6666667f);
                    }
                    guiGraphics.method_27535(this.field_22793, (class_2561)entries, 0, 0, -1);
                    guiGraphics.method_51448().popMatrix();
                });
                if (board.statsList.isEmpty()) {
                    guiGraphics.method_51448().pushMatrix();
                    guiGraphics.method_51448().translate((float)this.panel.x + ((float)this.panel.width - (float)this.field_22793.method_27525((class_5348)NO_RESULTS) * 1.5f) / 2.0f, (float)this.panel.y + ((float)this.panel.height - 13.5f) / 2.0f);
                    guiGraphics.method_51448().scale(1.5f, 1.5f);
                    guiGraphics.method_51439(this.field_22793, NO_RESULTS, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    guiGraphics.method_51448().popMatrix();
                    return;
                }
                guiGraphics.method_51439(this.field_22793, RANK, this.panel.x + 40, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                guiGraphics.method_51439(this.field_22793, USERNAME, this.panel.x + 108, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                int totalWidth = 0;
                this.statsInScreen = 0;
                for (int index = this.page; index < board.renderables.size() && (newWidth = totalWidth + board.renderables.get(index).method_25368()) <= 351; ++index) {
                    ++this.statsInScreen;
                    totalWidth = newWidth;
                }
                FactoryScreenUtil.enableBlend();
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)this.panel.x + (float)(this.panel.width - 211) / 2.0f, (float)(this.panel.y - 12));
                guiGraphics.method_51448().scale(0.5f, 0.5f);
                (ControlType.getActiveType().isKbm() ? ControlTooltip.CompoundComponentIcon.of(ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)) : ControllerBinding.LEFT_STICK.getIcon()).render(guiGraphics, 4, 0, false);
                if (this.statsInScreen < LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).renderables.size()) {
                    ControlTooltip.ComponentIcon pageControl = ControlTooltip.CompoundComponentIcon.of(ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon());
                    pageControl.render(guiGraphics, 422 - pageControl.getWidth() - 8, 0, false);
                }
                guiGraphics.method_51448().popMatrix();
                FactoryScreenUtil.disableBlend();
                if (this.statsInScreen == 0) {
                    return;
                }
                int x = (351 - totalWidth) / (this.statsInScreen + 1);
                Integer hovered = null;
                for (int index = this.page; index < this.page + this.statsInScreen; ++index) {
                    SimpleLayoutRenderable r = board.renderables.get(index);
                    r.method_48229(this.panel.x + 182 + x, this.panel.y + 22 - r.height / 2);
                    r.method_25394(guiGraphics, i, j, f);
                    if (r.isHovered((double)i, (double)j)) {
                        hovered = index;
                    }
                    x += r.method_25368() + (351 - totalWidth) / this.statsInScreen;
                }
                if (hovered != null) {
                    class_2561 class_25612;
                    Object patt0$temp = board.statsList.get(hovered).method_14951();
                    if (patt0$temp instanceof class_1299) {
                        class_1299 e = (class_1299)patt0$temp;
                        class_25612 = e.method_5897();
                    } else {
                        class_1935 item;
                        Object patt1$temp = board.statsList.get(hovered).method_14951();
                        class_25612 = patt1$temp instanceof class_1935 && (item = (class_1935)patt1$temp).method_8389() != class_1802.field_8162 ? class_2561.method_43471((String)item.method_8389().method_7876()) : ControlTooltip.getAction("stat." + board.statsList.get(hovered).method_14951().toString().replace(':', '.'));
                    }
                    guiGraphics.method_51438(this.field_22793, class_25612, i, j);
                }
            }
        });
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 9, this.panel.y + 39, 551, 226);
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public void onStatsUpdated() {
        if (!Legacy4JClient.hasModOnServer()) {
            LeaderboardsScreen.refreshStatsBoards(this.field_22787);
            if (LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.isEmpty()) {
                this.field_22787.method_40000(() -> this.changeStatBoard(false));
            }
        }
    }

    public static class StatsBoard {
        public final class_2561 displayName;
        public final class_3448<?> type;
        public final List<class_3445<?>> statsList = new ArrayList();
        public final List<StatIconOverride<?>> statIconOverrides = new ArrayList();
        public List<SimpleLayoutRenderable> renderables = new ArrayList<SimpleLayoutRenderable>();

        public StatsBoard(class_3448<?> type, class_2561 displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public static StatsBoard create(class_3448<?> type, class_2561 displayName) {
            return new StatsBoard(type, displayName);
        }

        public static StatsBoard create(class_3448<?> type, class_2561 displayName, final Predicate<class_3445<?>> canAccept) {
            return new StatsBoard(type, displayName){

                @Override
                public boolean canAdd(class_3445<?> stat) {
                    return super.canAdd(stat) && canAccept.test(stat);
                }
            };
        }

        public void clear() {
            this.statsList.clear();
            this.renderables.clear();
        }

        public SimpleLayoutRenderable getRenderable(class_3445<?> stat) {
            Object h;
            for (StatIconOverride<?> override : this.statIconOverrides) {
                if (!override.test(stat)) continue;
                return override.icon();
            }
            Object object = stat.method_14951();
            if (object instanceof class_1935) {
                class_1935 i = (class_1935)object;
                h = new LegacyIconHolder(24, 24);
                ((LegacyIconHolder)h).itemIcon = i.method_8389().method_7854();
                return h;
            }
            h = stat.method_14951();
            if (h instanceof class_1299) {
                class_1299 e = (class_1299)h;
                class_2960 entityIcon = Legacy4J.createModLocation("icon/leaderboards/entity/" + e.method_40124().method_40237().method_29177().method_12832());
                if (FactoryGuiGraphics.getSprites().field_5280.containsKey(entityIcon)) {
                    LegacyIconHolder h2 = new LegacyIconHolder(24, 24);
                    h2.iconSprite = entityIcon;
                    return h2;
                }
                return LegacyIconHolder.entityHolder(0, 0, 24, 24, e);
            }
            class_5250 name = class_2561.method_43471((String)("stat." + stat.method_14951().toString().replace(':', '.')));
            return SimpleLayoutRenderable.create((int)(class_310.method_1551().field_1772.method_27525((class_5348)name) * 2 / 3 + 8), (int)7, arg_0 -> StatsBoard.lambda$getRenderable$2((class_2561)name, arg_0));
        }

        public boolean canAdd(class_3445<?> stat) {
            return stat.method_14949() == this.type;
        }

        public boolean add(class_3445<?> stat) {
            if (this.canAdd(stat)) {
                if (!this.statsList.contains(stat)) {
                    this.statsList.add(stat);
                    this.renderables.add(this.getRenderable(stat));
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ class_4068 lambda$getRenderable$2(class_2561 name, SimpleLayoutRenderable l) {
            return (guiGraphics, i, j, f) -> LegacyFontUtil.applySmallerFont(LegacyFontUtil.MOJANGLES_11_FONT, b -> {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)(l.method_46426() + 4), (float)l.method_46427());
                if (!b.booleanValue()) {
                    guiGraphics.method_51448().scale(0.6666667f, 0.6666667f);
                }
                guiGraphics.method_51439(class_310.method_1551().field_1772, name, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                guiGraphics.method_51448().popMatrix();
            });
        }
    }

    public static class Manager
    implements class_4013 {
        public static final String LEADERBOARD_LISTING = "leaderboard_listing.json";

        public void method_14491(class_3300 resourceManager) {
            IOUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)LEADERBOARD_LISTING)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.method_43039();){
                    JsonObject obj = class_3518.method_15255((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("listing");
                    if (ioElement instanceof JsonArray) {
                        JsonArray array = (JsonArray)ioElement;
                        array.forEach(e -> {
                            if (e instanceof JsonObject) {
                                JsonObject o = (JsonObject)e;
                                statsBoards.add(this.statsBoardFromJson(o));
                            }
                        });
                    }
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        protected StatsBoard statsBoardFromJson(JsonObject o) {
            StatsBoard statsBoard;
            class_3448 statType = (class_3448)FactoryAPIPlatform.getRegistryValue((class_2960)class_2960.method_12829((String)class_3518.method_15265((JsonObject)o, (String)"type")), (class_2378)class_7923.field_41193);
            class_2561 name = o.has("displayName") ? class_2561.method_43471((String)class_3518.method_15265((JsonObject)o, (String)"displayName")) : statType.method_30739();
            JsonElement jsonElement = o.get("predicate");
            if (jsonElement instanceof JsonObject) {
                JsonObject predObj = (JsonObject)jsonElement;
                Predicate predicate = IOUtil.registryMatches(statType.method_14959(), predObj);
                statsBoard = StatsBoard.create(statType, name, s -> predicate.test(s.method_14951()));
            } else {
                statsBoard = StatsBoard.create(statType, name);
            }
            jsonElement = o.get("overrides");
            if (jsonElement instanceof JsonArray) {
                JsonArray a = (JsonArray)jsonElement;
                a.forEach(e -> this.parseOverride((class_3448)statType, statsBoard, (JsonElement)e));
            }
            return statsBoard;
        }

        protected <T> void parseOverride(class_3448<T> statType, StatsBoard statsBoard, JsonElement e) {
            JsonObject override;
            JsonElement jsonElement;
            if (e instanceof JsonObject && (jsonElement = (override = (JsonObject)e).get("type")) instanceof JsonPrimitive) {
                JsonPrimitive p = (JsonPrimitive)jsonElement;
                String type = p.getAsString();
                Predicate predicate = IOUtil.registryMatches(statType.method_14959(), override.getAsJsonObject("predicate"));
                switch (type) {
                    case "item": {
                        class_1792 item = (class_1792)FactoryAPIPlatform.getRegistryValue((class_2960)class_2960.method_12829((String)class_3518.method_15265((JsonObject)override, (String)"id")), (class_2378)class_7923.field_41178);
                        LegacyIconHolder h = new LegacyIconHolder(24, 24);
                        h.itemIcon = item.method_7854();
                        statsBoard.statIconOverrides.add(new StatIconOverride<T>(statType, predicate, h));
                        break;
                    }
                    case "entity_type": {
                        class_1299 entityType = (class_1299)FactoryAPIPlatform.getRegistryValue((class_2960)class_2960.method_12829((String)class_3518.method_15265((JsonObject)override, (String)"id")), (class_2378)class_7923.field_41177);
                        statsBoard.statIconOverrides.add(new StatIconOverride<T>(statType, predicate, LegacyIconHolder.entityHolder(0, 0, 24, 24, entityType)));
                        break;
                    }
                    case "sprite": {
                        class_2960 sprite = class_2960.method_12829((String)class_3518.method_15265((JsonObject)override, (String)"id"));
                        LegacyIconHolder h = new LegacyIconHolder(24, 24);
                        h.iconSprite = sprite;
                        statsBoard.statIconOverrides.add(new StatIconOverride<T>(statType, predicate, h));
                    }
                }
            }
        }

        public String method_22322() {
            return "legacy:leaderboards_listing";
        }
    }

    public record StatIconOverride<T>(class_3448<T> statType, Predicate<T> isValid, LegacyIconHolder icon) implements Predicate<class_3445<?>>
    {
        @Override
        public boolean test(class_3445<?> stat) {
            return stat.method_14949() == this.statType && this.isValid.test(stat.method_14951());
        }
    }
}

