/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptionPages;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptions;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import net.caffeinemc.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4068;
import net.minecraft.class_7919;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.TickBox;

public class SodiumCompat {
    public static final Map<String, Field> SODIUM_SLIDER_CONTROL_FIELDS = FactoryAPI.getAccessibleFieldsMap(SliderControl.class, (String[])new String[]{"min", "max", "mode"});
    public static final Map<String, Field> SODIUM_CYCLING_CONTROL_FIELDS = FactoryAPI.getAccessibleFieldsMap(CyclingControl.class, (String[])new String[]{"allowedValues", "names"});
    public static final OptionsScreen.Section SODIUM = OptionsScreen.Section.add(new OptionsScreen.Section((class_2561)class_2561.method_43470((String)FactoryAPIPlatform.getModInfo((String)"sodium").getName()), s -> Panel.centered(s, 250, 200, 0, 18), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> SodiumCompat.addSodiumOptionsFromPage(o, SodiumGameOptionPages.general(), SodiumGameOptionPages.quality(), SodiumGameOptionPages.performance(), SodiumGameOptionPages.advanced())))));
    public static final Map<String, Field> SODIUM_GAME_OPTIONS_PAGE_FIELDS = FactoryAPI.getAccessibleFieldsMap(SodiumGameOptionPages.class, (String[])new String[]{"sodiumOpts"});
    public static final Map<String, Field> SODIUM_OPTIONS_STORAGE_FIELDS = FactoryAPI.getAccessibleFieldsMap(SodiumOptionsStorage.class, (String[])new String[]{"options"});

    public static class_339 getSodiumOptionWidget(Option<?> option) {
        Control formatter;
        if (option.getStorage() instanceof MinecraftOptionsStorage) {
            return null;
        }
        class_7919 tooltip = option.getTooltip() == null ? null : class_7919.method_47407((class_2561)option.getTooltip());
        Control control = option.getControl();
        if (control instanceof TickBoxControl) {
            TickBoxControl c = (TickBoxControl)control;
            return new TickBox(0, 0, 0, (Boolean)c.getOption().getValue(), b -> option.getName(), b -> tooltip, t -> {
                c.getOption().setValue((Object)t.selected);
                option.applyChanges();
                option.getStorage().save();
            });
        }
        control = option.getControl();
        if (control instanceof SliderControl) {
            SliderControl c = (SliderControl)control;
            formatter = (ControlValueFormatter)ReflectionUtil.getFieldValue((Field)SODIUM_SLIDER_CONTROL_FIELDS.get("mode"), (Object)c);
            int min = (Integer)ReflectionUtil.getFieldValue((Field)SODIUM_SLIDER_CONTROL_FIELDS.get("min"), (Object)c);
            int max = (Integer)ReflectionUtil.getFieldValue((Field)SODIUM_SLIDER_CONTROL_FIELDS.get("max"), (Object)c);
            return LegacySliderButton.createFromIntRange(0, 0, 0, 16, arg_0 -> SodiumCompat.lambda$getSodiumOptionWidget$5(option, (ControlValueFormatter)formatter, arg_0), b -> tooltip, (Integer)c.getOption().getValue(), min, max, s -> {
                if (!Objects.equals(c.getOption().getValue(), s.getObjectValue())) {
                    c.getOption().setValue((Object)((Integer)s.getObjectValue()));
                    option.applyChanges();
                    option.getStorage().save();
                }
            });
        }
        formatter = option.getControl();
        if (formatter instanceof CyclingControl) {
            CyclingControl c = (CyclingControl)formatter;
            List<Enum> values = List.of((Enum[])ReflectionUtil.getFieldValue((Field)SODIUM_CYCLING_CONTROL_FIELDS.get("allowedValues"), (Object)c));
            class_2561[] components = (class_2561[])ReflectionUtil.getFieldValue((Field)SODIUM_CYCLING_CONTROL_FIELDS.get("names"), (Object)c);
            return new LegacySliderButton<Enum>(0, 0, 0, 16, b -> b.getDefaultMessage(option.getName(), components[values.indexOf(b.getObjectValue())]), b -> tooltip, (Enum)c.getOption().getValue(), () -> values, s -> {
                if (!Objects.equals(c.getOption().getValue(), s.getObjectValue())) {
                    c.getOption().setValue((Object)((Enum)s.getObjectValue()));
                    option.applyChanges();
                    option.getStorage().save();
                }
            });
        }
        return null;
    }

    public static void addSodiumOptionsFromPage(OptionsScreen screen, OptionPage ... pages) {
        for (OptionPage page : pages) {
            List<class_339> widgets = page.getOptions().stream().map(SodiumCompat::getSodiumOptionWidget).filter(Objects::nonNull).toList();
            if (widgets.isEmpty()) continue;
            screen.getRenderableVList().addRenderable((class_4068)SimpleLayoutRenderable.createDrawString((class_2561)page.getName(), (int)0, (int)1, (int)200, (int)9, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), (boolean)false));
            screen.getRenderableVList().renderables.addAll(widgets);
        }
    }

    public static void init() {
        Legacy4JClient.whenResetOptions.add(() -> {
            SodiumClientMod.restoreDefaultOptions();
            ReflectionUtil.setFieldValue((Field)SODIUM_OPTIONS_STORAGE_FIELDS.get("options"), (Object)ReflectionUtil.getStaticFieldValue((Field)SODIUM_GAME_OPTIONS_PAGE_FIELDS.get("sodiumOpts")), (Object)SodiumGameOptions.defaults());
        });
    }

    private static /* synthetic */ class_2561 lambda$getSodiumOptionWidget$5(Option option, ControlValueFormatter formatter, LegacySliderButton b) {
        return b.getDefaultMessage(option.getName(), formatter.format(((Integer)b.getObjectValue()).intValue()));
    }
}

