/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.network.ServerMenuCraftPayload;

public interface RecipeMenu {
    public static void handleCompactInventoryList(Collection<class_1799> compactList, class_1661 inventory, class_1799 carriedItem) {
        RecipeMenu.handleCompactItemStackList(compactList, (Iterable<class_1799>)inventory.method_67533());
        if (!carriedItem.method_7960()) {
            RecipeMenu.handleCompactItemStackListAdd(compactList, carriedItem);
        }
    }

    public static void handleCompactItemStackList(Collection<class_1799> compactList, Iterable<class_1799> items) {
        for (class_1799 item : items) {
            if (item.method_7960()) continue;
            RecipeMenu.handleCompactItemStackListAdd(compactList, item);
        }
    }

    public static void handleCompactItemStackListAdd(Collection<class_1799> compactList, class_1799 item) {
        for (class_1799 itemStack : compactList) {
            if (!FactoryItemUtil.equalItems((class_1799)itemStack, (class_1799)item)) continue;
            itemStack.method_7933(item.method_7947());
            return;
        }
        compactList.add(item.method_7972());
    }

    public static boolean canCraft(List<Optional<class_1856>> ingredients, class_1661 inventory, class_1799 carriedItem) {
        boolean canCraft = true;
        ArrayList<class_1799> compactList = new ArrayList<class_1799>();
        RecipeMenu.handleCompactInventoryList(compactList, inventory, carriedItem);
        block0: for (Optional<class_1856> ing : ingredients) {
            if (ing.isEmpty()) continue;
            for (int i = 0; i < FactoryIngredient.of((class_1856)ing.get()).getCount(); ++i) {
                class_1799 itemStack2;
                block3: {
                    for (class_1799 itemStack2 : compactList) {
                        if (itemStack2.method_7960() || !ing.get().method_8093(itemStack2.method_46651(1))) continue;
                        break block3;
                    }
                    canCraft = false;
                    break block0;
                }
                itemStack2.method_7934(1);
            }
        }
        return canCraft;
    }

    default public boolean canCraft(List<Optional<class_1856>> ingredients, class_1657 player, ServerMenuCraftPayload packet) {
        return RecipeMenu.canCraft(ingredients, player.method_31548(), player.field_7512.method_34255());
    }

    default public List<class_1799> getRemainingItems(class_1657 player, ServerMenuCraftPayload packet) {
        return Collections.emptyList();
    }

    default public void tryCraft(class_1657 player, ServerMenuCraftPayload packet) {
        int tries = 0;
        List<Optional<class_1856>> ingredients = this.getIngredients(player, packet);
        if (ingredients.isEmpty()) {
            return;
        }
        while (this.canCraft(ingredients, player, packet) && (packet.max() && tries <= 2304 || tries == 0)) {
            ++tries;
            this.setupActualItems(player, packet, null, -1);
            for (int index = 0; index < ingredients.size(); ++index) {
                Optional<class_1856> ing = ingredients.get(index);
                if (ing.isEmpty()) continue;
                int count = FactoryIngredient.of((class_1856)ing.get()).getCount();
                block2: for (int c = 0; c < count; ++c) {
                    class_1799 copy;
                    if (!player.field_7512.method_34255().method_7960()) {
                        copy = player.field_7512.method_34255().method_46651(1);
                        if (ing.get().method_8093(copy)) {
                            if (c == count - 1) {
                                this.setupActualItems(player, packet, copy, index);
                            }
                            player.field_7512.method_34255().method_7934(1);
                            continue;
                        }
                    }
                    for (int i = 0; i < player.field_7512.field_7761.size(); ++i) {
                        class_1735 slot = player.field_7512.method_7611(i);
                        if (slot.field_7871 != player.method_31548() || !slot.method_7681()) continue;
                        copy = slot.method_7677().method_46651(1);
                        if (!ing.get().method_8093(copy)) continue;
                        if (c == count - 1) {
                            this.setupActualItems(player, packet, copy, index);
                        }
                        slot.method_7677().method_7934(1);
                        continue block2;
                    }
                }
            }
            class_1799 result = this.getResult(player, packet);
            this.onCraft(player, packet, result);
            this.getRemainingItems(player, packet).forEach(arg_0 -> ((class_1661)player.method_31548()).method_7398(arg_0));
            player.method_31548().method_7398(result.method_7972());
        }
    }

    public void onCraft(class_1657 var1, ServerMenuCraftPayload var2, class_1799 var3);

    public class_1799 getResult(class_1657 var1, ServerMenuCraftPayload var2);

    default public List<Optional<class_1856>> getIngredients(class_1657 player, ServerMenuCraftPayload packet) {
        return packet.customIngredients();
    }

    default public void setupActualItems(class_1657 player, ServerMenuCraftPayload packet, class_1799 setItem, int index) {
    }
}

