/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_3489;
import net.minecraft.class_6880;
import net.minecraft.class_9282;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.config.LegacyCommonOptions;

public class LegacyItemUtil {
    public static boolean canRepair(class_1799 repairItem, class_1799 ingredient) {
        return repairItem.method_31574(ingredient.method_7909()) && repairItem.method_7947() == 1 && ingredient.method_7947() == 1 && repairItem.method_7909().method_57347().method_57832(class_9334.field_49629) && !repairItem.method_7942() && !ingredient.method_7942();
    }

    public static boolean isDyedItem(class_1799 itemStack) {
        return itemStack.method_58694(class_9334.field_49644) == null;
    }

    public static boolean isDyeableItem(class_6880<class_1792> item) {
        return item.method_40220(class_3489.field_48803);
    }

    public static class_1799 dyeItem(class_1799 itemStack, int color) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        class_9282 dyedItemColor = (class_9282)itemStack.method_58694(class_9334.field_49644);
        if (dyedItemColor != null) {
            colors.add(color);
        }
        colors.add(color);
        itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(LegacyItemUtil.mixColors(colors.iterator())));
        return itemStack;
    }

    public static int mixColors(Iterator<Integer> colors) {
        float h;
        int[] is = new int[3];
        int i = 0;
        int j = 0;
        Iterator<Integer> it = colors;
        while (it.hasNext()) {
            Integer color = it.next();
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            h = (float)(color & 0xFF) / 255.0f;
            i += (int)(Math.max(f, Math.max(g, h)) * 255.0f);
            is[0] = is[0] + (int)(f * 255.0f);
            is[1] = is[1] + (int)(g * 255.0f);
            is[2] = is[2] + (int)(h * 255.0f);
            ++j;
        }
        int k = is[0] / j;
        int o = is[1] / j;
        int p = is[2] / j;
        h = (float)i / (float)j;
        float q = Math.max(k, Math.max(o, p));
        k = (int)((float)k * h / q);
        o = (int)((float)o * h / q);
        p = (int)((float)p * h / q);
        int n = k;
        n = (n << 8) + o;
        n = (n << 8) + p;
        return n;
    }

    public static boolean hasValidPatterns(class_1799 stack) {
        int count = LegacyItemUtil.getPatternsCount(stack);
        return count > 0 && count <= 6;
    }

    public static int getPatternsCount(class_1799 stack) {
        return ((class_9307)stack.method_58695(class_9334.field_49619, (Object)class_9307.field_49404)).comp_2428().size();
    }

    public static boolean anyArmorSlotMatch(class_1661 inventory, Predicate<class_1799> predicate) {
        return class_1661.field_56551.int2ObjectEntrySet().stream().anyMatch(e -> e.getValue() != class_1304.field_6171 && predicate.test(inventory.method_5438(e.getIntKey())));
    }

    public static class_6880<class_1842> getPotionContent(class_1799 itemStack) {
        return ((class_1844)itemStack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().orElse(null);
    }

    public static class_1799 setItemStackPotion(class_1799 stack, class_6880<class_1842> potion) {
        stack.method_57379(class_9334.field_49651, (Object)new class_1844(potion));
        return stack;
    }

    public static void addPotionTooltip(class_6880<class_1842> potion, List<class_2561> tooltipList, float f, float tickRate) {
        class_1844.method_8065((Iterable)((class_1842)potion.comp_349()).method_8049(), tooltipList::add, (float)f, (float)tickRate);
    }

    public static int getDyeColor(class_1767 dyeColor) {
        return dyeColor.method_7787();
    }

    public static float getItemDamageModifier(class_1799 stack) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            if (stack.method_31573(class_3489.field_42611)) {
                return 1.0f;
            }
            if (stack.method_7909() instanceof class_1821) {
                return -0.5f;
            }
            if (stack.method_31573(class_3489.field_42614)) {
                return 1.0f;
            }
            if (stack.method_7909() instanceof class_1743) {
                if (stack.method_31574(class_1802.field_8062)) {
                    return -4.0f;
                }
                if (stack.method_31574(class_1802.field_8556) || stack.method_31574(class_1802.field_22025)) {
                    return -2.0f;
                }
                return -3.0f;
            }
        }
        return 0.0f;
    }
}

