/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import wily.factoryapi.FactoryAPI;
import wily.legacy.Legacy4J;
import wily.legacy.util.JsonUtil;

public class LegacyBiomeOverride {
    public static final Map<ResourceLocation, LegacyBiomeOverride> map = new HashMap<ResourceLocation, LegacyBiomeOverride>();
    private static final String BIOME_OVERRIDES = "biome_overrides.json";
    public static final ResourceLocation DEFAULT_LOCATION = FactoryAPI.createVanillaLocation((String)"default");
    public static final LegacyBiomeOverride DEFAULT = new LegacyBiomeOverride(){

        @Override
        public float waterTransparency() {
            return this.waterTransparency == null ? 1.0f : this.waterTransparency.floatValue();
        }
    };
    private ItemStack icon = ItemStack.f_41583_;
    Integer waterColor;
    Integer waterFogColor;
    Float waterTransparency;

    public static LegacyBiomeOverride getOrDefault(Optional<ResourceKey<Biome>> optionalKey) {
        return optionalKey.isEmpty() ? DEFAULT : LegacyBiomeOverride.getOrDefault(optionalKey.get().m_135782_());
    }

    public static LegacyBiomeOverride getOrDefault(ResourceLocation location) {
        return map.getOrDefault(location, DEFAULT);
    }

    public ItemStack icon() {
        return this.icon;
    }

    public float waterTransparency() {
        return this.waterTransparency == null ? DEFAULT.waterTransparency() : this.waterTransparency.floatValue();
    }

    public Integer waterColor() {
        return this.waterColor == null ? LegacyBiomeOverride.DEFAULT.waterColor : this.waterColor;
    }

    public int getWaterARGBOrDefault(int defaultColor) {
        return (int)(this.waterTransparency() * 255.0f) << 24 | (this.waterColor() == null ? defaultColor : this.waterColor()) & 0xFFFFFF;
    }

    public Integer waterFogColor() {
        return this.waterFogColor == null ? LegacyBiomeOverride.DEFAULT.waterFogColor : this.waterFogColor;
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public void m_6213_(ResourceManager resourceManager) {
            map.clear();
            map.put(DEFAULT_LOCATION, DEFAULT);
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.m_213713_(FactoryAPI.createLocation((String)name, (String)LegacyBiomeOverride.BIOME_OVERRIDES)).ifPresent(r -> {
                try {
                    BufferedReader bufferedReader = r.m_215508_();
                    JsonObject obj = GsonHelper.m_13859_((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("overrides");
                    if (ioElement instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)ioElement;
                        jsonObject.asMap().forEach((s, e) -> {
                            if (e instanceof JsonObject) {
                                JsonPrimitive p;
                                JsonElement patt0$temp;
                                JsonObject o = (JsonObject)e;
                                LegacyBiomeOverride override = map.computeIfAbsent(FactoryAPI.createLocation((String)s), resourceLocation -> new LegacyBiomeOverride());
                                JsonUtil.getItemFromJson((JsonElement)o, true).ifPresent(i -> {
                                    override.icon = i;
                                });
                                Integer i2 = JsonUtil.optionalJsonColor(o, "water_color", null);
                                if (i2 != null) {
                                    override.waterColor = i2;
                                }
                                if ((i2 = JsonUtil.optionalJsonColor(o, "water_fog_color", null)) != null) {
                                    override.waterFogColor = i2;
                                }
                                if ((patt0$temp = o.get("water_transparency")) instanceof JsonPrimitive && (p = (JsonPrimitive)patt0$temp).isNumber()) {
                                    override.waterTransparency = Float.valueOf(p.getAsFloat());
                                }
                            }
                        });
                    }
                    bufferedReader.close();
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public String m_7812_() {
            return "legacy:biome_overrides";
        }
    }
}

