/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.GlobalPacks;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public record PackAlbum(String id, int version, Component displayName, Component description, Optional<ResourceLocation> iconSprite, Optional<ResourceLocation> backgroundSprite, List<String> packs, Optional<String> displayPack) {
    public static final Codec<PackAlbum> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("id").forGetter(PackAlbum::id), (App)Codec.INT.optionalFieldOf("version", (Object)0).forGetter(PackAlbum::version), (App)DynamicUtil.getComponentCodec().fieldOf("name").forGetter(PackAlbum::displayName), (App)DynamicUtil.getComponentCodec().fieldOf("description").forGetter(PackAlbum::description), (App)ResourceLocation.f_135803_.optionalFieldOf("icon").forGetter(PackAlbum::iconSprite), (App)ResourceLocation.f_135803_.optionalFieldOf("background").forGetter(PackAlbum::backgroundSprite), (App)Codec.STRING.listOf().fieldOf("packs").forGetter(PackAlbum::packs), (App)Codec.STRING.optionalFieldOf("displayPack").forGetter(PackAlbum::displayPack)).apply((Applicative)i, PackAlbum::new));
    public static final Codec<List<PackAlbum>> LIST_CODEC = CODEC.listOf();
    public static final ListMap<String, PackAlbum> resourceAlbums = new ListMap();
    public static final List<PackAlbum> DEFAULT_RESOURCE_ALBUMS = new ArrayList<PackAlbum>();
    public static final String RESOURCE_ALBUMS = "resource_albums";
    public static final Path RESOURCE_ALBUMS_PATH = Minecraft.m_91087_().f_91069_.toPath().resolve("resource_albums");
    @Deprecated
    public static final Path RESOURCE_ASSORTS_PATH = Minecraft.m_91087_().f_91069_.toPath().resolve("resource_assorts");
    public static final Component ALBUM_OPTIONS = Component.m_237115_((String)"legacy.menu.album_options");
    public static final Component ALBUM_OPTIONS_MESSAGE = Component.m_237115_((String)"legacy.menu.album_options_message");
    public static final Component ADD_ALBUM = Component.m_237115_((String)"legacy.menu.add_album");
    public static final Component EDIT_ALBUM = Component.m_237115_((String)"legacy.menu.edit_album");
    public static final Component REMOVE_ALBUM = Component.m_237115_((String)"legacy.menu.remove_album");
    public static final Gson GSON = new GsonBuilder().create();
    public static final PackAlbum MINECRAFT = PackAlbum.registerDefaultResource("minecraft", 2, (Component)Component.m_237115_((String)"legacy.menu.albums.resource.minecraft"), (Component)Component.m_237115_((String)"legacy.menu.albums.resource.minecraft.description"), null, Legacy4J.createModLocation("icon/background"), PackAlbum.getMinecraftResourcePacks(), "vanilla");
    public static final PackAlbum MINECRAFT_CLASSIC_TEXTURES = PackAlbum.registerDefaultResource("minecraft_classic", 1, (Component)Component.m_237115_((String)"legacy.menu.albums.resource.minecraft_classic"), (Component)Component.m_237115_((String)"legacy.menu.albums.resource.minecraft_classic.description"), Legacy4J.createModLocation("icon/minecraft_classic"), Legacy4J.createModLocation("icon/minecraft_classic_background"), PackAlbum.getMinecraftClassicResourcePacks(), null);
    public static final Stocker<String> defaultResourceAlbum = Stocker.of((Object)PackAlbum.MINECRAFT.id);

    public static List<String> getMinecraftResourcePacks() {
        return new ArrayList<String>(List.of("vanilla", FactoryAPI.getLoader().isForgeLike() ? "mod_resources" : "fabric", "legacy:legacy_waters"));
    }

    public static List<String> getMinecraftClassicResourcePacks() {
        List<String> album = PackAlbum.getMinecraftResourcePacks();
        album.add(album.size() - 1, "programmer_art");
        if (FactoryAPI.getLoader().isForgeLike()) {
            album.add(album.size() - 1, "legacy:programmer_art");
        }
        return album;
    }

    public static PackAlbum getDefaultResourceAlbum() {
        return PackAlbum.resourceById((String)defaultResourceAlbum.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PackAlbum)) return false;
        PackAlbum a = (PackAlbum)obj;
        if (!a.id.equals(this.id)) return false;
        return true;
    }

    public PackAlbum withPacks(List<String> packs) {
        return new PackAlbum(this.id, this.version, this.displayName, this.description, this.iconSprite, this.backgroundSprite, packs, this.displayPack);
    }

    public static void init() {
        List<PackAlbum> albums = Files.exists(RESOURCE_ASSORTS_PATH, new LinkOption[0]) ? PackAlbum.load(RESOURCE_ASSORTS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum, true) : Collections.emptyList();
        albums.forEach(PackAlbum::registerResource);
        if (!Files.exists(RESOURCE_ALBUMS_PATH, new LinkOption[0]) || !albums.isEmpty()) {
            PackAlbum.save(RESOURCE_ALBUMS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum);
        }
        if (albums.isEmpty()) {
            PackAlbum.load();
        }
    }

    public static PackAlbum resourceById(String s) {
        return (PackAlbum)resourceAlbums.getOrDefault((Object)s, (Object)MINECRAFT);
    }

    public static void load() {
        resourceAlbums.clear();
        PackAlbum.load(RESOURCE_ALBUMS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum).forEach(PackAlbum::registerResource);
    }

    public static List<PackAlbum> load(Path path, List<PackAlbum> defaultAlbums, Stocker<String> selected) {
        return PackAlbum.load(path, defaultAlbums, selected, false);
    }

    public static List<PackAlbum> load(Path path, List<PackAlbum> defaultAlbums, Stocker<String> selected, boolean deprecated) {
        ArrayList<String> order = new ArrayList<String>();
        Path orderJson = path.resolveSibling(String.valueOf(path.getFileName()) + ".json");
        String defaultAlbum = PackAlbum.MINECRAFT.id;
        try (BufferedReader r2 = Files.newBufferedReader(orderJson, Charsets.UTF_8);){
            JsonObject obj = (JsonObject)GSON.getAdapter(JsonObject.class).read(new JsonReader((Reader)r2));
            defaultAlbum = obj.getAsJsonPrimitive("default").getAsString();
            for (JsonElement e : obj.getAsJsonArray("order")) {
                if (!(e instanceof JsonPrimitive)) continue;
                order.add(e.getAsString());
            }
        }
        catch (IOException r2) {
            // empty catch block
        }
        for (int i = defaultAlbums.size() - 1; i >= 0; --i) {
            PackAlbum a = defaultAlbums.get(i);
            if (order.contains(a.id)) continue;
            order.add(0, a.id);
        }
        ArrayList<PackAlbum> list = new ArrayList<PackAlbum>();
        try (Stream<Path> s = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.comparingInt(p -> {
            int i = order.indexOf(FilenameUtils.getBaseName((String)p.getFileName().toString()));
            return i < 0 ? order.size() : i;
        }));){
            for (Path p2 : s::iterator) {
                if (!p2.toString().endsWith(".json")) continue;
                try {
                    BufferedReader r = Files.newBufferedReader(p2, Charsets.UTF_8);
                    try {
                        CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13859_((Reader)r)).result().ifPresent(list::add);
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                    }
                }
                catch (IOException e) {
                    Legacy4J.LOGGER.warn("Failed to load {}, this album won't be loaded", (Object)p2, (Object)e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (deprecated) {
            FileUtils.deleteQuietly((File)path.toFile());
            FileUtils.deleteQuietly((File)orderJson.toFile());
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
        }
        for (int i = defaultAlbums.size() - 1; i >= 0; --i) {
            PackAlbum a = defaultAlbums.get(i);
            int index = list.indexOf(a);
            if (index < 0) {
                list.add(0, a);
                continue;
            }
            if (a.version <= ((PackAlbum)list.get((int)index)).version) continue;
            list.set(index, a);
        }
        selected.set((Object)defaultAlbum);
        return list;
    }

    public static void save() {
        PackAlbum.save(RESOURCE_ALBUMS_PATH, resourceAlbums.values(), defaultResourceAlbum);
    }

    public static void save(Path path, Collection<PackAlbum> albums, Stocker<String> selected) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Failed to make albums directory {}", (Object)path, (Object)e);
            }
        } else {
            FileUtils.listFiles((File)path.toFile(), (String[])new String[]{"json"}, (boolean)true).forEach(File::delete);
        }
        ArrayList<String> order = new ArrayList<String>();
        for (PackAlbum album : albums) {
            order.add(album.id);
            Path p = path.resolve(album.id + ".json");
            try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(p, Charsets.UTF_8, new OpenOption[0]));){
                w.setSerializeNulls(false);
                w.setIndent("  ");
                GsonHelper.m_216207_((JsonWriter)w, (JsonElement)((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)album).result().orElseThrow()), null);
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Failed to write {}, this album won't be saved", (Object)p, (Object)e);
            }
        }
        Path orderJson = path.resolveSibling(String.valueOf(path.getFileName()) + ".json");
        try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(orderJson, Charsets.UTF_8, new OpenOption[0]));){
            w.setSerializeNulls(false);
            w.setIndent("  ");
            JsonArray a = new JsonArray();
            order.forEach(arg_0 -> ((JsonArray)a).add(arg_0));
            JsonObject obj = new JsonObject();
            obj.add("default", (JsonElement)new JsonPrimitive((String)selected.get()));
            obj.add("order", (JsonElement)a);
            GsonHelper.m_216207_((JsonWriter)w, (JsonElement)obj, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PackAlbum registerResource(PackAlbum a) {
        resourceAlbums.put((Object)a.id(), (Object)a);
        return a;
    }

    public static PackAlbum registerDefaultResource(String id, int version, Component displayName, Component description, ResourceLocation iconSprite, ResourceLocation backgroundSprite, List<String> packs, String displayPack) {
        return PackAlbum.registerDefaultResource(new PackAlbum(id, version, displayName, description, Optional.ofNullable(iconSprite), Optional.ofNullable(backgroundSprite), packs, Optional.ofNullable(displayPack)));
    }

    public static PackAlbum registerDefaultResource(PackAlbum a) {
        DEFAULT_RESOURCE_ALBUMS.add(a);
        return a;
    }

    public static void applyDefaultResourceAlbum() {
        List<String> oldSelection = PackAlbum.getSelectableIds(Minecraft.m_91087_().m_91099_());
        ((GlobalPacks)GlobalPacks.globalResources.get()).applyPacks(Minecraft.m_91087_().m_91099_(), PackAlbum.getDefaultResourceAlbum().packs());
        if (!oldSelection.equals(PackAlbum.getSelectableIds(Minecraft.m_91087_().m_91099_()))) {
            Minecraft.m_91087_().m_91391_();
            PackAlbum.updateSavedResourcePacks();
        }
    }

    public static void updateSavedResourcePacks() {
        Minecraft.m_91087_().f_91066_.f_92117_.clear();
        Minecraft.m_91087_().f_91066_.f_92118_.clear();
        Minecraft.m_91087_().m_91099_().m_10524_().forEach(p -> {
            if (p.m_10443_().m_10489_()) {
                Minecraft.m_91087_().f_91066_.f_92117_.add(p.m_10446_());
            } else {
                Minecraft.m_91087_().f_91066_.f_92118_.add(p.m_10446_());
            }
        });
    }

    public static List<String> getSelectedIds(PackRepository packRepository) {
        return packRepository.m_10524_().stream().map(Pack::m_10446_).toList();
    }

    public static List<String> getSelectableIds(PackRepository packRepository) {
        return packRepository.m_10524_().stream().filter(pack -> !FactoryAPIPlatform.isPackHidden((Pack)pack)).map(Pack::m_10446_).toList();
    }

    public boolean isValidPackDisplay(PackRepository packRepository) {
        String id = this.getDisplayPackId();
        if (id == null) {
            return false;
        }
        return packRepository.m_10507_(id) != null;
    }

    public String getDisplayPackId() {
        return this.displayPack.orElse(this.packs.isEmpty() ? null : this.packs.get(this.packs.size() - 1));
    }

    public static ConfirmationScreen createAlbumEditScreen(Screen parent, Component title, Component defaultName, Component defaultDescription, BiConsumer<Component, Component> editAlbum) {
        final EditBox nameBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, (Component)Component.m_237115_((String)"legacy.menu.album_info"));
        final MultiLineEditBox descriptionBox = new MultiLineEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 60, defaultDescription, nameBox.m_6035_());
        nameBox.m_257771_(defaultName);
        return new ConfirmationScreen(parent, 230, 184, title, nameBox.m_6035_(), p -> editAlbum.accept((Component)(nameBox.m_94155_().isBlank() ? defaultName : Component.m_237113_((String)nameBox.m_94155_())), (Component)(descriptionBox.m_239249_().isBlank() ? defaultDescription : Component.m_237113_((String)descriptionBox.m_239249_())))){

            @Override
            protected void m_7856_() {
                super.m_7856_();
                nameBox.m_264152_(this.panel.x + 15, this.panel.y + 45);
                this.m_142416_((GuiEventListener)nameBox);
                descriptionBox.m_264152_(this.panel.x + 15, this.panel.y + 69);
                this.m_142416_((GuiEventListener)descriptionBox);
            }
        };
    }

    public static class Selector
    extends AbstractWidget
    implements ControlTooltip.ActionHolder {
        public static final String TEMPLATE_ALBUM = "template_album";
        public static final ResourceLocation DEFAULT_ICON = FactoryAPI.createVanillaLocation((String)"textures/misc/unknown_pack.png");
        private static final Map<String, ResourceLocation> packIcons = Maps.newHashMap();
        private static final Map<String, ResourceLocation> packBackgrounds = Maps.newHashMap();
        private final ListMap<String, PackAlbum> albums;
        public final Stocker.Sizeable scrolledList;
        private final Component screenComponent;
        public PackAlbum savedAlbum;
        protected final PackAlbum initialAlbum;
        private final Path packPath;
        private final Consumer<Selector> reloadChanges;
        private final FactoryConfig<GlobalPacks> globalPacks;
        private final boolean hasTooltip;
        public int selectedIndex;
        private final PackRepository packRepository;
        private final Minecraft minecraft;
        protected final List<String> oldSelection;
        protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
        public final ScrollableRenderer scrollableRenderer = new ScrollableRenderer(this.scrollRenderer);
        public final BiFunction<Component, Integer, MultiLineLabel> labelsCache = Util.m_143821_((c, i) -> MultiLineLabel.m_94341_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)c, (int)i));

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip) {
            return new Selector(i, j, k, l, LegacyComponents.RESOURCE_ALBUMS, LegacyComponents.SHOW_RESOURCE_PACKS, (ListMap)resourceAlbums, Minecraft.m_91087_().m_91091_() ? LegacyClientWorldSettings.of(Minecraft.m_91087_().m_91092_().m_129910_()).getSelectedResourceAlbum() : PackAlbum.resourceById((String)defaultResourceAlbum.get()), Minecraft.m_91087_().m_91099_(), Minecraft.m_91087_().m_245161_(), Selector::reloadResourcesChanges, (FactoryConfig)GlobalPacks.globalResources, hasTooltip){

                @Override
                public void applyChanges(boolean reloadAndSave) {
                    super.applyChanges(reloadAndSave);
                    if (!Minecraft.m_91087_().m_91091_()) {
                        defaultResourceAlbum.set((Object)this.savedAlbum.id());
                        PackAlbum.save();
                    }
                }
            };
        }

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip, PackAlbum selectedAlbum) {
            return new Selector(i, j, k, l, LegacyComponents.RESOURCE_ALBUMS, LegacyComponents.SHOW_RESOURCE_PACKS, resourceAlbums, selectedAlbum, Minecraft.m_91087_().m_91099_(), Minecraft.m_91087_().m_245161_(), Selector::reloadResourcesChanges, GlobalPacks.globalResources, hasTooltip);
        }

        public Selector(int i2, int j, int k, int l, Component component, Component screenComponent, ListMap<String, PackAlbum> albums, PackAlbum savedAlbum, PackRepository packRepository, Path packPath, Consumer<Selector> reloadChanges, FactoryConfig<GlobalPacks> globalPacks, boolean hasTooltip) {
            super(i2, j, k, l, component);
            this.screenComponent = screenComponent;
            this.savedAlbum = this.initialAlbum = savedAlbum;
            this.packPath = packPath;
            this.reloadChanges = reloadChanges;
            this.globalPacks = globalPacks;
            this.hasTooltip = hasTooltip;
            this.albums = albums;
            this.minecraft = Minecraft.m_91087_();
            this.packRepository = packRepository;
            this.oldSelection = PackAlbum.getSelectedIds(packRepository);
            this.scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
            if (albums.size() > this.getMaxPacks()) {
                this.scrolledList.max = albums.size() - this.getMaxPacks();
            }
            this.setSelectedIndex(savedAlbum == null ? 0 : ((List)albums.values()).indexOf(savedAlbum));
            while (this.selectedIndex >= (Integer)this.scrolledList.get() + this.getMaxPacks() && this.scrolledList.add(1) != 0) {
            }
            this.updateTooltip();
        }

        public void updateTooltip() {
            if (this.hasTooltip) {
                this.m_257544_(Tooltip.m_257563_((Component)this.getSelectedAlbum().description(), (Component)this.getSelectedAlbum().displayName()));
            }
        }

        public void renderTooltipBox(GuiGraphics guiGraphics, LayoutElement panel) {
            this.renderTooltipBox(guiGraphics, panel, 0);
        }

        public void renderTooltipBox(GuiGraphics guiGraphics, LayoutElement panel, int xOffset) {
            this.renderTooltipBox(guiGraphics, panel.m_252754_() + panel.m_5711_() - 2 + xOffset, panel.m_252907_() + 5, 161, panel.m_93694_() - 10);
        }

        public void renderTooltipBox(GuiGraphics graphics, int x, int y, int width, int height) {
            if (this.hasTooltip) {
                return;
            }
            ScreenUtil.renderPointerPanel(graphics, x, y, width, height);
            if (this.getSelectedAlbum() != null) {
                boolean p = this.getSelectedAlbum().isValidPackDisplay(this.packRepository);
                if (this.getSelectedAlbum().iconSprite().isPresent()) {
                    FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(this.getSelectedAlbum().iconSprite().get(), x + 7, y + 5, 32, 32);
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)graphics).blit(p ? Selector.getPackIcon(this.packRepository.m_10507_(this.getSelectedAlbum().getDisplayPackId())) : DEFAULT_ICON, x + 7, y + 5, 0.0f, 0.0f, 32, 32, 32, 32);
                }
                graphics.m_280588_(x + 40, y + 4, x + 148, y + 44);
                this.labelsCache.apply(this.getSelectedAlbum().displayName(), 108).m_6508_(graphics, x + 43, y + 8, 12, 0xFFFFFF);
                graphics.m_280618_();
                ResourceLocation background = this.getSelectedAlbum().backgroundSprite.orElse(p ? Selector.getPackBackground(this.packRepository.m_10507_(this.getSelectedAlbum().getDisplayPackId())) : null);
                MultiLineLabel label = this.labelsCache.apply(this.getSelectedAlbum().description(), 145);
                this.scrollableRenderer.render(graphics, x + 8, y + 40, 146, 12 * (background == null ? 14 : 7), () -> label.m_6508_(graphics, x + 8, y + 40, 12, 0xFFFFFF));
                if (background != null) {
                    if (this.getSelectedAlbum().backgroundSprite().isPresent()) {
                        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(background, x + 8, y + height - 78, 145, 72);
                    } else {
                        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(background, x + 8, y + height - 78, 0.0f, 0.0f, 145, 72, 145, 72);
                    }
                }
            }
        }

        public boolean m_7933_(int i, int j, int k) {
            if (this.m_198029_() && this.f_93623_) {
                if (i == 88) {
                    this.openPackSelectionScreen();
                    return true;
                }
                if (CommonInputs.m_278691_((int)i)) {
                    this.savedAlbum = this.getSelectedAlbum();
                    this.m_7435_(Minecraft.m_91087_().m_91106_());
                    return true;
                }
                if (i == 263 || i == 262) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get() + (i == 263 ? 0 : this.getMaxPacks() - 1)) {
                        this.updateScroll(i == 263 ? -1 : 1, true);
                    }
                    this.setSelectedIndex(this.selectedIndex + (i == 263 ? -1 : 1));
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
                    return true;
                }
                if (i == 79) {
                    final Screen screen = Minecraft.m_91087_().f_91080_;
                    this.minecraft.m_91152_((Screen)new ConfirmationScreen(this.minecraft.f_91080_, 230, 133, ALBUM_OPTIONS, ALBUM_OPTIONS_MESSAGE, b -> {}){

                        @Override
                        protected void addButtons() {
                            this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_253136_());
                            this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)ADD_ALBUM, b -> {
                                int repeat = 0;
                                while (!PackAlbum.resourceById(Selector.TEMPLATE_ALBUM + (String)(repeat > 0 ? "_" + repeat : "")).equals(MINECRAFT)) {
                                    ++repeat;
                                }
                                String id = Selector.TEMPLATE_ALBUM + (String)(repeat > 0 ? "_" + repeat : "");
                                this.f_96541_.m_91152_((Screen)PackAlbum.createAlbumEditScreen(this.parent, b.m_6035_(), (Component)Component.m_237110_((String)"legacy.menu.albums.resource.template", (Object[])new Object[]{repeat}), (Component)Component.m_237115_((String)"legacy.menu.albums.resource.template.description"), (name, description) -> this.f_96541_.m_91152_((Screen)new PackSelectionScreen(packRepository, r -> {
                                    resourceAlbums.put((Object)id, (Object)new PackAlbum(id, 0, (Component)name, (Component)description, Optional.empty(), Optional.empty(), PackAlbum.getSelectableIds(packRepository), Optional.empty()));
                                    PackAlbum.save();
                                    Minecraft.m_91087_().m_91152_(this.parent);
                                    packRepository.m_10509_(oldSelection);
                                    this.updateSavedAlbum();
                                    this.setSelectedIndex(albums.size());
                                }, packPath, this.f_96539_))));
                            }).m_253136_());
                            this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)EDIT_ALBUM, b -> {
                                PackAlbum editAlbum = this.getSelectedAlbum();
                                this.f_96541_.m_91152_((Screen)PackAlbum.createAlbumEditScreen(this.parent, b.m_6035_(), editAlbum.displayName, editAlbum.description, (name, description) -> {
                                    resourceAlbums.put((Object)editAlbum.id(), (Object)new PackAlbum(editAlbum.id(), editAlbum.version(), (Component)name, (Component)description, editAlbum.iconSprite(), editAlbum.backgroundSprite(), editAlbum.packs(), editAlbum.displayPack()));
                                    PackAlbum.save();
                                    Minecraft.m_91087_().m_91152_(this.parent);
                                    packRepository.m_10509_(oldSelection);
                                    this.updateSavedAlbum();
                                }));
                            }).m_253136_());
                            Button removeButton = Button.m_253074_((Component)REMOVE_ALBUM, b -> {
                                albums.remove((Object)this.getSelectedAlbum().id());
                                PackAlbum.save();
                                this.updateSavedAlbum();
                                this.setSelectedIndex(0);
                                this.f_96541_.m_91152_(screen);
                            }).m_253136_();
                            this.renderableVList.addRenderable((Renderable)removeButton);
                            if (DEFAULT_RESOURCE_ALBUMS.stream().anyMatch(a -> a.equals(this.getSelectedAlbum()))) {
                                removeButton.f_93623_ = false;
                            }
                        }
                    });
                    return true;
                }
            }
            return super.m_7933_(i, j, k);
        }

        public void setSelectedIndex(int index) {
            if (this.selectedIndex == index) {
                return;
            }
            this.selectedIndex = Stocker.cyclic((int)0, (int)index, (int)this.albums.size());
            this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
            this.scrollableRenderer.scrolled.max = Math.max((int)0, (int)(this.labelsCache.apply(this.getSelectedAlbum().description(), 145).m_5770_() - (this.getSelectedAlbum().backgroundSprite.orElse(this.getSelectedAlbum().isValidPackDisplay(this.packRepository) ? Selector.getPackBackground(this.packRepository.m_10507_(this.getSelectedAlbum().getDisplayPackId())) : null) == null ? 20 : 7)));
            this.updateTooltip();
        }

        public void applyChanges(boolean reloadAndSave) {
            ((GlobalPacks)this.globalPacks.get()).applyPacks(this.packRepository, this.savedAlbum.packs());
            if (Minecraft.m_91087_().m_91091_()) {
                LegacyClientWorldSettings.of(Minecraft.m_91087_().m_91092_().m_129910_()).setSelectedResourceAlbum(this.savedAlbum);
            }
            if (reloadAndSave) {
                this.reloadChanges.accept(this);
            }
        }

        public static void applyResourceChanges(Minecraft minecraft, List<String> oldSelection, List<String> newSelection, Runnable runnable) {
            ((GlobalPacks)GlobalPacks.globalResources.get()).applyPacks(minecraft.m_91099_(), newSelection);
            minecraft.m_91152_((Screen)new LegacyLoadingScreen());
            if (!oldSelection.equals(PackAlbum.getSelectedIds(minecraft.m_91099_()))) {
                PackAlbum.updateSavedResourcePacks();
                Minecraft.m_91087_().m_91391_().thenRun(runnable);
            } else {
                runnable.run();
            }
        }

        public static void reloadResourcesChanges(Selector selector) {
            if (!selector.oldSelection.equals(PackAlbum.getSelectedIds(selector.packRepository))) {
                PackAlbum.updateSavedResourcePacks();
                Minecraft.m_91087_().m_91391_();
            }
        }

        public void openPackSelectionScreen() {
            if (this.minecraft.f_91080_ != null) {
                Screen screen = this.minecraft.f_91080_;
                this.packRepository.m_10509_(this.getSelectedAlbum().packs());
                List<String> oldSelection = PackAlbum.getSelectedIds(this.packRepository);
                this.minecraft.m_91152_((Screen)new PackSelectionScreen(this.packRepository, p -> {
                    if (!oldSelection.equals(PackAlbum.getSelectedIds(p))) {
                        this.albums.put((Object)this.getSelectedAlbum().id(), (Object)this.getSelectedAlbum().withPacks(List.copyOf(PackAlbum.getSelectableIds(p))));
                        this.updateSavedAlbum();
                        PackAlbum.save();
                    }
                    this.minecraft.m_91152_(screen);
                    this.packRepository.m_10509_(this.oldSelection);
                }, this.packPath, this.m_6035_()));
            }
        }

        public void updateSavedAlbum() {
            this.savedAlbum = (PackAlbum)this.albums.getOrDefault((Object)this.savedAlbum.id(), (Object)this.initialAlbum);
        }

        public void m_93692_(boolean bl) {
            if (!bl && this.savedAlbum != null) {
                this.setSelectedIndex(((List)this.albums.values()).indexOf(this.savedAlbum));
            }
            super.m_93692_(bl);
        }

        public void m_5716_(double d, double e) {
            if (Screen.m_96638_()) {
                this.openPackSelectionScreen();
                return;
            }
            int visibleCount = 0;
            for (int index = 0; index < this.albums.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                double d2 = this.m_252754_() + 20 + 30 * index;
                int n = this.m_252907_();
                Objects.requireNonNull(this.minecraft.f_91062_);
                if (!ScreenUtil.isMouseOver(d, e, d2, n + 9 + 3, 30, 30)) continue;
                this.setSelectedIndex(index + (Integer)this.scrolledList.get());
                this.savedAlbum = this.getSelectedAlbum();
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return;
            }
            super.m_5716_(d, e);
        }

        public boolean m_6050_(double d, double e, double f, double g) {
            if (this.updateScroll((int)Math.signum((double)g), false)) {
                return true;
            }
            return super.m_6050_(d, e, f, g);
        }

        public boolean updateScroll(int i, boolean cyclic) {
            if (this.scrolledList.max > 0 && ((Integer)this.scrolledList.get() <= this.scrolledList.max && i > 0 || (Integer)this.scrolledList.get() >= 0 && i < 0)) {
                return this.scrolledList.add(i, cyclic) != 0;
            }
            return false;
        }

        protected int getMaxPacks() {
            return (this.f_93618_ - 40) / 30;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            Font font = this.minecraft.f_91062_;
            FactoryGuiGraphics factoryGuiGraphics = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
            int n = this.m_252754_() - 1;
            int n2 = this.m_252907_();
            Objects.requireNonNull(font);
            int n3 = n2 + 9 - 1;
            Objects.requireNonNull(this.minecraft.f_91062_);
            factoryGuiGraphics.blitSprite(LegacySprites.PANEL_RECESS, n, n3, this.f_93618_ + 2, this.f_93619_ + 2 - 9);
            int visibleCount = 0;
            RenderSystem.enableBlend();
            for (int index = 0; index < this.albums.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                PackAlbum album = (PackAlbum)this.albums.getByIndex(Math.min((int)(this.albums.size() - 1), (int)((Integer)this.scrolledList.get() + index)));
                if (album.iconSprite().isPresent()) {
                    FactoryGuiGraphics factoryGuiGraphics2 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                    int n4 = this.m_252754_() + 21 + 30 * index;
                    int n5 = this.m_252907_();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics2.blitSprite(album.iconSprite().get(), n4, n5 + 9 + 4, 28, 28);
                } else {
                    FactoryGuiGraphics factoryGuiGraphics3 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                    ResourceLocation resourceLocation = album.isValidPackDisplay(this.packRepository) ? Selector.getPackIcon(this.packRepository.m_10507_(album.getDisplayPackId())) : DEFAULT_ICON;
                    int n6 = this.m_252754_() + 21 + 30 * index;
                    int n7 = this.m_252907_();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics3.blit(resourceLocation, n6, n7 + 9 + 4, 0.0f, 0.0f, 28, 28, 28, 28);
                }
                if ((Integer)this.scrolledList.get() + index != this.selectedIndex) continue;
                FactoryGuiGraphics factoryGuiGraphics4 = FactoryGuiGraphics.of((GuiGraphics)guiGraphics);
                int n8 = this.m_252754_() + 20 + 30 * index;
                int n9 = this.m_252907_();
                Objects.requireNonNull(font);
                factoryGuiGraphics4.blitSprite(LegacySprites.PACK_HIGHLIGHTED, n8, n9 + 9 + 3, 30, 30);
            }
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85836_();
            if (!this.m_198029_()) {
                guiGraphics.m_280168_().m_252880_(0.5f, 0.5f, 0.0f);
            }
            guiGraphics.m_280614_(font, this.m_6035_(), this.m_252754_() + 2, this.m_252907_(), this.m_198029_() ? ScreenUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.m_198029_());
            guiGraphics.m_280168_().m_85849_();
            if (this.scrolledList.max > 0) {
                if ((Integer)this.scrolledList.get() < this.scrolledList.max) {
                    int n10 = this.m_252754_() + this.f_93618_ - 12;
                    int n11 = this.m_252907_();
                    Objects.requireNonNull(font);
                    int n12 = n11 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, n10, n12 + (this.f_93619_ - 9 - 11) / 2);
                }
                if ((Integer)this.scrolledList.get() > 0) {
                    int n13 = this.m_252754_() + 8;
                    int n14 = this.m_252907_();
                    Objects.requireNonNull(font);
                    int n15 = n14 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, n13, n15 + (this.f_93619_ - 9 - 11) / 2);
                }
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ResourceLocation loadPackIcon(TextureManager textureManager, Pack pack, String icon, ResourceLocation fallback) {
            try (PackResources packResources = pack.m_10445_();){
                void resourceLocation2;
                IoSupplier ioSupplier = packResources.m_8017_(new String[]{icon});
                if (ioSupplier == null) {
                    ResourceLocation resourceLocation3 = fallback;
                    return resourceLocation3;
                }
                String string = pack.m_10446_();
                ResourceLocation resourceLocation3 = FactoryAPI.createLocation((String)"minecraft", (String)(icon + "/" + Util.m_137483_((String)string, ResourceLocation::m_135828_) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)string)) + "/icon"));
                try (InputStream inputStream = (InputStream)ioSupplier.m_247737_();){
                    NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
                    textureManager.m_118495_(resourceLocation3, (AbstractTexture)new DynamicTexture(nativeImage));
                    ResourceLocation resourceLocation22 = resourceLocation3;
                }
                void resourceLocation = resourceLocation2;
                return resourceLocation;
            }
            catch (Exception exception) {
                Legacy4J.LOGGER.warn("Failed to load icon from pack {}", (Object)pack.m_10446_(), (Object)exception);
                return fallback;
            }
        }

        public static ResourceLocation getPackIcon(Pack pack) {
            return packIcons.computeIfAbsent(pack.m_10446_(), string -> Selector.loadPackIcon(Minecraft.m_91087_().m_91097_(), pack, "pack.png", DEFAULT_ICON));
        }

        public static ResourceLocation getPackBackground(Pack pack) {
            return packBackgrounds.computeIfAbsent(pack.m_10446_(), string -> Selector.loadPackIcon(Minecraft.m_91087_().m_91097_(), pack, "background.png", null));
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public PackAlbum getSelectedAlbum() {
            return this.albums.isEmpty() || this.selectedIndex > this.albums.size() ? null : (PackAlbum)this.albums.getByIndex(this.selectedIndex);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> k.key() == 79 && this.m_93696_() ? LegacyComponents.ALBUM_OPTIONS : (k.key() == 88 && this.m_93696_() || k.key() == 0 && this.m_274382_() ? this.screenComponent : ControlTooltip.getSelectAction((GuiEventListener)this, context)));
        }
    }
}

