/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.io.FileUtils;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyWorldTemplate;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class CreationList
extends RenderableVList {
    protected final Minecraft minecraft;

    public CreationList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = Minecraft.m_91087_();
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/create_world"), (Component)Component.m_237115_((String)"legacy.menu.create_world"), c -> CreateWorldScreen.m_232896_((Minecraft)this.minecraft, (Screen)this.getScreen()));
        LegacyWorldTemplate.list.forEach(t -> CreationList.addIconButton(this, t.icon(), t.buttonMessage(), c -> {
            if (t.isGamePath() && !Files.exists(t.getPath(), new LinkOption[0])) {
                this.minecraft.m_91152_((Screen)ConfirmationScreen.createInfoScreen(this.getScreen(), LegacyComponents.MISSING_WORLD_TEMPLATE, (Component)Component.m_237110_((String)"legacy.menu.missing_world_template_message", (Object[])new Object[]{t.buttonMessage()})));
                return;
            }
            try (LevelStorageSource.LevelStorageAccess access = Legacy4JClient.getLevelStorageSource().m_78260_(Legacy4JClient.importSaveFile(t.open(), arg_0 -> ((LevelStorageSource)this.minecraft.m_91392_()).m_78255_(arg_0), Legacy4JClient.getLevelStorageSource(), t.folderName()));){
                LevelSummary summary = access.m_78308_(access.m_307464_());
                access.close();
                if (t.directJoin()) {
                    LoadSaveScreen.loadWorld(this.getScreen(), this.minecraft, Legacy4JClient.getLevelStorageSource(), summary);
                } else {
                    this.minecraft.m_91152_((Screen)new LoadSaveScreen(this.getScreen(), summary, access, t.isLocked()){

                        @Override
                        public void m_7379_() {
                            if (!((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
                                FileUtils.deleteQuietly((File)this.access.m_197394_(Level.f_46428_).toFile());
                            }
                            super.m_7379_();
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static void addIconButton(RenderableVList list, ResourceLocation iconSprite, Component message, Consumer<AbstractButton> onPress) {
        CreationList.addIconButton(list, iconSprite, message, onPress, null);
    }

    public static void addIconButton(final RenderableVList list, final ResourceLocation iconSprite, Component message, final Consumer<AbstractButton> onPress, Tooltip tooltip) {
        AbstractButton button = new AbstractButton(0, 0, 270, 30, message){

            protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
                super.m_87963_(guiGraphics, i, j, f);
                if (!list.accessor.getBoolean("allowButtonsWithIcons", Boolean.valueOf(true)).booleanValue()) {
                    return;
                }
                RenderSystem.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(iconSprite, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                RenderSystem.disableBlend();
                if (((Boolean)Minecraft.m_91087_().f_91066_.m_231828_().m_231551_()).booleanValue() || this.f_93622_) {
                    guiGraphics.m_280509_(this.m_252754_() + 5, this.m_252907_() + 5, this.m_252754_() + 25, this.m_252907_() + 25, -1601138544);
                }
            }

            protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                int k = this.m_252754_() + 35;
                int l = this.m_252754_() + this.m_5711_();
                ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), k, this.m_252907_(), l, this.m_252907_() + this.m_93694_(), j, true);
            }

            public void m_5691_() {
                onPress.accept(this);
            }

            protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                this.m_168802_(narrationElementOutput);
            }
        };
        list.addRenderable((Renderable)button);
        button.m_257544_(tooltip);
    }
}

