/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.ScreenSection;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.util.JsonUtil;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class HowToPlayScreen
extends LegacyScreen {
    protected final Section section;
    protected final int sectionIndex;
    protected final ResourceLocation uiDefinitionID;
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();

    public HowToPlayScreen(Screen parent, Section section) {
        super(parent, section.title());
        this.section = section;
        this.sectionIndex = Section.list.indexOf(section);
        this.uiDefinitionID = section.uiDefinitionLocation().m_246208_("ui_definitions/").m_266382_(".json");
    }

    public String toString() {
        return this.uiDefinitionID.toString();
    }

    public ScrollableRenderer getScrollableRenderer() {
        return (ScrollableRenderer)this.accessor.getElementValue("scrollable_renderer", (Object)this.scrollableRenderer, ScrollableRenderer.class);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.replace(1, i -> i, a -> this.hasNextPage() ? LegacyComponents.NEXT_PAGE : null).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> this.hasPreviousPage() ? LegacyComponents.PREVIOUS_PAGE : null);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.accessor.putStaticElement("scrollable_renderer", (Object)this.scrollableRenderer);
    }

    protected boolean hasNextPage() {
        return this.sectionIndex < Section.list.size() - 1;
    }

    protected boolean hasPreviousPage() {
        return this.sectionIndex > 0;
    }

    public boolean m_7933_(int i, int j, int k) {
        boolean next = i == 257;
        if (next && this.hasNextPage() || i == 88 && this.hasPreviousPage()) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f);
            this.f_96541_.m_91152_((Screen)Section.list.get(this.sectionIndex + (next ? 1 : -1)).build(this.parent));
            return true;
        }
        if (this.getScrollableRenderer().keyPressed(i)) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public boolean m_6050_(double d, double e, double f, double g) {
        if (this.getScrollableRenderer().mouseScrolled(g)) {
            return true;
        }
        return super.m_6050_(d, e, f, g);
    }

    public record Section(Component title, ResourceLocation uiDefinitionLocation, boolean hasButton, int index) implements ScreenSection<HowToPlayScreen>
    {
        public static final Codec<Section> CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.getComponentCodec().fieldOf("title").forGetter(Section::title), (App)ResourceLocation.f_135803_.fieldOf("ui_definition").forGetter(Section::uiDefinitionLocation), (App)Codec.BOOL.fieldOf("hasButton").orElse((Object)true).forGetter(Section::hasButton), (App)Codec.INT.fieldOf("index").orElse((Object)-1).forGetter(Section::index)).apply((Applicative)i, Section::new));
        public static final Codec<List<Section>> LIST_CODEC = CODEC.listOf();
        public static final List<Section> list = new ArrayList<Section>();

        public static Stream<Section> getWithButton() {
            return list.stream().filter(Section::hasButton);
        }

        @Override
        public HowToPlayScreen build(Screen parent) {
            return new HowToPlayScreen(parent, this);
        }
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public static final String HOW_TO_PLAY_SECTIONS = "how_to_play_sections.json";

        public void m_6213_(ResourceManager resourceManager) {
            Section.list.clear();
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.m_213713_(FactoryAPI.createLocation((String)name, (String)HOW_TO_PLAY_SECTIONS)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.m_215508_();){
                    Section.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedReader)).result().ifPresent(l -> l.forEach(s -> Section.list.add(s.index < 0 ? Section.list.size() : Math.min(s.index, Section.list.size()), (Section)s)));
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public String m_7812_() {
            return "legacy:how_to_play_sections";
        }
    }
}

