/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyKeyMappingScreen
extends PanelVListScreen {
    protected AdvancedTextWidget mappingTooltipLines;
    protected LegacyKeyMapping selectedMapping;
    protected ArbitrarySupplier<Component> mappingTooltip;

    public LegacyKeyMappingScreen(Screen parent) {
        this(parent, (Component)Component.m_237115_((String)"controls.keybinds.title"));
    }

    public LegacyKeyMappingScreen(Screen parent, Component title) {
        this(parent, s -> Panel.centered(s, LegacySprites.PANEL, 255, 293), title);
    }

    public LegacyKeyMappingScreen(Screen parent, Function<Screen, Panel> panelFunction, Component title) {
        super(parent, panelFunction, title);
        this.mappingTooltipLines = new AdvancedTextWidget(this.accessor).withShadow(false);
        this.selectedMapping = null;
        this.mappingTooltip = ArbitrarySupplier.empty();
        this.renderableVList.layoutSpacing(l -> 1);
        this.addButtons();
    }

    public void addButtons() {
        Object[] keyMappings = (KeyMapping[])ArrayUtils.clone((Object[])Minecraft.m_91087_().f_91066_.f_92059_);
        Arrays.sort(keyMappings);
        String lastCategory = null;
        this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.reset_defaults"), arg_0 -> this.lambda$addButtons$3((KeyMapping[])keyMappings, arg_0)).m_253046_(240, 20).m_253136_());
        this.renderableVList.addOptions(LegacyOptions.of(Minecraft.m_91087_().f_91066_.m_231831_()), LegacyOptions.of(Minecraft.m_91087_().f_91066_.m_231832_()));
        for (Object keyMapping : keyMappings) {
            String category = keyMapping.m_90858_();
            if (!Objects.equals(lastCategory, category)) {
                this.renderableVList.addRenderables(new Renderable[]{SimpleLayoutRenderable.create((int)240, (int)13, l -> (graphics, i, j, f) -> {}), SimpleLayoutRenderable.create((int)240, (int)13, l -> (graphics, i, j, f) -> graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)category), l.x + 1, l.y + 4, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false))});
            }
            lastCategory = keyMapping.m_90858_();
            this.renderableVList.addRenderable((Renderable)new MappingButton(0, 0, 240, 20, LegacyKeyMapping.of((KeyMapping)keyMapping), (KeyMapping)keyMapping){
                final /* synthetic */ KeyMapping val$keyMapping;
                {
                    this.val$keyMapping = keyMapping;
                    super(i, j, k, l, mapping);
                }

                @Override
                public ControlTooltip.ComponentIcon getIcon() {
                    return ControlTooltip.getKeyIcon(this.mapping.getKey().m_84873_());
                }

                @Override
                public boolean isNone() {
                    return this.mapping.getKey() == InputConstants.f_84822_;
                }

                public void m_5691_() {
                    if (Screen.m_96638_() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed) {
                        LegacyKeyMappingScreen.setAndUpdateKey(this.val$keyMapping, this.val$keyMapping.m_90861_());
                        LegacyKeyMappingScreen.this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
                    } else {
                        LegacyKeyMappingScreen.this.setSelectedMapping(this.mapping);
                        LegacyKeyMappingScreen.this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)((ArbitrarySupplier)LegacyKeyMappingScreen.this::getCancelTooltip));
                    }
                }
            });
        }
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.selectedMapping != null && this.allowsKey()) {
            LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), InputConstants.Type.MOUSE.m_84895_(i));
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
            this.resolveConflictingMappings();
            this.setSelectedMapping(null);
            return true;
        }
        return super.m_6375_(d, e, i);
    }

    public static void setAndUpdateKey(KeyMapping key, InputConstants.Key input) {
        key.m_90848_(input);
        Minecraft.m_91087_().f_91066_.m_92169_();
        KeyMapping.m_90854_();
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (this.selectedMapping != null && this.allowsKey()) {
            LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), i == 256 ? InputConstants.f_84822_ : InputConstants.m_84827_((int)i, (int)j));
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
            this.resolveConflictingMappings();
            this.setSelectedMapping(null);
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public boolean allowsKey() {
        return true;
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        super.m_7522_(guiEventListener);
        this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public Component getCancelTooltip() {
        return Component.m_237110_((String)"legacy.options.keyMappingTooltip", (Object[])new Object[]{((ControlTooltip.ComponentIcon)ControlTooltip.CANCEL_BINDING.get()).getComponent()});
    }

    public Component getConflictingTooltip() {
        return LegacyComponents.CONFLICTING_KEYS;
    }

    protected void setSelectedMapping(LegacyKeyMapping keyMapping) {
        this.selectedMapping = keyMapping;
    }

    protected boolean areConflicting(LegacyKeyMapping keyMapping, LegacyKeyMapping comparison) {
        return keyMapping.getKey() == comparison.getKey();
    }

    protected void setNone(LegacyKeyMapping keyMapping) {
        LegacyKeyMappingScreen.setAndUpdateKey(keyMapping.self(), InputConstants.f_84822_);
    }

    protected void resolveConflictingMappings() {
        for (Renderable renderable : this.getRenderableVList().renderables) {
            if (!(renderable instanceof MappingButton)) continue;
            MappingButton b = (MappingButton)renderable;
            if (this.selectedMapping == b.mapping || b.isNone() || !this.areConflicting(this.selectedMapping, b.mapping)) continue;
            this.getRenderableVList().focusRenderable((Renderable)b);
            this.setNone(b.mapping);
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)((ArbitrarySupplier)this::getConflictingTooltip));
            break;
        }
    }

    protected void setAndUpdateMappingTooltip(ArbitrarySupplier<Component> tooltip) {
        this.mappingTooltip = tooltip;
        this.updateMappingTooltip();
    }

    protected void updateMappingTooltip() {
        this.mappingTooltipLines.withLines(Collections.emptyList());
        this.mappingTooltip.ifPresent(c -> this.mappingTooltipLines.withLines(c, 120));
    }

    @Override
    protected void m_7856_() {
        this.updateMappingTooltip();
        this.m_169394_((guiGraphics, i, j, f) -> {
            GuiEventListener patt0$temp = this.m_7222_();
            if (patt0$temp instanceof MappingButton) {
                MappingButton b = (MappingButton)patt0$temp;
                if (!this.mappingTooltipLines.getLines().isEmpty()) {
                    int tooltipHeight = this.mappingTooltipLines.m_93694_() + 18;
                    int tooltipX = this.panel.m_252754_() + this.panel.m_5711_() - 2;
                    int tooltipY = Math.max(this.panel.m_252907_() + 2, Math.min(b.m_252907_() + (b.m_93694_() - tooltipHeight) / 2, this.panel.m_252907_() + this.panel.m_93694_() - tooltipHeight - 2));
                    ScreenUtil.renderPointerPanel(guiGraphics, tooltipX, tooltipY, 129, tooltipHeight);
                    this.mappingTooltipLines.m_264152_(tooltipX + 4, tooltipY + 9);
                    this.mappingTooltipLines.m_88315_(guiGraphics, i, j, f);
                }
            }
        });
        super.m_7856_();
        this.m_169394_((guiGraphics, i, j, f) -> guiGraphics.m_280056_(this.f_96547_, FactoryAPIPlatform.getModInfo((String)"minecraft").getVersion() + " " + Legacy4J.VERSION.get(), this.panel.m_252754_() + this.panel.m_5711_() + 81, this.panel.m_252907_() + this.panel.m_93694_() - 7, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 7, this.panel.y + 6, this.panel.width - 14, this.panel.height - 20);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.replace(0, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(1, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(2, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(3, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.add(() -> ControlTooltip.CANCEL_BINDING.get(), () -> this.selectedMapping == null ? null : LegacyComponents.CANCEL);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (this.selectedMapping != null) {
            state.block();
            if (state.is(ControllerBinding.BACK) && state.pressed) {
                LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), InputConstants.f_84822_);
                this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
                this.setSelectedMapping(null);
            }
        }
    }

    private /* synthetic */ void lambda$addButtons$3(KeyMapping[] keyMappings, Button button) {
        this.f_96541_.m_91152_((Screen)new ConfirmationScreen((Screen)this, (Component)Component.m_237115_((String)"legacy.menu.reset_keyBinds"), (Component)Component.m_237115_((String)"legacy.menu.reset_keyBinds_message"), b -> {
            for (KeyMapping keyMapping : keyMappings) {
                keyMapping.m_90848_(keyMapping.m_90861_());
            }
            KeyMapping.m_90854_();
            Minecraft.m_91087_().f_91066_.m_92169_();
            this.f_96541_.m_91152_((Screen)this);
        }));
    }

    public abstract class MappingButton
    extends AbstractButton {
        public final LegacyKeyMapping mapping;

        public MappingButton(int i, int j, int k, int l, LegacyKeyMapping mapping) {
            super(i, j, k, l, mapping.getDisplayName());
            this.mapping = mapping;
        }

        public abstract ControlTooltip.ComponentIcon getIcon();

        public abstract boolean isNone();

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            Component c;
            if (!this.m_93696_() && this.isPressed()) {
                LegacyKeyMappingScreen.this.setSelectedMapping(null);
            }
            super.m_87963_(guiGraphics, i, j, f);
            Object object = this.isPressed() ? LegacyComponents.SELECTION : (c = this.isNone() ? LegacyComponents.NONE : null);
            if (c != null) {
                Font font = LegacyKeyMappingScreen.this.f_96547_;
                int n = this.m_252754_() + this.f_93618_ - 20 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)c) / 2;
                int n2 = this.m_252907_();
                Objects.requireNonNull(LegacyKeyMappingScreen.this.f_96547_);
                guiGraphics.m_280430_(font, c, n, n2 + (this.f_93619_ - 9) / 2 + 1, 0xFFFFFF);
                return;
            }
            ControlTooltip.ComponentIcon icon = this.getIcon();
            RenderSystem.enableBlend();
            int n = this.m_252754_() + this.f_93618_ - 20 - icon.render(guiGraphics, 0, 0, false, true) / 2;
            int n3 = this.m_252907_();
            Objects.requireNonNull(LegacyKeyMappingScreen.this.f_96547_);
            icon.render(guiGraphics, n, n3 + (this.f_93619_ - 9) / 2 + 1, false, false);
            RenderSystem.disableBlend();
        }

        private boolean isPressed() {
            return LegacyKeyMappingScreen.this.selectedMapping != null && this.mapping == LegacyKeyMappingScreen.this.selectedMapping;
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
            ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 8, this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), j, true);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }
}

