/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyLoadingScreen
extends Screen
implements LegacyLoading {
    public static LegacyTip actualLoadingTip;
    private int progress;
    private Component loadingHeader;
    private Component loadingStage;
    private boolean genericLoading;
    private UIAccessor accessor = UIAccessor.of((Screen)this);
    protected RandomSource random = RandomSource.m_216327_();

    public LegacyLoadingScreen() {
        super(GameNarrator.f_93310_);
    }

    public LegacyLoadingScreen(Component loadingHeader, Component loadingStage) {
        this();
        this.setLoadingHeader(loadingHeader);
        this.setLoadingStage(loadingStage);
    }

    public void prepareRender(Minecraft minecraft, int width, int height, Component loadingHeader, Component loadingStage, int progress, boolean genericLoading) {
        this.m_6574_(minecraft, width, height);
        this.f_96541_ = minecraft;
        this.accessor = UIAccessor.of((Screen)minecraft.f_91080_);
        this.setLoadingHeader((Component)this.accessor.getElementValue("loadingHeader.component", (Object)loadingHeader, Component.class));
        this.setLoadingStage((Component)this.accessor.getElementValue("loadingStage.component", (Object)loadingStage, Component.class));
        this.setProgress(this.accessor.getInteger("progress", progress));
        this.setGenericLoading(this.accessor.getBoolean("genericLoading", Boolean.valueOf(genericLoading)));
    }

    public LegacyTip getLoadingTip() {
        if (usingLoadingTips.isEmpty()) {
            if (LegacyTipManager.loadingTips.isEmpty()) {
                return null;
            }
            usingLoadingTips.addAll(LegacyTipManager.loadingTips);
        }
        if (actualLoadingTip == null) {
            int i = this.random.m_188503_(usingLoadingTips.size());
            actualLoadingTip = (LegacyTip)((Supplier)usingLoadingTips.get(i)).get();
            usingLoadingTips.remove(i);
        } else if (LegacyLoadingScreen.actualLoadingTip.visibility == Toast.Visibility.HIDE) {
            actualLoadingTip = null;
            return this.getLoadingTip();
        }
        return actualLoadingTip;
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_280273_(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        RenderSystem.disableDepthTest();
        super.m_88315_(guiGraphics, i, j, f);
        int x = this.f_96543_ / 2 - 160;
        int y = this.f_96544_ / 2 + 16;
        ResourceLocation fontOverride = (ResourceLocation)this.accessor.getElementValue("fontOverride", null, ResourceLocation.class);
        if (!this.isGenericLoading()) {
            if (this.getProgress() != -1) {
                LegacyTip tip;
                if (this.getLoadingStage() != null) {
                    Legacy4JClient.applyFontOverrideIf(fontOverride != null, fontOverride, b -> guiGraphics.m_280430_(this.f_96541_.f_91062_, this.getLoadingStage(), this.accessor.getInteger("loadingStage.x", x + 1), this.accessor.getInteger("loadingStage.y", this.f_96544_ / 2 + 5), ((Integer)CommonColor.STAGE_TEXT.get()).intValue()));
                }
                try (SpriteContents contents = FactoryGuiGraphics.getSprites().m_118901_(LegacySprites.LOADING_BACKGROUND).m_245424_();){
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BACKGROUND, x, y, 320, 320 * contents.m_245330_() / contents.m_246492_());
                }
                if (this.getProgress() >= 0) {
                    contents = FactoryGuiGraphics.getSprites().m_118901_(LegacySprites.LOADING_BAR).m_245424_();
                    try {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BAR, 318, 318 * contents.m_245330_() / contents.m_246492_(), 0, 0, x + 1, y + 1, 0, (int)(318.0f * Math.max(0.0f, Math.min((float)this.getProgress() / 100.0f, 1.0f))), 318 * contents.m_245330_() / contents.m_246492_());
                    }
                    finally {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                }
                if ((tip = this.getLoadingTip()) != null) {
                    tip.m_252865_((this.f_96543_ - tip.width) / 2);
                    tip.m_253211_(y + 8 + (this.f_96544_ - (y + 8) - tip.height) / 2);
                    tip.m_88315_(guiGraphics, i, j, f);
                }
            }
        } else {
            ScreenUtil.drawGenericLoading(guiGraphics, (this.f_96543_ - 75) / 2, this.f_96544_ / 2);
        }
        if (this.getLoadingHeader() != null) {
            Legacy4JClient.applyFontOverrideIf(fontOverride != null, fontOverride, b -> {
                guiGraphics.m_280168_().m_85836_();
                float scaleX = this.accessor.getFloat("loadingHeader.scaleX", 2.0f);
                guiGraphics.m_280168_().m_252880_(this.accessor.getFloat("loadingHeader.x", ((float)this.f_96543_ - (float)this.f_96541_.f_91062_.m_92852_((FormattedText)this.getLoadingHeader()) * scaleX) / 2.0f), this.accessor.getFloat("loadingHeader.y", (float)(this.f_96544_ / 2 - 23)), 0.0f);
                guiGraphics.m_280168_().m_85841_(scaleX, this.accessor.getFloat("loadingHeader.scaleY", 2.0f), 1.0f);
                ScreenUtil.drawOutlinedString(guiGraphics, this.f_96541_.f_91062_, this.getLoadingHeader(), 0, 0, (int)((Integer)CommonColor.TITLE_TEXT.get()), (int)((Integer)CommonColor.TITLE_TEXT_OUTLINE.get()), this.accessor.getFloat("loadingHeader.outline", 0.5f));
                guiGraphics.m_280168_().m_85849_();
            });
        }
        RenderSystem.enableDepthTest();
    }

    public static LegacyLoadingScreen getDimensionChangeScreen(ClientLevel lastLevel, ClientLevel newLevel) {
        boolean lastOd = LegacyLoadingScreen.isOtherDimension((Level)lastLevel);
        boolean od = LegacyLoadingScreen.isOtherDimension((Level)newLevel);
        LegacyLoadingScreen screen = new LegacyLoadingScreen((Component)(od || lastOd ? Component.m_237110_((String)("legacy.menu." + (lastOd ? "leaving" : "entering")), (Object[])new Object[]{LegacyComponents.getDimensionName((ResourceKey<Level>)(lastOd ? lastLevel : newLevel).m_46472_())}) : Component.m_237119_()), (Component)Component.m_237119_());
        if (od || lastOd) {
            screen.setGenericLoading(true);
        }
        return screen;
    }

    public static boolean isOtherDimension(Level level) {
        return level != null && level.m_46472_() != Level.f_46428_;
    }

    public static LegacyLoadingScreen getRespawningScreen(final BooleanSupplier levelReady) {
        final long createdTime = Util.m_137550_();
        LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.RESPAWNING, (Component)Component.m_237119_()){

            public void m_86600_() {
                if (levelReady.getAsBoolean() || Util.m_137550_() - createdTime >= 30000L) {
                    this.f_96541_.m_91152_(null);
                }
            }

            public boolean m_7043_() {
                return false;
            }
        };
        screen.setGenericLoading(true);
        return screen;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public Component getLoadingHeader() {
        return this.loadingHeader;
    }

    @Override
    public void setLoadingHeader(Component loadingHeader) {
        this.loadingHeader = loadingHeader;
    }

    @Override
    public Component getLoadingStage() {
        return this.loadingStage;
    }

    @Override
    public void setLoadingStage(Component loadingStage) {
        this.loadingStage = loadingStage;
    }

    @Override
    public boolean isGenericLoading() {
        return this.genericLoading;
    }

    @Override
    public void setGenericLoading(boolean genericLoading) {
        this.genericLoading = genericLoading;
    }
}

