/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelBackgroundScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LoadSaveScreen
extends PanelBackgroundScreen {
    public static final Component GAME_MODEL_LABEL = Component.m_237115_((String)"selectWorld.gameMode");
    protected final boolean isLocked;
    public BiConsumer<GameRules, MinecraftServer> applyGameRules = (r, s) -> {};
    protected final LevelStorageSource.LevelStorageAccess access;
    protected final LegacySliderButton<GameType> gameTypeSlider;
    public boolean trustPlayers;
    public boolean allowCommands;
    public static final List<ResourceKey<Level>> RESETTABLE_DIMENSIONS = new ArrayList<ResourceKey>(List.of(Level.f_46429_, Level.f_46430_));
    public final List<ResourceKey<Level>> dimensionsToReset = new ArrayList<ResourceKey<Level>>();
    public Difficulty difficulty;
    public final LevelSummary summary;
    protected final PackAlbum.Selector resourceAssortSelector;
    protected final TickBox onlineTickBox;
    protected final PublishScreen publishScreen;
    public static final List<GameType> GAME_TYPES = Arrays.stream(GameType.values()).toList();

    public LoadSaveScreen(Screen screen, LevelSummary summary, LevelStorageSource.LevelStorageAccess access, boolean isLocked) {
        super((Screen s) -> Panel.createPanel(s, p -> (s.f_96543_ - (p.width + (ScreenUtil.hasTooltipBoxes(UIAccessor.of((Screen)s)) ? 160 : 0))) / 2, p -> (s.f_96544_ - p.height) / 2 + 21, 245, 233), (Component)Component.m_237115_((String)"legacy.menu.load_save.load"));
        this.isLocked = isLocked;
        this.parent = screen;
        this.summary = summary;
        this.access = access;
        this.difficulty = summary.m_164913_().m_46931_();
        this.gameTypeSlider = new LegacySliderButton<GameType>(0, 0, 220, 16, b -> b.getDefaultMessage(GAME_MODEL_LABEL, ((GameType)b.getObjectValue()).m_151499_()), b -> Tooltip.m_257550_((Component)Component.m_237115_((String)("selectWorld.gameMode." + ((GameType)b.getObjectValue()).m_46405_() + ".info"))), summary.m_164913_().m_46929_(), () -> GAME_TYPES, b -> {});
        this.gameTypeSlider.f_93623_ = !summary.m_78368_();
        this.publishScreen = new PublishScreen((Screen)this, this.gameTypeSlider.getObjectValue());
        this.onlineTickBox = new TickBox(0, 0, 220, this.publishScreen.publish, b -> PublishScreen.PUBLISH, b -> null, button -> {
            if (button.selected) {
                this.f_96541_.m_91152_((Screen)this.publishScreen);
            }
            this.publishScreen.publish = false;
            button.selected = false;
        });
        this.allowCommands = LoadSaveScreen.hasCommands(summary);
        this.trustPlayers = LegacyClientWorldSettings.of(summary.m_164913_()).trustPlayers();
        this.resourceAssortSelector = PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 112, 220, 45, !ScreenUtil.hasTooltipBoxes(this.accessor), LegacyClientWorldSettings.of(summary.m_164913_()).getSelectedResourceAlbum());
        PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 112, 220, 45, !ScreenUtil.hasTooltipBoxes(this.accessor), LegacyClientWorldSettings.of(summary.m_164913_()).getSelectedResourceAlbum()).f_93623_ = !this.isLocked;
    }

    public LoadSaveScreen(Screen screen, LevelSummary summary, LevelStorageSource source) {
        this(screen, summary, LoadSaveScreen.getSummaryAccess(source, summary), false);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        OptionsScreen.setupSelectorControlTooltips(renderer, this);
    }

    public static boolean hasCommands(LevelSummary levelSummary) {
        return levelSummary.m_78369_();
    }

    public static LevelStorageSource.LevelStorageAccess getSummaryAccess(LevelStorageSource source, LevelSummary summary) {
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        block8: {
            LevelStorageSource.LevelStorageAccess access = source.m_78260_(summary.m_78358_());
            try {
                levelStorageAccess = access;
                if (access == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (access != null) {
                        try {
                            access.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            access.close();
        }
        return levelStorageAccess;
    }

    @Override
    protected void m_7856_() {
        this.panel.init();
        this.gameTypeSlider.m_264152_(this.panel.x + 13, this.panel.y + 65);
        ((LegacySliderButton)this.m_142416_(new LegacySliderButton<Difficulty>((int)(this.panel.x + 13), (int)(this.panel.y + 90), (int)220, (int)16, (Function<LegacySliderButton<T>, Component>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$11(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)Lnet/minecraft/network/chat/Component;)(), (Function<LegacySliderButton<T>, Tooltip>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$12(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)Lnet/minecraft/client/gui/components/Tooltip;)((LoadSaveScreen)this), this.difficulty, (Supplier<List<T>>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$init$13(), ()Ljava/util/List;)(), (Consumer<LegacySliderButton<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$init$14(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)V)((LoadSaveScreen)this)))).f_93623_ = !LegacyClientWorldSettings.of(this.summary.m_164913_()).isDifficultyLocked() && !this.summary.m_78368_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"createWorld.tab.more.title"), button -> this.f_96541_.m_91152_((Screen)new WorldMoreOptionsScreen(this))).m_252987_(this.panel.x + 13, this.panel.y + 178, 220, 20).m_253136_());
        Button loadButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.load_save.load"), button -> this.onLoad()).m_252987_(this.panel.x + 13, this.panel.y + 203, 220, 20).m_253136_());
        this.m_142416_((GuiEventListener)this.gameTypeSlider);
        this.onlineTickBox.selected = this.publishScreen.publish;
        this.onlineTickBox.m_264152_(this.panel.x + 14, this.panel.y + 161);
        this.m_142416_((GuiEventListener)this.onlineTickBox);
        this.m_264313_((GuiEventListener)loadButton);
        this.resourceAssortSelector.m_252865_(this.panel.x + 13);
        this.resourceAssortSelector.m_253211_(this.panel.y + 112);
        this.m_142416_((GuiEventListener)this.resourceAssortSelector);
    }

    public void onLoad() {
        if (this.dimensionsToReset.isEmpty()) {
            this.completeLoad();
        } else {
            this.confirmDimensionToReset(0);
        }
    }

    public void confirmDimensionToReset(final int index) {
        ResourceKey<Level> level = this.dimensionsToReset.get(index);
        final Component dimensionName = LegacyComponents.getDimensionName(level);
        this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, (Component)Component.m_237110_((String)"legacy.menu.load_save.reset", (Object[])new Object[]{dimensionName}), (Component)Component.m_237110_((String)"legacy.menu.load_save.reset_message", (Object[])new Object[]{dimensionName, dimensionName}), b -> {
            if (index == this.dimensionsToReset.size() - 1) {
                this.completeLoad();
            } else {
                this.confirmDimensionToReset(index + 1);
            }
        }){

            @Override
            protected void addButtons() {
                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237110_((String)"legacy.menu.load_save.reset_cancel", (Object[])new Object[]{dimensionName}), b -> {
                    LoadSaveScreen.this.dimensionsToReset.remove(index);
                    if (LoadSaveScreen.this.dimensionsToReset.isEmpty()) {
                        LoadSaveScreen.this.completeLoad();
                    } else {
                        LoadSaveScreen.this.confirmDimensionToReset(index);
                    }
                }).m_253136_());
                this.okButton = Button.m_253074_((Component)this.m_96636_(), b -> this.okAction.accept(this)).m_253136_();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }
        });
    }

    public void completeLoad() {
        this.dimensionsToReset.forEach(l -> {
            if (l == Level.f_46428_) {
                return;
            }
            try {
                LoadSaveScreen.deleteLevelDimension(this.access, (ResourceKey<Level>)l);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        LegacyClientWorldSettings.of(this.summary.m_164913_()).setSelectedResourceAlbum(this.resourceAssortSelector.getSelectedAlbum());
        LoadSaveScreen.loadWorld((Screen)this, this.f_96541_, Legacy4JClient.getLevelStorageSource(), this.summary);
        Legacy4JClient.serverPlayerJoinConsumer = s -> {
            if (this.dimensionsToReset.contains(Level.f_46430_)) {
                s.f_8924_.m_129880_(Level.f_46430_).m_287200_(new EndDragonFight(this.f_96541_.m_91092_().m_129880_(Level.f_46430_), this.f_96541_.m_91092_().m_129910_().m_246337_().m_245499_(), EndDragonFight.Data.f_289709_));
            }
            s.f_8924_.m_7835_(this.gameTypeSlider.getObjectValue());
            s.f_8924_.m_129827_(this.difficulty, false);
            this.applyGameRules.accept(s.f_8924_.m_129900_(), (MinecraftServer)this.f_96541_.m_91092_());
            this.publishScreen.publish((IntegratedServer)s.f_8924_);
            LegacyClientWorldSettings.of(s.f_8924_.m_129910_()).setAllowCommands(this.allowCommands);
            s.f_8924_.m_6846_().m_11289_(s);
            LegacyClientWorldSettings.of(s.f_8924_.m_129910_()).setSelectedResourceAlbum(this.resourceAssortSelector.getSelectedAlbum());
            if (s.f_8941_.m_9290_() != this.gameTypeSlider.getObjectValue()) {
                s.m_143403_(this.gameTypeSlider.getObjectValue());
            }
        };
    }

    public static void deleteLevelDimension(LevelStorageSource.LevelStorageAccess access, ResourceKey<Level> dimension) throws IOException {
        Path path = access.m_197394_(dimension);
        Legacy4J.LOGGER.info("Deleting dimension {}", dimension);
        for (int i = 1; i <= 5; ++i) {
            Legacy4J.LOGGER.info("Attempt {}...", (Object)i);
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path pathx, BasicFileAttributes basicFileAttributes) throws IOException {
                        Legacy4J.LOGGER.debug("Deleting {}", (Object)pathx);
                        Files.delete(pathx);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path pathx, @Nullable IOException iOException) throws IOException {
                        if (iOException != null) {
                            throw iOException;
                        }
                        Files.delete(pathx);
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            catch (IOException var6) {
                if (i >= 5) {
                    throw var6;
                }
                Legacy4J.LOGGER.warn("Failed to delete {}", (Object)path, (Object)var6);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public boolean m_6050_(double d, double e, double f, double g) {
        if (this.resourceAssortSelector.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.m_6050_(d, e, f, g);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        this.resourceAssortSelector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel);
        this.panel.m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.5f, 0.0f, 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_ENTITY_PANEL, this.panel.x + 12, this.panel.y + 9, 32, 32);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.5f, 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(((FaviconTexture)SaveRenderableList.iconCache.getUnchecked((Object)this.summary)).m_289196_(), this.panel.x + 14, this.panel.y + 10, 0.0f, 0.0f, 29, 29, 29, 29);
        guiGraphics.m_280056_(this.f_96547_, this.summary.m_78361_(), this.panel.x + 48, this.panel.y + 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"legacy.menu.load_save.created_in", (Object[])new Object[]{(LoadSaveScreen.hasCommands(this.summary) ? GameType.CREATIVE : GameType.SURVIVAL).m_151500_()}), this.panel.x + 48, this.panel.y + 29, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.m_280168_().m_85849_();
        if (!this.isLocked) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"commands.seed.success", (Object[])new Object[]{LegacyClientWorldSettings.of(this.summary.m_164913_()).getDisplaySeed()}), this.panel.x + 13, this.panel.y + 49, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        if (ScreenUtil.isMouseOver(i, j, (double)this.panel.x + 14.5, this.panel.y + 10, 29, 29)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237110_((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.m_237113_((String)this.summary.m_78358_()).m_130940_(ChatFormatting.ITALIC)}), i, j);
        }
    }

    public static void loadWorld(Screen screen, Minecraft minecraft, LevelStorageSource source, String levelId) {
        try (LevelStorageSource.LevelStorageAccess access = source.m_78260_(levelId);){
            LoadSaveScreen.loadWorld(screen, minecraft, source, access.m_78308_(access.m_307464_()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadWorld(Screen screen, Minecraft minecraft, LevelStorageSource source, LevelSummary summary) {
        SaveRenderableList.resetIconCache();
        PackAlbum.Selector.applyResourceChanges(minecraft, PackAlbum.getSelectedIds(minecraft.m_91099_()), LegacyClientWorldSettings.of(summary.m_164913_()).getSelectedResourceAlbum().packs(), () -> new WorldOpenFlows(minecraft, source).m_306404_(summary.m_78358_(), () -> minecraft.m_91152_(screen)));
    }

    private /* synthetic */ void lambda$init$14(LegacySliderButton b) {
        this.difficulty = (Difficulty)b.getObjectValue();
    }

    private static /* synthetic */ List lambda$init$13() {
        return Arrays.asList(Difficulty.values());
    }

    private /* synthetic */ Tooltip lambda$init$12(LegacySliderButton b) {
        return Tooltip.m_257550_((Component)this.difficulty.m_267622_());
    }

    private static /* synthetic */ Component lambda$init$11(LegacySliderButton b) {
        return b.getDefaultMessage((Component)Component.m_237115_((String)"options.difficulty"), ((Difficulty)b.getObjectValue()).m_19033_());
    }
}

