/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class MixedCraftingScreen<T extends RecipeBookMenu<CraftingContainer>>
extends AbstractContainerScreen<T>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    private final Inventory inventory;
    protected final List<ItemStack> compactItemStackList = new ArrayList<ItemStack>();
    protected final StackedContents stackedContents = new StackedContents();
    private int timesInventoryChanged;
    private final boolean is2x2;
    private boolean onlyCraftableRecipes = false;
    protected Stocker.Sizeable infoType = new Stocker.Sizeable(Integer.valueOf(0), 2);
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final List<RecipeIconHolder<VanillaCrafting>> craftingButtons = new PagedList(new Stocker.Sizeable(Integer.valueOf(0), 0), () -> this.accessor.getInteger("maxCraftingButtonsCount", 12));
    protected List<List<RecipeInfo<VanillaCrafting>>> recipesByGroup = new ArrayList<List<RecipeInfo<VanillaCrafting>>>();
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList().add(43, 0, LegacyTabButton.iconOf(LegacySprites.STRUCTURES), LegacyComponents.STRUCTURES, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.MECHANISMS), LegacyComponents.MECHANISMS, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.TOOLS), LegacyComponents.TOOLS_AND_ARMOUR, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.MISC), LegacyComponents.MISC, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.SEARCH), LegacyComponents.SEARCH_ITEMS, t -> this.enableSearchMode(true));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    protected boolean allowRecipeDisplay = false;
    protected final EditBox searchBox;
    protected boolean searchMode;
    public static final RecipeBookCategories[] VANILLA_CATEGORIES = new RecipeBookCategories[]{RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_REDSTONE, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_MISC, RecipeBookCategories.CRAFTING_SEARCH};
    protected int selectedCraftingButton;

    public static MixedCraftingScreen<CraftingMenu> craftingScreen(CraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new MixedCraftingScreen<CraftingMenu>(abstractContainerMenu, inventory, component, false);
    }

    public static MixedCraftingScreen<InventoryMenu> playerCraftingScreen(Player player) {
        return new MixedCraftingScreen<InventoryMenu>(player.f_36095_, player.m_150109_(), LegacyCraftingMenu.CRAFTING_TITLE, true);
    }

    public void enableSearchMode(boolean clearSearch) {
        this.searchMode = true;
        this.resetElements(true, clearSearch);
        this.m_7522_((GuiEventListener)this.searchBox);
    }

    public void disableSearchMode() {
        this.searchMode = false;
        this.resetElements(true, false);
    }

    public MixedCraftingScreen(T abstractContainerMenu, Inventory inventory, Component component, boolean is2x2) {
        super(abstractContainerMenu, inventory, component);
        this.searchBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, LegacyComponents.SEARCH_ITEMS);
        this.searchMode = false;
        this.inventory = inventory;
        this.is2x2 = is2x2;
        this.searchBox.m_94151_(s -> this.updateStackedContents());
        this.searchBox.m_94199_(50);
        this.resetElements(false, false);
        this.addCraftingButtons();
        this.accessor.getStaticDefinitions().add(UIDefinition.createBeforeInit(a -> this.accessor.putStaticElement("is2x2", (Object)is2x2)));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> LegacyComponents.INFO).add(() -> ControlTooltip.OPTION.get(), () -> this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES).add(() -> this.searchMode ? (ControlTooltip.Icon)ControlTooltip.VERTICAL_NAVIGATION.get() : ControlTooltip.ComponentIcon.compoundOf(ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(340) : ControllerBinding.LEFT_STICK_BUTTON.getIcon(), ControlTooltip.PLUS_ICON, (ControlTooltip.ComponentIcon)ControlTooltip.OPTION.get()), () -> this.searchMode ? LegacyComponents.EXIT_SEARCH_MODE : LegacyComponents.SEARCH_MODE).addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> LegacyComponents.GROUP);
    }

    public void resetElements() {
        this.searchMode = false;
        this.resetElements(true, true);
    }

    public void resetElements(boolean reposition, boolean resetCrafting) {
        if (!resetCrafting || this.searchBox.m_94155_().isEmpty()) {
            this.updateStackedContents();
        } else {
            this.searchBox.m_94144_("");
        }
        this.selectedCraftingButton = 0;
        if (resetCrafting) {
            this.infoType.set(Integer.valueOf(0));
            this.craftingButtonsOffset.set(Integer.valueOf(0));
        }
        if (reposition) {
            this.m_267719_();
        }
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.m_7522_(guiEventListener);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        if (!this.searchMode) {
            Component title = this.getTabList() == this.craftingTabList ? this.getTabList().tabButtons.get(this.getTabList().selectedTab).m_6035_() : CommonComponents.f_237098_;
            guiGraphics.m_280614_(this.f_96547_, title, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)title)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        int inventoryPanelX = this.accessor.getInteger("inventoryPanelX", 176);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanelWidth", 163);
        if ((Integer)this.infoType.get() <= 0) {
            guiGraphics.m_280614_(this.f_96547_, this.f_169604_, inventoryPanelX + (inventoryPanelWidth - this.f_96547_.m_92852_((FormattedText)this.f_169604_)) / 2, this.accessor.getInteger("bottomPanelTitleY", 114), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            RecipeIconHolder<VanillaCrafting> h = this.craftingButtons.get(this.selectedCraftingButton);
            if ((Integer)this.infoType.get() == 1 && LegacyTipManager.hasTip(h.getFocusedResult())) {
                List l = this.f_96547_.m_92923_((FormattedText)LegacyTipManager.getTipComponent(h.getFocusedResult()), inventoryPanelWidth - 11);
                this.scrollableRenderer.scrolled.max = Math.max(0, l.size() - 7);
                this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 5, 105, inventoryPanelWidth - 11, 84, () -> {
                    for (int i1 = 0; i1 < l.size(); ++i1) {
                        guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)l.get(i1), inventoryPanelX + 5, 108 + i1 * 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    }
                });
            } else if ((Integer)this.infoType.get() == 2) {
                guiGraphics.m_280614_(this.f_96547_, LegacyComponents.INGREDIENTS, inventoryPanelX + (inventoryPanelWidth - this.f_96547_.m_92852_((FormattedText)LegacyComponents.INGREDIENTS)) / 2, 108, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                if (h.getFocusedRecipe() != null) {
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactItemStackList(this.compactItemStackList, () -> h.getFocusedRecipe().getOptionalIngredients().stream().map(RecipeIconHolder::getActualItem).iterator());
                    this.scrollableRenderer.scrolled.max = Math.max(0, this.compactItemStackList.size() - 4);
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 2, 122, 152, 60, () -> {
                        for (int i1 = 0; i1 < this.compactItemStackList.size(); ++i1) {
                            ItemStack ing = this.compactItemStackList.get(i1);
                            ScreenUtil.iconHolderRenderer.itemHolder(inventoryPanelX + 4, 124 + 15 * i1, 14, 14, ing, false, Vec3.f_82478_).m_88315_(guiGraphics, i, j, 0.0f);
                            guiGraphics.m_280168_().m_85836_();
                            guiGraphics.m_280168_().m_252880_((float)(inventoryPanelX + 22), (float)(128 + 15 * i1), 0.0f);
                            Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                                if (!b.booleanValue()) {
                                    guiGraphics.m_280168_().m_85841_(0.6666667f, 0.6666667f, 0.6666667f);
                                }
                                guiGraphics.m_280614_(this.f_96547_, ing.m_41786_(), 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                            });
                            guiGraphics.m_280168_().m_85849_();
                        }
                    });
                }
            }
        }
        guiGraphics.m_280168_().m_252880_((float)(-this.f_97735_), (float)(-this.f_97736_), 0.0f);
        this.getCraftingButtons().forEach(b -> b.m_88315_(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
        guiGraphics.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.timesInventoryChanged != this.f_96541_.f_91074_.m_150109_().m_36072_()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.f_96541_.f_91074_.m_150109_().m_36072_();
        }
    }

    protected void m_6597_(Slot slot, int i, int j, ClickType clickType) {
        this.allowRecipeDisplay = false;
        super.m_6597_(slot, i, j, clickType);
        this.updateStackedContents();
    }

    private void updateStackedContents() {
        ClientPacketListener clientPacketListener;
        this.f_96541_ = Minecraft.m_91087_();
        this.stackedContents.m_36453_();
        this.inventory.m_36010_(this.stackedContents);
        ((RecipeBookMenu)this.f_97732_).m_5816_(this.stackedContents);
        List collections = Minecraft.m_91087_().f_91074_.m_108631_().m_90623_(VANILLA_CATEGORIES[this.getTabList().selectedTab]);
        this.allowRecipeDisplay = false;
        int dim = ((RecipeBookMenu)this.f_97732_).m_6635_() * ((RecipeBookMenu)this.f_97732_).m_6656_();
        for (int i = 1; i <= dim && !((RecipeBookMenu)this.f_97732_).m_38853_(i).m_6657_(); ++i) {
            if (i != dim) continue;
            this.allowRecipeDisplay = true;
        }
        collections.forEach(collection -> collection.m_100501_(this.stackedContents, ((RecipeBookMenu)this.f_97732_).m_6635_(), ((RecipeBookMenu)this.f_97732_).m_6656_(), (RecipeBook)Minecraft.m_91087_().f_91074_.m_108631_()));
        this.recipesByGroup.clear();
        List searchCollections = null;
        if (!this.searchBox.m_94155_().isBlank() && (clientPacketListener = this.f_96541_.m_91403_()) != null) {
            searchCollections = this.f_96541_.m_231372_(SearchRegistry.f_301428_).m_6293_(this.searchBox.m_94155_().toLowerCase(Locale.ROOT));
        }
        for (final RecipeCollection collection2 : collections) {
            List selectedRecipes;
            if (!collection2.m_100515_() || searchCollections != null && !searchCollections.contains(collection2) || (selectedRecipes = collection2.m_100510_(this.onlyCraftableRecipes)).isEmpty()) continue;
            this.recipesByGroup.add(selectedRecipes.stream().map(e -> {
                final ArrayList<Optional<Ingredient>> ings = new ArrayList<Optional<Ingredient>>(Collections.nCopies(((RecipeBookMenu)this.f_97732_).m_6635_() * ((RecipeBookMenu)this.f_97732_).m_6656_(), Optional.empty()));
                boolean[] warningSlots = new boolean[((RecipeBookMenu)this.f_97732_).m_6635_() * ((RecipeBookMenu)this.f_97732_).m_6656_()];
                Recipe recipe = e.f_291008_();
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    LegacyCraftingMenu.updateShapedIngredients(ings, LegacyCraftingMenu.getRecipeOptionalIngredients(shapedRecipe), ((RecipeBookMenu)this.f_97732_).m_6635_(), shapedRecipe.m_44220_(), shapedRecipe.m_44221_());
                } else {
                    for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                        ings.set(i, Optional.of((Ingredient)recipe.m_7527_().get(i)));
                    }
                }
                if (this.allowRecipeDisplay) {
                    LegacyCraftingScreen.canCraft(this.compactItemStackList, ings, warningSlots);
                }
                final VanillaCrafting crafting = new VanillaCrafting(){
                    final /* synthetic */ RecipeHolder val$e;
                    final /* synthetic */ boolean[] val$warningSlots;
                    {
                        this.val$e = recipeHolder;
                        this.val$warningSlots = blArray;
                    }

                    @Override
                    public ItemStack getItemFromGrid(int index) {
                        return RecipeIconHolder.getActualItem((Optional)ings.get(index));
                    }

                    @Override
                    public boolean canCraft() {
                        return collection2.m_100506_(this.val$e);
                    }

                    @Override
                    public void craft() {
                        ((MixedCraftingScreen)MixedCraftingScreen.this).f_96541_.f_91072_.m_105217_(((MixedCraftingScreen)MixedCraftingScreen.this).f_96541_.f_91074_.f_36096_.f_38840_, this.val$e, Screen.m_96638_());
                    }

                    @Override
                    public boolean isWarning(int index) {
                        return this.val$warningSlots[index];
                    }
                };
                final List<ItemStack> resultDisplay = Collections.singletonList(recipe.m_8043_((RegistryAccess)this.f_96541_.m_91403_().m_105152_()));
                RecipeInfo<VanillaCrafting> info = new RecipeInfo<VanillaCrafting>(){

                    public VanillaCrafting get() {
                        return crafting;
                    }

                    public ResourceLocation getId() {
                        return null;
                    }

                    @Override
                    public List<Optional<Ingredient>> getOptionalIngredients() {
                        return ings;
                    }

                    @Override
                    public ItemStack getResultItem() {
                        return resultDisplay.size() == 1 ? (ItemStack)resultDisplay.get(0) : (ItemStack)resultDisplay.get((int)(Util.m_137550_() / 800L % (long)resultDisplay.size()));
                    }

                    @Override
                    public Component getName() {
                        return this.getResultItem().m_41786_();
                    }

                    @Override
                    public Component getDescription() {
                        return null;
                    }
                };
                return info;
            }).toList());
        }
        this.craftingButtonsOffset.max = Math.max(0, this.recipesByGroup.size() - 12);
    }

    protected boolean isInventoryActive() {
        return (Integer)this.infoType.get() <= 0;
    }

    protected void m_7856_() {
        this.f_97726_ = 349;
        this.f_97727_ = 215;
        super.m_7856_();
        this.f_97736_ += 18;
        for (int i2 = 0; i2 < ((RecipeBookMenu)this.f_97732_).f_38839_.size(); ++i2) {
            final Slot s = (Slot)((RecipeBookMenu)this.f_97732_).f_38839_.get(i2);
            if (i2 == 0) {
                LegacySlotDisplay.override(s, 123, 151, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 36;
                    }

                    @Override
                    public ItemStack getItemOverride() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return recipeIconHolder.getFocusedResult();
                        }
                        return LegacySlotDisplay.super.getItemOverride();
                    }

                    @Override
                    public boolean isWarning() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return !recipeIconHolder.canCraft();
                        }
                        return LegacySlotDisplay.super.isWarning();
                    }
                });
                continue;
            }
            if (i2 < (this.is2x2 ? 5 : 10)) {
                LegacySlotDisplay.override(s, 21 + s.m_150661_() % ((RecipeBookMenu)this.f_97732_).m_6635_() * 23, (this.is2x2 ? 145 : 133) + s.m_150661_() / ((RecipeBookMenu)this.f_97732_).m_6656_() * 23, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ItemStack getItemOverride() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return ((VanillaCrafting)recipeIconHolder.getFocusedRecipe().get()).getItemFromGrid(s.m_150661_());
                        }
                        return LegacySlotDisplay.super.getItemOverride();
                    }

                    @Override
                    public boolean isWarning() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return ((VanillaCrafting)recipeIconHolder.getFocusedRecipe().get()).isWarning(s.m_150661_());
                        }
                        return LegacySlotDisplay.super.isWarning();
                    }
                });
                continue;
            }
            if (this.is2x2 && (i2 < 9 || i2 == ((RecipeBookMenu)this.f_97732_).f_38839_.size() - 1)) {
                LegacySlotDisplay.override(s, new LegacySlotDisplay(){

                    @Override
                    public boolean isVisible() {
                        return false;
                    }
                });
                continue;
            }
            if (i2 < ((RecipeBookMenu)this.f_97732_).f_38839_.size() - (this.is2x2 ? 10 : 9)) {
                LegacySlotDisplay.override(s, 186 + (s.m_150661_() - 9) % 9 * 16, 133 + (s.m_150661_() - 9) / 9 * 16, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 16;
                    }

                    @Override
                    public boolean isVisible() {
                        return MixedCraftingScreen.this.isInventoryActive();
                    }
                });
                continue;
            }
            if (i2 >= ((RecipeBookMenu)this.f_97732_).f_38839_.size() - (this.is2x2 ? 1 : 0)) continue;
            LegacySlotDisplay.override(s, 186 + s.m_150661_() * 16, 186, new LegacySlotDisplay(){

                @Override
                public int getWidth() {
                    return 16;
                }

                @Override
                public boolean isVisible() {
                    return MixedCraftingScreen.this.isInventoryActive();
                }
            });
        }
        if (this.searchMode) {
            this.searchBox.m_264152_(this.f_97735_ + (this.f_97726_ - this.searchBox.m_5711_()) / 2, this.f_97736_ + 11);
            this.m_142416_((GuiEventListener)this.searchBox);
        }
        if (this.selectedCraftingButton < this.getCraftingButtons().size() && !this.searchMode) {
            this.m_7522_(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        this.getCraftingButtons().forEach(b -> {
            b.setPos(this.f_97735_ + this.accessor.getInteger("craftingButtonsX", 13) + this.getCraftingButtons().indexOf(b) * 27, this.f_97736_ + 38);
            this.m_7787_((GuiEventListener)b);
        });
        this.m_7787_(this.getTabList());
        this.getTabList().init(this.f_97735_, this.f_97736_ - 37, this.f_97726_, (t, i) -> {
            int index = this.getTabList().tabButtons.indexOf(t);
            t.type = index == 0 ? 0 : (index >= this.getMaxTabCount() ? 2 : 1);
            t.m_93674_(this.accessor.getInteger("tabListButtonWidth", 71));
            t.offset = t1 -> new Vec3(this.accessor.getDouble("tabListXOffset", -1.5) * (double)this.getTabList().tabButtons.indexOf(t), t1.selected ? 0.0 : this.accessor.getDouble("tabListSelectedYOffset", 4.5), 0.0);
        });
    }

    @Override
    public TabList getTabList() {
        return this.craftingTabList;
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 4);
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<VanillaCrafting> h = new RecipeIconHolder<VanillaCrafting>(this.f_97735_ + 13 + i * 27, this.f_97736_ + 38){

                @Override
                public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
                    if (this.m_93696_()) {
                        MixedCraftingScreen.this.selectedCraftingButton = index;
                    }
                    super.m_88315_(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<VanillaCrafting> rcp) {
                    return rcp == null || ((VanillaCrafting)rcp.get()).canCraft();
                }

                @Override
                protected List<RecipeInfo<VanillaCrafting>> getRecipes() {
                    return MixedCraftingScreen.this.recipesByGroup.size() <= (Integer)MixedCraftingScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : MixedCraftingScreen.this.recipesByGroup.get((Integer)MixedCraftingScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void toggleCraftableRecipes() {
                    if (Screen.m_96638_() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed) {
                        return;
                    }
                    MixedCraftingScreen.this.onlyCraftableRecipes = !MixedCraftingScreen.this.onlyCraftableRecipes;
                    MixedCraftingScreen.this.updateStackedContents();
                }

                @Override
                public boolean m_7933_(int i, int j, int k) {
                    if (this.controlCyclicNavigation(i, index, MixedCraftingScreen.this.craftingButtons, MixedCraftingScreen.this.craftingButtonsOffset, MixedCraftingScreen.this.scrollRenderer, (Screen)MixedCraftingScreen.this)) {
                        return true;
                    }
                    if (i == 88) {
                        MixedCraftingScreen.this.infoType.add(1, true);
                        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                        return true;
                    }
                    return super.m_7933_(i, j, k);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<VanillaCrafting> rcp) {
                    MixedCraftingScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
                }

                @Override
                public void craft() {
                    ScreenUtil.playSimpleUISound(SoundEvents.f_12019_, 1.0f);
                    ((VanillaCrafting)this.getFocusedRecipe().get()).craft();
                    MixedCraftingScreen.this.m_6597_(((RecipeBookMenu)MixedCraftingScreen.this.f_97732_).m_38853_(((RecipeBookMenu)MixedCraftingScreen.this.f_97732_).m_6636_()), ((RecipeBookMenu)MixedCraftingScreen.this.f_97732_).m_6636_(), 0, ClickType.QUICK_MOVE);
                }
            };
            this.getCraftingButtons().add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
        }
    }

    public boolean m_6050_(double d, double e, double f, double g) {
        if (super.m_6050_(d, e, f, g)) {
            return true;
        }
        if (this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.m_267719_();
            return true;
        }
        return false;
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.searchBox.m_93696_() && this.searchMode && !this.searchBox.m_5953_(d, e)) {
            this.disableSearchMode();
        }
        return super.m_6375_(d, e, i);
    }

    public void m_280273_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_7286_(guiGraphics, f, i, j);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        this.getTabList().m_88315_(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        int panelWidth = this.accessor.getInteger("craftingGridPanelWidth", 163);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 9, this.f_97736_ + 103, panelWidth, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + this.accessor.getInteger("inventoryPanelX", 176), this.f_97736_ + this.accessor.getInteger("inventoryPanelY", 103), this.accessor.getInteger("inventoryPanelWidth", 163), 105);
        int contentsWidth = (this.is2x2 ? 2 : 3) * 23 + 69;
        int xDiff = this.f_97735_ + 9 + (panelWidth - contentsWidth) / 2;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, xDiff + (this.is2x2 ? 2 : 3) * 23 + 8, this.f_97736_ + 161, 16, 13);
        if ((Integer)this.craftingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.f_97735_ + 5, this.f_97736_ + 45);
        }
        if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.f_97735_ + this.f_97726_ - 11, this.f_97736_ + 45);
        }
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.searchMode && (i == 265 || i == 264)) {
            this.disableSearchMode();
            return true;
        }
        if (this.getTabList().controlTab(i)) {
            return true;
        }
        if (i != 256 && this.searchBox.m_93696_()) {
            return this.searchBox.m_7933_(i, j, k);
        }
        return super.m_7933_(i, j, k);
    }

    public boolean m_7920_(int i, int j, int k) {
        if (!this.searchBox.m_93696_() && !this.searchMode && i == 79 && (MixedCraftingScreen.m_96638_() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed)) {
            this.enableSearchMode(false);
            return true;
        }
        return super.m_7920_(i, j, k);
    }

    public List<RecipeIconHolder<VanillaCrafting>> getCraftingButtons() {
        return this.craftingButtons;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_280273_(guiGraphics, i, j, f);
        super.m_88315_(guiGraphics, i, j, f);
        int panelWidth = this.accessor.getInteger("craftingGridPanelWidth", 163);
        ItemStack resultStack = this.craftingButtons.get(this.selectedCraftingButton).getFocusedResult();
        if (!resultStack.m_41619_() && this.allowRecipeDisplay) {
            Component resultName = this.getCraftingButtons().get(this.selectedCraftingButton).getFocusedRecipe().getName();
            Component description = this.getCraftingButtons().get(this.selectedCraftingButton).getFocusedRecipe().getDescription();
            int titleY = this.accessor.getInteger("bottomPanelTitleY", 114) - (description == null ? 0 : 6);
            ScreenUtil.renderScrollingString(guiGraphics, this.f_96547_, resultName, this.f_97735_ + 11 + Math.max(panelWidth - this.f_96547_.m_92852_((FormattedText)resultName), 0) / 2, this.f_97736_ + titleY, this.f_97735_ + 7 + panelWidth, this.f_97736_ + titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            if (description != null) {
                ScreenUtil.renderScrollingString(guiGraphics, this.f_96547_, (Component)description.m_6881_().m_6270_(Style.f_131099_), this.f_97735_ + 11 + Math.max(panelWidth - this.f_96547_.m_92852_((FormattedText)description), 0) / 2, this.f_97736_ + titleY + 12, this.f_97735_ + 7 + panelWidth, this.f_97736_ + titleY + 23, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            }
        }
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.f_96541_, guiGraphics, i, j));
        this.m_280072_(guiGraphics, i, j);
    }

    public static interface VanillaCrafting {
        public ItemStack getItemFromGrid(int var1);

        public boolean canCraft();

        public void craft();

        public boolean isWarning(int var1);
    }
}

