/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.ControlType;
import wily.legacy.client.GlobalPacks;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacyLanguageScreen;
import wily.legacy.client.screen.ModsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVListScreen;
import wily.legacy.client.screen.ScreenSection;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.util.LegacyComponents;

public class OptionsScreen
extends PanelVListScreen {
    public Screen advancedOptionsScreen;

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component) {
        super(parent, panelConstructor, component);
    }

    public OptionsScreen(Screen parent, Section section) {
        this(parent, LegacyOptions.advancedOptionsMode.get() == LegacyOptions.AdvancedOptionsMode.MERGE && section.advancedSection.isPresent() ? ((Section)section.advancedSection.get()).panelConstructor() : section.panelConstructor(), section.title());
        section.elements().forEach(c -> c.accept(this));
        section.advancedSection.ifPresent(s -> {
            switch ((LegacyOptions.AdvancedOptionsMode)((Object)((Object)LegacyOptions.advancedOptionsMode.get()))) {
                case DEFAULT: {
                    this.withAdvancedOptions(s.build(this));
                    break;
                }
                case MERGE: {
                    s.elements().forEach(c -> c.accept(this));
                }
            }
        });
    }

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component, Renderable ... renderables) {
        this(parent, panelConstructor, component);
        this.renderableVList.addRenderables(renderables);
    }

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component, FactoryConfig<?> ... options) {
        this(parent, panelConstructor, component);
        this.renderableVList.addOptions(options);
    }

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component, Stream<FactoryConfig<?>> options) {
        this(parent, panelConstructor, component);
        this.renderableVList.addOptions(options);
    }

    public OptionsScreen withAdvancedOptions(Function<OptionsScreen, Screen> advancedOptionsFunction) {
        return this.withAdvancedOptions(advancedOptionsFunction.apply(this));
    }

    public OptionsScreen withAdvancedOptions(Screen screen) {
        this.advancedOptionsScreen = screen;
        return this;
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (super.m_7933_(i, j, k)) {
            return true;
        }
        if (i == 79 && this.advancedOptionsScreen != null) {
            this.f_96541_.m_91152_(this.advancedOptionsScreen);
            return true;
        }
        return false;
    }

    public static void setupSelectorControlTooltips(ControlTooltip.Renderer renderer, Screen screen) {
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(0)}) : null, () -> ControlTooltip.getKeyMessage(0, screen));
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> ControlTooltip.getKeyMessage(88, screen));
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(79, screen));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        OptionsScreen.setupSelectorControlTooltips(renderer, this);
        renderer.replace(6, i -> i, c -> c == null ? (this.advancedOptionsScreen == null ? null : LegacyComponents.SHOW_ADVANCED_OPTIONS) : c);
    }

    public record Section(Component title, Function<Screen, Panel> panelConstructor, List<Consumer<OptionsScreen>> elements, ArbitrarySupplier<Section> advancedSection, BiFunction<Screen, Section, OptionsScreen> sectionBuilder) implements ScreenSection<OptionsScreen>
    {
        private static final Minecraft mc = Minecraft.m_91087_();
        public static final List<Section> list = new ArrayList<Section>();
        public static final Section GAME_OPTIONS = Section.add(new Section((Component)Component.m_237115_((String)"legacy.menu.game_options"), s -> Panel.centered(s, 250, 162), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.of(Section.mc.f_91066_.m_231812_()), LegacyOptions.of(Section.mc.f_91066_.m_231830_()), LegacyOptions.flyingViewRolling, LegacyOptions.hints, LegacyOptions.autoSaveInterval), o -> o.renderableVList.addRenderables(new Renderable[]{RenderableVListScreen.openScreenButton((Component)Component.m_237115_((String)"options.language"), () -> new LegacyLanguageScreen((Screen)o, mc.m_91102_())).m_253136_(), RenderableVListScreen.openScreenButton((Component)Component.m_237115_((String)"legacy.menu.mods"), () -> new ModsScreen((Screen)o)).m_253136_()}), o -> {
            if (Section.mc.f_91073_ == null && !mc.m_91091_()) {
                o.renderableVList.addOptions(LegacyOptions.createWorldDifficulty);
            }
        })), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_GAME_OPTIONS)));
        public static final Section ADVANCED_GAME_OPTIONS = new Section((Component)Component.m_237110_((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{GAME_OPTIONS.title()}), s -> Panel.centered(s, 250, 172), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.selectedControlType, LegacyOptions.lockControlTypeChange, LegacyOptions.unfocusedInputs, LegacyOptions.autoSaveWhenPaused, LegacyOptions.directSaveLoad, LegacyOptions.saveCache, LegacyOptions.legacyCreativeBlockPlacing, LegacyOptions.cursorMode, LegacyOptions.invertedFrontCameraPitch, LegacyOptions.skipIntro, LegacyOptions.skipInitialSaveWarning, LegacyOptions.vanillaTutorial, LegacyOptions.of(Section.mc.f_91066_.m_231822_()), LegacyOptions.of(Section.mc.f_91066_.m_231823_())), o -> {
            if (Section.mc.f_91073_ == null) {
                LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> o.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b -> c.sync())));
            }
        }, o -> o.renderableVList.addRenderables(new Renderable[]{RenderableVListScreen.openScreenButton(LegacyComponents.RESET_KNOWN_BLOCKS_TITLE, () -> ConfirmationScreen.createResetKnownListingScreen(o, LegacyComponents.RESET_KNOWN_BLOCKS_TITLE, LegacyComponents.RESET_KNOWN_BLOCKS_MESSAGE, Legacy4JClient.knownBlocks)).m_253136_(), RenderableVListScreen.openScreenButton(LegacyComponents.RESET_KNOWN_ENTITIES_TITLE, () -> ConfirmationScreen.createResetKnownListingScreen(o, LegacyComponents.RESET_KNOWN_ENTITIES_TITLE, LegacyComponents.RESET_KNOWN_ENTITIES_MESSAGE, Legacy4JClient.knownEntities)).m_253136_()}))));
        public static final Section AUDIO = Section.add(new Section((Component)Component.m_237115_((String)"legacy.menu.audio"), s -> Panel.centered(s, 250, 88, 0, -30), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(Streams.concat((Stream[])new Stream[]{Arrays.stream(SoundSource.values()).filter(s -> s.ordinal() <= 1).sorted(Comparator.comparingInt(s -> s == SoundSource.MUSIC ? 0 : 1)).map(s -> LegacyOptions.of(Section.mc.f_91066_.m_246669_(s))), Stream.of(LegacyOptions.caveSounds, LegacyOptions.minecartSounds)})))), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_AUDIO)));
        public static final Section ADVANCED_AUDIO = new Section((Component)Component.m_237110_((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{AUDIO.title()}), s -> Panel.centered(s, 250, 198, 0, 30), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(Stream.concat(Stream.of(Section.mc.f_91066_.m_231931_()), Arrays.stream(SoundSource.values()).filter(ss -> ss.ordinal() > 1).map(arg_0 -> ((Options)Section.mc.f_91066_).m_246669_(arg_0))).map(LegacyOptions::of)))));
        public static final Section GRAPHICS = Section.add(new Section((Component)Component.m_237115_((String)"legacy.menu.graphics"), s -> Panel.centered(s, 250, 222, 0, 24), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.of(Section.mc.f_91066_.m_232050_()), LegacyOptions.of(Section.mc.f_91066_.m_232060_())), o -> o.renderableVList.addLinkedOptions(LegacyOptions.displayLegacyGamma, Supplier::get, LegacyOptions.legacyGamma), o -> o.renderableVList.addOptions(LegacyOptions.of(Section.mc.f_91066_.m_231927_()), LegacyOptions.of(Section.mc.f_91066_.m_232070_())))), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_GRAPHICS), (p, s) -> {
            final GlobalPacks.Selector globalPackSelector = GlobalPacks.Selector.resources(0, 0, 230, 45, false);
            final PackAlbum.Selector selector = PackAlbum.Selector.resources(0, 0, 230, 45, false);
            OptionsScreen screen = new OptionsScreen((Screen)p, (Section)s){
                int selectorTooltipVisibility;
                boolean startedSelectorVisibility;
                {
                    super(parent, section);
                    this.selectorTooltipVisibility = 0;
                    this.startedSelectorVisibility = false;
                }

                @Override
                public void m_7379_() {
                    super.m_7379_();
                    globalPackSelector.applyChanges();
                    selector.applyChanges(true);
                }

                @Override
                protected void panelInit() {
                    super.panelInit();
                    this.panel.x -= Math.round(Math.min(10.0f, this.getSelectorTooltipVisibility()) / 10.0f * 80.0f);
                }

                private float getSelectorTooltipVisibility() {
                    return this.selectorTooltipVisibility == 0 ? (float)this.selectorTooltipVisibility : (float)this.selectorTooltipVisibility + FactoryAPIClient.getPartialTick();
                }

                @Override
                public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
                    if (this.selectorTooltipVisibility < 10 && this.startedSelectorVisibility) {
                        this.m_267719_();
                    }
                    super.renderDefaultBackground(guiGraphics, i, j, f);
                    if (this.selectorTooltipVisibility > 0) {
                        if (this.m_7222_() != globalPackSelector) {
                            selector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel, Math.round((1.0f - Math.min(10.0f, this.getSelectorTooltipVisibility()) / 10.0f) * -161.0f));
                        } else {
                            globalPackSelector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel, Math.round((1.0f - Math.min(10.0f, this.getSelectorTooltipVisibility()) / 10.0f) * -161.0f));
                        }
                        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 0.03f);
                    }
                }

                public void m_86600_() {
                    if (!(this.startedSelectorVisibility || this.m_7222_() != selector && this.m_7222_() != globalPackSelector)) {
                        this.startedSelectorVisibility = true;
                    }
                    if (this.startedSelectorVisibility && this.selectorTooltipVisibility < 10) {
                        ++this.selectorTooltipVisibility;
                    }
                    super.m_86600_();
                }
            };
            screen.renderableVList.addRenderables(new Renderable[]{globalPackSelector, selector});
            return screen;
        }));
        public static final Section ADVANCED_GRAPHICS = new Section((Component)Component.m_237110_((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{GRAPHICS.title()}), s -> Panel.centered(s, 250, 215, 0, 20), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.of(Section.createResolutionOptionInstance()), LegacyOptions.of(Section.mc.f_91066_.m_232121_()), LegacyOptions.of(Section.mc.f_91066_.m_231984_()), LegacyOptions.of(Section.mc.f_91066_.m_232080_()), LegacyOptions.of(Section.mc.f_91066_.m_232001_()), LegacyOptions.overrideTerrainFogStart, LegacyOptions.terrainFogStart, LegacyOptions.overrideTerrainFogEnd, LegacyOptions.terrainFogEnd, LegacyOptions.legacySkyShape, LegacyOptions.fastLeavesWhenBlocked, LegacyOptions.fastLeavesCustomModels, LegacyOptions.mapsWithCoords, LegacyOptions.of(Section.mc.f_91066_.m_232035_()), LegacyOptions.of(Section.mc.f_91066_.m_231817_()), LegacyOptions.displayNameTagBorder, LegacyOptions.itemLightingInHand, LegacyOptions.loyaltyLines, LegacyOptions.merchantTradingIndicator, LegacyOptions.legacyDrownedAnimation, LegacyOptions.legacyEntityFireTint, LegacyOptions.vehicleCameraRotation, LegacyOptions.defaultParticlePhysics, LegacyOptions.headFollowsTheCamera, LegacyOptions.enhancedPistonMovingRenderer, FactoryOptions.RANDOM_BLOCK_ROTATIONS, LegacyOptions.of(Section.mc.f_91066_.m_231829_()), LegacyOptions.of(Section.mc.f_91066_.m_231929_()), LegacyOptions.of(Section.mc.f_91066_.m_232119_()), FactoryOptions.NEAREST_MIPMAP_SCALING, LegacyOptions.of(Section.mc.f_91066_.m_231818_()), LegacyOptions.of(Section.mc.f_91066_.m_231924_()), LegacyOptions.of(Section.mc.f_91066_.m_232018_()), LegacyOptions.of(Section.mc.f_91066_.m_231837_()), LegacyOptions.of(Section.mc.f_91066_.m_231925_()), LegacyOptions.of(Section.mc.f_91066_.m_231926_()), LegacyOptions.of(Section.mc.f_91066_.m_267805_()), LegacyOptions.legacyEvokerFangs, LegacyOptions.of(Section.mc.f_91066_.m_267782_())), o -> Legacy4JClient.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> o.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c))))));
        public static final Section USER_INTERFACE = Section.add(new Section((Component)Component.m_237115_((String)"legacy.menu.user_interface"), s -> Panel.centered(s, 250, 200, 0, 18), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.displayHUD, LegacyOptions.displayHand, LegacyOptions.of(Section.mc.f_91066_.m_231834_()), LegacyOptions.showVanillaRecipeBook, LegacyOptions.tooltipBoxes, LegacyOptions.hudOpacity, LegacyOptions.of(Section.mc.f_91066_.m_232120_()), LegacyOptions.hudScale, LegacyOptions.hudDistance), o -> o.renderableVList.addLinkedOptions(LegacyOptions.autoResolution, b -> (Boolean)b.get() == false, LegacyOptions.interfaceResolution), o -> o.renderableVList.addOptions(LegacyOptions.inGameTooltips, LegacyOptions.animatedCharacter, LegacyOptions.smoothAnimatedCharacter, LegacyOptions.interfaceSensitivity, LegacyOptions.classicCrafting, LegacyOptions.classicTrading, LegacyOptions.classicStonecutting, LegacyOptions.classicLoom, LegacyOptions.forceMixedCrafting, LegacyOptions.vanillaTabs, LegacyOptions.searchCreativeTab, LegacyOptions.of(Section.mc.f_91066_.m_257871_())), o -> o.getRenderableVList().addLinkedOptions(LegacyOptions.legacyItemTooltips, Supplier::get, LegacyOptions.legacyItemTooltipScaling), o -> o.getRenderableVList().addOptions(LegacyOptions.vignette, LegacyOptions.of(Section.mc.f_91066_.m_231930_()), LegacyOptions.of(Section.mc.f_91066_.m_231825_()), LegacyOptions.of(Section.mc.f_91066_.m_274330_())))), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_USER_INTERFACE)));
        public static final Section ADVANCED_USER_INTERFACE = new Section((Component)Component.m_237110_((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{USER_INTERFACE.title()}), USER_INTERFACE.panelConstructor(), LegacyOptions.legacyCreativeTab, LegacyOptions.invertedCrosshair, LegacyOptions.selectedItemTooltipLines, LegacyOptions.itemTooltipEllipsis, LegacyOptions.selectedItemTooltipSpacing, LegacyOptions.legacyOverstackedItems, LegacyOptions.displayMultipleControlsFromAction, LegacyOptions.advancedHeldItemTooltip, LegacyOptions.autoSaveCountdown, LegacyOptions.displayControlTooltips, LegacyOptions.systemMessagesAsOverlay, LegacyOptions.titleScreenFade, LegacyOptions.titleScreenVersionText, LegacyOptions.legacyPanorama, LegacyOptions.menusWithBackground, LegacyOptions.of(Section.mc.f_91066_.m_264038_()), LegacyOptions.of(Section.mc.f_91066_.m_269326_()), LegacyOptions.of(Section.mc.f_91066_.m_267805_()), LegacyOptions.of(Section.mc.f_91066_.m_267782_()), LegacyOptions.of(Section.mc.f_91066_.m_231935_()), LegacyOptions.of(Section.mc.f_91066_.m_231838_()), LegacyOptions.of(Section.mc.f_91066_.m_245201_()), LegacyOptions.of(Section.mc.f_91066_.m_292959_()), LegacyOptions.of(Section.mc.f_91066_.m_232090_()), LegacyOptions.of(Section.mc.f_91066_.m_231814_()), LegacyOptions.of(Section.mc.f_91066_.m_231815_()), LegacyOptions.of(Section.mc.f_91066_.m_231816_()), LegacyOptions.of(Section.mc.f_91066_.m_231827_()), LegacyOptions.of(Section.mc.f_91066_.m_232098_()), LegacyOptions.of(Section.mc.f_91066_.m_232104_()), LegacyOptions.of(Section.mc.f_91066_.m_232110_()), LegacyOptions.of(Section.mc.f_91066_.m_232101_()), LegacyOptions.of(Section.mc.f_91066_.m_232118_()), LegacyOptions.of(Section.mc.f_91066_.m_232113_()), LegacyOptions.of(Section.mc.f_91066_.m_232117_()), LegacyOptions.of(Section.mc.f_91066_.m_232116_()), LegacyOptions.of(Section.mc.f_91066_.m_231930_()), LegacyOptions.of(Section.mc.f_91066_.m_231813_()), LegacyOptions.of(Section.mc.f_91066_.m_231833_()), LegacyOptions.of(Section.mc.f_91066_.m_231824_()), LegacyOptions.of(Section.mc.f_91066_.m_231836_()));

        public Section(Component title, Function<Screen, Panel> panelConstructor, List<Consumer<OptionsScreen>> elements, ArbitrarySupplier<Section> advancedSection) {
            this(title, panelConstructor, elements, advancedSection, OptionsScreen::new);
        }

        public Section(Component title, Function<Screen, Panel> panelConstructor, List<Consumer<OptionsScreen>> elements) {
            this(title, panelConstructor, elements, (ArbitrarySupplier<Section>)ArbitrarySupplier.empty());
        }

        public Section(Component title, Function<Screen, Panel> panelConstructor, ArbitrarySupplier<Section> advancedSection, FactoryConfig<?> ... options) {
            this(title, panelConstructor, new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(options))), advancedSection);
        }

        public Section(Component title, Function<Screen, Panel> panelConstructor, FactoryConfig<?> ... optionInstances) {
            this(title, panelConstructor, (ArbitrarySupplier<Section>)ArbitrarySupplier.empty(), optionInstances);
        }

        public static OptionInstance<?> createResolutionOptionInstance() {
            Monitor monitor = mc.m_91268_().m_85450_();
            int j = monitor == null ? -1 : mc.m_91268_().m_85436_().map(arg_0 -> ((Monitor)monitor).m_84946_(arg_0)).orElse(-1);
            return new OptionInstance("options.fullscreen.resolution", OptionInstance.m_231498_(), (component, integer) -> {
                if (monitor == null) {
                    return Component.m_237115_((String)"options.fullscreen.unavailable");
                }
                if (integer == -1) {
                    return Options.m_231921_((Component)component, (Component)Component.m_237115_((String)"options.fullscreen.current"));
                }
                VideoMode videoMode = monitor.m_84944_(integer.intValue());
                return Options.m_231921_((Component)component, (Component)Component.m_237110_((String)"options.fullscreen.entry", (Object[])new Object[]{videoMode.m_85332_(), videoMode.m_85335_(), videoMode.m_85341_(), videoMode.m_85336_() + videoMode.m_85337_() + videoMode.m_85338_()}));
            }, (OptionInstance.ValueSet)new OptionInstance.IntRange(-1, monitor != null ? monitor.m_84953_() - 1 : -1), (Object)j, integer -> {
                if (monitor == null) {
                    return;
                }
                mc.m_91268_().m_85405_(integer == -1 ? Optional.empty() : Optional.of(monitor.m_84944_(integer.intValue())));
            });
        }

        public static Section add(Section section) {
            list.add(section);
            return section;
        }

        @Override
        public OptionsScreen build(Screen parent) {
            return this.sectionBuilder.apply(parent, this);
        }
    }
}

