/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.SaveOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class SaveRenderableList
extends RenderableVList {
    static final ResourceLocation ERROR_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/error_highlighted");
    static final ResourceLocation ERROR = FactoryAPI.createVanillaLocation((String)"world_list/error");
    static final ResourceLocation MARKED_JOIN_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/marked_join_highlighted");
    static final ResourceLocation MARKED_JOIN = FactoryAPI.createVanillaLocation((String)"world_list/marked_join");
    static final ResourceLocation WARNING_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/warning_highlighted");
    static final ResourceLocation WARNING = FactoryAPI.createVanillaLocation((String)"world_list/warning");
    static final ResourceLocation JOIN_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/join_highlighted");
    static final ResourceLocation JOIN = FactoryAPI.createVanillaLocation((String)"world_list/join");
    static final Logger LOGGER = LogUtils.getLogger();
    static final Component FROM_NEWER_TOOLTIP_1 = Component.m_237115_((String)"selectWorld.tooltip.fromNewerVersion1").m_130940_(ChatFormatting.RED);
    static final Component FROM_NEWER_TOOLTIP_2 = Component.m_237115_((String)"selectWorld.tooltip.fromNewerVersion2").m_130940_(ChatFormatting.RED);
    static final Component SNAPSHOT_TOOLTIP_1 = Component.m_237115_((String)"selectWorld.tooltip.snapshot1").m_130940_(ChatFormatting.GOLD);
    static final Component SNAPSHOT_TOOLTIP_2 = Component.m_237115_((String)"selectWorld.tooltip.snapshot2").m_130940_(ChatFormatting.GOLD);
    static final Component WORLD_LOCKED_TOOLTIP = Component.m_237115_((String)"selectWorld.locked").m_130940_(ChatFormatting.RED);
    static final Component WORLD_REQUIRES_CONVERSION = Component.m_237115_((String)"selectWorld.conversion.tooltip").m_130940_(ChatFormatting.RED);
    static final Component WORLD_EXPERIMENTAL = Component.m_237115_((String)"selectWorld.experimental");
    static final Component INCOMPATIBLE_VERSION_TOOLTIP = Component.m_237115_((String)"selectWorld.incompatible.tooltip").m_130940_(ChatFormatting.RED);
    protected Minecraft minecraft;
    private CompletableFuture<List<LevelSummary>> pendingLevels;
    @Nullable
    public List<LevelSummary> currentlyDisplayedLevels;
    private String filter;
    public boolean firstLoad = true;
    public static LoadingCache<LevelSummary, Long> sizeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LevelSummary, Long>(){

        public Long load(LevelSummary key) {
            return FileUtils.sizeOfDirectory((File)Minecraft.m_91087_().m_91392_().m_78257_().resolve(key.m_78358_()).toFile());
        }
    });
    public static LoadingCache<LevelSummary, FaviconTexture> iconCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LevelSummary, FaviconTexture>(){

        public FaviconTexture load(LevelSummary key) {
            boolean bl;
            Path iconFile = key.m_230875_();
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(iconFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (basicFileAttributes.isSymbolicLink()) {
                    List list = Minecraft.m_91087_().m_294312_().m_295373_(iconFile);
                    if (!list.isEmpty()) {
                        Legacy4J.LOGGER.warn("{}", (Object)ContentValidationException.m_289907_((Path)iconFile, (List)list));
                        iconFile = null;
                    } else {
                        basicFileAttributes = Files.readAttributes(iconFile, BasicFileAttributes.class, new LinkOption[0]);
                    }
                }
                if (!basicFileAttributes.isRegularFile()) {
                    iconFile = null;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                iconFile = null;
            }
            catch (IOException iOException) {
                Legacy4J.LOGGER.error("could not validate symlink", (Throwable)iOException);
                iconFile = null;
            }
            FaviconTexture icon = FaviconTexture.m_289210_((TextureManager)Minecraft.m_91087_().m_91097_(), (String)key.m_78358_());
            boolean bl2 = bl = iconFile != null && Files.isRegularFile(iconFile, new LinkOption[0]);
            if (bl) {
                try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                    icon.m_289201_(NativeImage.m_85058_((InputStream)inputStream));
                }
                catch (Throwable throwable) {
                    Legacy4J.LOGGER.error("Invalid icon for world {}", (Object)key.m_78358_(), (Object)throwable);
                }
            } else {
                icon.m_289218_();
            }
            return icon;
        }
    });

    public SaveRenderableList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = Minecraft.m_91087_();
        this.filter = "";
        this.reloadSaveList();
    }

    public static void resetIconCache() {
        iconCache.asMap().forEach((s, i) -> i.close());
        iconCache.invalidateAll();
    }

    @Nullable
    public List<LevelSummary> pollLevelsIgnoreErrors() {
        try {
            return this.pendingLevels.getNow(null);
        }
        catch (CancellationException | CompletionException runtimeException) {
            return null;
        }
    }

    void reloadSaveList() {
        this.pendingLevels = this.loadLevels();
    }

    public void updateFilter(String string) {
        if (this.currentlyDisplayedLevels != null && !string.equals(this.filter)) {
            this.fillLevels(string, this.currentlyDisplayedLevels);
        }
        this.filter = string;
    }

    private CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates levelCandidates;
        try {
            levelCandidates = this.minecraft.m_91392_().m_230833_();
        }
        catch (LevelStorageException levelStorageException) {
            Legacy4J.LOGGER.error("Couldn't load level list", (Throwable)levelStorageException);
            SaveRenderableList.handleLevelLoadFailure(this.minecraft, levelStorageException.m_230806_());
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelCandidates.m_230843_()) {
            this.getScreen(PlayGameScreen.class).tabList.selectedTab = 1;
            return CompletableFuture.completedFuture(List.of());
        }
        if (this.currentlyDisplayedLevels == null || this.currentlyDisplayedLevels.isEmpty()) {
            this.getScreen(PlayGameScreen.class).isLoading = true;
        }
        CompletableFuture completableFuture = this.minecraft.m_91392_().m_230813_(levelCandidates);
        completableFuture.thenAcceptAsync(l -> l.forEach(s -> sizeCache.refresh(s)));
        return completableFuture.exceptionally(throwable -> {
            this.minecraft.m_231412_(CrashReport.m_127521_((Throwable)throwable, (String)"Couldn't load level list"));
            return List.of();
        });
    }

    public void addCreationButtons() {
        if (!this.accessor.getBoolean("hasTabList", Boolean.valueOf(true)).booleanValue()) {
            this.getScreen(PlayGameScreen.class).creationList.renderables.forEach(this::addRenderable);
        }
    }

    public void fillLevels(String filter, List<LevelSummary> list) {
        this.getScreen(PlayGameScreen.class).isLoading = false;
        this.renderables.clear();
        this.addCreationButtons();
        if (list != null) {
            filter = filter.toLowerCase(Locale.ROOT);
            for (LevelSummary summary : list) {
                if (!this.filterAccepts(filter, summary)) continue;
                this.addRenderable((Renderable)new SaveButton(0, 0, 270, 30, summary));
            }
        }
        this.currentlyDisplayedLevels = list;
        this.getScreen().m_169407_(true);
    }

    @Override
    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        if (this.firstLoad) {
            this.addCreationButtons();
            this.firstLoad = false;
        }
        super.init(name, leftPos, topPos, listWidth, listHeight);
    }

    private boolean filterAccepts(String string, LevelSummary levelSummary) {
        return levelSummary.m_78361_().toLowerCase(Locale.ROOT).contains(string) || levelSummary.m_78358_().toLowerCase(Locale.ROOT).contains(string);
    }

    public static void handleLevelLoadFailure(Minecraft minecraft, Component component) {
        minecraft.m_91152_((Screen)new ConfirmationScreen((Screen)new TitleScreen(), (Component)Component.m_237115_((String)"selectWorld.futureworld.error.title"), component, b -> {}){

            @Override
            protected void addButtons() {
                this.okButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.ok"), b -> this.m_7379_()).m_252987_(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).m_253136_();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }
        });
    }

    public LevelSummary getLevelSummary(int saveButtonIndex) {
        if (this.currentlyDisplayedLevels != null && this.renderables.get(saveButtonIndex) instanceof AbstractButton && saveButtonIndex < this.currentlyDisplayedLevels.size()) {
            return this.currentlyDisplayedLevels.get(saveButtonIndex);
        }
        return null;
    }

    public void joinWorld(LevelSummary summary) {
        if (summary.m_305960_()) {
            if (summary instanceof LevelSummary.SymlinkLevelSummary) {
                this.minecraft.m_91152_(NoticeWithLinkScreen.m_293051_(() -> this.minecraft.m_91152_(this.getScreen())));
            } else {
                this.loadWorld(summary);
            }
        }
    }

    public void loadWorld(LevelSummary summary) {
        this.reloadSaveList();
        if (((Boolean)LegacyOptions.directSaveLoad.get()).booleanValue()) {
            Legacy4JClient.copySaveBtwSources(LoadSaveScreen.getSummaryAccess(Minecraft.m_91087_().m_91392_(), summary), Legacy4JClient.getLevelStorageSource());
            LoadSaveScreen.loadWorld(this.getScreen(), this.minecraft, Legacy4JClient.getLevelStorageSource(), summary);
        } else {
            this.minecraft.m_91152_((Screen)new LoadSaveScreen(this.getScreen(), summary, Legacy4JClient.getLevelStorageSource()){

                @Override
                public void completeLoad() {
                    if (((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
                        Legacy4JClient.copySaveBtwSources(LoadSaveScreen.getSummaryAccess(Minecraft.m_91087_().m_91392_(), this.summary), Legacy4JClient.currentWorldSource);
                    }
                    super.completeLoad();
                }
            });
        }
    }

    public void deleteSave(LevelSummary summary) {
        LevelStorageSource levelStorageSource = this.minecraft.m_91392_();
        String string = summary.m_78358_();
        try (LevelStorageSource.LevelStorageAccess levelStorageAccess = levelStorageSource.m_78260_(string);){
            levelStorageAccess.m_78311_();
        }
        catch (IOException iOException) {
            SystemToast.m_94866_((Minecraft)this.minecraft, (String)string);
            LOGGER.error("Failed to delete world {}", (Object)string, (Object)iOException);
        }
        this.reloadSaveList();
        this.minecraft.m_91152_(this.getScreen());
    }

    public class SaveButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final LevelSummary summary;

        public SaveButton(int i, int j, int k, int l, LevelSummary summary) {
            super(i, j, k, l, (Component)Component.m_237113_((String)summary.m_78361_()));
            this.summary = summary;
        }

        public void m_5691_() {
            SaveRenderableList.this.joinWorld(this.summary);
        }

        public void m_5716_(double d, double e) {
            if (this.summary.m_164916_()) {
                return;
            }
            boolean hoverIcon = ScreenUtil.isMouseOver(d, e, this.m_252754_() + 5, this.m_252907_() + 5, 20, this.f_93619_);
            if (hoverIcon || this.m_93696_()) {
                this.m_5691_();
            }
        }

        public boolean m_7933_(int i, int j, int k) {
            if (i == 79) {
                SaveRenderableList.this.minecraft.m_91152_((Screen)new SaveOptionsScreen(SaveRenderableList.this.getScreen(PlayGameScreen.class), this.summary));
                SaveRenderableList.this.getScreen().m_7522_((GuiEventListener)this);
                return true;
            }
            return super.m_7933_(i, j, k);
        }

        protected MutableComponent m_5646_() {
            MutableComponent component = Component.m_237110_((String)"narrator.select.world_info", (Object[])new Object[]{this.summary.m_78361_(), new Date(this.summary.m_78366_()).toString(), this.summary.m_78376_()});
            if (this.summary.m_78375_()) {
                component = CommonComponents.m_267603_((Component[])new Component[]{component, WORLD_LOCKED_TOOLTIP});
            }
            if (this.summary.m_246454_()) {
                component = CommonComponents.m_267603_((Component[])new Component[]{component, WORLD_EXPERIMENTAL});
            }
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{component});
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            RenderSystem.enableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(((FaviconTexture)iconCache.getUnchecked((Object)this.summary)).m_289196_(), this.m_252754_() + 5, this.m_252907_() + 5, 0.0f, 0.0f, 20, 20, 20, 20);
            RenderSystem.disableBlend();
            if (((Boolean)SaveRenderableList.this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || this.f_93622_) {
                ResourceLocation resourceLocation4;
                guiGraphics.m_280509_(this.m_252754_() + 5, this.m_252907_() + 5, this.m_252754_() + 25, this.m_252907_() + 25, -1601138544);
                boolean hoverIcon = ScreenUtil.isMouseOver(i, j, this.m_252754_() + 5, this.m_252907_() + 5, 20, this.f_93619_);
                ResourceLocation resourceLocation = hoverIcon ? JOIN_HIGHLIGHTED : JOIN;
                ResourceLocation resourceLocation2 = hoverIcon ? WARNING_HIGHLIGHTED : WARNING;
                ResourceLocation resourceLocation3 = hoverIcon ? ERROR_HIGHLIGHTED : ERROR;
                ResourceLocation resourceLocation5 = resourceLocation4 = hoverIcon ? MARKED_JOIN_HIGHLIGHTED : MARKED_JOIN;
                if (this.summary instanceof LevelSummary.SymlinkLevelSummary || this.summary instanceof LevelSummary.CorruptedLevelSummary) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation4, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    return;
                }
                if (this.summary.m_78375_()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    if (hoverIcon) {
                        SaveRenderableList.this.getScreen().m_257959_(SaveRenderableList.this.minecraft.f_91062_.m_92923_((FormattedText)WORLD_LOCKED_TOOLTIP, 175));
                    }
                } else if (this.summary.m_193020_()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    if (hoverIcon) {
                        SaveRenderableList.this.getScreen().m_257959_(SaveRenderableList.this.minecraft.f_91062_.m_92923_((FormattedText)WORLD_REQUIRES_CONVERSION, 175));
                    }
                } else if (!this.summary.m_193021_()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    if (hoverIcon) {
                        SaveRenderableList.this.getScreen().m_257959_(SaveRenderableList.this.minecraft.f_91062_.m_92923_((FormattedText)INCOMPATIBLE_VERSION_TOOLTIP, 175));
                    }
                } else if (this.summary.m_306713_()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation4, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    if (this.summary.m_305825_()) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation3, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                        if (hoverIcon) {
                            SaveRenderableList.this.getScreen().m_257959_((List)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.m_7532_(), (Object)FROM_NEWER_TOOLTIP_2.m_7532_()));
                        }
                    } else if (!SharedConstants.m_183709_().m_132498_()) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation2, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                        if (hoverIcon) {
                            SaveRenderableList.this.getScreen().m_257959_((List)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.m_7532_(), (Object)SNAPSHOT_TOOLTIP_2.m_7532_()));
                        }
                    }
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(resourceLocation, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                }
            }
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
            ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 35, this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), j, true);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.m_93696_() ? LegacyComponents.SAVE_OPTIONS : ControlTooltip.getSelectAction((GuiEventListener)this, c));
        }
    }
}

