/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.LanServer;
import net.minecraft.client.server.LanServerDetection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.ServerEditScreen;
import wily.legacy.client.screen.ServerOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class ServerRenderableList
extends RenderableVList {
    static final ResourceLocation INCOMPATIBLE = FactoryAPI.createVanillaLocation((String)"server_list/incompatible");
    static final ResourceLocation UNREACHABLE = FactoryAPI.createVanillaLocation((String)"server_list/unreachable");
    static final ResourceLocation PING_1 = FactoryAPI.createVanillaLocation((String)"server_list/ping_1");
    static final ResourceLocation PING_2 = FactoryAPI.createVanillaLocation((String)"server_list/ping_2");
    static final ResourceLocation PING_3 = FactoryAPI.createVanillaLocation((String)"server_list/ping_3");
    static final ResourceLocation PING_4 = FactoryAPI.createVanillaLocation((String)"server_list/ping_4");
    static final ResourceLocation PING_5 = FactoryAPI.createVanillaLocation((String)"server_list/ping_5");
    static final ResourceLocation PINGING_1 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_1");
    static final ResourceLocation PINGING_2 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_2");
    static final ResourceLocation PINGING_3 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_3");
    static final ResourceLocation PINGING_4 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_4");
    static final ResourceLocation PINGING_5 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_5");
    protected static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final ResourceLocation ICON_MISSING = FactoryAPI.createVanillaLocation((String)"textures/misc/unknown_server.png");
    static final Component SCANNING_LABEL = Component.m_237115_((String)"lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130938_(style -> style.m_178520_(-65536));
    static final Component CANT_CONNECT_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130938_(style -> style.m_178520_(-65536));
    static final Component INCOMPATIBLE_STATUS = Component.m_237115_((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_STATUS = Component.m_237115_((String)"multiplayer.status.no_connection");
    static final Component PINGING_STATUS = Component.m_237115_((String)"multiplayer.status.pinging");
    static final Component ONLINE_STATUS = Component.m_237115_((String)"multiplayer.status.online");
    private static final Component LAN_SERVER_HEADER = Component.m_237115_((String)"lanServer.title");
    private static final Component HIDDEN_ADDRESS_TEXT = Component.m_237115_((String)"selectServer.hiddenAddress");
    protected final Minecraft minecraft;
    public final ServerList servers;
    @Nullable
    public LanServerDetection.LanServerDetector lanServerDetector;
    public final LanServerDetection.LanServerList lanServerList;
    public List<LanServer> lanServers;

    public ServerRenderableList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = Minecraft.m_91087_();
        this.servers = new ServerList(this.minecraft);
        this.servers.m_105431_();
        this.lanServerList = new LanServerDetection.LanServerList();
        this.updateServers();
    }

    @Override
    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        try {
            this.lanServerDetector = new LanServerDetection.LanServerDetector(this.lanServerList);
            this.lanServerDetector.start();
        }
        catch (Exception exception) {
            Legacy4J.LOGGER.warn("Unable to start LAN server detection: {}", (Object)exception.getMessage());
        }
        super.init(name, leftPos, topPos, listWidth, listHeight);
    }

    public boolean hasOnlineFriends() {
        return false;
    }

    public void added() {
    }

    public void removed() {
        if (this.lanServerDetector != null) {
            this.lanServerDetector.interrupt();
            this.lanServerDetector = null;
        }
    }

    private Component getMultiplayerDisabledReason() {
        if (this.minecraft.m_91400_()) {
            return null;
        }
        if (this.minecraft.m_294837_()) {
            return Component.m_237115_((String)"title.multiplayer.disabled.banned.name");
        }
        BanDetails banDetails = this.minecraft.m_239210_();
        if (banDetails != null) {
            return banDetails.expires() != null ? Component.m_237115_((String)"title.multiplayer.disabled.banned.temporary") : Component.m_237115_((String)"title.multiplayer.disabled.banned.permanent");
        }
        return Component.m_237115_((String)"title.multiplayer.disabled");
    }

    public static void drawIcon(GuiGraphics guiGraphics, int i, int j, ResourceLocation resourceLocation) {
        RenderSystem.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(resourceLocation, i + 5, j + 5, 0.0f, 0.0f, 20, 20, 20, 20);
        RenderSystem.disableBlend();
    }

    public void updateServers() {
        this.renderables.clear();
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/add_server"), (Component)Component.m_237115_((String)"legacy.menu.add_server"), c -> this.minecraft.m_91152_((Screen)new ServerEditScreen(this.getScreen(PlayGameScreen.class), new ServerData(I18n.m_118938_((String)"selectServer.defaultName", (Object[])new Object[0]), "", ServerData.Type.OTHER), true)));
        Component component = this.getMultiplayerDisabledReason();
        Tooltip tooltip = component != null ? Tooltip.m_257550_((Component)component) : null;
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/realms"), (Component)Component.m_237115_((String)"menu.online"), b -> this.minecraft.m_91152_((Screen)new RealmsMainScreen(this.getScreen())), tooltip);
        for (int i = 0; i < this.servers.m_105445_(); ++i) {
            this.addRenderable((Renderable)new ServerButton(0, 0, 0, 30, i));
        }
        this.updateLANServers();
    }

    public void updateLANServers() {
        if (this.lanServers != null) {
            for (final LanServer lanServer : this.lanServers) {
                AbstractButton lanButton = new AbstractButton(0, 0, 0, 30, (Component)Component.m_237113_((String)lanServer.m_120078_())){

                    protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                        guiGraphics.m_280614_(ServerRenderableList.this.minecraft.f_91062_, LAN_SERVER_HEADER, this.m_252754_() + 32 + 3, this.m_252907_() + 1, 0xFFFFFF, false);
                        guiGraphics.m_280056_(ServerRenderableList.this.minecraft.f_91062_, lanServer.m_120078_(), this.m_252754_() + 32 + 3, this.m_252907_() + 12, -8355712, false);
                        if (ServerRenderableList.this.minecraft.f_91066_.f_92124_) {
                            guiGraphics.m_280614_(ServerRenderableList.this.minecraft.f_91062_, HIDDEN_ADDRESS_TEXT, this.m_252754_() + 32 + 3, this.m_252907_() + 12 + 11, 0x303030, false);
                        } else {
                            guiGraphics.m_280056_(ServerRenderableList.this.minecraft.f_91062_, lanServer.m_120079_(), this.m_252754_() + 32 + 3, this.m_252907_() + 12 + 11, 0x303030, false);
                        }
                    }

                    public void m_5691_() {
                        if (this.m_93696_()) {
                            ServerRenderableList.this.joinLanServer(lanServer);
                        }
                    }

                    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                        this.m_168802_(narrationElementOutput);
                    }
                };
                this.addRenderable((Renderable)lanButton);
                if (!this.getScreen().f_96540_.contains(lanButton)) continue;
                this.minecraft.m_240477_().m_263195_((Component)Component.m_237110_((String)"multiplayer.lan.server_found", (Object[])new Object[]{Component.m_237119_().m_7220_(LAN_SERVER_HEADER).m_7220_(CommonComponents.f_263701_).m_130946_(lanServer.m_120078_())}));
            }
        } else {
            this.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)30, r -> (guiGraphics, i, j, f) -> {
                int n = r.y;
                int n2 = r.height;
                Objects.requireNonNull(this.minecraft.f_91062_);
                int p = n + (n2 - 9) / 2;
                guiGraphics.m_280614_(this.minecraft.f_91062_, SCANNING_LABEL, r.x + (this.listWidth - this.minecraft.f_91062_.m_92852_((FormattedText)SCANNING_LABEL)) / 2, p, 0xFFFFFF, false);
                String string = LoadingDotsText.m_232744_((long)Util.m_137550_());
                Font font = this.minecraft.f_91062_;
                int n3 = r.x + (this.listWidth - this.minecraft.f_91062_.m_92895_(string)) / 2;
                Objects.requireNonNull(this.minecraft.f_91062_);
                guiGraphics.m_280056_(font, string, n3, p + 9, -8355712, false);
            }));
        }
    }

    public void joinSelectedServer() {
        Renderable r;
        int i;
        GuiEventListener guiEventListener = this.getScreen().m_7222_();
        if (guiEventListener instanceof Renderable && (i = this.renderables.indexOf(r = (Renderable)guiEventListener)) > 0) {
            if (this.servers.m_105445_() > i) {
                this.join(this.servers.m_105432_(i));
            } else if (this.lanServers != null) {
                this.joinLanServer(this.lanServers.get(i - this.servers.m_105445_()));
            }
        }
    }

    private void joinLanServer(LanServer lanServer) {
        this.join(new ServerData(lanServer.m_120078_(), lanServer.m_120079_(), ServerData.Type.LAN));
    }

    private void join(ServerData serverData) {
        ConnectScreen.m_278792_((Screen)this.getScreen(), (Minecraft)this.minecraft, (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData, (boolean)false);
    }

    public class ServerButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final ServerData server;
        public final int serverIndex;
        private byte @Nullable [] lastIconBytes;
        private boolean showOnlinePlayersTooltip;
        @Nullable
        private ResourceLocation statusIcon;
        @Nullable
        private Component statusIconTooltip;
        public final FaviconTexture icon;

        public ServerButton(int i, int j, int k, int l, int serverIndex) {
            super(i, j, k, l, (Component)Component.m_237113_((String)ServerRenderableList.this.servers.m_105432_((int)serverIndex).f_105362_));
            this.serverIndex = serverIndex;
            this.server = ServerRenderableList.this.servers.m_105432_(serverIndex);
            this.icon = FaviconTexture.m_289187_((TextureManager)ServerRenderableList.this.minecraft.m_91097_(), (String)this.server.f_105363_);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            byte[] bs;
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
            if (!this.server.f_105369_) {
                this.server.f_105369_ = true;
                this.server.f_105366_ = -2L;
                this.server.f_105365_ = CommonComponents.f_237098_;
                this.server.f_105364_ = CommonComponents.f_237098_;
                THREAD_POOL.submit(() -> {
                    try {
                        ServerRenderableList.this.getScreen(PlayGameScreen.class).getPinger().m_105459_(this.server, () -> ServerRenderableList.this.minecraft.execute(this::updateServerList));
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.server.f_105366_ = -1L;
                        this.server.f_105365_ = CANT_RESOLVE_TEXT;
                    }
                    catch (Exception exception) {
                        this.server.f_105366_ = -1L;
                        this.server.f_105365_ = CANT_CONNECT_TEXT;
                    }
                });
            }
            this.refreshStatus();
            guiGraphics.m_280430_(ServerRenderableList.this.minecraft.f_91062_, this.m_6035_(), this.m_252754_() + 32 + 3, this.m_252907_() + 3, 0xFFFFFF);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 35), (float)(this.m_252907_() + 10), 0.0f);
            guiGraphics.m_280168_().m_85841_(0.6666667f, 0.6666667f, 0.6666667f);
            List list = ServerRenderableList.this.minecraft.f_91062_.m_92923_((FormattedText)this.server.f_105365_, Math.max(this.f_93618_ - 36, ServerRenderableList.this.minecraft.f_91062_.m_92852_((FormattedText)this.server.f_105365_) / 2 + 20));
            for (int p = 0; p < Math.min(2, list.size()); ++p) {
                Font font = ServerRenderableList.this.minecraft.f_91062_;
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)list.get(p);
                Objects.requireNonNull(ServerRenderableList.this.minecraft.f_91062_);
                Objects.requireNonNull(ServerRenderableList.this.minecraft.f_91062_);
                ScreenUtil.renderScrollingString(guiGraphics, font, formattedCharSequence, 0, 9 * p, this.f_93618_ - 36, 11 + 9 * p, -8355712, false, ServerRenderableList.this.minecraft.f_91062_.m_92724_((FormattedCharSequence)list.get(p)) * 2 / 3);
            }
            guiGraphics.m_280168_().m_85849_();
            Component component = !this.isCompatible() ? this.server.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.server.f_105364_;
            int q = ServerRenderableList.this.minecraft.f_91062_.m_92852_((FormattedText)component);
            guiGraphics.m_280614_(ServerRenderableList.this.minecraft.f_91062_, component, this.m_252754_() + this.f_93618_ - q - 15 - 2, this.m_252907_() + 3, -8355712, false);
            if (this.pingCompleted()) {
                int p = (int)(Util.m_137550_() / 100L + (long)(this.serverIndex * 2) & 7L);
                if (p > 4) {
                    p = 8 - p;
                }
                switch (p) {
                    default: {
                        ResourceLocation resourceLocation = PINGING_1;
                        break;
                    }
                    case 1: {
                        ResourceLocation resourceLocation = PINGING_2;
                        break;
                    }
                    case 2: {
                        ResourceLocation resourceLocation = PINGING_3;
                        break;
                    }
                    case 3: {
                        ResourceLocation resourceLocation = PINGING_4;
                        break;
                    }
                    case 4: {
                        ResourceLocation resourceLocation = this.statusIcon = PINGING_5;
                    }
                }
            }
            if (this.statusIcon != null) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.statusIcon, this.m_252754_() + this.f_93618_ - 15, this.m_252907_() + 3, 10, 8);
            }
            if (!Arrays.equals(bs = this.server.m_271916_(), this.lastIconBytes)) {
                if (this.uploadServerIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.server.m_271813_(null);
                    this.updateServerList();
                }
            }
            ServerRenderableList.drawIcon(guiGraphics, this.m_252754_(), this.m_252907_(), this.icon.m_289196_());
            int s = mouseX - this.m_252754_();
            int t = mouseY - this.m_252907_();
            if (this.statusIconTooltip != null && s >= this.f_93618_ - 15 && s <= this.f_93618_ - 5 && t >= 2 && t <= 10) {
                guiGraphics.m_280557_(ServerRenderableList.this.minecraft.f_91062_, this.statusIconTooltip, mouseX, mouseY);
            } else if (this.showOnlinePlayersTooltip && s >= this.f_93618_ - q - 15 - 2 && s <= this.f_93618_ - 15 - 2 && t >= 2 && t <= 10) {
                guiGraphics.m_280666_(ServerRenderableList.this.minecraft.f_91062_, this.server.f_105370_, mouseX, mouseY);
            }
            if (((Boolean)ServerRenderableList.this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || this.f_93622_) {
                guiGraphics.m_280509_(this.m_252754_() + 5, this.m_252907_() + 5, this.m_252754_() + 25, this.m_252907_() + 25, -1601138544);
                int u = mouseX - this.m_252754_();
                int v = mouseY - this.m_252907_();
                if (u < 32 && u > 16) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN_HIGHLIGHTED, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                }
                if (this.serverIndex > 0) {
                    if (u < 16 && v < 16) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_UP_HIGHLIGHTED, this.m_252754_(), this.m_252907_(), 32, 32);
                    } else {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_UP, this.m_252754_(), this.m_252907_(), 32, 32);
                    }
                }
                if (this.serverIndex < ServerRenderableList.this.getScreen(PlayGameScreen.class).getServers().m_105445_() - 1) {
                    if (u < 16 && v > 16) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_DOWN_HIGHLIGHTED, this.m_252754_(), this.m_252907_(), 32, 32);
                    } else {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_DOWN, this.m_252754_(), this.m_252907_(), 32, 32);
                    }
                }
            }
        }

        public boolean pingCompleted() {
            return this.server.f_105369_ && this.server.f_105366_ != -2L;
        }

        public void refreshStatus() {
            this.showOnlinePlayersTooltip = false;
            if (!this.isCompatible()) {
                this.statusIcon = INCOMPATIBLE;
                this.statusIconTooltip = INCOMPATIBLE_STATUS;
                this.showOnlinePlayersTooltip = true;
            } else if (this.pingCompleted()) {
                ResourceLocation resourceLocation = this.server.f_105366_ < 0L ? UNREACHABLE : (this.server.f_105366_ < 150L ? PING_5 : (this.server.f_105366_ < 300L ? PING_4 : (this.server.f_105366_ < 600L ? PING_3 : (this.statusIcon = this.server.f_105366_ < 1000L ? PING_2 : PING_1))));
                if (this.server.f_105366_ < 0L) {
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                } else {
                    this.statusIconTooltip = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.server.f_105366_});
                    this.showOnlinePlayersTooltip = true;
                }
            } else {
                this.statusIcon = PING_1;
                this.statusIconTooltip = PINGING_STATUS;
            }
        }

        private boolean isCompatible() {
            return this.server.f_105367_ == SharedConstants.m_183709_().m_132495_();
        }

        public void updateServerList() {
            ServerRenderableList.this.getScreen(PlayGameScreen.class).getServers().m_105442_();
        }

        private boolean uploadServerIcon(@Nullable byte[] bs) {
            if (bs == null) {
                this.icon.m_289218_();
            } else {
                try {
                    this.icon.m_289201_(NativeImage.m_271751_((byte[])bs));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.server.f_105362_, this.server.f_105363_, throwable});
                    return false;
                }
            }
            return true;
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
        }

        public void m_5716_(double d, double e) {
            double f = d - (double)this.m_252754_();
            double g = e - (double)this.m_252907_();
            if (f <= 32.0) {
                if (f < 16.0 && g < 16.0 && this.serverIndex > 0) {
                    this.swap(this.serverIndex, this.serverIndex - 1);
                    return;
                }
                if (f < 16.0 && g > 16.0 && this.serverIndex < ServerRenderableList.this.servers.m_105445_() - 1) {
                    this.swap(this.serverIndex, this.serverIndex + 1);
                    return;
                }
                ServerRenderableList.this.join(this.server);
            } else {
                super.m_5716_(d, e);
            }
        }

        public void m_5691_() {
            if (this.m_93696_()) {
                ServerRenderableList.this.join(this.server);
            }
        }

        private void swap(int i, int j) {
            Object e;
            ServerRenderableList.this.servers.m_105434_(i, j);
            ServerRenderableList.this.updateServers();
            ServerRenderableList.this.accessor.reloadUI();
            if (j < ServerRenderableList.this.renderables.size() && (e = ServerRenderableList.this.renderables.get(j)) instanceof GuiEventListener) {
                GuiEventListener l = (GuiEventListener)e;
                ServerRenderableList.this.getScreen().m_7522_(l);
            }
        }

        public boolean m_7933_(int i, int j, int k) {
            if (Screen.m_96638_() && (i == 264 && this.serverIndex < ServerRenderableList.this.servers.m_105445_() - 1 || i == 265 && this.serverIndex > 0)) {
                this.swap(this.serverIndex, i == 264 ? this.serverIndex + 1 : this.serverIndex - 1);
                return true;
            }
            if (i == 79) {
                ServerRenderableList.this.minecraft.m_91152_((Screen)new ServerOptionsScreen(ServerRenderableList.this.getScreen(PlayGameScreen.class), this.server));
                ServerRenderableList.this.getScreen().m_7522_((GuiEventListener)this);
                return true;
            }
            return super.m_7933_(i, j, k);
        }

        protected MutableComponent m_5646_() {
            MutableComponent mutableComponent = Component.m_237119_();
            mutableComponent.m_7220_((Component)Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.server.f_105362_}));
            mutableComponent.m_7220_(CommonComponents.f_178389_);
            if (!this.isCompatible()) {
                mutableComponent.m_7220_(INCOMPATIBLE_STATUS);
                mutableComponent.m_7220_(CommonComponents.f_178389_);
                mutableComponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.server.f_105368_}));
                mutableComponent.m_7220_(CommonComponents.f_178389_);
                mutableComponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.f_105365_}));
            } else if (this.server.f_105366_ < 0L) {
                mutableComponent.m_7220_(NO_CONNECTION_STATUS);
            } else if (!this.pingCompleted()) {
                mutableComponent.m_7220_(PINGING_STATUS);
            } else {
                mutableComponent.m_7220_(ONLINE_STATUS);
                mutableComponent.m_7220_(CommonComponents.f_178389_);
                mutableComponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.server.f_105366_}));
                mutableComponent.m_7220_(CommonComponents.f_178389_);
                mutableComponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.f_105365_}));
                if (this.server.f_263840_ != null) {
                    mutableComponent.m_7220_(CommonComponents.f_178389_);
                    mutableComponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.server.f_263840_.f_271178_(), this.server.f_263840_.f_271503_()}));
                    mutableComponent.m_7220_(CommonComponents.f_178389_);
                    mutableComponent.m_7220_(ComponentUtils.m_178433_((Collection)this.server.f_105370_, (Component)Component.m_237113_((String)", ")));
                }
            }
            return mutableComponent;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.m_93696_() ? LegacyComponents.SERVER_OPTIONS : ControlTooltip.getSelectAction((GuiEventListener)this, c));
        }
    }
}

