/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import wily.factoryapi.base.Stocker;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.ScreenUtil;

public class TabList
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final List<LegacyTabButton> tabButtons;
    public int selectedTab = 0;
    boolean focused = false;

    public TabList() {
        this(new ArrayList<LegacyTabButton>());
    }

    public TabList(List<LegacyTabButton> list) {
        this.tabButtons = list;
    }

    public LegacyTabButton addTabButton(LegacyTabButton button) {
        this.tabButtons.add(button);
        return button;
    }

    public LegacyTabButton addTabButton(int x, int y, int width, int height, int type, Function<LegacyTabButton, Renderable> icon, Component message, Tooltip tooltip, Consumer<LegacyTabButton> onPress) {
        return this.addTabButton(new LegacyTabButton(x, y, width, height, type, icon, message, tooltip, t -> {
            int index = this.tabButtons.indexOf(t);
            if (this.selectedTab != index) {
                this.selectedTab = index;
                onPress.accept((LegacyTabButton)((Object)t));
            }
        }));
    }

    public LegacyTabButton addTabButton(int height, int type, Function<LegacyTabButton, Renderable> icon, Component component, Consumer<LegacyTabButton> onPress) {
        return this.addTabButton(0, 0, 0, height, type, icon, component, null, onPress);
    }

    public TabList add(int x, int y, int width, int height, int type, Function<LegacyTabButton, Renderable> icon, Component message, Tooltip tooltip, Consumer<LegacyTabButton> onPress) {
        this.addTabButton(x, y, width, height, type, icon, message, tooltip, onPress);
        return this;
    }

    public TabList add(int height, int type, Function<LegacyTabButton, Renderable> icon, Component component, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, 0, height, type, icon, component, null, onPress);
    }

    public TabList add(int x, int y, int width, int height, int type, Component message, Consumer<LegacyTabButton> onPress) {
        return this.add(x, y, width, height, type, null, message, null, onPress);
    }

    public TabList add(int x, int y, int height, int type, Component message, Consumer<LegacyTabButton> onPress) {
        return this.add(x, y, 0, height, type, null, message, null, onPress);
    }

    public TabList add(int height, int type, Component message, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, 0, height, type, null, message, null, onPress);
    }

    public void init(int leftPos, int topPos, int width) {
        this.init(leftPos, topPos, width, (t, i) -> {});
    }

    public void init(int leftPos, int topPos, int width, BiConsumer<LegacyTabButton, Integer> buttonManager) {
        this.init((b, i) -> {
            b.m_93674_(width / this.tabButtons.size());
            b.m_252865_(leftPos + i);
            b.m_253211_(topPos);
            buttonManager.accept((LegacyTabButton)((Object)b), (Integer)i);
        }, false);
    }

    public void init(BiConsumer<LegacyTabButton, Integer> buttonManager, boolean vertical) {
        int position = 0;
        for (LegacyTabButton b : this.tabButtons) {
            buttonManager.accept(b, position);
            position += vertical ? b.m_93694_() : b.m_5711_();
        }
    }

    public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
        for (int index = 0; index < this.tabButtons.size(); ++index) {
            LegacyTabButton tabButton = this.tabButtons.get(index);
            tabButton.selected = this.selectedTab == index;
            tabButton.m_88315_(graphics, i, j, f);
        }
    }

    public void resetSelectedTab() {
        if (!this.tabButtons.isEmpty()) {
            this.selectedTab = -1;
            this.tabButtons.get(0).m_5691_();
        }
    }

    public void m_93692_(boolean bl) {
        this.focused = bl;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public boolean m_7933_(int i, int j, int k) {
        return this.tabButtons.stream().anyMatch(t -> t.m_198029_() && t.m_7933_(i, j, k));
    }

    public boolean controlTab(int i) {
        return this.controlTab(i, 91, 93);
    }

    public boolean directionalControlTab(int i) {
        return this.controlTab(i, 263, 262);
    }

    public boolean controlTab(int i, int leftButton, int rightButton) {
        return this.controlTab(i == leftButton, i == rightButton);
    }

    public boolean controlTab(boolean left, boolean right) {
        if (!left && !right || this.tabButtons.isEmpty()) {
            return false;
        }
        Optional<LegacyTabButton> opt = this.tabButtons.stream().filter(AbstractWidget::m_142518_).min(Comparator.comparingInt(t -> {
            int diff = this.tabButtons.indexOf(t) - this.selectedTab;
            return left ? (diff < 0 ? -diff : this.tabButtons.size() * 2 - diff) : (diff > 0 ? diff : this.tabButtons.size() * 2 + diff);
        }));
        if (opt.isPresent() && this.tabButtons.indexOf((Object)opt.get()) != this.selectedTab) {
            opt.get().m_5691_();
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        return false;
    }

    protected boolean controlPage(Stocker.Sizeable page, boolean left, boolean right) {
        if ((left || right) && page.max > 0) {
            int lastPage = (Integer)page.get();
            page.add(left ? -1 : 1);
            if (lastPage != (Integer)page.get()) {
                this.resetSelectedTab();
                return true;
            }
        }
        return false;
    }

    public void numberControlTab(int i) {
        if (i <= 57 && i > 48 && i - 49 < this.tabButtons.size()) {
            this.tabButtons.get(i - 49).m_5691_();
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
        }
    }

    public boolean m_6375_(double d, double e, int i) {
        return !this.tabButtons.stream().filter(t -> t.m_6375_(d, e, i)).toList().isEmpty();
    }

    public boolean m_5953_(double d, double e) {
        return !this.tabButtons.stream().filter(t -> t.m_5953_(d, e)).toList().isEmpty();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.tabButtons.stream().map(AbstractWidget::m_142684_).max(Comparator.naturalOrder()).orElse(NarratableEntry.NarrationPriority.NONE);
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        Optional<LegacyTabButton> optional = this.tabButtons.stream().filter(AbstractWidget::m_274382_).findFirst().or(() -> Optional.ofNullable(this.tabButtons.get(this.selectedTab)));
        optional.ifPresent(tabButton -> {
            narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.tab", (Object[])new Object[]{this.selectedTab + 1, this.tabButtons.size()}));
            tabButton.m_142291_(narrationElementOutput);
        });
        if (this.m_93696_()) {
            narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.tab_navigation.usage"));
        }
    }

    public static interface Access {
        public TabList getTabList();
    }
}

