/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldDataConfiguration;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.DatapackRepositoryAccessor;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class WorldMoreOptionsScreen
extends PanelVListScreen
implements ControlTooltip.Event,
DatapackRepositoryAccessor {
    protected List<FormattedCharSequence> tooltipBoxLabel;
    protected ScrollableRenderer scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
    protected final TabList tabList = new TabList().add(29, 0, (Component)Component.m_237115_((String)"createWorld.tab.world.title"), t -> this.m_232761_()).add(29, 2, (Component)Component.m_237115_((String)"legacy.menu.game_options"), t -> this.m_232761_());
    protected final RenderableVList gameRenderables = new RenderableVList(this.accessor);
    protected final Panel tooltipBox = Panel.tooltipBoxOf(this.panel, 188);
    protected Runnable onClose;
    public static final Component ENTER_SEED = Component.m_237115_((String)"selectWorld.enterSeed");
    public static final Component SEED_INFO = Component.m_237115_((String)"selectWorld.seedInfo");

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> this.tabList.selectedTab == 0 ? LegacyComponents.GAME_OPTIONS : LegacyComponents.WORLD_OPTIONS);
    }

    public WorldMoreOptionsScreen(CreateWorldScreen parent, Bearer<Boolean> trustPlayers) {
        super((Screen)parent, 244, 199, (Component)Component.m_237115_((String)"createWorld.tab.more.title"));
        this.onClose = () -> {};
        this.renderableVLists.add(this.gameRenderables);
        this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.createDrawString((Component)ENTER_SEED, (int)0, (int)1, (int)2, (int)9, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), (boolean)false));
        EditBox editBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 308, 20, ENTER_SEED){

            protected MutableComponent m_5646_() {
                return super.m_5646_().m_7220_(CommonComponents.f_178389_).m_7220_(SEED_INFO);
            }
        };
        editBox.m_94144_(parent.m_267748_().m_267707_());
        editBox.m_94151_(string -> parent.m_267748_().m_267759_(editBox.m_94155_()));
        this.renderableVList.addRenderable((Renderable)editBox);
        this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, SEED_INFO, r.x + 1, r.y + 2, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false)));
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.m_267748_().m_267615_(), b -> Component.m_237115_((String)"selectWorld.mapFeatures"), b -> Tooltip.m_257550_((Component)Component.m_237115_((String)"selectWorld.mapFeatures.info")), b -> parent.m_267748_().m_267770_(b.selected)));
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.m_267748_().m_267593_(), b -> Component.m_237115_((String)"selectWorld.bonusItems"), b -> null, b -> parent.m_267748_().m_267666_(b.selected)));
        this.renderableVList.addRenderable((Renderable)new LegacySliderButton<WorldCreationUiState.WorldTypeEntry>(0, 0, 0, 16, s -> s.getDefaultMessage((Component)Component.m_237115_((String)"selectWorld.mapType"), parent.m_267748_().m_267828_().m_267572_()), b -> parent.m_267748_().m_267828_().m_267589_() ? Tooltip.m_257550_((Component)Component.m_237115_((String)"generator.minecraft.amplified.info")) : null, parent.m_267748_().m_267828_(), () -> WorldMoreOptionsScreen.m_96639_() ? parent.m_267748_().m_267674_() : parent.m_267748_().m_267815_(), b -> parent.m_267748_().m_267576_((WorldCreationUiState.WorldTypeEntry)b.objectValue)));
        Button customizeButton = Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.customizeType"), button -> {
            PresetEditor presetEditor = parent.m_267748_().m_267744_();
            if (presetEditor != null) {
                this.f_96541_.m_91152_(presetEditor.m_232976_(parent, parent.m_267748_().m_267573_()));
            }
        }).m_253136_();
        parent.m_267748_().m_267755_(s -> {
            customizeButton.f_93623_ = !s.m_267735_() && s.m_267744_() != null;
        });
        this.renderableVList.addRenderable((Renderable)customizeButton);
        this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> {}));
        TickBox hostPrivileges = new TickBox(0, 0, parent.m_267748_().m_267823_(), b -> Component.m_237115_((String)"selectWorld.allowCommands"), b -> Tooltip.m_257550_((Component)Component.m_237115_((String)"selectWorld.allowCommands.info")), b -> parent.m_267748_().m_267601_(b.selected));
        parent.m_267748_().m_267755_(s -> {
            hostPrivileges.f_93623_ = !s.m_267735_() && !s.m_267790_();
        });
        GameRules gameRules = parent.m_267748_().m_267721_();
        Pair pair = parent.m_267637_(parent.m_267748_().m_267573_().f_243842_());
        if (pair != null) {
            this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"selectWorld.experiments"), r.x + 1, r.y + 2, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false)));
            PackRepository dataRepository = (PackRepository)pair.getSecond();
            ArrayList selectedExperiments = new ArrayList(dataRepository.m_10523_());
            dataRepository.m_10519_().forEach(p -> {
                if (p.m_10453_() != PackSource.f_244201_) {
                    return;
                }
                String id = "dataPack." + p.m_10446_() + ".name";
                MutableComponent name = Language.m_128107_().m_6722_(id) ? Component.m_237115_((String)id) : p.m_10429_();
                this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, selectedExperiments.contains(p.m_10446_()), arg_0 -> WorldMoreOptionsScreen.lambda$new$28((Component)name, arg_0), b -> new MultilineTooltip(this.tooltipBox.m_5711_() - 10, p.m_10442_()), b -> {
                    if (b.selected && !selectedExperiments.contains(p.m_10446_())) {
                        selectedExperiments.add(p.m_10446_());
                    } else if (!b.selected) {
                        selectedExperiments.remove(p.m_10446_());
                    }
                }));
            });
            this.onClose = () -> {
                dataRepository.m_10509_((Collection)selectedExperiments);
                parent.m_269443_(dataRepository, false, w -> this.f_96541_.m_91152_((Screen)this));
            };
        }
        this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.dataPacks"), button -> this.openDataPackSelectionScreen(parent, parent.m_267748_().m_267573_().f_243842_())).m_253136_());
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, (Boolean)trustPlayers.get(), b -> Component.m_237115_((String)"legacy.menu.selectWorld.trust_players"), b -> null, t -> trustPlayers.set((Object)t.selected)));
        this.addGameRulesOptions(this.renderableVList, gameRules, k -> k.m_46332_() == GameRules.Category.UPDATES);
        this.gameRenderables.addRenderable((Renderable)hostPrivileges);
        for (GameRules.Category value : GameRules.Category.values()) {
            if (value == GameRules.Category.UPDATES) continue;
            this.addGameRulesOptions(this.gameRenderables, gameRules, k -> k.m_46332_() == value);
        }
        parent.m_267748_().m_267758_();
    }

    public void addGameRulesOptions(final RenderableVList list, final GameRules gameRules, final Predicate<GameRules.Key<?>> allowGamerule) {
        GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public void m_6891_(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                if (!allowGamerule.test(key)) {
                    return;
                }
                GameRules.BooleanValue value = (GameRules.BooleanValue)gameRules.m_46170_(key);
                GameRules.BooleanValue defaultValue = (GameRules.BooleanValue)type.m_46352_();
                MutableComponent tooltip = Component.m_237115_((String)(key.m_46331_() + ".description"));
                MutableComponent valueTooltip = Component.m_237110_((String)"editGamerule.default", (Object[])new Object[]{defaultValue.m_5831_()}).m_130940_(ChatFormatting.GRAY);
                list.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)gameRules.m_46170_(key)).m_46223_(), b -> Component.m_237115_((String)key.m_46331_()), arg_0 -> this.lambda$visitBoolean$1((Component)tooltip, (Component)valueTooltip, arg_0), b -> value.m_46246_(b.selected, null)));
            }

            public void m_6894_(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                if (!allowGamerule.test(key)) {
                    return;
                }
                GameRules.IntegerValue value = (GameRules.IntegerValue)gameRules.m_46170_(key);
                GameRules.IntegerValue defaultValue = (GameRules.IntegerValue)type.m_46352_();
                MutableComponent tooltip = Component.m_237115_((String)(key.m_46331_() + ".description"));
                MutableComponent valueTooltip = Component.m_237110_((String)"editGamerule.default", (Object[])new Object[]{defaultValue.m_5831_()}).m_130940_(ChatFormatting.GRAY);
                EditBox integerEdit = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 220, 20, (Component)Component.m_237115_((String)key.m_46331_()));
                integerEdit.m_257544_((Tooltip)new MultilineTooltip(WorldMoreOptionsScreen.this.tooltipBox.width - 10, new Component[]{tooltip, valueTooltip}));
                integerEdit.m_94144_(Integer.toString(value.m_46288_()));
                integerEdit.m_94151_(string -> {
                    if (value.m_46314_(string)) {
                        integerEdit.m_94202_(0xE0E0E0);
                        value.m_151489_(Integer.parseInt(string), null);
                    } else {
                        integerEdit.m_94202_(-65536);
                    }
                });
                list.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)key.m_46331_()), r.x + 1, r.y + 2, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false)));
                list.addRenderable((Renderable)integerEdit);
            }

            private /* synthetic */ Tooltip lambda$visitBoolean$1(Component tooltip, Component valueTooltip, Boolean b) {
                return new MultilineTooltip(WorldMoreOptionsScreen.this.tooltipBox.width - 10, tooltip, valueTooltip);
            }
        });
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.onClose.run();
    }

    @Override
    public boolean m_6050_(double d, double e, double f, double g) {
        if (this.tooltipBox.isHovered(d, e) && this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.m_6050_(d, e, f, g);
    }

    public void m_262791_(Tooltip tooltip, ClientTooltipPositioner clientTooltipPositioner, boolean bl) {
        if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
            this.tooltipBoxLabel = tooltip.m_257408_(this.f_96541_);
            this.scrollableRenderer.scrolled.max = Math.max(0, this.tooltipBoxLabel.size() - (this.tooltipBox.m_93694_() - 44) / 12);
        } else {
            super.m_262791_(tooltip, clientTooltipPositioner, bl);
        }
    }

    public WorldMoreOptionsScreen(LoadSaveScreen parent) {
        super(parent, 244, 199, (Component)Component.m_237115_((String)"createWorld.tab.more.title"));
        this.onClose = () -> {};
        this.renderableVLists.add(this.gameRenderables);
        this.tabList.selectedTab = 1;
        GameRules gameRules = parent.summary.m_164913_().m_46933_();
        LoadSaveScreen.RESETTABLE_DIMENSIONS.forEach(d -> this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.dimensionsToReset.contains(d), b -> Component.m_237110_((String)"legacy.menu.load_save.reset", (Object[])new Object[]{LegacyComponents.getDimensionName((ResourceKey<Level>)d)}), b -> null, t -> {
            if (t.selected) {
                parent.dimensionsToReset.add((ResourceKey<Level>)d);
            } else {
                parent.dimensionsToReset.remove(d);
            }
        })));
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.trustPlayers, b -> Component.m_237115_((String)"legacy.menu.selectWorld.trust_players"), b -> null, t -> {
            parent.trustPlayers = t.selected;
        }));
        this.addGameRulesOptions(this.renderableVList, gameRules, k -> k.m_46332_() == GameRules.Category.UPDATES);
        this.gameRenderables.addRenderable((Renderable)new TickBox(0, 0, parent.allowCommands, b -> Component.m_237115_((String)"selectWorld.allowCommands"), b -> Tooltip.m_257550_((Component)Component.m_237115_((String)"selectWorld.allowCommands.info")), b -> {
            parent.allowCommands = b.selected;
        }));
        for (GameRules.Category value : GameRules.Category.values()) {
            if (value == GameRules.Category.UPDATES) continue;
            this.addGameRulesOptions(this.gameRenderables, gameRules, k -> k.m_46332_() == value);
        }
        parent.applyGameRules = (g, s) -> {
            if (!g.equals(gameRules)) {
                g.m_46176_(gameRules, s);
            }
        };
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
            AbstractWidget w;
            GuiEventListener guiEventListener;
            if (this.tooltipBoxLabel != null && this.m_94729_(i, j).map(g -> {
                Tooltip tooltip;
                if (g instanceof AbstractWidget) {
                    AbstractWidget w = (AbstractWidget)g;
                    tooltip = w.m_278622_();
                } else {
                    tooltip = null;
                }
                return tooltip;
            }).isEmpty() && (!((guiEventListener = this.m_7222_()) instanceof AbstractWidget) || (w = (AbstractWidget)guiEventListener).m_278622_() == null)) {
                this.tooltipBoxLabel = null;
                this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
            }
            this.tooltipBox.m_88315_(guiGraphics, i, j, f);
            if (this.tooltipBoxLabel != null) {
                this.scrollableRenderer.render(guiGraphics, this.panel.x + this.panel.width + 3, this.panel.y + 13, this.tooltipBox.width - 10, this.tooltipBox.m_93694_() - 44, () -> this.tooltipBoxLabel.forEach(c -> guiGraphics.m_280648_(this.f_96547_, c, this.panel.x + this.panel.width + 3, this.panel.y + 13 + this.tooltipBoxLabel.indexOf(c) * 12, 0xFFFFFF)));
            }
        }
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        this.tabList.controlTab(i);
        return super.m_7933_(i, j, k);
    }

    @Override
    public RenderableVList getRenderableVList() {
        return (RenderableVList)this.renderableVLists.get(this.tabList.selectedTab);
    }

    @Override
    protected void m_7856_() {
        this.m_142416_(this.tabList);
        super.m_7856_();
        this.tabList.init(this.panel.x, this.panel.y - 23, this.panel.width);
    }

    @Override
    public void renderableVListInit() {
        if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
            this.tooltipBox.init();
        }
        super.renderableVListInit();
    }

    protected void openDataPackSelectionScreen(CreateWorldScreen screen, WorldDataConfiguration worldDataConfiguration) {
        Pair pair = screen.m_267637_(worldDataConfiguration);
        if (pair != null) {
            this.f_96541_.m_91152_((Screen)new PackSelectionScreen((PackRepository)pair.getSecond(), packRepository -> screen.m_269443_(packRepository, true, d -> this.openDataPackSelectionScreen(screen, (WorldDataConfiguration)d)), (Path)pair.getFirst(), (Component)Component.m_237115_((String)"dataPack.title")));
        }
    }

    public PackRepository getDatapackRepository() {
        PackRepository packRepository;
        Screen screen = this.parent;
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            packRepository = (PackRepository)screen2.m_267637_(screen2.m_267748_().m_267573_().f_243842_()).getSecond();
        } else {
            packRepository = null;
        }
        return packRepository;
    }

    public void tryApplyNewDataPacks(PackRepository packRepository) {
        Screen screen = this.parent;
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            screen2.m_269443_(packRepository, false, w -> this.f_96541_.m_91152_((Screen)this));
        }
    }

    private static /* synthetic */ Component lambda$new$28(Component name, Boolean b) {
        return name;
    }
}

