/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.WorldHostComponents;
import io.github.gaming32.worldhost.gui.screen.AddFriendScreen;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.widget.UserListWidget;
import io.github.gaming32.worldhost.plugin.FriendAdder;
import io.github.gaming32.worldhost.plugin.FriendListFriend;
import io.github.gaming32.worldhost.plugin.ProfileInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class WorldHostFriendsScreen
extends PanelVListScreen {
    public static final Tooltip ADD_SILENTLY_TEXT_TOOLTIP = Tooltip.m_257550_((Component)Component.m_237115_((String)"world-host.friends.add_silently.tooltip"));
    public static final Component INVITE = Component.m_237115_((String)"legacy.menu.invite");
    public static final Component INVITE_FRIENDS = Component.m_237115_((String)"legacy.menu.invite_friends");
    public static final Component FRIENDS = Component.m_237115_((String)"world-host.friends");
    public static final Component WORLD_HOST_FRIENDS = WorldHostComponents.FRIENDS;
    public static final Component WORLD_HOST_REMOVE_FRIEND = Component.m_237115_((String)"world-host.friends.remove");
    public static final Component WORLD_HOST_FRIEND_USERNAME_TEXT = Component.m_237115_((String)"world-host.add_friend.enter_username");

    public WorldHostFriendsScreen(Screen parent) {
        this(parent, 250, 190);
    }

    public WorldHostFriendsScreen(Screen parent, int imageWidth, int imageHeight) {
        super(parent, s -> Panel.centered(s, LegacySprites.PANEL, imageWidth, imageHeight), WORLD_HOST_FRIENDS);
        this.renderableVList.layoutSpacing(i -> 0);
        this.addFriendButtons(() -> {});
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(88, this));
    }

    public void reloadFriendButtons() {
        int i = this.renderableVList.renderables.indexOf(this.m_7222_());
        this.renderableVList.renderables.clear();
        this.addFriendButtons(() -> {
            if (i >= 0 && i < this.renderableVList.renderables.size()) {
                this.m_7522_((GuiEventListener)this.renderableVList.renderables.get(i));
            }
            this.m_267719_();
        });
    }

    @Override
    public void renderableVListInit() {
        this.renderableVList.init(this.panel.x + 10, this.panel.y + 22, this.panel.width - 20, this.panel.height - 28);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.m_169394_((guiGraphics, i, j, f) -> guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), this.panel.x + 11, this.panel.y + this.panel.height - 182, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.f_96541_.f_91073_ == null) {
            ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        }
    }

    protected void addFriendButtons(Runnable afterButtonsAdd) {
        CreationList.addIconButton(this.renderableVList, Legacy4J.createModLocation("icon/add_user_portal"), FriendsScreen.ADD_FRIEND_TEXT, b -> this.f_96541_.m_91152_((Screen)new WorldHostFriendsScreen(this, 250, 234){
            long lastTyping;
            private Runnable delayedLookup;
            final List<FriendListFriend> addableFriends;
            final List<FriendListFriend> friendsToAdd;
            final TickBox silentAddBox;
            final EditBox friendBox;
            final List<FriendAdder> friendAdders;
            {
                this.lastTyping = -1L;
                this.addableFriends = new ArrayList<FriendListFriend>();
                this.friendsToAdd = new ArrayList<FriendListFriend>();
                this.silentAddBox = new TickBox(0, 0, 200, 16, false, b1 -> AddFriendScreen.ADD_FRIEND_SILENT_TEXT, b1 -> ADD_SILENTLY_TEXT_TOOLTIP, t -> {});
                this.friendBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 100, 0, 200, 20, WORLD_HOST_FRIEND_USERNAME_TEXT);
                this.friendAdders = WorldHost.getFriendAdders();
            }

            @Override
            protected void addFriendButtons(Runnable afterButtonsAdd) {
                if (this.addableFriends == null) {
                    return;
                }
                this.addableFriends.forEach(this::addFriendButton);
                this.friendsToAdd.forEach(this::addFriendButton);
                afterButtonsAdd.run();
            }

            private void addFriendButton(FriendListFriend friend) {
                this.renderableVList.addRenderable((Renderable)new FriendButton(0, 0, 230, 30, friend){

                    @Override
                    protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
                        super.m_87963_(guiGraphics, i, j, f);
                        RenderSystem.enableBlend();
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.SPRITES[this.m_198029_() ? 1 : 0], this.m_252754_() + 30, this.m_252907_() + (this.f_93619_ - 12) / 2, 12, 12);
                        if (friendsToAdd.contains(this.friend)) {
                            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.TICK, this.m_252754_() + 30, this.m_252907_() + (this.f_93619_ - 12) / 2, 14, 12);
                        }
                        RenderSystem.disableBlend();
                    }

                    @Override
                    protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                        ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 45, this.m_252907_(), this.m_252754_() + this.m_5711_() - 2, this.m_252907_() + this.m_93694_(), j, true);
                    }

                    @Override
                    public void m_5691_() {
                        if (friendsToAdd.contains(this.friend)) {
                            friendsToAdd.remove(this.friend);
                            addableFriends.add(this.friend);
                        } else {
                            friendsToAdd.add(this.friend);
                            addableFriends.remove(this.friend);
                        }
                        this.reloadFriendButtons();
                    }

                    @Override
                    public boolean supportsRemoving() {
                        return false;
                    }
                });
            }

            @Override
            public void m_7379_() {
                this.friendsToAdd.forEach(f -> f.addFriend(!this.silentAddBox.selected, WorldHostFriendsScreen.this::reloadFriendButtons));
                super.m_7379_();
            }

            @Override
            protected void m_7856_() {
                super.m_7856_();
                this.friendBox.m_264152_(this.panel.x + (this.panel.m_5711_() - this.friendBox.m_5711_()) / 2, this.panel.y + 5);
                this.friendBox.m_94199_(36);
                this.friendBox.m_94151_(s -> {
                    this.lastTyping = Util.m_137550_();
                    this.addableFriends.clear();
                    ArrayList<FriendAdder> delayedAdders = new ArrayList<FriendAdder>();
                    for (FriendAdder adder : this.friendAdders) {
                        if (s.length() > adder.maxValidNameLength()) continue;
                        if (adder.delayLookup(s)) {
                            delayedAdders.add(adder);
                            continue;
                        }
                        adder.searchFriends(s, 16 - this.addableFriends.size(), f -> {
                            if (this.friendsToAdd.stream().anyMatch(f1 -> f1.fallbackProfileInfo().name().equals(f.fallbackProfileInfo().name()))) {
                                return;
                            }
                            this.addableFriends.add((FriendListFriend)f);
                            this.reloadFriendButtons();
                        });
                    }
                    this.delayedLookup = delayedAdders.isEmpty() ? null : () -> delayedAdders.forEach(adder -> adder.searchFriends(s, 16 - this.addableFriends.size(), f -> {
                        if (this.friendsToAdd.stream().anyMatch(f1 -> f1.fallbackProfileInfo().name().equals(f.fallbackProfileInfo().name()))) {
                            return;
                        }
                        this.addableFriends.add((FriendListFriend)f);
                        this.reloadFriendButtons();
                    }));
                });
                this.m_142416_((GuiEventListener)this.friendBox);
                this.silentAddBox.m_264152_(this.panel.m_252754_() + (this.panel.m_5711_() - 200) / 2, this.panel.y + 30);
                this.m_142416_((GuiEventListener)this.silentAddBox);
            }

            public void m_86600_() {
                if (this.lastTyping != -1L && Util.m_137550_() - 300L > this.lastTyping) {
                    this.lastTyping = -1L;
                    this.delayedLookup.run();
                    this.delayedLookup = null;
                }
            }

            @Override
            public void renderableVListInit() {
                this.renderableVList.init(this.panel.x + 10, this.panel.y + 66, this.panel.width - 20, this.panel.height - 72);
            }
        }));
        WorldHost.getPlugins().forEach(p -> p.plugin().listFriends(f -> this.renderableVList.addRenderable((Renderable)new FriendButton(0, 0, 230, 30, (FriendListFriend)f))));
        afterButtonsAdd.run();
    }

    public class FriendButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final FriendListFriend friend;
        public ProfileInfo profileInfo;

        public FriendButton(int x, int y, int width, int height, FriendListFriend friend) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.friend = friend;
            this.profileInfo = friend.fallbackProfileInfo();
            ((CompletableFuture)friend.profileInfo().thenAcceptAsync(ready -> {
                this.profileInfo = ready;
            }, (Executor)Minecraft.m_91087_())).exceptionally(t -> {
                WorldHost.LOGGER.error("Failed to request profile info for {}", (Object)friend, t);
                return null;
            });
        }

        public Component m_6035_() {
            return UserListWidget.getNameWithTag((FriendListFriend)this.friend, (ProfileInfo)this.profileInfo);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            this.profileInfo.iconRenderer().draw(guiGraphics, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
            ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 30, this.m_252907_(), this.m_252754_() + this.m_5711_() - 2, this.m_252907_() + this.m_93694_(), j, true);
        }

        public boolean m_7933_(int i, int j, int k) {
            if (i == 88) {
                WorldHostFriendsScreen.this.f_96541_.m_91152_((Screen)new ConfirmationScreen((Screen)WorldHostFriendsScreen.this, WORLD_HOST_REMOVE_FRIEND, (Component)Component.m_237115_((String)"world-host.friends.remove.title"), b -> this.friend.removeFriend(() -> {
                    WorldHostFriendsScreen.this.f_96541_.m_91152_((Screen)WorldHostFriendsScreen.this);
                    WorldHostFriendsScreen.this.reloadFriendButtons();
                })));
                return true;
            }
            return super.m_7933_(i, j, k);
        }

        public void m_5691_() {
            this.friend.showFriendInfo((Screen)WorldHostFriendsScreen.this);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public boolean supportsRemoving() {
            return true;
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> this.m_93696_() && k.key() == 88 && this.supportsRemoving() ? WORLD_HOST_REMOVE_FRIEND : ControlTooltip.getSelectAction((GuiEventListener)this, context));
        }
    }
}

