/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.init;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.RegisterListing;
import wily.legacy.Legacy4J;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacyMerchantMenu;

public class LegacyRegistries {
    private static final RegisterListing<BlockEntityType<?>> BLOCK_ENTITIES_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.f_257049_);
    private static final RegisterListing<Block> BLOCK_ITEMS_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.f_256975_);
    private static final RegisterListing<Block> BLOCK_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.f_256975_);
    private static final RegisterListing<Item> ITEM_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.f_257033_);
    private static final RegisterListing<MenuType<?>> MENU_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.f_256818_);
    static final RegisterListing<SoundEvent> SOUND_EVENT_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.f_256894_);
    public static final RegisterListing.Holder<MenuType<LegacyMerchantMenu>> MERCHANT_MENU = MENU_REGISTER.add("merchant_menu", () -> new MenuType(LegacyMerchantMenu::new, FeatureFlags.f_244377_));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> STONECUTTER_PANEL_MENU = MENU_REGISTER.add("stonecutter_panel_menu", () -> new MenuType(LegacyCraftingMenu::stoneCutterMenu, FeatureFlags.f_244377_));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> LOOM_PANEL_MENU = MENU_REGISTER.add("loom_panel_menu", () -> new MenuType(LegacyCraftingMenu::loomMenu, FeatureFlags.f_244377_));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> PLAYER_CRAFTING_PANEL_MENU = MENU_REGISTER.add("player_crafting_panel_menu", () -> new MenuType(LegacyCraftingMenu::playerCraftingMenu, FeatureFlags.f_244377_));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> CRAFTING_PANEL_MENU = MENU_REGISTER.add("crafting_panel_menu", () -> new MenuType(LegacyCraftingMenu::craftingMenu, FeatureFlags.f_244377_));
    public static final RegisterListing.Holder<Item> WATER = ITEM_REGISTER.add("water", () -> new BlockItem(Blocks.f_49990_, new Item.Properties()));
    public static final RegisterListing.Holder<Item> LAVA = ITEM_REGISTER.add("lava", () -> new BlockItem(Blocks.f_49991_, new Item.Properties()));
    public static final RegisterListing.Holder<Block> SHRUB = BLOCK_ITEMS_REGISTER.add("shrub", () -> new TallGrassBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_280170_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XYZ).m_278183_().m_278166_(PushReaction.DESTROY)));
    public static final RegisterListing.Holder<BlockEntityType<WaterCauldronBlockEntity>> WATER_CAULDRON_BLOCK_ENTITY = BLOCK_ENTITIES_REGISTER.add("water_cauldron", () -> BlockEntityType.Builder.m_155273_(WaterCauldronBlockEntity::new, (Block[])new Block[]{Blocks.f_152476_}).m_58966_(null));
    public static final RegisterListing.Holder<SoundEvent> SCROLL = SOUND_EVENT_REGISTER.add("random.scroll", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.scroll")));
    public static final RegisterListing.Holder<SoundEvent> CRAFT_FAIL = SOUND_EVENT_REGISTER.add("random.craft_fail", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.craft_fail")));
    public static final RegisterListing.Holder<SoundEvent> BACK = SOUND_EVENT_REGISTER.add("random.back", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.back")));
    public static final RegisterListing.Holder<SoundEvent> FOCUS = SOUND_EVENT_REGISTER.add("random.focus", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.focus")));
    public static final RegisterListing.Holder<SoundEvent> ACTION = SOUND_EVENT_REGISTER.add("random.action", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.action")));
    public static final RegisterListing.Holder<SoundEvent> SHIFT_LOCK = SOUND_EVENT_REGISTER.add("random.shift_lock", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.shift_lock")));
    public static final RegisterListing.Holder<SoundEvent> SHIFT_UNLOCK = SOUND_EVENT_REGISTER.add("random.shift_unlock", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.shift_unlock")));
    public static final RegisterListing.Holder<SoundEvent> SPACE = SOUND_EVENT_REGISTER.add("random.space", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.space")));
    public static final RegisterListing.Holder<SoundEvent> BACKSPACE = SOUND_EVENT_REGISTER.add("random.backspace", () -> SoundEvent.m_262824_((ResourceLocation)Legacy4J.createModLocation("random.backspace")));

    public static boolean isInvalidCauldron(BlockState blockState, Level level, BlockPos blockPos) {
        Optional opt;
        return blockState.m_60713_(Blocks.f_152476_) && (opt = level.m_141902_(blockPos, (BlockEntityType)WATER_CAULDRON_BLOCK_ENTITY.get())).isPresent() && (!((WaterCauldronBlockEntity)((Object)opt.get())).hasWater() || ((WaterCauldronBlockEntity)((Object)opt.get())).waterColor != null);
    }

    public static void register() {
        BLOCK_REGISTER.register();
        if (((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            BLOCK_ENTITIES_REGISTER.register();
        }
        BLOCK_ITEMS_REGISTER.register();
        BLOCK_ITEMS_REGISTER.forEach(b -> ITEM_REGISTER.add(b.getId().m_135815_(), () -> new BlockItem((Block)b.get(), new Item.Properties())));
        ITEM_REGISTER.register();
        MENU_REGISTER.register();
        SOUND_EVENT_REGISTER.register();
    }
}

