/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;

public abstract class LegacyCraftingMenu
extends AbstractContainerMenu
implements RecipeMenu {
    public static final Component CRAFTING_TITLE = Component.m_237115_((String)"container.crafting");
    public static final Component STONECUTTER_TITLE = Component.m_237115_((String)"container.stonecutter");
    public static final Component LOOM_TITLE = Component.m_237115_((String)"container.loom");
    public static final Map<ResourceKey<BannerPattern>, Optional<Ingredient>> LOOM_PATTERN_EXTRA_INGREDIENT_CACHE = new ConcurrentHashMap<ResourceKey<BannerPattern>, Optional<Ingredient>>();
    public final Predicate<Player> stillValid;
    public boolean inventoryActive = true;
    public static final Vec3 DEFAULT_INVENTORY_OFFSET = new Vec3(0.5, 0.5, 0.0);
    public Vec3 inventoryOffset = DEFAULT_INVENTORY_OFFSET;
    public boolean showedNotEnoughIngredientsHint = false;

    public static LegacyCraftingMenu craftingMenu(Inventory inventory, @Nullable MenuType<?> menuType, int i, BlockPos pos, final int gridDimension) {
        return new LegacyCraftingMenu(inventory, menuType, i, p -> pos == null || LegacyCraftingMenu.isValidBlock(p, pos, Blocks.f_50091_)){
            RecipeHolder<CraftingRecipe> customRcp;
            final CraftingContainer container;
            {
                super(inventory, menuType, i, stillValid);
                this.container = new TransientCraftingContainer((AbstractContainerMenu)this, gridDimension, gridDimension);
            }

            @Override
            public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
                super.onCraft(player, packet, result);
                if (packet.craftId().isPresent() || this.customRcp != null) {
                    player.m_20194_().m_129894_().m_44043_(this.customRcp == null ? this.getRecipeKey(packet.craftId().get()) : this.customRcp.f_291676_()).ifPresent(h -> player.m_280300_(h, this.container.m_7086_()));
                }
            }

            @Override
            public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
                if (packet.craftId().isEmpty()) {
                    return player.m_20194_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.container, player.m_9236_()).map(h -> {
                        this.customRcp = h;
                        return ((CraftingRecipe)this.customRcp.f_291008_()).m_5874_((Container)this.container, player.m_9236_().m_9598_());
                    }).orElse(ItemStack.f_41583_);
                }
                return player.m_20194_().m_129894_().m_44043_(this.getRecipeKey(packet.craftId().get())).map(h -> {
                    ItemStack itemStack;
                    Recipe patt0$temp = h.f_291008_();
                    if (patt0$temp instanceof CraftingRecipe) {
                        CraftingRecipe rcp = (CraftingRecipe)patt0$temp;
                        itemStack = rcp.m_5874_((Container)this.container, player.m_9236_().m_9598_());
                    } else {
                        itemStack = null;
                    }
                    return itemStack;
                }).orElse(ItemStack.f_41583_);
            }

            @Override
            public List<ItemStack> getRemainingItems(Player player, ServerMenuCraftPayload packet) {
                return player.m_20194_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.container, player.m_9236_()).map(h -> ((CraftingRecipe)h.f_291008_()).m_7457_((Container)this.container)).orElse(super.getRemainingItems(player, packet));
            }

            @Override
            public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
                return packet.craftId().isEmpty() || !packet.customIngredients().isEmpty() ? super.getIngredients(player, packet) : player.m_20194_().m_129894_().m_44043_(this.getRecipeKey(packet.craftId().get())).map(r -> 1.getRecipeOptionalIngredients(r.f_291008_())).orElse(Collections.emptyList());
            }

            @Override
            public void setupActualItems(Player player, ServerMenuCraftPayload packet, ItemStack setItem, int index) {
                if (setItem == null) {
                    this.container.m_6211_();
                } else {
                    this.container.m_6836_(index, setItem);
                }
            }
        };
    }

    public static List<Optional<Ingredient>> getRecipeOptionalIngredients(Recipe<?> recipe) {
        return LegacyCraftingMenu.convertIngredientsToOptional((List<Ingredient>)recipe.m_7527_());
    }

    static List<Optional<Ingredient>> convertIngredientsToOptional(List<Ingredient> ingredients) {
        return ingredients.stream().map(i -> i.m_43947_() ? Optional.empty() : Optional.of(i)).toList();
    }

    public static LegacyCraftingMenu playerCraftingMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.craftingMenu(inventory, (MenuType)LegacyRegistries.PLAYER_CRAFTING_PANEL_MENU.get(), window, null, 2);
    }

    public static LegacyCraftingMenu craftingMenu(int window, Inventory inventory, BlockPos pos) {
        return LegacyCraftingMenu.craftingMenu(inventory, (MenuType)LegacyRegistries.CRAFTING_PANEL_MENU.get(), window, pos, 3);
    }

    public static LegacyCraftingMenu craftingMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.craftingMenu(window, inventory, null);
    }

    public static LegacyCraftingMenu loomMenu(int window, Inventory inventory, BlockPos blockPos) {
        return new LegacyCraftingMenu(inventory, (MenuType)LegacyRegistries.LOOM_PANEL_MENU.get(), window, p -> LegacyCraftingMenu.isValidBlock(p, blockPos, Blocks.f_50617_)){
            final Container container = new SimpleContainer(3);

            @Override
            public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
                List customIngredients = super.getIngredients(player, packet);
                if (packet.craftId().isPresent() && customIngredients.size() == 2 && Arrays.stream(FactoryIngredient.of((Ingredient)((Ingredient)((Optional)customIngredients.get(0)).get())).getStacks()).allMatch(i -> i.m_41720_() instanceof BannerItem) && Arrays.stream(FactoryIngredient.of((Ingredient)((Ingredient)((Optional)customIngredients.get(1)).get())).getStacks()).allMatch(i -> i.m_41720_() instanceof DyeItem)) {
                    return player.m_9236_().m_9598_().m_254861_(Registries.f_256969_).flatMap(b -> b.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256969_, (ResourceLocation)packet.craftId().get())).map(p -> {
                        Optional<Ingredient> extraIng = 2.getBannerPatternExtraIngredient(player.m_9236_().m_9598_(), (ResourceKey<BannerPattern>)p.m_205785_());
                        if (extraIng.isEmpty()) {
                            return customIngredients;
                        }
                        return ImmutableList.builder().addAll((Iterable)customIngredients).add(extraIng).build();
                    })).orElse(Collections.emptyList());
                }
                return Collections.emptyList();
            }

            @Override
            public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
                return player.m_9236_().m_9598_().m_254861_(Registries.f_256969_).flatMap(b -> b.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256969_, (ResourceLocation)packet.craftId().get())).map(p -> {
                    ItemStack banner = this.container.m_8020_(0);
                    CompoundTag beTag = banner.m_41698_("BlockEntityTag");
                    ListTag patternsTag = beTag.m_128437_("Patterns", 10);
                    beTag.m_128365_("Patterns", (Tag)patternsTag);
                    CompoundTag patternTag = new CompoundTag();
                    patternsTag.add((Object)patternTag);
                    patternTag.m_128359_("Pattern", ((BannerPattern)p.m_203334_()).m_58579_());
                    patternTag.m_128405_("Color", ((DyeItem)this.container.m_8020_(1).m_41720_()).m_41089_().m_41060_());
                    return banner;
                })).orElse(ItemStack.f_41583_);
            }

            @Override
            public List<ItemStack> getRemainingItems(Player player, ServerMenuCraftPayload packet) {
                return this.container.m_8020_(2).m_41619_() ? super.getRemainingItems(player, packet) : List.of(this.container.m_8020_(2));
            }

            @Override
            public void setupActualItems(Player player, ServerMenuCraftPayload packet, ItemStack setItem, int index) {
                if (setItem == null) {
                    this.container.m_6211_();
                } else {
                    this.container.m_6836_(index, setItem);
                }
            }
        };
    }

    public static LegacyCraftingMenu loomMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.loomMenu(window, inventory, null);
    }

    public static LegacyCraftingMenu stoneCutterMenu(int window, Inventory inventory, final BlockPos blockPos) {
        return new LegacyCraftingMenu(inventory, (MenuType)LegacyRegistries.STONECUTTER_PANEL_MENU.get(), window, p -> LegacyCraftingMenu.isValidBlock(p, blockPos, Blocks.f_50679_)){
            long lastSoundTime;

            @Override
            public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
                super.onCraft(player, packet, result);
                long l = player.m_9236_().m_46467_();
                if (this.lastSoundTime != l) {
                    player.m_9236_().m_5594_(null, blockPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.lastSoundTime = l;
                }
            }

            @Override
            public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
                return player.m_20194_().m_129894_().m_44043_(this.getRecipeKey(packet.craftId().get())).map(r -> 3.getRecipeOptionalIngredients(r.f_291008_())).orElse(Collections.emptyList());
            }

            @Override
            public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
                return player.m_20194_().m_129894_().m_44043_(this.getRecipeKey(packet.craftId().get())).map(h -> {
                    ItemStack itemStack;
                    Recipe patt0$temp = h.f_291008_();
                    if (patt0$temp instanceof StonecutterRecipe) {
                        StonecutterRecipe rcp = (StonecutterRecipe)patt0$temp;
                        itemStack = rcp.m_5874_(null, player.m_9236_().m_9598_());
                    } else {
                        itemStack = null;
                    }
                    return itemStack;
                }).orElse(ItemStack.f_41583_);
            }
        };
    }

    public static LegacyCraftingMenu stoneCutterMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.stoneCutterMenu(window, inventory, null);
    }

    public LegacyCraftingMenu(@Nullable MenuType<?> menuType, int i, Predicate<Player> stillValid) {
        super(menuType, i);
        this.stillValid = stillValid;
    }

    public LegacyCraftingMenu(Inventory inventory, @Nullable MenuType<?> menuType, int i, Predicate<Player> stillValid) {
        this(menuType, i, stillValid);
        this.addInventorySlotGrid((Container)inventory, 9, 186, 133, 3);
        this.addInventorySlotGrid((Container)inventory, 0, 186, 186, 1);
    }

    public static List<Optional<Ingredient>> updateShapedIngredients(List<Optional<Ingredient>> ingredientsGrid, List<Optional<Ingredient>> recipeIngredients, int gridDimension, int rcpWidth, int rcpHeight) {
        int i;
        int rcpDimension = Math.max(rcpWidth, rcpHeight);
        if (rcpDimension > gridDimension) {
            return Collections.emptyList();
        }
        Ingredient[] ingredients = new Ingredient[rcpDimension * rcpDimension];
        for (i = 0; i < recipeIngredients.size(); ++i) {
            ingredients[rcpWidth < rcpHeight ? i / rcpWidth * rcpHeight + i % rcpWidth : i] = recipeIngredients.get(i).orElse(null);
        }
        for (i = 0; i < ingredients.length; ++i) {
            ingredientsGrid.set(i > 1 && gridDimension > rcpDimension ? i + 1 : i, Optional.ofNullable(ingredients[i]));
        }
        return ingredientsGrid;
    }

    public static Optional<Ingredient> getBannerPatternExtraIngredient(RegistryAccess registryAccess, ResourceKey<BannerPattern> pattern) {
        return LOOM_PATTERN_EXTRA_INGREDIENT_CACHE.computeIfAbsent(pattern, key -> {
            Holder.Reference holder = registryAccess.m_255025_(Registries.f_256969_).m_255043_(pattern);
            for (Item item : BuiltInRegistries.f_257033_) {
                BannerPatternItem p;
                if (!(item instanceof BannerPatternItem) || !holder.m_203656_((p = (BannerPatternItem)item).m_220010_())) continue;
                return Optional.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{p}));
            }
            return Optional.empty();
        });
    }

    public ResourceLocation getRecipeKey(ResourceLocation id) {
        return id;
    }

    public void addInventorySlotGrid(Container container, int startIndex, int x, int y, int rows) {
        for (int j = 0; j < rows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(LegacySlotDisplay.override(new Slot(container, startIndex + j * 9 + k, x + k * 16, y + j * 16){

                    public void m_6654_() {
                        super.m_6654_();
                        LegacyCraftingMenu.this.m_6199_(this.f_40218_);
                    }

                    public boolean m_6659_() {
                        return LegacyCraftingMenu.this.inventoryActive;
                    }
                }, new LegacySlotDisplay(){

                    @Override
                    public Vec3 getOffset() {
                        return LegacyCraftingMenu.this.inventoryOffset;
                    }

                    @Override
                    public int getWidth() {
                        return 16;
                    }

                    @Override
                    public int getHeight() {
                        return 16;
                    }
                }));
            }
        }
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (i >= 0 && i < 27 ? !this.m_38903_(itemStack2, 27, 36, false) : !this.m_38903_(itemStack2, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269206_(ItemStack.f_41583_, itemStack);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return this.stillValid.test(player);
    }

    public static boolean isValidBlock(Player player, BlockPos pos, Block wantedBlock) {
        return player.m_9236_().m_8055_(pos).m_60713_(wantedBlock) && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    public static MenuProvider getMenuProvider(BlockPos pos, boolean is2x2) {
        return new SimpleMenuProvider((i, inventory, player) -> is2x2 ? LegacyCraftingMenu.playerCraftingMenu(i, inventory) : LegacyCraftingMenu.craftingMenu(i, inventory, pos), CRAFTING_TITLE);
    }

    public static MenuProvider getMenuProvider(MenuConstructor constructor, Component component) {
        return new SimpleMenuProvider(constructor, component);
    }

    public static MenuProvider getLoomMenuProvider(BlockPos pos) {
        return LegacyCraftingMenu.getMenuProvider((i, inv, p) -> LegacyCraftingMenu.loomMenu(i, inv, pos), LOOM_TITLE);
    }

    public static MenuProvider getStonecutterMenuProvider(BlockPos pos) {
        return LegacyCraftingMenu.getMenuProvider((i, inv, p) -> LegacyCraftingMenu.stoneCutterMenu(i, inv, pos), STONECUTTER_TITLE);
    }

    @Override
    public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
        result.m_41678_(player.m_9236_(), player, result.m_41613_());
    }
}

