/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.entity.LegacyPlayerInfo;

@Mixin(value={MapRenderer.MapInstance.class})
public abstract class MapRendererMixin {
    @Unique
    private static final RenderType MAP_ICONS = RenderType.m_110497_((ResourceLocation)new ResourceLocation("textures/map/map_icons.png"));
    @Shadow
    private MapItemSavedData f_93280_;

    @Unique
    private boolean isPlayerDecoration(MapDecoration.Type type) {
        return type.equals((Object)MapDecoration.Type.PLAYER) || type.equals((Object)MapDecoration.Type.PLAYER_OFF_MAP) || type.equals((Object)MapDecoration.Type.PLAYER_OFF_LIMITS);
    }

    @Redirect(method={"draw"}, at=@At(value="INVOKE", target="Ljava/lang/Iterable;iterator()Ljava/util/Iterator;"))
    Iterator<MapDecoration> drawDecorations(Iterable<MapDecoration> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(s -> !this.isPlayerDecoration(s.f_77791_())).iterator();
    }

    @Inject(method={"draw"}, at={@At(value="HEAD")})
    void draw(PoseStack poseStack, MultiBufferSource multiBufferSource, boolean bl, int i, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        if (!bl && ((Boolean)LegacyOptions.mapsWithCoords.get()).booleanValue()) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.2f, 0.4f, -0.1f);
            poseStack.m_85841_(1.0f, 0.95f, 1.0f);
            font.m_271703_(I18n.m_118938_((String)"legacy.map.coords", (Object[])new Object[]{(int)minecraft.f_91074_.m_20185_(), (int)minecraft.f_91074_.m_20188_(), (int)minecraft.f_91074_.m_20189_()}), 0.0f, 0.0f, 0, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, i);
            poseStack.m_85849_();
        }
    }

    @Inject(method={"draw"}, at={@At(value="RETURN")})
    void drawReturn(PoseStack poseStack, MultiBufferSource multiBufferSource, boolean bl, int i, CallbackInfo ci) {
        int l = 0;
        for (MapDecoration mapDecoration : this.f_93280_.m_164811_()) {
            float[] fArray;
            LegacyPlayerInfo playerInfo;
            PlayerInfo playerInfo2;
            MapDecoration.Type type = mapDecoration.f_77791_();
            if (bl && !mapDecoration.m_77809_() || !this.isPlayerDecoration(type)) continue;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f + (float)mapDecoration.f_77792_() / 2.0f + 64.0f, 0.0f + (float)mapDecoration.f_77793_() / 2.0f + 64.0f, -0.02f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(mapDecoration.f_77794_() * 360) / 16.0f));
            poseStack.m_85841_(4.0f, 4.0f, 3.0f);
            poseStack.m_252880_(-0.125f, 0.125f, 0.0f);
            Matrix4f matrix4f2 = poseStack.m_85850_().m_252922_();
            Minecraft minecraft = Minecraft.m_91087_();
            if (mapDecoration.f_77795_() == null || minecraft.m_91403_() == null || !((playerInfo2 = minecraft.m_91403_().m_104938_(mapDecoration.f_77795_().getString())) instanceof LegacyPlayerInfo)) {
                v0 = null;
            } else {
                LegacyPlayerInfo info = (LegacyPlayerInfo)playerInfo2;
                v0 = playerInfo = info;
            }
            if (playerInfo == null) {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            } else {
                fArray = Legacy4JClient.getVisualPlayerColor(playerInfo);
            }
            float[] color = fArray;
            byte image = playerInfo == null ? mapDecoration.m_77802_() : PlayerIdentifier.of(playerInfo.getIdentifierIndex()).indexByMapDecorationType(type);
            float g = (float)(image % 16) / 16.0f;
            float h = (float)(image / 16) / 16.0f;
            float m = (float)(image % 16 + 1) / 16.0f;
            float n = (float)(image / 16 + 1) / 16.0f;
            VertexConsumer vertexConsumer2 = multiBufferSource.m_6299_(MAP_ICONS);
            vertexConsumer2.m_252986_(matrix4f2, -1.0f, 1.0f, (float)l * -0.001f).m_85950_(color[0], color[1], color[2], 1.0f).m_7421_(g, h).m_85969_(i).m_5752_();
            vertexConsumer2.m_252986_(matrix4f2, 1.0f, 1.0f, (float)l * -0.001f).m_85950_(color[0], color[1], color[2], 1.0f).m_7421_(m, h).m_85969_(i).m_5752_();
            vertexConsumer2.m_252986_(matrix4f2, 1.0f, -1.0f, (float)l * -0.001f).m_85950_(color[0], color[1], color[2], 1.0f).m_7421_(m, n).m_85969_(i).m_5752_();
            vertexConsumer2.m_252986_(matrix4f2, -1.0f, -1.0f, (float)l * -0.001f).m_85950_(color[0], color[1], color[2], 1.0f).m_7421_(g, n).m_85969_(i).m_5752_();
            poseStack.m_85849_();
            ++l;
        }
    }
}

