/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={PackSelectionScreen.class})
public abstract class PackSelectionScreenMixin
extends Screen
implements ControlTooltip.Event,
RenderableVList.Access {
    private static final Component INCOMPATIBLE_TITLE = Component.m_237115_((String)"pack.incompatible").m_130940_(ChatFormatting.RED);
    private static final Component INCOMPATIBLE_CONFIRM_TITLE = Component.m_237115_((String)"pack.incompatible.confirm.title");
    private static final Component AVAILABLE_PACK = Component.m_237115_((String)"pack.selected.title");
    private static final Component SELECTED_PACK = Component.m_237115_((String)"pack.available.title");
    @Shadow
    @Final
    private PackSelectionModel f_99973_;
    @Shadow
    private Button f_99980_;
    @Shadow
    @Final
    private Path f_99979_;
    @Unique
    private Panel panel = Panel.centered((Screen)this, 410, 240);
    @Unique
    private RenderableVList selectedPacksList = new RenderableVList(this).layoutSpacing(l -> 0);
    @Unique
    private RenderableVList unselectedPacksList = new RenderableVList(this).layoutSpacing(l -> 0);
    @Unique
    private final List<RenderableVList> renderableVLists = List.of(this.unselectedPacksList, this.selectedPacksList);

    @Shadow
    protected abstract void m_100041_();

    protected PackSelectionScreenMixin(Component component) {
        super(component);
    }

    private PackSelectionScreen self() {
        return (PackSelectionScreen)this;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        super.m_7856_();
        this.panel.init();
        this.unselectedPacksList.init(this.panel.x + 15, this.panel.y + 30, 180, 192);
        this.selectedPacksList.init(this.panel.x + 215, this.panel.y + 30, 180, 192);
        this.f_99980_ = Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_253136_();
    }

    public void m_274333_() {
        super.m_274333_();
        ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> LegacyComponents.OPEN_DIRECTORY);
    }

    public void m_280273_(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initConstruct(CallbackInfo info) {
        this.m_100041_();
    }

    @Inject(method={"populateLists"}, at={@At(value="HEAD")}, cancellable=true)
    private void populateLists(CallbackInfo ci) {
        ci.cancel();
        this.addPacks(this.unselectedPacksList, this.f_99973_.m_99913_());
        this.addPacks(this.selectedPacksList, this.f_99973_.m_99918_());
        this.m_267719_();
    }

    @Inject(method={"onClose"}, at={@At(value="RETURN")})
    public void onClose(CallbackInfo info) {
        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.BACK.get(), 1.0f);
    }

    private void addPacks(RenderableVList list, Stream<PackSelectionModel.Entry> stream) {
        list.renderables.clear();
        stream.forEach(e -> {
            ArrayList<Component> description = new ArrayList<Component>();
            if (!e.m_7709_().m_10489_()) {
                description.add(INCOMPATIBLE_TITLE);
                description.add(e.m_7709_().m_10492_());
            }
            if (!e.m_99929_().getString().isEmpty()) {
                description.add(e.m_99929_());
            }
            AbstractButton button = new AbstractButton(0, 0, 180, 30, e.m_7356_(), (PackSelectionModel.Entry)e){
                final /* synthetic */ PackSelectionModel.Entry val$e;
                {
                    this.val$e = entry;
                    super(i, j, k, l, arg);
                }

                protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                    RenderSystem.enableBlend();
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(this.val$e.m_6876_(), this.m_252754_() + 5, this.m_252907_() + 5, 0.0f, 0.0f, 20, 20, 20, 20);
                    RenderSystem.disableBlend();
                    if ((((Boolean)((PackSelectionScreenMixin)PackSelectionScreenMixin.this).f_96541_.f_91066_.m_231828_().m_231551_()).booleanValue() || this.f_93622_) && this.showHoverOverlay()) {
                        guiGraphics.m_280509_(this.m_252754_() + 5, this.m_252907_() + 5, this.m_252754_() + 25, this.m_252907_() + 25, -1601138544);
                        int p = mouseX - this.m_252754_();
                        int q = mouseY - this.m_252907_();
                        if (this.val$e.m_99930_()) {
                            if (p < 32) {
                                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN_HIGHLIGHTED, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                            } else {
                                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                            }
                        } else {
                            if (this.val$e.m_99931_()) {
                                if (p < 16) {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.UNSELECT_HIGHLIGHTED, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                                } else {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.UNSELECT, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                                }
                            }
                            if (this.val$e.m_7802_()) {
                                if (p < 32 && p > 16 && q < 16) {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_UP_HIGHLIGHTED, this.m_252754_(), this.m_252907_(), 32, 32);
                                } else {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_UP, this.m_252754_(), this.m_252907_(), 32, 32);
                                }
                            }
                            if (this.val$e.m_7803_()) {
                                if (p < 32 && p > 16 && q > 16) {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_DOWN_HIGHLIGHTED, this.m_252754_(), this.m_252907_(), 32, 32);
                                } else {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_DOWN, this.m_252754_(), this.m_252907_(), 32, 32);
                                }
                            }
                        }
                    }
                }

                protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                    ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 30, this.m_252907_(), this.m_252754_() + this.f_93618_ - 2, this.m_252907_() + this.f_93619_, this.val$e.m_7709_().m_10489_() ? ScreenUtil.getDefaultTextColor(!this.m_198029_()) : 0xFF0000, true);
                }

                public void m_5716_(double i, double j) {
                    double f = i - (double)this.m_252754_();
                    double g = j - (double)this.m_252907_();
                    if (this.showHoverOverlay() && f <= 32.0) {
                        if (this.val$e.m_99930_()) {
                            this.m_5691_();
                            return;
                        }
                        if (f < 16.0 && this.val$e.m_99931_()) {
                            this.val$e.m_7850_();
                            return;
                        }
                        if (f > 16.0 && g < 16.0 && this.val$e.m_7802_()) {
                            this.val$e.m_7852_();
                            return;
                        }
                        if (f > 16.0 && g > 16.0 && this.val$e.m_7803_()) {
                            this.val$e.m_7845_();
                            return;
                        }
                    }
                    if (this.m_93696_()) {
                        this.m_5691_();
                    }
                }

                private boolean showHoverOverlay() {
                    return !this.val$e.m_7867_() || !this.val$e.m_7844_();
                }

                public void m_5691_() {
                    if (this.val$e.m_7857_() && this.val$e.m_99931_()) {
                        this.val$e.m_7850_();
                        return;
                    }
                    if (this.val$e.m_7709_().m_10489_()) {
                        this.val$e.m_7849_();
                    } else {
                        PackSelectionScreenMixin.this.f_96541_.m_91152_((Screen)new ConfirmationScreen((Screen)PackSelectionScreenMixin.this.self(), INCOMPATIBLE_CONFIRM_TITLE, this.val$e.m_7709_().m_10493_(), b -> {
                            this.val$e.m_7849_();
                            if (((PackSelectionScreenMixin)PackSelectionScreenMixin.this).f_96541_.f_91080_ != null) {
                                ((PackSelectionScreenMixin)PackSelectionScreenMixin.this).f_96541_.f_91080_.m_7379_();
                            }
                        }));
                    }
                }

                public boolean m_7933_(int i, int j, int k) {
                    if (Screen.m_96638_() || ControllerBinding.LEFT_BUTTON.state().pressed) {
                        switch (i) {
                            case 265: {
                                int oldFocused;
                                int n = oldFocused = PackSelectionScreenMixin.this.m_7222_() == null ? -1 : PackSelectionScreenMixin.this.m_6702_().indexOf(PackSelectionScreenMixin.this.m_7222_());
                                if (this.val$e.m_7802_()) {
                                    this.val$e.m_7852_();
                                }
                                if (oldFocused >= 0 && oldFocused < PackSelectionScreenMixin.this.f_96540_.size()) {
                                    PackSelectionScreenMixin.this.m_7522_((GuiEventListener)PackSelectionScreenMixin.this.m_6702_().get(oldFocused));
                                }
                                return false;
                            }
                            case 264: {
                                int oldFocused;
                                int n = oldFocused = PackSelectionScreenMixin.this.m_7222_() == null ? -1 : PackSelectionScreenMixin.this.m_6702_().indexOf(PackSelectionScreenMixin.this.m_7222_());
                                if (this.val$e.m_7803_()) {
                                    this.val$e.m_7845_();
                                }
                                if (oldFocused >= 0 && oldFocused < PackSelectionScreenMixin.this.f_96540_.size()) {
                                    PackSelectionScreenMixin.this.m_7522_((GuiEventListener)PackSelectionScreenMixin.this.m_6702_().get(oldFocused));
                                }
                                return false;
                            }
                        }
                    }
                    return super.m_7933_(i, j, k);
                }

                protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                    this.m_168802_(narrationElementOutput);
                }
            };
            if (!description.isEmpty()) {
                button.m_257544_((Tooltip)new MultilineTooltip(description, 161));
            }
            list.addRenderable((Renderable)button);
        });
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.unselectedPacksList;
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }

    public boolean m_6050_(double d, double e, double f, double g) {
        RenderableVList vList = this.getRenderableVListAt(d, e);
        if (vList != null) {
            vList.mouseScrolled(g);
        }
        return super.m_6050_(d, e, f, g);
    }

    public boolean m_7933_(int i, int j, int k) {
        for (RenderableVList renderableVList : this.getRenderableVLists()) {
            if (!renderableVList.keyPressed(i)) continue;
            return true;
        }
        if (i == 79) {
            Util.m_137581_().m_137648_(this.f_99979_.toUri());
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(UIAccessor.of((Screen)this), guiGraphics, false);
        this.panel.m_88315_(guiGraphics, i, j, f);
        RenderSystem.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.6f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 10, this.panel.y + 10, 190, 220);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
        RenderSystem.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 210, this.panel.y + 10, 190, 220);
        guiGraphics.m_280614_(this.f_96547_, SELECTED_PACK, this.panel.x + 10 + (190 - this.f_96547_.m_92852_((FormattedText)SELECTED_PACK)) / 2, this.panel.y + 18, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.m_280614_(this.f_96547_, AVAILABLE_PACK, this.panel.x + 210 + (190 - this.f_96547_.m_92852_((FormattedText)AVAILABLE_PACK)) / 2, this.panel.y + 18, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        super.m_88315_(guiGraphics, i, j, f);
    }
}

