/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.init.LegacyGameRules;

@Mixin(value={TntBlock.class})
public class TntBlockMixin {
    private static final AABB tntDetectBounding = new AABB(-50.0, -50.0, -50.0, 50.0, 50.0, 50.0);

    @Inject(method={"explode(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void explode(Level level, BlockPos blockPos, LivingEntity livingEntity, CallbackInfo ci) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (!(serverLevel = (ServerLevel)level).m_46469_().m_46207_(LegacyGameRules.TNT_EXPLODES) || ((GameRules.IntegerValue)serverLevel.m_46469_().m_46170_(LegacyGameRules.TNT_LIMIT)).m_46288_() > 0 && level.m_45976_(PrimedTnt.class, tntDetectBounding.m_82338_(blockPos)).size() >= ((GameRules.IntegerValue)serverLevel.m_46469_().m_46170_(LegacyGameRules.TNT_LIMIT)).m_46288_())) {
            ci.cancel();
        }
    }

    @Inject(method={"wasExploded"}, at={@At(value="HEAD")}, cancellable=true)
    private void wasExploded(Level level, BlockPos blockPos, Explosion explosion, CallbackInfo ci) {
        if (!level.m_46469_().m_46207_(LegacyGameRules.TNT_EXPLODES) || ((GameRules.IntegerValue)level.m_46469_().m_46170_(LegacyGameRules.TNT_LIMIT)).m_46288_() > 0 && level.m_45976_(PrimedTnt.class, tntDetectBounding.m_82338_(blockPos)).size() >= ((GameRules.IntegerValue)level.m_46469_().m_46170_(LegacyGameRules.TNT_LIMIT)).m_46288_()) {
            ci.cancel();
        }
    }

    @Inject(method={"neighborChanged"}, at={@At(value="HEAD")}, cancellable=true)
    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl, CallbackInfo ci) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_46469_().m_46207_(LegacyGameRules.TNT_EXPLODES)) {
            ci.cancel();
        }
    }
}

