/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={Gui.class})
public abstract class GuiMixin
implements ControlTooltip.Event {
    @Shadow
    @Final
    private Minecraft f_92986_;
    @Final
    @Shadow
    private static Comparator<? super PlayerScoreEntry> f_302813_;
    @Shadow
    private long f_92976_;

    @Shadow
    public abstract Font m_93082_();

    @Redirect(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getPopTime()I"))
    public int renderSlot(ItemStack instance) {
        return 0;
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;", ordinal=1))
    public Object renderCrosshair(OptionInstance<AttackIndicatorStatus> instance) {
        return FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? AttackIndicatorStatus.OFF : instance.m_231551_();
    }

    @Redirect(method={"renderHotbar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;"))
    public Object renderItemHotbar(OptionInstance<AttackIndicatorStatus> instance) {
        return FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? AttackIndicatorStatus.OFF : instance.m_231551_();
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;blendFuncSeparate(Lcom/mojang/blaze3d/platform/GlStateManager$SourceFactor;Lcom/mojang/blaze3d/platform/GlStateManager$DestFactor;Lcom/mojang/blaze3d/platform/GlStateManager$SourceFactor;Lcom/mojang/blaze3d/platform/GlStateManager$DestFactor;)V", remap=false))
    public void renderCrosshairBlendFunc(GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor sourceFactor2, GlStateManager.DestFactor destFactor2, GuiGraphics guiGraphics) {
        if (((Boolean)LegacyOptions.invertedCrosshair.get()).booleanValue()) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)sourceFactor, (GlStateManager.DestFactor)destFactor, (GlStateManager.SourceFactor)sourceFactor2, (GlStateManager.DestFactor)destFactor2);
        }
    }

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEffects(GuiGraphics guiGraphics, CallbackInfo ci) {
        ci.cancel();
        ScreenUtil.renderGuiEffects(guiGraphics);
    }

    @Inject(method={"renderHotbar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1)})
    private void renderHotbarSelection(float f, GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.HOTBAR_SELECTION, 24, 24, 0, 23, guiGraphics.m_280182_() / 2 - 91 - 1 + this.f_92986_.f_91074_.m_150109_().f_35977_ * 20, guiGraphics.m_280206_(), 0, 24, 1);
    }

    @Inject(method={"displayScoreboardSidebar"}, at={@At(value="HEAD")}, cancellable=true)
    private void displayScoreboardSidebar(GuiGraphics guiGraphics, Objective objective, CallbackInfo ci) {
        ci.cancel();
        if (this.f_92986_.f_91080_ != null) {
            return;
        }
        Scoreboard scoreboard = objective.m_83313_();
        NumberFormat numberFormat = objective.m_305063_((NumberFormat)StyledFormat.f_303088_);
        List<? super PlayerScoreEntry> scores = scoreboard.m_306706_(objective).stream().filter(playerScoreEntry -> !playerScoreEntry.m_307477_()).sorted(f_302813_).limit(15L).toList();
        Component component = objective.m_83322_();
        int i = this.m_93082_().m_92852_((FormattedText)component);
        int k = this.m_93082_().m_92895_(": ");
        int j = Math.max(i, scores.stream().mapToInt(lv -> {
            int w = this.m_93082_().m_92852_((FormattedText)lv.m_304640_(numberFormat));
            return this.m_93082_().m_92852_((FormattedText)PlayerTeam.m_83348_((Team)scoreboard.m_83500_(lv.f_302847_()), (Component)lv.m_305530_())) + (w > 0 ? k + w : 0);
        }).max().orElse(0));
        Objects.requireNonNull(this.m_93082_());
        int l = scores.size() * 9;
        int m = guiGraphics.m_280206_() / 2 + l / 3;
        int x = guiGraphics.m_280182_() - 8;
        int o = x - j;
        int p = x + 2;
        Objects.requireNonNull(this.m_93082_());
        int s = m - scores.size() * 9;
        Objects.requireNonNull(this.m_93082_());
        ScreenUtil.renderPointerPanel(guiGraphics, o - 6, s - 16, j + 12, scores.size() * 9 + 22);
        Font var18 = this.m_93082_();
        int var10003 = o + j / 2 - i / 2;
        Objects.requireNonNull(this.m_93082_());
        guiGraphics.m_280614_(var18, component, var10003, s - 9, -1, false);
        for (int t = 0; t < scores.size(); ++t) {
            PlayerScoreEntry lv2 = scores.get(t);
            x = scores.size() - t;
            Objects.requireNonNull(this.m_93082_());
            int u = m - x * 9;
            guiGraphics.m_280614_(this.m_93082_(), (Component)PlayerTeam.m_83348_((Team)scoreboard.m_83500_(lv2.f_302847_()), (Component)lv2.m_305530_()), o, u, -1, false);
            MutableComponent score = lv2.m_304640_(numberFormat);
            guiGraphics.m_280614_(this.m_93082_(), (Component)score, p - this.m_93082_().m_92852_((FormattedText)score), u, -1, false);
        }
    }

    @Redirect(method={"renderExperienceBar"}, at=@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;experienceLevel:I", ordinal=0))
    public int renderExperienceLevel(LocalPlayer instance, GuiGraphics guiGraphics) {
        int i = this.f_92986_.f_91074_.f_36078_;
        if (i > 0) {
            guiGraphics.m_280168_().m_252880_((float)guiGraphics.m_280182_() / 2.0f, (float)guiGraphics.m_280206_(), 0.0f);
            FactoryAPIClient.getProfiler().m_6180_("expLevel");
            String exp = "" + i;
            int hudScale = (Integer)LegacyOptions.hudScale.get();
            boolean is720p = this.f_92986_.m_91268_().m_85442_() % 720 == 0;
            guiGraphics.m_280168_().m_252880_(0.0f, -36.0f, 0.0f);
            if (!is720p && hudScale != 1) {
                guiGraphics.m_280168_().m_85841_(0.875f, 0.875f, 0.875f);
            }
            ScreenUtil.drawOutlinedString(guiGraphics, this.m_93082_(), (Component)Component.m_237113_((String)exp), -this.m_93082_().m_92895_(exp) / 2, -2, 8453920, 0, is720p && hudScale == 3 || !is720p && hudScale == 2 || hudScale == 1 ? 0.5f : 0.6666667f);
            FactoryAPIClient.getProfiler().m_7238_();
        }
        return 0;
    }

    @Inject(method={"renderSavingIndicator"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderAutoSaveIndicator(GuiGraphics guiGraphics, CallbackInfo ci) {
        ci.cancel();
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z"))
    private boolean tick(ItemStack instance) {
        return !ScreenUtil.getTooltip(instance).equals(ScreenUtil.getTooltip(this.f_92986_.f_91074_.m_150109_().m_36056_()));
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;"))
    private Object tick(OptionInstance<Double> instance) {
        return (double)Math.min(ScreenUtil.getSelectedItemTooltipLines(), ScreenUtil.getTooltip(this.f_92986_.f_91074_.m_150109_().m_36056_()).size()) * (Double)instance.m_231551_();
    }

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void renderSelectedItemName(GuiGraphics guiGraphics, int shift, CallbackInfo ci) {
        ci.cancel();
        ScreenUtil.renderHUDTooltip(guiGraphics, shift);
    }
}

