/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.inventory;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends AbstractContainerScreen<InventoryMenu>
implements ReplaceableScreen,
LegacyMenuAccess<InventoryMenu> {
    @Shadow
    @Final
    private RecipeBookComponent f_98833_;
    @Shadow
    private boolean f_98835_;
    private ImageButton recipeButton;
    private static final Vec3 EQUIP_SLOT_OFFSET = new Vec3(50.0, 0.0, 0.0);
    private static final ResourceLocation[] EQUIPMENT_SLOT_SPRITES = new ResourceLocation[]{LegacySprites.HEAD_SLOT, LegacySprites.CHEST_SLOT, LegacySprites.LEGS_SLOT, LegacySprites.FEET_SLOT};
    private boolean canReplace = true;

    public InventoryScreenMixin(InventoryMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Redirect(method={"containerTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;hasInfiniteItems()Z"))
    public boolean containerTick(MultiPlayerGameMode instance) {
        return false;
    }

    public void m_280273_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_7286_(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.f_97726_ = 215;
        this.f_97727_ = 217;
        this.f_97730_ = 14;
        this.f_97731_ = 103;
        super.m_7856_();
        for (int i = 0; i < ((InventoryMenu)this.f_97732_).f_38839_.size(); ++i) {
            final Slot s = (Slot)((InventoryMenu)this.f_97732_).f_38839_.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 180, 40, new LegacySlotDisplay(){

                    @Override
                    public boolean isVisible() {
                        return ScreenUtil.hasClassicCrafting();
                    }
                });
                continue;
            }
            if (i < 5) {
                LegacySlotDisplay.override(s, 111 + s.m_150661_() % 2 * 21, 30 + s.m_150661_() / 2 * 21, new LegacySlotDisplay(){

                    @Override
                    public boolean isVisible() {
                        return ScreenUtil.hasClassicCrafting();
                    }
                });
                continue;
            }
            if (i < 9) {
                final int index = 39 - s.m_150661_();
                LegacySlotDisplay.override(s, 14, 14 + index * 21, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.m_7993_().m_41619_() ? EQUIPMENT_SLOT_SPRITES[index] : null;
                    }

                    @Override
                    public Vec3 getOffset() {
                        return ScreenUtil.hasClassicCrafting() ? Vec3.f_82478_ : EQUIP_SLOT_OFFSET;
                    }
                });
                continue;
            }
            if (i < ((InventoryMenu)this.f_97732_).f_38839_.size() - 10) {
                LegacySlotDisplay.override(s, 14 + (s.m_150661_() - 9) % 9 * 21, 116 + (s.m_150661_() - 9) / 9 * 21);
                continue;
            }
            if (i < ((InventoryMenu)this.f_97732_).f_38839_.size() - 1) {
                LegacySlotDisplay.override(s, 14 + s.m_150661_() * 21, 186);
                continue;
            }
            LegacySlotDisplay.override(s, 111, 77, new LegacySlotDisplay(){

                @Override
                public Vec3 getOffset() {
                    return ScreenUtil.hasClassicCrafting() ? Vec3.f_82478_ : EQUIP_SLOT_OFFSET;
                }

                @Override
                public ResourceLocation getIconSprite() {
                    return s.m_7993_().m_41619_() ? LegacySprites.SHIELD_SLOT : null;
                }
            });
        }
        this.f_98835_ = this.f_96543_ < 379;
        this.f_98833_.m_100309_(this.f_96543_, this.f_96544_, this.f_96541_, this.f_98835_, (RecipeBookMenu)this.f_97732_);
        if (((Boolean)LegacyOptions.showVanillaRecipeBook.get()).booleanValue() && ScreenUtil.hasClassicCrafting()) {
            this.f_97735_ = this.f_98833_.m_181401_(this.f_96543_, this.f_97726_);
            this.recipeButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 180, this.f_97736_ + 71, 20, 18, RecipeBookComponent.f_291154_, button -> {
                this.f_98833_.m_100384_();
                this.f_97735_ = this.f_98833_.m_181401_(this.f_96543_, this.f_97726_);
                button.m_264152_(this.f_97735_ + 180, this.f_97736_ + 71);
            }));
            if (this.f_98833_.m_100385_()) {
                this.recipeButton.m_93692_(true);
            }
        } else if (this.f_98833_.m_100385_()) {
            this.f_98833_.m_100384_();
        }
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics graphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SMALL_PANEL, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.ENTITY_PANEL, this.f_97735_ + 40 + (ScreenUtil.hasClassicCrafting() ? 0 : 50), this.f_97736_ + 13, 63, 84);
        Pose pose = this.f_96541_.f_91074_.m_20089_();
        this.f_96541_.f_91074_.m_20124_(Pose.STANDING);
        ScreenUtil.renderEntityInInventoryFollowsMouse(graphics, this.f_97735_ + 40 + (ScreenUtil.hasClassicCrafting() ? 0 : 50), this.f_97736_ + 13, this.f_97735_ + 103 + (ScreenUtil.hasClassicCrafting() ? 0 : 50), this.f_97736_ + 97, 35, 0.0625f, i, j, (LivingEntity)this.f_96541_.f_91074_);
        this.f_96541_.f_91074_.m_20124_(pose);
        if (ScreenUtil.hasClassicCrafting()) {
            graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97735_ + 111, this.f_97736_ + 16, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SMALL_ARROW, this.f_97735_ + 158, this.f_97736_ + 43, 16, 13);
        }
        if (!this.f_98833_.m_100385_() && this.recipeButton != null && !this.recipeButton.m_274382_()) {
            this.recipeButton.m_93692_(false);
        }
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    @Override
    public boolean canReplace() {
        return this.f_96541_.f_91072_.m_105290_() && this.canReplace;
    }

    @Override
    public void setCanReplace(boolean canReplace) {
        this.canReplace = canReplace;
    }

    @Override
    public Screen getReplacement() {
        return CreativeModeScreen.getActualCreativeScreenInstance(this.f_96541_);
    }

    @Override
    public int getTipXDiff() {
        return -186;
    }

    @Override
    public boolean allowItemPopping() {
        return true;
    }
}

